package code;

import java.util.*;
import java.net.*;
import java.io.*;


public class BarrierServer extends Thread{
  
  private Hashtable serversMap;
  private int barrierNumber;
  private long[] intervals;
  private long[] streams;
  private int blockCount;
  private int totalCount;
  private int listernPort;
  private Socket incoming = null;
  private ServerSocket ss = null;
  public static final int LOOP_FOREVER = -1;
  private int nLoops = LOOP_FOREVER;

  
  public BarrierServer(int port, int tCount, int nLoops){
    barrierNumber = 0; 
    serversMap = new Hashtable();
    blockCount = 0;
    totalCount = tCount;
    listernPort = port;
    intervals = new long[totalCount];
    streams = new long[totalCount];
    this.nLoops = nLoops;

    //
    // Moved the listen code up into constructor
    // so that when constructor returns, OK to start
    // trying to connect (simplifies synchronization)
    //
    try{
      ss = new ServerSocket(listernPort);
    } catch (Exception e){
      assert false;
      e.printStackTrace();
    }
    Env.inform("Barrier server ready for work...");
  }

  public void run(){
    int loopsSoFar = 0;
    try{
      while(nLoops == LOOP_FOREVER || barrierNumber < nLoops){
        loopsSoFar++;
        try{
          if (this.isInterrupted()){
            return;
          }
	  
          incoming = ss.accept();
          ObjectInputStream ois = new ObjectInputStream(incoming.getInputStream());
          BarrierMsg bMsg = (BarrierMsg) ois.readObject();
          bMsg.setSocket(incoming);
        
          addToBarrier(bMsg);

          assert blockCount == serversMap.size();
          if(totalCount == blockCount){
            for(int i=0; i<totalCount; i++){
              Env.inform("Server-" + i + " time: " + intervals[i] + " bytes: " + streams[i]);
            }
            removeBarrier();
          } else {
            Env.inform(totalCount + ":::" + serversMap.size());
            assert totalCount > serversMap.size();
          }

        } catch (Exception e){
          e.printStackTrace();
          break;
        }
      }
    }
    finally{
      try{
        ss.close();
      }
      catch(IOException z){
      }
    }
  }
  
  public void addToBarrier(BarrierMsg msg){
    int sid = msg.getServerId();
    Env.inform(msg.getBarrierNumber() + "::" + barrierNumber);
    //assert msg.getBarrierNumber() != barrierNumber;
    Integer key = new Integer(sid);
    if(serversMap.containsKey(key)){
      assert false;
    } else {
      serversMap.put(key, msg);
      streams[sid] += msg.getStream();
      intervals[sid] = msg.getInterval();
      blockCount ++;
    }
  }

  public void removeBarrier() throws IOException{
    Env.inform("Activating servers for the next stage ...");
    assert blockCount == totalCount;
    barrierNumber ++;
    for(Enumeration e = serversMap.keys(); e.hasMoreElements();){
      // this is no fault-tolerant procedure
      BarrierMsg bMsg = (BarrierMsg)serversMap.remove((Integer)e.nextElement());
      assert bMsg != null;

      ObjectOutputStream oos = new ObjectOutputStream(bMsg.getSocket().getOutputStream());
      oos.writeObject(new Integer(barrierNumber));
      oos.flush();
      oos.close();
      blockCount --;
    }
    assert serversMap.size() == 0;
    assert blockCount == 0;
//    resetIntervals();
  }

  public static void main(String[] argv){
    if(argv.length < 2) {
      System.out.println("Usage: BarrierServer <port> <count> [numBarriers]");
      System.exit(-1);
    }
    int port = (new Integer(argv[0])).intValue();
    int count = (new Integer(argv[1])).intValue();
    int numBarriers = LOOP_FOREVER;

    if(argv.length > 2){
      numBarriers = (new Integer(argv[2])).intValue();
    }
    (new BarrierServer(port, count, numBarriers)).start();
  }

}

//---------------------------------------------------------------------------
/* $Log: BarrierServer.java,v $
/* Revision 1.9  2007/07/11 19:08:07  zjiandan
/* clean IncommingConnection
/*
/* Revision 1.8  2007/05/30 20:30:19  dahlin
/* Added checkpoint to SubscribeBWUnit. Changed outgoingconnection checkpoint send to not send body by default. Told barrier to close sockets when done with them.
/*
/* Revision 1.7  2007/03/18 19:24:00  dahlin
/* *** empty log message ***
/*
/* Revision 1.6  2006/09/12 22:18:05  dahlin
/* Working to get the unit tests to all run. Up to RandomAccessState now go through. Note that to encourage people to run RASUnit, I have changed the parameters to --quick-- versions that are less extensive tests.
/*
/* Revision 1.5  2006/08/23 22:02:24  nalini
/* Minor bug fixes
/*
 */
//---------------------------------------------------------------------------

