package code;

/* BlockedQueue
 * 
 *  a producer/consumer queue 
 *  -  getNext blocks until an object is available in the queue.
 *  - returns objects in the order they were inserted.
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */


import java.util.*;
import java.lang.*;

public class BlockedQueue {
  private LinkedList _list;

 /** 
 *  Constructor 
 **/ 

  public BlockedQueue() {
    _list = new LinkedList();
  }

 
 /** 
 *  grab lock; adds objects to the queue 
 **/ 

  public synchronized void
  add(Object obj) {
    _list.add(obj);
    notifyAll();
  }

 /** 
 *  get next 
 *  - wait until an object is available and remove it from the queue 
 **/ 

  public synchronized Object
  getNext() {
    while(_list.size() == 0){
      try {
        wait();
      }
      catch(InterruptedException e) {
      }
    }
    assert(_list.size() > 0);
      return _list.removeFirst();
  }

 /** 
 *  isEmpty 
 **/ 
  public synchronized boolean
  isEmpty(){
    if(_list.size() > 0){
      return false;
    }
    return true;
  }
}

//---------------------------------------------------------------------------
/* $Log: BlockedQueue.java,v $
/* Revision 1.4  2006/10/31 16:08:08  nalini
/* bug fix
/*
/* Revision 1.3  2006/10/30 20:05:10  nalini
/* added isEmpty method
/*
/* Revision 1.2  2006/09/26 20:55:34  nalini
/* minor bug fix
/*
/* Revision 1.1  2006/09/26 20:24:17  nalini
/* added worker queues to handle insert and watch of tuples in overlog policy
/*
 */
//---------------------------------------------------------------------------