package code;
//package utils.junit;

import junit.textui.TestRunner;
import junit.framework.*;
import java.io.ObjectOutputStream;
import java.io.ObjectInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
/**
 * TBD: Update class name
 */
public class BoundInvalUnit extends TestCase {
  public static final String TEST_ALL_TEST_TYPE = "UNIT";
  
  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public BoundInvalUnit (final String s) {
    super (s);
  }

  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
    /* 
     * TBD: Insert other fixture code here
     * e.g., this.objectUnderTest = new ClassToBeTested(...);
     */
  }

  protected void tearDown() throws Exception{
    /* 
     * TBD: Insert other fixture cleanup code here
     */
    super.tearDown();
  }

 /** 
 *  test basic functions
 
 **/ 
  public void testBasicFunction(){
ObjInvalTarget hit1 = null;
    
    BoundInval ii1 = null;
    BoundInval ii2 = null;
    AcceptStamp as1 = null;
    
    ByteArrayOutputStream baos = null;
    ByteArrayInputStream bais = null;
    ObjectOutputStream oos = null;
    ObjectInputStream ois = null;

    // Test 1
    // Try a simple invalidate
    try{
      baos = new ByteArrayOutputStream();
      oos = new ObjectOutputStream(baos);
      byte[] data = new byte[2];
      data[0] = 0;
      data[1] = 1;

      ii1 = new BoundInval(new ObjId("/b"),
                           0,
                           2,
                           new AcceptStamp(1, new NodeId(10)),
                           new ImmutableBytes(data),
                           1.0,
                           new AcceptStamp(10, new NodeId(10)),
                           Long.MAX_VALUE,
                           true);

      //System.out.println("test " + ii1);
      oos.writeObject(ii1);
      oos.flush();
      oos.close();
      baos.flush();
      baos.close();

      bais = new ByteArrayInputStream(baos.toByteArray());
      ois = new ObjectInputStream(bais);
      try{
        ii2 = (BoundInval)(ois.readObject());
      }catch(ClassNotFoundException ce){
        ce.printStackTrace();
        assert false;
      }
      //System.out.println("get " + ii2);
      assert(ii1 != ii2);
      assert(ii2.equals(ii1));
      assert(ii1.equals(ii2));
    }catch(IOException e){
      e.printStackTrace();
      System.out.println("" + e);
      assert(false);
    }
  }
  
  public void testBasic2(){
 // getStartVV() copied from PreciseInv
    // getEndVV() copied from PreciseInv
    // cloneIntersectInvalTarget() copied from PreciseInv
    // cloneIntersectInvalTargetChopStartEnd() copied from PreciseInv
    // getOneWriterSubsetFrom() copied from PreciseInv
    // isIncludedBy() copied from PreciseInv
    // anyComponentIncludedBy() copied from PreciseInv
    // isCommitted() copied from PreciseInv
    // isPrecise() copied from PreciseInv
    // newUnion() copied from PreciseInv
    // totalOrderCompare() copied from PreciseInv

    // To test: Constructors
    // To test: clone()
    byte[] bdy1 = null;
    byte[] bdy2 = null;
    BoundInval bi1 = null;
    BoundInval bi2 = null;
    PreciseInv pi1 = null;
    BodyMsg bodyMsg1 = null;

    // Test 1
    bdy1 = new byte[5];
    bdy1[0] = 10;
    bdy1[1] = 9;
    bdy1[2] = 8;
    bdy1[3] = 7;
    bdy1[4] = 6;
    ImmutableBytes body1 = new ImmutableBytes(bdy1);

    bi1 = new BoundInval(new ObjId("obj1"),
                         10,
                         body1.getLength(),
                         new AcceptStamp(190, new NodeId(200)),
                         body1,
                         5);
    System.out.println("bi1 = " + bi1.toString());
    System.out.println("bi1.clone() = " + bi1.clone());
    bi2 = (BoundInval)bi1.clone();
    System.out.println("(bi1.clone().getBody() == bi1.getBody()) = " +
                       (bi2.getBody().equals(bi1.getBody())));

    // Test 2a
    bi1 = new BoundInval(new ObjId("obj1"),
                         10,
                         body1.getLength(),
                         new AcceptStamp(200, new NodeId(300)),
                         body1,
                         1.9,
                         5);
    System.out.println("bi1 = " + bi1);
    assert(bi1.getPriority() == 1.9);

    // Test 2b
    bi1 = new BoundInval(new ObjId("obj1"),
                         10,
                         body1.getLength(),
                         new AcceptStamp(200, new NodeId(300)),
                         body1,
                         1.9,
                         5);
    System.out.println("bi1 = " + bi1);
    assert(bi1.getMaxBoundHops() == 5);


    // Test 3
    bi1 = new BoundInval(new ObjId("obj1"),
                         10,
                         body1.getLength(),
                         new AcceptStamp(200, new NodeId(300)),
                         body1,
                         1.9,
                         5);
    pi1 = bi1.clonePreciseInv();
    assert(!(pi1 instanceof BoundInval));
    assert(pi1.getInvalTarget().equals(bi1.getInvalTarget()));
    assert(pi1.getAcceptStamp().equals(bi1.getAcceptStamp()));
    assert(pi1.getRTAcceptStamp().equals(bi1.getRTAcceptStamp()));
    assert(pi1.isEmbargoed() == bi1.isEmbargoed());

    // Test 4
    bi1 = new BoundInval(new ObjId("obj1"),
                         10,
                         body1.getLength(),
                         new AcceptStamp(200, new NodeId(300)),
                         body1,
                         1.9,
                         5);
    bodyMsg1 = bi1.cloneBodyMsg();
    assert(bodyMsg1.getObjInvalTarget().equals(bi1.getInvalTarget()));
    assert(bodyMsg1.getAcceptStamp().equals(bi1.getAcceptStamp()));
    assert(bodyMsg1.getBody().equals(bi1.getBody()));
    assert(bodyMsg1.getPriority() == 1.9);
    assert(!bodyMsg1.isDemandReply());
   
  }
  
  
  public void
  testEquals(){
    BoundInval bi1 = null;
    BoundInval bi2 = null;
    byte[] data1 = null;
    ImmutableBytes body1 = null;

    data1 = new byte[5];
    data1[0] = 10;
    data1[1] = 9;
    data1[2] = 8;
    data1[3] = 7;
    data1[4] = 6;
    body1 = new ImmutableBytes(data1);

    // Test 1: Comparison to self
    bi1 = new BoundInval(new ObjId("obj1"),
                         10,
                         body1.getLength(),
                         new AcceptStamp(200, new NodeId(300)),
                         body1,
                         1.9,
                         5);
    assert(bi1.equals(bi1));

    // Test 2: Successful comparison to equal
    bi1 = new BoundInval(new ObjId("/obj2"),
                         20,
                         body1.getLength(),
                         new AcceptStamp(200, new NodeId(300)),
                         body1,
                         1.9,
                         5);
    bi2 = new BoundInval(new ObjId("/obj2"),
                         20,
                         body1.getLength(),
                         new AcceptStamp(200, new NodeId(300)),
                         body1,
                         1.9,
                         5);
    assert(bi1.equals(bi2));
    assert(bi2.equals(bi1));

    // Test 3: Unsuccessful comparison to equal
    bi1 = new BoundInval(new ObjId("/obj3"),
                         10,
                         body1.getLength(),
                         new AcceptStamp(200, new NodeId(300)),
                         body1,
                         1.9,
                         5);
    data1[0] = 15;
    body1 = new ImmutableBytes(data1);
    bi2 = new BoundInval(new ObjId("/obj3"),
                         10,
                         body1.getLength(),
                         new AcceptStamp(200, new NodeId(300)),
                         body1,
                         1.9,
                         5);
    assert(!bi1.equals(bi2));
    assert(!bi2.equals(bi1));

 // Test 4: Unsuccessful comparison to equal
    bi1 = new BoundInval(new ObjId("/obj3"),
                         10,
                         body1.getLength(),
                         new AcceptStamp(200, new NodeId(300)),
                         body1,
                         1.9,
                         5);
    bi2 = new BoundInval(new ObjId("/obj3"),
                         10,
                         body1.getLength(),
                         new AcceptStamp(200, new NodeId(300)),
                         body1,
                         1.9,
                         7);
    assert(!bi1.equals(bi2));
    assert(!bi2.equals(bi1));
  }
  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(BoundInvalUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "BoundInvalUnit";
    System.err.print(name + " self test begins...");
    TestRunner tr = new TestRunner();
    tr.doRun(suite());
    System.err.println(name + " self test succeeds");
  }

}

//---------------------------------------------------------------------------
/* $Log$*/
//---------------------------------------------------------------------------
