package code;

 /** 
 *  Keep track of who has acknowleged receiving bound copies of  
 *  data and unbind when appropriate. Right now we follow of simple 
 *  policy of unbinding when k distinct nodes 
 *  have acknowleged, with k being a global (staic) parameter. 
 **/ 
import java.util.List;
import java.util.LinkedList;

public class BoundStatus
{
    private ObjId objId;
    private long offset;
    private long length;
    private AcceptStamp as;

    private List haveReceived;

    public final static int DEFAULT_GOLD_COUNT = 2;
    private static int goldCount = DEFAULT_GOLD_COUNT;

    public static void setGoldCount(int newCount)
    {
	assert(newCount >= 0);
	goldCount = newCount;
    }

    public static int getGoldCount()
    {
	return goldCount;
    }

    public BoundStatus(ObjId objId_, long offset_, long length_, 
		       AcceptStamp as_)
    {
	this.objId = objId_;
	this.offset = offset_;
	this.length = length_;
	this.as = as_;
	this.haveReceived = new LinkedList();
    }

 /** 
 *  Return true if we now have completed enough writes 
 *  to unbind 
 **/ 
    public boolean update(NodeId senderNodeId)
    {
	assert(haveReceived.size() < goldCount);

	if(haveReceived.contains(senderNodeId)){
	    return false;
	}

	if(haveReceived.size() == goldCount - 1){
	    return true;
	}
	haveReceived.add(senderNodeId);
	assert(haveReceived.size() < goldCount);
	return false;
    }


    public ObjInvalTarget getObjInvalTarget()
    {
	return new ObjInvalTarget(objId, offset, length);
    }


    public static void main(String s[])
    {
	System.err.print("BoundStatus self test...");
	NodeId me = new NodeId(1);
	Config.readConfig("test/bound-status-test.config");
	ObjId o1 = new ObjId("/");
	BoundStatus.setGoldCount(3);
	AcceptStamp as = new AcceptStamp(1000, me);
	BoundStatus status = new BoundStatus(o1, 234, 234, as);
	
	NodeId n1 = new NodeId(13);
	NodeId n2 = new NodeId(2);
	NodeId n3 = new NodeId(13);
	NodeId n4 = new NodeId(11);

	assert(!status.update(n1)); // 1
	assert(!status.update(me));
	assert(!status.update(n1));
	assert(!status.update(n2)); // 2
	assert(!status.update(n3));
	assert(status.update(n4)); // 3
	System.err.println("BoundStatus self test SUCCEEDS");
	System.exit(0);
    }

}

//---------------------------------------------------------------------------
/* $Log: BoundStatus.java,v $
/* Revision 1.3  2005/10/13 00:24:23  zjiandan
/* remove Config.getMy* fixed Garbage Collection and Checkpoint exchange code
/*
/* Revision 1.2  2004/05/24 10:37:33  arun
/* rectified some logic for updating ISStatus. Changes for dealing with bound invals
/* using sdims.
/*
/* Revision 1.1  2004/05/13 21:58:14  dahlin
/* simple unbind implemented
/*
 */
//---------------------------------------------------------------------------
