package code;

 /** 
 *  Contains a CSN. Useful because this gives a way to have a mutable 
 *  equivalent of "Long". 
 **/ 
public class CSNContainer
{
    private long csn;

	public static final long DUMMY_CSN = -1;

 /** 
 *  Constructor 
 **/ 
    public CSNContainer(long csn_)
    {
	this.csn = csn_;
    }

 /** 
 *  Set the value of the stored csn 
 **/ 
    public void setCSN(long c)
    {
	this.csn = c;
    }

 /** 
 *  Return the stored CSN 
 **/ 
    public long getCSN()
    {
	return(this.csn);
    }

 /** 
 *  Convert to a string representation 
 **/ 
    public String toString()
    {
	return("" + this.csn);
    }

 /** 
 *  Used for testing 
 **/ 
    public static void main(String[] argv)
    {
	// Not much testing necessary
	long csn = 0;
	CSNContainer cont = null;

	cont = new CSNContainer(10);
	System.out.println("cont = " + cont);
	System.out.println("cont.getCSN() = " + cont.getCSN());
	System.out.println("cont.setCSN(50)");
	cont.setCSN(50);
	System.out.println("cont.getCSN() = " + cont.getCSN());
    }
}

//---------------------------------------------------------------------------
/* $Log: CSNContainer.java,v $
/* Revision 1.4  2004/05/20 02:08:47  arun
/* *** empty log message ***
/*
/* Revision 1.3  2004/04/22 21:21:53  nayate
/* Finished + tested simple CSNContainer implementation
/*
/* Revision 1.2  2004/04/15 20:04:24  nayate
/* New Makefile; added provision to allow CVS to append file modification
/* logs to files.
/* */
//---------------------------------------------------------------------------
