package code;

 /** 
 *  Used to iterate through invalidate messages in a list 
 *  difference from InvalIterator:: 
 *    The CatchupInvalIterator does not accumulate imprecise invalidate 
 *    to summarize non-interested invalidates. 
 *    i.e, this iterator only returns whatever invalidate from updatelog 
 *         that is related to the subscriptionset 
 *     
 *  Note: 
 *     it is still safe if we don't send impreciseInvalidate for non-interseted invalidate 
 *     in the catchup stream because those information should have already summarized in 
 *     the main InvalIterator 
 **/ 
import javax.naming.TimeLimitExceededException;
import java.io.IOException;

public class CatchupInvalIterator 
{
  public static final boolean useNewIterator = InvalIterator.useNewIterator;
  
  private InMemLogIterator iter = null;
  
  /*
   * An invalIterator is guaranteed to return a sequence
   * of invalidation messages that ensure a causally
   * consistent view of data for the receiver. In particular,
   * we send every invalidation in the log whose timestamp
   * exceeds the startVV of the iterator.
   */
  private UpdateLog causalLog;
  private CounterVV currentVV;   // We have sent a causal stream
  // up to currentVV
  private AcceptVV endVV;

  // are in the "past"
  private SubscriptionSet ss;

  //normally the catchup invaliterator should have an endVV
  // < log.currentVV, therefore it won't need the TIMEOUTFORNEXTEVENT
  // to force the waiting for the new comming invalidate.
  // But we just have one so that the UpdateLog.getNext() will be happy
  public static final long TIMEOUTFORNEXTEVENT = 20;

  public static final boolean dbg = false;
  private static final boolean measureTime = true;
  
  //constance for handlenextEvent cases
  //private static final int 
    
 /** 
 *  Constructor 
 **/ 
  public CatchupInvalIterator(VV startVV_,
                       SubscriptionSet ss_,
                       long unbindCounter_,
                       long debargoCounter_,
                       long maxAccumulateForceMS_,
                       long maxSendDelayMS_,
			      UpdateLog log_,
			      VV endVV) 
    {
      
      this.currentVV = new CounterVV(startVV_);
      
      this.ss = (SubscriptionSet) ss_.clone();
      assert maxSendDelayMS_ <=0;//not support accumulate across overlapping inv.
      assert (maxSendDelayMS_<=0)||(maxAccumulateForceMS_ <= maxSendDelayMS_);
      this.causalLog = log_;

      assert !causalLog.getInMemOmitVV().includesAnyPartOf(currentVV);
      this.endVV = (AcceptVV)endVV;
      if(useNewIterator){
        iter = this.causalLog.makeInMemLogIterator((AcceptVV)startVV_);
      }
    }
    
 /** 
 *  Constructor -- temp  removed later 
 **/ 
  public CatchupInvalIterator(VV startVV_,
                       SubscriptionSet ss_,
                       long unbindCounter_,
                       long maxAccumulateForceMS_,
                       long maxSendDelayMS_,
			      UpdateLog log_,
			      VV endVV) 
    {
      
      this.currentVV = new CounterVV(startVV_);

      this.ss = (SubscriptionSet) ss_.clone();
      assert maxSendDelayMS_ <=0;//not support accumulate across overlapping inv.
      assert (maxSendDelayMS_<=0)||(maxAccumulateForceMS_ <= maxSendDelayMS_);
      this.causalLog = log_;

      assert !causalLog.getInMemOmitVV().includesAnyPartOf(currentVV);
      this.endVV = (AcceptVV)endVV;
      
      if(useNewIterator){
        iter = this.causalLog.makeInMemLogIterator((AcceptVV)startVV_);
      }
    }
    
  static boolean printone = true;
 /** 
 *  Advance CurrentVV to reduce redundant invals. 
 **/ 
  public synchronized void advanceCVV(VV newVV){
    if(printone){
      Env.tbd("need new mechanisms other than the InvalIteratorFilter "
              + "to avoid the redundant invalidations when there's a ring "
              + "in the inval subscription topology."
              + " because advanceCVV will falsely advance incommingConnection.prevVV"
              + " while the incommingConnection.subscriptionSet misses "
              + "some preciseInv in between");
      printone = false;
    }
    this.currentVV.advanceTimestamps(newVV);
  }

 /** 
 *  Handle nextEvent to decide next step. 
 **/ 
  private synchronized Object handleNextEvent(Object nextEventO){
    if (nextEventO instanceof GeneralInv){
      GeneralInv nextEvent = (GeneralInv)nextEventO;
      
      if(nextEvent.getInvalTarget().intersects(ss)){//send as it is if intersect with subset
        currentVV.advanceTimestamps(nextEvent.getEndVV());
        return nextEventO;
	
      }else{ //advance the cvv and ignore the event if it is not intersected
        currentVV.advanceTimestamps(nextEvent.getEndVV()); 
        return null;
      }
    }else{
      assert(false):" unexpected event:" + nextEventO + " expected: GenearlInv";
      return null;
    }
    
  }
    

 /** 
 *  return any invalidate intersect SS from startVV to endVV one by one 
 *      end with a "null". 
 *  
 *  note: here it omits all non-intersected invalidates 
 *        because this is a catchup stream. 
 *  
 *  side effect:  
 *     currentVV advances after handling each invalidate 
 **/ 
  public Object getNext()
    throws OmittedVVException, IOException{
    long start, end;
    if(measureTime){
      start = System.currentTimeMillis();
    }
    Object nextEventO = null;
    while(!currentVV.includes(endVV)){ // Keep going until something to send
      //or endVV is met.
      
      //get next event
      try{
	long lstart, lend;
	if(measureTime){
	  lstart = System.currentTimeMillis();
	}
	nextEventO = causalLog.getNext(Long.MAX_VALUE,//not interested in any unbind msg
				       Long.MAX_VALUE,//not interested in any debargo msg
				       currentVV.cloneAcceptVV(),
				       TIMEOUTFORNEXTEVENT);
	if(measureTime){
	  lend = System.currentTimeMillis();
	  LatencyWatcher.put("log.getNext", (lend-lstart));
	}
	if (dbg) {
	  Env.dprintln(dbg, "catchup invaliterator get: " 
		       + nextEventO.toString() 
		       + " currentVV=" + currentVV.toString());
	}
	
	if(!useNewIterator){
          nextEventO = causalLog.getNext(Long.MAX_VALUE,//not interested in any unbind msg
              Long.MAX_VALUE,//not interested in any debargo msg
              currentVV.cloneAcceptVV(),
              TIMEOUTFORNEXTEVENT);
          //System.out.println("****\n"+ ((SingleWriterInval)(nextEventO)).toString() + "\n");
          
        }else{
 
          nextEventO = iter.next();
          
          if(nextEventO==null){
            assert false;
            /*
            try{
              Thread.sleep(TIMEOUTFORNEXTEVENT);//simulate the original timeout
            }catch(InterruptedException e){
              e.printStackTrace();
            }
            nextEventO = iter.next();
            if(nextEventO == null){
              throw new TimeLimitExceededException("End of log");
            }
            */
          }
          //System.out.println("****\n"+ ((SingleWriterInval)(nextEventO)).toString() + "\n");
          
        }
      }catch(TimeLimitExceededException t){
	assert false:" have you set up a catch up stream with endVV in the future?";
      }


      long hstart, hend;
      if(measureTime){
	hstart = System.currentTimeMillis();
      }
      assert nextEventO != null;
      Object ret = handleNextEvent(nextEventO);
      if(measureTime){
	hend = System.currentTimeMillis();
	LatencyWatcher.put("CatchupII.handleNext", (hend-hstart));
      }


      if (ret != null) {
	if(measureTime){
	  end = System.currentTimeMillis();
	  LatencyWatcher.put("CatchupInvalIterator-getNext1", (end-start));
	  start = System.currentTimeMillis();
	}
	return ret;
      }
    }//while
    if (dbg){
      Env.dprintln(dbg, "--------catchup done with" + endVV 
		   + " updateLog: " + causalLog.toString());
    }
    
    if(measureTime){
      end = System.currentTimeMillis();
      LatencyWatcher.put("CatchupInvalIterator-getNext2", (end-start));
      
    }
    return null;
  }//method
  
 /** 
 *  Return currentVV 
 **/ 
  public AcceptVV getCurrentVV(){    
    return currentVV.cloneAcceptVV();
  }

 /** 
 *  Return currentVV 
 **/ 
  public AcceptVV getEndVV(){    
    return this.endVV;
  }

 /** 
 *  Return subscriptionset 
 **/ 
  public SubscriptionSet getSubscriptionSet(){    
    return ss;
  }

 /** 
 *  ****** callback ********* start	 
 **/ 
  
 /** 
 *  Add new subscription set to this subscription set 
 **/ 
  public synchronized void addSubscriptionSet(SubscriptionSet newSS){    
    this.ss = this.ss.getCompleteUnion(newSS);
  }

 /** 
 *  Remove a sub-subscription set from this subscription set 
  // Note: "/a/*" remove "/a/b" will actually result in an empty SubscriptionSet
  **/
  public synchronized void removeSubscriptionSet(SubscriptionSet newSS){
    try{
      this.ss = this.ss.remove(newSS, true);
      
    }catch(IllegalRemoveSubscriptionSetException e){
      assert false : ("" + e);
    }
  }
  
  //-------------------------------------------------------------------------
  // ****** callback ********* end	
  //-------------------------------------------------------------------------  

  //-----------------------------------------------------------------------
  // Return a string representation
  //-----------------------------------------------------------------------
  public final String toString(){
    String str = null;
    str = "CatchupInvalIterator: cvv = " + this.currentVV.toString() 
      + " is = " + this.ss.toString();  
    return str;
  }

}


//---------------------------------------------------------------------------
/* $Log: CatchupInvalIterator.java,v $
/* Revision 1.10  2007/11/05 23:32:41  zjiandan
/* fix SubscribeBWunit.
/*
/* Revision 1.9  2007/09/10 23:52:22  zjiandan
/* upgrade to newest BerkeleyDB je version.
/*
/* Revision 1.8  2007/08/05 04:43:54  zjiandan
/* SocketServer shutdown quietly
/*
/* Revision 1.7  2007/06/25 05:21:28  zjiandan
/* Cleanup OutgoingConnection and add unit tests
/*
/* Revision 1.6  2007/04/12 17:09:32  zjiandan
/* fix across unit test mem leak.
/*
/* Revision 1.5  2007/04/02 21:11:38  zjiandan
/* snapshort for sosp2007.
/*
/* Revision 1.4  2007/03/16 07:10:18  zjiandan
/* fixed OutgoingConnection unittest.
/*
/* Revision 1.3  2007/03/15 21:58:31  dahlin
/* Added experimetn to test BW for subscribe for SOSP paper
/*
/* Revision 1.2  2007/03/08 21:41:17  nalini
/* total revamp of P2Runtime, update subscriptions removed, retry logic changed
/*
/* Revision 1.1  2007/03/06 18:25:50  zjiandan
/* Add optimization for CatchupInvalIterator, fixed SubscriptionSet, HierInvalTarget
/* and P2Runtime problems. Add aways split when receiving subtree ISStatus in Checkpoint.
/* */
//---------------------------------------------------------------------------
