package code;

 /** 
 *  CatchupStreamStartMsg -- 
 *    Msg marks the start of a Checkpoint stream. 
 **/ 
import java.io.Serializable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectInput;
import java.io.ObjectOutputStream;
import java.io.ObjectInputStream;

public class CatchupStreamStartMsg implements Externalizable{

  //
  // Members should be final here, but I'm to lazy
  // to make Externalization work with introspection...
  //
  private SubscriptionSet ss;
  private AcceptVV startVV;
  private static boolean perfDbg = false;

 /** 
 *  Constructor 
 **/ 
  public CatchupStreamStartMsg(SubscriptionSet ss, AcceptVV startVV){
    this.ss = ss;
    this.startVV = startVV;
  }


 /** 
 *  Constructor for externalization 
 **/ 
  public CatchupStreamStartMsg(){
    this.ss = null;
    this.startVV = null;
  }

 /** 
 *  writeExternal -- externalization 
 **/ 
  public void writeExternal(ObjectOutput out)
    throws IOException{
    long start = 0;
    if(perfDbg){
      start = System.currentTimeMillis();
    }

    //
    // note: to use the SubscriptionSet.write/readExternal directly
    //       is a little bit more expensive than
    //       copy the SubscriptionSet.write/readExternal here.
    //       which elliminate the SubscriptionSet class info
    //       and save 40 bytes per msg.
    //
    //  tbd: can optimize the AcceptVV the same way as well.
    //  
    String ssStr = "";
    if(!ss.isEmpty()){
      ssStr = ss.toString();
    }
    out.writeUTF(ssStr);
    
    out.writeObject(startVV);
    if(perfDbg){
      long end = System.currentTimeMillis();
      System.out.println("CatchupStreamStartMsg writeExternal takes " 
                         + (end-start) + " ms");
    }
  }
 /** 
 *  readExternal  
 **/ 
  public void readExternal(ObjectInput in)
    throws IOException, ClassNotFoundException{
    long start = 0;
    long middle = 0;
    if(perfDbg){
      start = System.currentTimeMillis();
    }
    String ssStr = (String)(in.readUTF());
    if(ssStr.equals("")){
      ss = SubscriptionSet.makeEmptySet();
    }else{
      ss = SubscriptionSet.makeSubscriptionSet(ssStr);
    }
    if(perfDbg){
      middle = System.currentTimeMillis();
    }
    startVV = (AcceptVV)in.readObject();
    if(perfDbg){
      long end = System.currentTimeMillis();
      System.out.println("CatchupStreamStartMsg readExternal takes " 
                         + (end-start) + " ms"
                         + "(ss took " + (middle-start) + ")"
                         + "(svv took " + (end-middle) + ")");
    }
  }

  public SubscriptionSet getSubscriptionSet(){
    return this.ss;
  }

  public AcceptVV getStartVV(){
    return this.startVV;
  }

 /** 
 *  Return true if the passed-in object is "equal" to this CatchupStreamStartMsg 
 **/ 
  public boolean
  equals(Object obj){
    boolean result = false;
    CatchupStreamStartMsg pi = null;

    
    if(obj instanceof CatchupStreamStartMsg){
      pi = (CatchupStreamStartMsg)obj;
      result = (this.ss.equals(pi.ss) &&
                this.startVV.equalsIgnoreNegatives(pi.startVV));
    }
    return(result);
  }

 /** 
 *  Convert this exception to a string 
 **/ 
  public String toString(){
	return("CatchupStreamStartMsg: (" + ss + ", " + startVV + " )" );
  }
}

//---------------------------------------------------------------------------
/* $Log: CatchupStreamStartMsg.java,v $
/* Revision 1.5  2007/07/15 06:21:29  zjiandan
/* optimize bw for cp exchange
/*
/* Revision 1.4  2007/05/31 06:02:01  zjiandan
/* add AllPreciseSetsUnit
/*
/* Revision 1.3  2007/05/25 21:06:01  dahlin
/* fixed 1 second delay on serializing start catchup stream; SubscribeBWUnit runs much faster -- though still nto as fast as I would like. Probably also need to convert catchup stream to catchup checkpoint
/*
/* Revision 1.2  2007/03/18 19:24:00  dahlin
/* *** empty log message ***
/*
/* Revision 1.1  2006/04/20 03:52:52  zjiandan
/* Callbacks merged with runTime.
/* */
//---------------------------------------------------------------------------
