package code;

import java.util.*;
import java.net.*;
import java.io.*;
import java.lang.*;


/**
 * CommandInterface.java
 *   
 *    interface that listens on a port, accepts commands, and responds
 *         -- commands and response routines are customizable by
 *            any other class using this class.
 *
 * @author Praveen Yalagandula
 * @version
 */

public class CommandInterface extends Thread {

    // Serversocket port
    int sport = 0;
    ServerSocket ssocket = null;
    
    // currently only one commandAnalyzer.. later multiple
    //  analyzers be installed.
    CommandAnalyzer comAnal ; 

    public CommandInterface(int _sport, 
			    CommandAnalyzer _comAnal) {
	sport = _sport ;
	comAnal = _comAnal ;
    }

    public void run() {
	assert(sport != 0) ;
	assert(ssocket == null) ;

	try {
	    ssocket = new ServerSocket(sport) ;	    
	} 
	catch( Exception e ) {
	    System.out.println(" Server socket creation failed "+ e );
	    assert(false) ;
	}
	assert(ssocket != null) ;
	//System.out.println(" Server socket succeded " + ssocket );

	// Read command and pass it to the commandAnalyzer
	String command = null;
	Socket s = null ;
	BufferedReader input = null ;

	while(ssocket!=null) {
	    try {
		System.out.println("Starting command socket listening on port "+sport);
		s  = ssocket.accept() ;
		System.out.println("got connection from "+s.getRemoteSocketAddress()) ;
		input = new BufferedReader( new InputStreamReader(s.getInputStream()));
	    } 
	    catch( Exception e ) {
		System.out.println( e );
		input = null ;
	    }
	    while(input != null && !s.isClosed()) {
		try {
		    command = input.readLine();
		} 
		catch( Exception e ) {
		    System.out.println("unable to read from command line:"+ e );
		    input = null ;
		}

		if(command != null) {
		    if(command.equals("quit")) {
			try{
			    s.close() ;
			    input.close() ;
			    input = null ;
			}
			catch(Exception e) {
			    System.out.println(e) ;
			}
		    }
		    else if(command.equals("kill")) {
			try{
			    s.close() ;
			    ssocket.close() ;
			}catch(Exception e) {
			    System.out.println(e) ;
			}
			System.exit(1) ;
		    }
		    else {
			String retVal = comAnal.processCommand(command) ;
			
			try{
			    PrintWriter out = new PrintWriter(s.getOutputStream(), true);
			    out.println(retVal) ;
			    out.flush() ;
			}catch(Exception e) {
			    System.out.println(e) ;
			}
		    }
		}
	    }
	}
    }

    public static String getAnswerForCommand(String hostName, int port, String command) {
	// open a client socket to the hostName and port
	// apply command and then quit
	// return the answer read from the server
	Socket cSocket = null; 
	PrintWriter out = null;
	BufferedReader in = null;
	String answer = null;

	try {
	    cSocket = new Socket(hostName, port);
	    out = new PrintWriter(cSocket.getOutputStream(), true);
	    in = new BufferedReader(new InputStreamReader(
							  cSocket.getInputStream()));
	    
	    out.println(command) ;
	    out.flush() ;
	    answer = in.readLine() ;
	}catch(Exception e) {
	    System.out.println(e) ;
	    //System.exit(1) ;
	    return "[could not connect]" ;
	}
	try {
	    out.println("quit") ;
	    out.flush() ;
	    if(cSocket != null) {
		in.close() ;
		out.close() ;
		cSocket.close() ;
	    }
	}catch(Exception e) {
	    System.out.println(e) ;
	}	    
	return answer ;
    }
    
    public static void main(String [] s) {
	CommandInterface cintf = new CommandInterface(5000, new TestCommandAnalyzer()) ;
	
	cintf.start() ;
    }

} // CommandInterface


// test command analyzer
//       -- that just returns the command string
class TestCommandAnalyzer implements CommandAnalyzer{
    // default constructor
    
    public String processCommand(String command) {
	assert(command != null) ;
	return command ;
    }
}

    

//---------------------------------------------------------------------------
/* $Log: CommandInterface.java,v $
/* Revision 1.1  2005/09/13 17:19:47  ypraveen
/* *** empty log message ***
/*
/*
/*
 */
//---------------------------------------------------------------------------
