package code;
 /** 
 *  Represents an invalidate that indicates the "Commit" acceptStamp  
 *  for a given previous precise invalidation. 
 *   
 **/ 
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectInput;


//reflection class used for workaround custom serialize private final fields
import java.lang.reflect.Field;
import java.lang.reflect.AccessibleObject;

import code.branchDetecting.BranchID;
import code.security.SangminConfig;



public class CommitInv implements GeneralInv, SingleWriterInval, Immutable, Externalizable
{

  private static boolean doExpensiveSanityChecksForRead = Env.getDoExpensiveSanityChecks();
  private static boolean doExpensiveSanityChecksForWrite = Env.getDoExpensiveSanityChecks();
  private static boolean warnedExpensiveSanity = false;
  private final InvalTarget targetSet;
  private final AcceptStamp commitAS;
  private final AcceptStamp targetAS;
  private final AcceptStamp realTimeAS;
  
 /** 
 *  empty Constructor for serialization 
 **/ 
  public CommitInv(){
    targetSet = null;
    commitAS = null;
    targetAS = null;
    realTimeAS = null;
  }

 /** 
 *  Constructor 
 **/ 
  public
  CommitInv(InvalTarget targetSet,
             AcceptStamp commitAS,
             AcceptStamp targetAS,
             AcceptStamp realTimeAS){
    assert targetSet instanceof ObjInvalTarget 
    || targetSet instanceof MultiObjInvalTarget;
    assert(targetAS.lt(commitAS));
    this.targetSet = targetSet;
    this.commitAS = commitAS;
    this.targetAS = targetAS;
    this.realTimeAS = realTimeAS;
  }


 /** 
 *  Serialization -- optimization to reduce the pikles in the serialization  
 *                   and improve the performance -- removed from  
 *                   TaggedOutputStream to here 
 **/ 
  public void writeExternal(ObjectOutput out)
    throws IOException{

    if(doExpensiveSanityChecksForWrite && !warnedExpensiveSanity){
      Env.performanceWarning("PreciseInv -- doExpensiveSanityChecks on");
      warnedExpensiveSanity = true;
    }

    if(doExpensiveSanityChecksForWrite){
      //
      // Don't forget to update this when you change the definition
      // of the object
      //
      //System.out.println(PreciseInv.class.getDeclaredFields().length);
      doSanityCheck();
      doExpensiveSanityChecksForWrite = false;
    }
 
    out.writeObject(this.targetSet);
    if(SangminConfig.forkjoin){
      out.writeLong(this.commitAS.getLocalClock());
      out.writeObject(this.commitAS.getNodeId());      
      out.writeLong(this.targetAS.getLocalClock());
      out.writeObject(this.targetAS.getNodeId());
      out.writeLong(this.realTimeAS.getLocalClock());
      out.writeObject(this.realTimeAS.getNodeId());  
    } else {
      out.writeLong(this.commitAS.getLocalClock());
      out.writeLong(this.commitAS.getNodeId().getIDint());
      out.writeLong(this.targetAS.getLocalClock());
      out.writeLong(this.targetAS.getNodeId().getIDint());
      out.writeLong(this.realTimeAS.getLocalClock());
      out.writeLong(this.realTimeAS.getNodeId().getIDint());
    }
    
  }

  
 /** 
 *  Serialization --  optimization to reduce the pikles in the serialization  
 *                   and improve the performance --originated from  
 *                   TaggedInputStream 
 **/ 
  public void readExternal(ObjectInput in)
    throws IOException,
    ClassNotFoundException{
    
    if(doExpensiveSanityChecksForRead){
      //
      // Don't forget to update this when you change the definition
      // of the object
      //
      //System.out.println(PreciseInv.class.getDeclaredFields().length);
      doSanityCheck();
      //turn off
      doExpensiveSanityChecksForRead = false;
    }

    
    
    
    Field[] f = new Field[4];
      
      try{

        f[0] = this.getClass().getDeclaredField("targetSet");
        f[1] = this.getClass().getDeclaredField("commitAS");
        f[2] = this.getClass().getDeclaredField("targetAS");
        f[3] = this.getClass().getDeclaredField("realTimeAS");
      }catch(NoSuchFieldException ne){
        assert false;
      }
      try{
        AccessibleObject.setAccessible(f, true);
      } catch (SecurityException se){
        assert false;
      }
      try{
        f[0].set(this, in.readObject());
        long ts = in.readLong();
        NodeId nId = SangminConfig.forkjoin?
              (BranchID)in.readObject():new NodeId(in.readLong());       
        f[1].set(this, new AcceptStamp(ts, nId));
        ts = in.readLong();
        nId = SangminConfig.forkjoin?
              (BranchID)in.readObject():new NodeId(in.readLong());
        f[2].set(this, new AcceptStamp(ts, nId));
        ts = in.readLong();
        nId = SangminConfig.forkjoin?
              (BranchID)in.readObject():new NodeId(in.readLong());
        f[3].set(this, new AcceptStamp(ts, nId));
      }catch(IllegalArgumentException ie){
        assert false;
      }catch(IllegalAccessException iae){
        assert false;
      }
      
      try{
        AccessibleObject.setAccessible(f, false);
      } catch (SecurityException se){
        assert false;
      }
  }
  
 /** 
 *  Do sanity check for the custom object serialization 
 *  so that we don't forget updating the readObject and writeObject 
 *  when the object definition is changed 
 **/ 
  final private void doSanityCheck(){
    
     
    //the fields we custom serialize remain the same
    int totalFields = 7;
    int hiddenFields = 2;
    assert(this.getClass().getDeclaredFields().length == totalFields+hiddenFields):
      "" +this.getClass().getDeclaredFields().length;
    int count = 0;
    Field[] f = new Field[4];  
      try{
        f[count] = this.getClass().getDeclaredField("targetSet");         
        assert (f[count].getType().getName().equals("InvalTarget"));
    
        count++;
        f[count] = this.getClass().getDeclaredField("commitAS");         
        assert (f[count].getType().getName().equals("AcceptStamp"));
        
        f[count] = this.getClass().getDeclaredField("targetAS");         
        assert (f[count].getType().getName().equals("AcceptStamp"));
        
        f[count] = this.getClass().getDeclaredField("realTimeAS");         
        assert (f[count].getType().getName().equals("AcceptStamp"));
        
      }catch(NoSuchFieldException ne){
        assert false;
      }
  }

 /** 
 *  Return a hash code for this object 
 *  NOTE: Do nothing for now 
 **/ 
  public int
  hashCode(){
    assert(false);
    return(0);
  }

 /** 
 *  Return true if "this" equals "obj" 
 **/ 
  public boolean
  equals(Object obj){
    boolean result = false;
    CommitInv bi = null;
    
    // 2 Java-provided fields + 5 declared fields
    // System.out.println(this.getClass().getDeclaredFields().length );
    if(doExpensiveSanityChecksForRead){
      //
      // Don't forget to update this when you change the definition
      // of the object
      //
      //System.out.println(PreciseInv.class.getDeclaredFields().length);
      doSanityCheck();
      //turn off
      doExpensiveSanityChecksForRead = false;
    }
    
    if(obj instanceof CommitInv){
      bi = (CommitInv)obj;
      result = (this.targetSet.equals(bi.targetSet) &&
                this.commitAS.equals(bi.commitAS) &&
                this.realTimeAS.equals(bi.realTimeAS) &&
                (this.targetAS.equals(bi.targetAS)));
    }
    return(result);
  }

 /** 
 *  Return the target Accept Stamp 
 **/ 
  public final AcceptStamp
  getTargetAS(){
    return(this.targetAS);
  }

  public final AcceptStamp
  getCommitAS(){
    return this.commitAS;
  }
  
  public final InvalTarget getTargetSet(){
    return this.targetSet;
  }
  
  
 /** 
 *  Clone this object 
 *  
 *  If we *know* that this object and all objects we reference 
 *  are immutable, then just return this; otherwise perform 
 *      newOne = super.clone();  
 *      now replace any fields in newOne that point to mutable  
 *          objects with a clone of that field 
 *      return newOne 
 *  
 **/ 
  public Object
  clone(){
    assert(this instanceof Immutable);
    return this;
  }
  

 /** 
 *  METHODS INHERITED FROM GENERALINV: -- Overrides PreciseInval 
 **/ 

  private static boolean warned2 = false;
 /** 
 *  Return a new invalidate with mutiple operations performed 
 **/ 
  public GeneralInv
  cloneIntersectInvaltargetChopStartEnd(GeneralInv inv){
    InvalTarget invTarget = null;
    GeneralInv intersectInv = null;

    if(!warned2){
      Env.tbd("Check code for cloneIntersectInvaltargetChopStartEndCSN()"
              + " for all subclasses of GeneralInv."
              + " I don't trust it (see TODO.txt)");
      warned2 = true;
    }
    // This call should be made for uncommitted invalidates only

    invTarget = this.getInvalTarget().getIntersection(inv.getInvalTarget());
    assert(invTarget != null);
    if(invTarget instanceof ObjInvalTarget){
      assert this.targetSet instanceof ObjInvalTarget;
      intersectInv = this;
     
    }else if(invTarget instanceof HierInvalTarget){
      //should never reached here. It does not make sense to have a CommitInv occupy a timestamp where 
      //there's another overlapping invalidate that covers the same timestamp but with different objInval.
      assert false: "this=" + this.toString() + " inv=" + inv.toString() 
        + " intersection=" +invTarget.toString();//added by zjd
      
    }else if(invTarget instanceof MultiObjInvalTarget){
      assert this.targetSet instanceof MultiObjInvalTarget;
      intersectInv = this;
    }else{
      System.err.println("Invalid inval target type");
      assert(false);
    }
    return(intersectInv);
  }

  
 /** 
 *  METHODS INHERITED FROM SINGLEWRITERINVAL 
 **/ 

 /** 
 *  Convert to a string 
 **/ 
  public final String
  toString(){
    String str = null;

    str = "CommitInv: <" + "targetSet=" + targetSet.toString() 
      + " commitAS=" + this.commitAS 
      + " targetAS=" + this.targetAS + " "
      + " realTimeAS=" + this.realTimeAS;
    return(str);
  }

 /** 
 *  memSize() -- 
 *    Estimate the memory footprint of this object in a cheap while not 
 *    very accurate way +/- 1~7 bytes.  
 *  
 *  Use SizeOf and TestClass to get the number of overheads: 
 *  whenever delete or add new members, recalculate the number of bytes 
 *  refering to universalReplication/designDoc/FootPrintSizeOfStandardObject.txt 
 **/ 
  public long memSize(){
    return 200;//this is very conservate, doesn't count the multiple object inv
  }

  public boolean anyComponentIncludedBy(VV vv){
    return(vv.includes(this.commitAS));

  }

  public final AcceptVV getEndVV(){
   return this.getStartVV();
  }

  public final InvalTarget getInvalTarget(){
    return this.targetSet;
  }

 /** 
 *  Return the portion of an invalidate for one writer whose 
 *  starting stamp is potentially chopped. 
 **/ 
  public GeneralInv getOneWriterSubsetFrom(NodeId node, long startStampInclusive){
    /*
    return an invalidation (possibly this) with
    interestSet = this.interestSet
    nodeId = node // assert node was in this.VV
    startVV{node} == startStampInclusive
      // assert this.startStamp{node} >= startSTampInclusive
    endVV{node} == this.endVV{node}
    (Note: OK to just return this if we meet all of the other criteria)
  */
  GeneralInv subsetInv = null;
  assert(node.equals(this.commitAS.getNodeId()));
  if(this.commitAS.getLocalClock() == startStampInclusive){
      subsetInv = this;
  }
  return(subsetInv);

  }

  public final AcceptVV getRTVV(){
    AcceptVV vv = null;
    AcceptStamp[] uniStamp = null;

    assert this.realTimeAS != null;

    uniStamp = new AcceptStamp[1];
    uniStamp[0] = this.realTimeAS;
    vv = new AcceptVV(uniStamp);
    return(vv);

  }

  public final AcceptVV getStartVV(){
    AcceptVV vv = null;
    AcceptStamp[] uniStamp = null;

    uniStamp = new AcceptStamp[1];
    uniStamp[0] = this.commitAS;
    vv = new AcceptVV(uniStamp);
    return(vv);

  }

  public boolean isBound(){
    return false;
  }

  public boolean isCommitted(){
    return true;
  }

  public boolean isDelete(){
    return false;
  }

  public boolean isEmbargoed(){
    return false;
  }

  public boolean isIncludedBy(VV vv){
    return(vv.includes(this.commitAS));

  }

  public boolean isPrecise(){
    return true;
  }

  
 /** 
 *  Create a new generalInv that is the union of this and i 
 **/ 
    public GeneralInv
    newUnion(GeneralInv i, SubscriptionSet ss){
      assert (!this.isEmbargoed());
      assert (!i.isEmbargoed());
      /*
        each element of startVV is min of corresponding
                        end        max
        interest set is union of corresponding
        assert(either both are uncommitted or both are committed)
        if both committed
           assert no gap between csnEnd of one and csnStart of
             next (OK to overlap)
           csnstart = min of both csnStart
           csnEnd = max of both csnMax
      */
      InvalTarget it = null;
      ImpreciseInv impreciseInv = null;
      AcceptVV newStartVV = null;
      AcceptVV newEndVV = null;
      AcceptVV newRTVV = null;

      it = (i.getInvalTarget()).getUnion(this.targetSet, ss);

      if((it instanceof ObjInvalTarget) && (!i.equals(this))){
        assert this.targetSet instanceof ObjInvalTarget;
        ObjInvalTarget mytargetset = (ObjInvalTarget) this.targetSet;
        it = HierInvalTarget.makeHierInvalTarget(mytargetset.getObjId().getPath());
      }else if((it instanceof MultiObjInvalTarget)&&(!i.equals(this))){
        // Convert the returned object into a HierInvalTarget because we need
        // to build an Imprecise Invalidate out of the union
        it = ((MultiObjInvalTarget)it).makeHierInvalTarget();
      }
      assert(it instanceof HierInvalTarget);

      // Make an imprecise inval out of this
      newStartVV = this.getStartVV().cloneMinVV(i.getStartVV());
      newEndVV = this.getEndVV().cloneMaxVV(i.getEndVV());
      assert this.getRTVV() != null;
      newRTVV = this.getRTVV().cloneMaxVV(i.getRTVV());
      impreciseInv = new ImpreciseInv((HierInvalTarget)it,
                                      newStartVV,
                                      newEndVV,
                                      newRTVV);
      return(impreciseInv);
    }

 /** 
 *  Return -1, 0, or 1 if this is smaller, equal, or larger than 
 *  gi2, respectively, based on mechanism to provide total orders. 
 **/ 
    public int
    totalOrderCompare(GeneralInv gi2){
      /*
        return -1 if this < gi2 in the total order of the log
        return +1 if this > gi2 in the total order of the log
        return 0 if this and gi2 are equivalent and can be ordered either
        way (both start at the same time and end at the same time)

        we sort by CSN then by min acceptStamp then by serverId

        (1) CSN

        If this.CSN < gi2.CSN, then return -1

        Note that an unassigned CSN has an infinite value)

        For a bulk invalidation, consider the *minimum* CSN included
        in the invalidation.

        If this.CSN == gi2.CSN != CSN_UNASSIGNED, either order 
        is legal. If either is a bulk invalidation, the one with 
        the lower maxCSN goes first. If both have the same maxCSN
        then return 0

        (2) startTime acceptStamp

        assert this.CSN == gi2.CSN == CSN_UNASSIGNED

        if the invalidation is precise, consider its acceptStamp
        if the invalidation is imprecise, consider the startVV and
        look at the minimum entry across all nodeId's in startVV

        if they differ, return -1 or 1

        (3) nodeId
        if both minimum accept stamps in step (2) are equal, 
        then compare the node Ids

        if they differ, return -1 or 1

        (4) endtime acceptStamp

        assert csn, startTime, and nodeId are all the same

        send the "more precise" one first --> look at the endTime
        and the one with the smaller max endtime comes first

        if they differ, return -1 or 1
        if they are the same, return 0 (note that if the invals are
        imprecise, they may still differ in elements other than
        their max or min...but that's ok)
      */
      int result = 0;
      long stamp = Long.MAX_VALUE;
      long minStamp = Long.MAX_VALUE;
      Object gi2StampToken = null;
      Object minStampToken = null;
      AcceptVV gi2AcceptVV = null;
      NodeId nodeId = null;
      VVIterator i = null;

      gi2AcceptVV = gi2.getStartVV();
      for(i = gi2AcceptVV.getIterator(); i.hasMoreElements();){
        gi2StampToken = i.getNext();
        stamp = gi2AcceptVV.getStampByIteratorToken(gi2StampToken);
        if(stamp < minStamp){
          minStamp = stamp;
          minStampToken = gi2StampToken;
        }
      }
      assert(minStampToken != null);
      if(this.commitAS.getLocalClock() < minStamp){
        result = -1;
      }else if(minStamp < this.commitAS.getLocalClock()){
        result = 1;
      }else{
        nodeId = gi2AcceptVV.getServerByIteratorToken(minStampToken);
        // NOTE: NodeId.compareTo must return {-1,0,1}
        result = this.commitAS.getNodeId().compareTo(nodeId);
        if(result == 0){
          // NodeId's are the same; try end stamps
          assert(this.commitAS.getNodeId().equals(nodeId));
          if(this.commitAS.getLocalClock() <
             gi2.getEndVV().getMaxTimeStamp()){
            result = -1;
          }else if(gi2.getEndVV().getMaxTimeStamp() <
                   this.commitAS.getLocalClock()){
            result = 1;
          }else{
            result = 0;
          }
        }
      }
      return(result);
    }

 /** 
 *  Return the start vv entry for this writer (start == end for precise) 
 **/ 
    public long
    getStart(){
      return(this.commitAS.getLocalClock());
    }

 /** 
 *  Return the end vv entry for this writer (start == end for precise) 
 **/ 
    public long
    getEnd(){
      return(this.commitAS.getLocalClock());
    }

 /** 
 *  Return the real vv entry for this writer 
 **/ 
    public long
    getReal(){
      return this.realTimeAS.getLocalClock();
    }

 /** 
 *  Return the ID of the node that did this write 
 **/ 
    public NodeId
    getNodeId(){
      return(this.commitAS.getNodeId());
    }

 /** 
 *  Clone this object while chopping off a prefix of the startTime 
 **/ 
    public SingleWriterInval
    cloneChopStartTime(long startTimeOfNew){
      assert(this.commitAS.getLocalClock() == startTimeOfNew);
      return((SingleWriterInval)this.clone());
    }

 /** 
 *  Clone this object while chopping off a suffix of the startTime 
 **/ 
    public SingleWriterInval
    cloneChopEndTime(long endTimeOfNew){
      assert(this.commitAS.getLocalClock() == endTimeOfNew);
      return((SingleWriterInval)this.clone());
    }

 

  
}

/* $Log$*/
