package code;
//package utils.junit;

import junit.textui.TestRunner;
import junit.framework.*;
import java.io.ObjectOutputStream;
import java.io.ObjectInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
/**
 * TBD: Update class name
 */
public class CommitInvUnit extends TestCase {
  public static final String TEST_ALL_TEST_TYPE = "UNIT";
  
  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public CommitInvUnit (final String s) {
    super (s);
  }

  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
    /* 
     * TBD: Insert other fixture code here
     * e.g., this.objectUnderTest = new ClassToBeTested(...);
     */
  }

  protected void tearDown() throws Exception{
    /* 
     * TBD: Insert other fixture cleanup code here
     */
    super.tearDown();
  }

 /** 
 *  test basic functions
 
 **/ 
  public void testBasicFunction(){
    CommitInv ii1 = null;
    CommitInv ii2 = null;
    ByteArrayOutputStream baos = null;
    ByteArrayInputStream bais = null;
    ObjectOutputStream oos = null;
    ObjectInputStream ois = null;

    // Test 1
    // Try a simple invalidate
    try{
      baos = new ByteArrayOutputStream();
      oos = new ObjectOutputStream(baos);
      byte[] data = new byte[2];
      data[0] = 0;
      data[1] = 1;
      
      AcceptStamp commitAS = null, targetAS = null, realAS = null;
      ObjInvalTarget oit = new ObjInvalTarget(new ObjId("/b"),
          0,
          2);
      commitAS = new AcceptStamp(1, new NodeId(11));
      targetAS = new AcceptStamp(1, new NodeId(10));
      realAS = targetAS;
      
      ii1 = new CommitInv(oit,
                           commitAS,
                           targetAS,
                           realAS);

      //System.out.println("test " + ii1);
      oos.writeObject(ii1);
      oos.flush();
      oos.close();
      baos.flush();
      baos.close();

      bais = new ByteArrayInputStream(baos.toByteArray());
      ois = new ObjectInputStream(bais);
      try{
        ii2 = (CommitInv)(ois.readObject());
      }catch(ClassNotFoundException ce){
        ce.printStackTrace();
        assert false;
      }
      //System.out.println("get " + ii2);
      assert(ii1 != ii2);
      assert(ii2.equals(ii1)):"read from stream: " +ii2.toString() + " original: " + ii1.toString();
      assert(ii1.equals(ii2));
    }catch(IOException e){
      e.printStackTrace();
      System.out.println("" + e);
      assert(false);
    }
  }
  
  public void testBasic2(){
    // To test: Constructors
    // To test: clone()
    byte[] bdy1 = null;
    CommitInv bi1 = null;
    CommitInv bi2 = null;
    // Test 1
    bdy1 = new byte[5];
    bdy1[0] = 10;
    bdy1[1] = 9;
    bdy1[2] = 8;
    bdy1[3] = 7;
    bdy1[4] = 6;
    ImmutableBytes body1 = new ImmutableBytes(bdy1);

    ObjInvalTarget oit = null;
    
    AcceptStamp commitAS = null, targetAS = null, realAS = null;
    oit = new ObjInvalTarget(new ObjId("obj1"),
        10,
        body1.getLength());
    commitAS = new AcceptStamp(190, new NodeId(200));
    targetAS = new AcceptStamp(20, new NodeId(400));
    realAS = targetAS;
    // Test 1: Comparison to self
    bi1 = new CommitInv(oit,
                        commitAS,
                        targetAS,
                        realAS);
    
    
    //System.out.println("bi1 = " + bi1.toString());
    //System.out.println("bi1.clone() = " + bi1.clone());
    bi2 = (CommitInv)bi1.clone();
    
    //System.out.println("(bi1.clone().getBody() == bi1.getBody()) = " +
    //                   (bi2.getTargetAS().equals(bi1.getTargetAS())));
    
    assert bi1.equals(bi2);
    assert bi2.equals(bi1);

    // Test 2a
    commitAS = new AcceptStamp(200, new NodeId(300));
    targetAS = new AcceptStamp(21, new NodeId(400));
    
    realAS = targetAS;
    // Test 1: Comparison to self
    bi1 = new CommitInv(oit,
                        commitAS,
                        targetAS,
                        realAS);
    
    //System.out.println("bi1 = " + bi1);
    assert(bi1.getTargetAS().equals(new AcceptStamp(21, new NodeId(400))));
    
  }
  
 /** 
 *  test the custom serialization methods
 
 **/ 
  public void testEquals(){
    CommitInv bi1 = null;
    CommitInv bi2 = null;
    byte[] data1 = null;
    ImmutableBytes body1 = null;

    data1 = new byte[5];
    data1[0] = 10;
    data1[1] = 9;
    data1[2] = 8;
    data1[3] = 7;
    data1[4] = 6;
    body1 = new ImmutableBytes(data1);
    ObjInvalTarget oit = null;
    
    AcceptStamp commitAS = null, targetAS = null, realAS = null;
    oit = new ObjInvalTarget(new ObjId("obj1"),
        10,
        body1.getLength());
    commitAS = new AcceptStamp(200, new NodeId(300));
    targetAS = new AcceptStamp(21, new NodeId(400));
    realAS = targetAS;
    // Test 1: Comparison to self
    bi1 = new CommitInv(oit,
                        commitAS,
                        targetAS,
                        realAS);
    assert(bi1.equals(bi1));

    oit =new ObjInvalTarget( new ObjId("/obj2"),
                            20,
                            body1.getLength());
    // Test 2: Successful comparison to equal
    bi1 = new CommitInv(oit,
            commitAS,
            targetAS,
            realAS);
    
    bi2 = new CommitInv(oit,
        commitAS,
        targetAS,
        realAS);
    assert(bi1.equals(bi2));
    assert(bi2.equals(bi1));

    // Test 3: Unsuccessful comparison to equal
    oit =new ObjInvalTarget(new ObjId("/obj3"),
        10,
        body1.getLength());
    bi1 = new CommitInv(oit,
        commitAS,
        targetAS,
        realAS);
    
    targetAS = new AcceptStamp(22, new NodeId(400));
    bi2 = new CommitInv(oit,
        commitAS,
        targetAS,
        realAS);
    assert(!bi2.equals(bi1));
    assert bi1.isCommitted();
    assert bi2.isCommitted();
    assert bi1.isPrecise();
    assert bi2.isPrecise();
  }
  
  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(CommitInvUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "CommitInvUnit";
    System.err.print(name + " self test begins...");
    TestRunner tr = new TestRunner();
    tr.doRun(suite());
    System.err.println(name + " self test succeeds");
  }

}

//---------------------------------------------------------------------------
/* $Log$*/
//---------------------------------------------------------------------------
