package code;

import code.branchDetecting.BranchID;
import code.gnu.getopt.Getopt;
import code.gnu.getopt.LongOpt;
import code.security.Crypto;
import code.security.SangminConfig;

import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.TreeSet ;
import java.util.Iterator ;
import java.net.*;

import java.security.*;

 /** 
 * Config:: parse config file and store it in the in-mem data structure 

 * to add a new field: 
 * 1. increment MAX_CONFIG_FIELDS 
 * 2. add a member to store the value 
 * 3. add an element for longopts in readConfig() 
 * longopts[14] =  new LongOpt("COMM_PORT", LongOpt.REQUIRED_ARGUMENT, null, 14); 
 * 4. add a case like this: 
 * case 14: 
 * commPort = (new Integer(g.getOptarg())).intValue(); 
 * break ; 
 * 5. add a parameter for ConfigEntry class construct 
 * 6. add a method to get the new member in Config and in ConfigEntry 
 **/ 
public class Config{
  public static final int MAX_CONFIG_FIELDS = 17;
  static String configFile;
  static Hashtable allConfigurations; // Hash table of configEntries keyed by nodeId
  static boolean initialized = false;
  public static final long CACHE_SIZE_BYTES_DEFAULT = 50000000;
  public static final long MAX_LOG_DISK_SIZE_BYTES = Long.MAX_VALUE;//~inf
  public static final long MAX_LOG_MEM_SIZE_BYTES = Long.MAX_VALUE;//~inf

  static public Hashtable<Long,PublicKey> publicKeys;
  static public Hashtable<Long,PrivateKey> privateKeys;
  
  // GLOBAL CONFIG Entries
  
  static final String GLOBAL_START = "***Start Global Config";
  static final String GLOBAL_END = "***End Global Config";
  
  static int NUM_LOGICAL_NODES = -1;
  
  // End global config entries
  
 /** 
 *  read Configuration from the file 
 **/ 
  public static void readConfig(String configF) 
  {
    /*
     * Read the configuration file entry for this nodeId
     * and set up member variables.
     * A config file has a number of entries (one per node in the system),
     *  each of the following format:
     *
     * NODEID <id>
     *   DNS <name>
     *   PORT_INVAL <port>
     *   PORT_BODY  <port>
     *   PORT_NICE  <port>
     *   PORT_CP    <port>
     *   PORT_SYNC  <port>
     *   LOCAL_STORAGE <path>
     *   LOCAL_INTERESTSET <path>
     *   SDIMS_NODENAME <name>  
     *   SDIMS_PORT <port> 
     *   CACHE_SIZE_BYTES <size>
     *   ***END***
     * Note that multiple instances of a URA node can co-exist
     * on a single physical node.
     */

    int input;
    NodeId nodeId = null;
    String DNS = null;
    int portInval = -1;
    int portBody = -1;
    int portNice = -1;
    int portCP = -1;
    int portSync = -1;
    long bw = -1;
    String localStore = null;
    String interestSet = null;
    String sdimsNodeName = null ;
    int sdimsPort = -1 ;
    int commPort = -1 ;
    long nwDelay = -1;
    long cacheSizeBytes = CACHE_SIZE_BYTES_DEFAULT;
    long logDiskSizeBytes = MAX_LOG_DISK_SIZE_BYTES;
    long logMemSizeBytes = MAX_LOG_MEM_SIZE_BYTES;

    String host = null;

    configFile = configF;

    try {
//    host = getUnqualifiedName(InetAddress.getLocalHost().getHostName());
      host = InetAddress.getLocalHost().getHostName();
    } catch (Exception e){
      e.printStackTrace();
    }

    allConfigurations = new Hashtable();
    int optCount = 0;
    String fileInput[] = null;
    LongOpt[] longopts = new LongOpt[MAX_CONFIG_FIELDS+1];
    longopts[0] = new LongOpt("NODEID", LongOpt.REQUIRED_ARGUMENT, null, 0);
    longopts[1] = new LongOpt("DNS", LongOpt.REQUIRED_ARGUMENT, null, 1);
    longopts[2] = new LongOpt("PORT_INVAL", LongOpt.REQUIRED_ARGUMENT, null, 2);
    longopts[3] = new LongOpt("PORT_BODY", LongOpt.REQUIRED_ARGUMENT, null, 3);
    longopts[4] = new LongOpt("PORT_NICE", LongOpt.REQUIRED_ARGUMENT, null, 4);
    longopts[5] = new LongOpt("PORT_CP", LongOpt.REQUIRED_ARGUMENT, null, 5);
    longopts[6] = new LongOpt("PORT_SYNC", LongOpt.REQUIRED_ARGUMENT, null, 6);
    longopts[7] = new LongOpt("LOCAL_STORAGE", LongOpt.REQUIRED_ARGUMENT, null, 7);
    longopts[8] =  new LongOpt("LOCAL_INTERESTSET", LongOpt.REQUIRED_ARGUMENT, null, 8);
    longopts[9] =  new LongOpt("BW", LongOpt.REQUIRED_ARGUMENT, null, 9);
    longopts[10] =  new LongOpt("SDIMS_NODENAME", LongOpt.REQUIRED_ARGUMENT, null, 10);
    longopts[11] =  new LongOpt("SDIMS_PORT", LongOpt.REQUIRED_ARGUMENT, null, 11);
    longopts[12] = new LongOpt("NW_DELAY", LongOpt.REQUIRED_ARGUMENT, null, 12);

    longopts[13] =  new LongOpt("COMM_PORT", LongOpt.REQUIRED_ARGUMENT, null, 13);
    // max memory size for BerkeleyDB cache
    longopts[14] = new LongOpt("BERKELEYDB_CACHE_SIZE_BYTES", LongOpt.REQUIRED_ARGUMENT, null, 14);

    longopts[15] = new LongOpt("LOG_DISK_SIZE_BYTES", LongOpt.REQUIRED_ARGUMENT, null, 15);

    longopts[16] = new LongOpt("LOG_MEM_SIZE_BYTES", LongOpt.REQUIRED_ARGUMENT, null, 16);

    longopts[17] = new LongOpt("***END***", LongOpt.NO_ARGUMENT, null, 17);

    fileInput = parseFile(configF);

    Getopt g = new Getopt("Config", fileInput, "", longopts, true);
    while((input = g.getopt()) != -1){
      switch(input){
        case 0: 
          int id = (new Integer(g.getOptarg())).intValue();
          assert(id>=0);
          nodeId = new NodeId(id);
          //if(SangminConfig.forkjoin){
          // nodeId = new BranchID(nodeId.getIDint()); 
          //}
          optCount ++;
          break;
        case 1:
          DNS = g.getOptarg();
          optCount ++;
          break;
        case 2:
          portInval = (new Integer(g.getOptarg())).intValue();
          optCount ++;
          break;
        case 3:
          portBody = (new Integer(g.getOptarg())).intValue();
          optCount ++;
          break;
        case 4: 
          portNice = (new Integer(g.getOptarg())).intValue();
          optCount ++;
          break;
        case 5: 
          portCP = (new Integer(g.getOptarg())).intValue();
          optCount ++;
          break;
        case 6: 
          portSync = (new Integer(g.getOptarg())).intValue();
          optCount ++;
          break;
        case 7:
          localStore = g.getOptarg();
          optCount ++;
          break;
        case 8:
          interestSet = g.getOptarg();
          optCount ++;
          break;
        case 9:
          bw = (new Long(g.getOptarg())).longValue();
          optCount ++;
          break;
        case 10:
          sdimsNodeName = g.getOptarg();
          optCount ++;
          break;
        case 11:
          sdimsPort = (new Integer(g.getOptarg())).intValue();
          optCount ++;
          break;
        case 12:
          nwDelay = (new Long(g.getOptarg())).longValue();
          optCount ++;
          break;
        case 13:
          commPort = (new Integer(g.getOptarg())).intValue();
          break ;
        case 14:
          cacheSizeBytes = (new Long(g.getOptarg())).longValue();
          optCount ++;
          break;
        case 15:
          logDiskSizeBytes = (new Long(g.getOptarg())).longValue();
          optCount ++;
          break;
        case 16:
          logMemSizeBytes = (new Long(g.getOptarg())).longValue();
          optCount ++;
          break;  
        case 17:
          /*
            if(optCount!=MAX_CONFIG_FIELDS){
            System.err.println("Not all the required options are specified in the config file.");
            System.exit(-1);
            }
           */

          ConfigEntry configE = new ConfigEntry(nodeId, DNS, 
              portInval, portBody, portNice,
              portCP, portSync, 
              localStore, interestSet, bw,
              sdimsNodeName, sdimsPort,
              commPort,
              nwDelay,
              cacheSizeBytes,
              logDiskSizeBytes,
              logMemSizeBytes);
          allConfigurations.put(configE.getNodeId(), configE);

          optCount = 0;
          break;
        case '?':
          System.err.println("The option '" + (char)g.getOptopt() + "' is not valid.");
          System.exit(-1);
          break;
        default:
          System.err.println("getopt() returned " + input);
        System.exit(-1);
        break;
      }
    }

    readKeys();

    initialized = true;
  }

  public static void generateKeys(){

  }

  public static void readKeys(){
    // Temporary way to distribute public keys

    {
      // read public keys from disk
      try{ 
      	Crypto.readKeys();
      } catch (Exception e){
        System.err.println(e.toString());
        e.printStackTrace();
        System.exit(-1);
      }
    }


  }

 /** 
 *  for test only 
 *  config the system by calling the addOneNodeConfig() method 
 *  instead of reading from a config file 
 **/ 
  public static void createEmptyConfig(){
    configFile = "EMPTY.config";
    allConfigurations = new Hashtable(); 
  }

  public final static String getConfigFile(){
    return configFile;
  }

 /** 
 *  add one node configuration into the config object 
 **/ 
  public static void addOneNodeConfig(NodeId nodeId,
      String dns,
      int portInval,
      int portBody,
      int portNice,
      int portCP,
      int portSync,
      String localstore,
      String interestSet,
      long bw,
      String sdimsNodeName,
      int sdimsPort,
      int commPort,
      long nwDelay,
      long cacheSizeBytes,
      long logDiskSizeBytes,
      long logMemSizeBytes){
    ConfigEntry configE = new ConfigEntry(nodeId, dns, 
        portInval, portBody, portNice,
        portCP, portSync, 
        localstore, interestSet, bw,
        sdimsNodeName, sdimsPort,
        commPort,
        nwDelay,
        cacheSizeBytes,
        logDiskSizeBytes,
        logMemSizeBytes);
    allConfigurations.put(configE.getNodeId(), configE);
    initialized = true;
  }

 /** 
 *  write the current configuration into a file 
 **/ 
  public static void writeToFile(String newConfigFileName){
    String s;
    try{
      FileOutputStream fos = new FileOutputStream(newConfigFileName);
      
      writeGlobalEntries(fos);
      
      for(Enumeration e = allConfigurations.elements(); e.hasMoreElements();){
        ConfigEntry ce = (ConfigEntry)e.nextElement();
        s = "NODEID " + ce.getNodeId() + "\n";
        fos.write(s.getBytes());
        s = "DNS " + ce.getDNS() + "\n";
        fos.write(s.getBytes());
        s = "PORT_INVAL " + ce.getPortInval() +"\n";
        fos.write(s.getBytes());
        s = "PORT_BODY " + ce.getPortBody() +"\n";
        fos.write(s.getBytes());
        s = "PORT_NICE " + ce.getPortNice() +"\n";
        fos.write(s.getBytes());
        s = "PORT_CP " + ce.getPortCP() +"\n";
        fos.write(s.getBytes());
        s = "PORT_SYNC " + ce.getPortSync() +  "\n";
        fos.write(s.getBytes());
        s = "LOCAL_STORAGE " + ce.getLocalStore() + "\n";
        fos.write(s.getBytes());
        s = "LOCAL_INTERESTSET " + ce.getInterestSet() +"\n";
        fos.write(s.getBytes());
        s = "SDIMS_NODENAME " + ce.getSdimsNodeName() + "\n";
        fos.write(s.getBytes());
        s = "SDIMS_PORT " + ce.getSdimsPort() + "\n";
        fos.write(s.getBytes());
        s = "COMM_PORT " + ce.getCommPort() + "\n";
        fos.write(s.getBytes());
        s = "BERKELEYDB_CACHE_SIZE_BYTES " + ce.getCacheSizeBytes() + "\n";
        fos.write(s.getBytes());
        s = "LOG_DISK_SIZE_BYTES " + ce.getLogDiskSizeBytes() + "\n";
        fos.write(s.getBytes());
        s = "LOG_MEM_SIZE_BYTES " + ce.getLogMemSizeBytes() + "\n";
        fos.write(s.getBytes());
        s = "BW " + ce.getBW() + "\n";
        fos.write(s.getBytes());
        s = "NW_DELAY " + ce.getNWDelay() + "\n";
        fos.write(s.getBytes());
        s = "***END***\n";
        fos.write(s.getBytes());
      }
      fos.close();
    }
    catch(Exception e){
      e.printStackTrace();
      assert(false);
    }
    return;
  }

  private static String getUnqualifiedName(String host){
    int position = host.indexOf('.');
    if(position >= 0){
      Assert.affirm(position < host.length()); 
      host = host.substring(0,position);
    }
    return host;
  }

  private static void readGlobalEntries(BufferedReader in) throws IOException{    
    String line = null;
    boolean globalconfig_start = false;
    in.mark(1024);
    while((line = in.readLine()) != null){
      if(!globalconfig_start){
        if(line.equalsIgnoreCase(GLOBAL_START)){
          globalconfig_start = true;
          continue;
        } else {
          in.reset();
          return;
        }
      }
      
      if(globalconfig_start && line.equalsIgnoreCase(GLOBAL_END)){
        return;
      }
      
      StringTokenizer st = new StringTokenizer(line);
      String s = st.nextToken();
      if(s.equalsIgnoreCase("NumNodes")){
        NUM_LOGICAL_NODES = Integer.parseInt(st.nextToken());
      } else {
        System.err.println("Invalid Config File line : " + line);
        System.exit(-1);
      }
      
    }    
  }
  
  private static void writeGlobalEntries(FileOutputStream fos) throws IOException{
    fos.write((GLOBAL_START+"\n").getBytes());
    
    String s = "NumNodes " + NUM_LOGICAL_NODES + "\n";
    fos.write(s.getBytes());
    
    fos.write((GLOBAL_END+"\n").getBytes());
  }
  
  public static int getNumLogicalNodes(){
    return NUM_LOGICAL_NODES;
  }
  public static void setNumLogicalNodes(int n){
    NUM_LOGICAL_NODES = n;
  }

  private static String[] parseFile(String configFile){
    Vector config = new Vector();
    String line = null;
    int lineCounter = 0;
    try{
      BufferedReader in = new BufferedReader(new FileReader(configFile));
      
      readGlobalEntries(in);
      
      assert in!=null;
      while((line = in.readLine()) != null){
        validateConfigLine(line);
        /* "-" is added infront of each line to construct the format of the input arguments. */
        StringTokenizer st = new StringTokenizer("-" + line);
        while(st.hasMoreTokens()){
          config.add(st.nextToken());
        }
      }
    } catch (Exception e){
      e.printStackTrace();
      assert(false);
    }
    Object[] objA = config.toArray();
    String[] strA = new String[objA.length];
    for(int i=0; i<objA.length; i++){
      strA[i] = (String) objA[i];
    }
    return strA;
  }

  private static void validateConfigLine(String line){
    StringTokenizer st = new StringTokenizer(line);
    if((st.countTokens() == 1 && !st.nextToken().equals("***END***"))||
        (st.countTokens() > 2)){ 
      System.err.println("Bad configuration line: " + line);
      System.exit(-1);
    }
  }



  public static void
  makeOneNodeTestConfig(String configF, long nodeId, String interestSet,
      int portInval, int portBody, int portNice, int portCP, 
      int portSync, String localStore, int sdimsId, int sdimsPort, 
      int cacheBytes){
    String s;

    try{
      FileOutputStream fos = new FileOutputStream(configF);
      s = "NODEID " + nodeId + "\n";
      fos.write(s.getBytes());
      s = "DNS localhost\n";
      fos.write(s.getBytes());
      s = "LOCAL_INTERESTSET " + interestSet +"\n";
      fos.write(s.getBytes());
      s = "PORT_INVAL " + portInval +"\n";
      fos.write(s.getBytes());
      s = "PORT_BODY " + portBody +"\n";
      fos.write(s.getBytes());
      s = "PORT_NICE " + portNice +"\n";
      fos.write(s.getBytes());
      s = "PORT_CP " + portCP +"\n";
      fos.write(s.getBytes());
      s = "PORT_SYNC " + portSync +  "\n";
      fos.write(s.getBytes());
      s = "LOCAL_STORAGE " + configF + "\n";
      fos.write(s.getBytes());
      s = "SDIMS_NODENAME " + sdimsId + "\n";
      fos.write(s.getBytes());
      s = "SDIMS_PORT " + sdimsPort + "\n";
      fos.write(s.getBytes());
      s = "BERKELEYDB_CACHE_SIZE_BYTES " + cacheBytes + "\n";
      fos.write(s.getBytes());
      s = "***END***\n";
      fos.write(s.getBytes());
      fos.close();

    }
    catch(Exception e){
      e.printStackTrace();
      assert(false);
    }
    //assert false;
  }


 /** 
 * This method does not produce a complete config file 
 **/ 
  public static void
  makeOneNodeTestConfig(String configF, long nodeId, String interestSet,
      int portInval, int portSync,
      String localStore, int sdimsId, int sdimsPort, 
      int cacheBytes){
    String s;

    try{
      FileOutputStream fos = new FileOutputStream(configF);
      s = "NODEID " + nodeId + "\n";
      fos.write(s.getBytes());
      s = "DNS localhost\n";
      fos.write(s.getBytes());
      s = "LOCAL_INTERESTSET " + interestSet +"\n";
      fos.write(s.getBytes());
      s = "PORT_INVAL " + portInval +"\n";
      fos.write(s.getBytes());
      s = "PORT_SYNC " + portSync +  "\n";
      fos.write(s.getBytes());
      s = "LOCAL_STORAGE " + configF + "\n";
      fos.write(s.getBytes());
      s = "SDIMS_NODENAME " + sdimsId + "\n";
      fos.write(s.getBytes());
      s = "SDIMS_PORT " + sdimsPort + "\n";
      fos.write(s.getBytes());
      s = "CACHE_SIZE_BYTES " + cacheBytes + "\n";
      fos.write(s.getBytes());
      s = "***END***\n";
      fos.write(s.getBytes());
      fos.close();

    }
    catch(Exception e){
      e.printStackTrace();
      assert(false);
    }
    //assert false;
  }


 /** 
 **/ 
  public static boolean isInitialized(){
    return initialized;
  }

 /** 
 **/
  
  public final static byte getBodyConfig(NodeId nid){
    ConfigEntry configE = (ConfigEntry)allConfigurations.get(nid);
    return configE.getBodyConfig();
  }
  
  public final static void setBodyConfig(NodeId nid, byte b){
    ConfigEntry configE = (ConfigEntry)allConfigurations.get(nid);
    configE.setBodyConfig(b);
  }
  
  public final static String getDNS(NodeId nid){
    ConfigEntry configE = (ConfigEntry)allConfigurations.get(nid);
    return configE.getDNS();
  }
  public final static int getPortInval(NodeId nid){
    ConfigEntry configE = (ConfigEntry)allConfigurations.get(nid);
    return configE.getPortInval();
  }
  public final static int getPortBody(NodeId nid){
    ConfigEntry configE = (ConfigEntry)allConfigurations.get(nid);
    return configE.getPortBody();
  }
  public final static int getPortNice(NodeId nid){
    ConfigEntry configE = (ConfigEntry)allConfigurations.get(nid);
    return configE.getPortNice();
  }
  public final static int getPortCP(NodeId nid){
    ConfigEntry configE = (ConfigEntry)allConfigurations.get(nid);
    return configE.getPortCP();
  }
  public final static int getPortSync(NodeId nid){
    ConfigEntry configE = (ConfigEntry)allConfigurations.get(nid);
    return configE.getPortSync();
  }
  public final static String getRMIServiceName(NodeId nid){
    ConfigEntry configE = (ConfigEntry)allConfigurations.get(nid);
    return configE.getRMIServiceName();
  }
  public final static String getRMIUrl(NodeId nid){
    ConfigEntry configE = (ConfigEntry)allConfigurations.get(nid);
    return configE.getRMIUrl();
  }
  public final static String getLocalStore(NodeId nid){
    ConfigEntry configE = (ConfigEntry)allConfigurations.get(nid);
    return configE.getLocalStore();
  }    
  public final static long getBandwidth(NodeId nid){
    ConfigEntry configE = (ConfigEntry)allConfigurations.get(nid);
    return configE.getBW();
  }
  public final static long getNWDelay(NodeId nid){
    ConfigEntry configE = (ConfigEntry)allConfigurations.get(nid);
    return configE.getNWDelay();
  }
  public final static InterestRegion getInterestSet(NodeId nid){
    ConfigEntry configE = (ConfigEntry)allConfigurations.get(nid);
    return configE.getInterestSet();
  }

 /** 
 *  to construct the needed registered interestset for specific  
 *  experiment so that avoid to construct too many config files 
 **/ 
  public final static void setInterestSet(NodeId nid, String s){
    ConfigEntry configE = (ConfigEntry)allConfigurations.get(nid);
    configE.setInterestSet(s);
  }

  // for testing...
  public final static void setPortInval(NodeId nid, int port){
    ConfigEntry configE = (ConfigEntry)allConfigurations.get(nid);
    configE.setPortInval(port);
  }
  public final static void setPortBody(NodeId nid, int port){
    ConfigEntry configE = (ConfigEntry)allConfigurations.get(nid);
    configE.setPortBody(port);
  }
  public final static void setPortSync(NodeId nid, int port){
    ConfigEntry configE = (ConfigEntry)allConfigurations.get(nid);
    configE.setPortSync(port);
  }
  public final static void setPortNice(NodeId nid, int port){
    ConfigEntry configE = (ConfigEntry)allConfigurations.get(nid);
    configE.setPortNice(port);
  }
  public final static void setPortCP(NodeId nid, int port){
    ConfigEntry configE = (ConfigEntry)allConfigurations.get(nid);
    configE.setPortCP(port);
  }

  public final static String getSdimsNodeName(NodeId nid){
    ConfigEntry configE = (ConfigEntry)allConfigurations.get(nid);
    return configE.getSdimsNodeName();
  }

  public final static int getSdimsPort(NodeId nid){
    ConfigEntry configE = (ConfigEntry)allConfigurations.get(nid);
    return configE.getSdimsPort();
  }

  public final static int getCommPort(NodeId nid){
    ConfigEntry configE = (ConfigEntry)allConfigurations.get(nid);
    return configE.getCommPort();
  }

  public final static long getCacheSizeBytes(NodeId nid){
    ConfigEntry configE = (ConfigEntry)allConfigurations.get(nid);
    return configE.getCacheSizeBytes();
  }

  public final static long getLogDiskSizeBytes(NodeId nid){
    ConfigEntry configE = (ConfigEntry)allConfigurations.get(nid);
    return configE.getLogDiskSizeBytes();
  }

  public final static long getLogMemSizeBytes(NodeId nid){
    ConfigEntry configE = (ConfigEntry)allConfigurations.get(nid);
    return configE.getLogMemSizeBytes();
  }

  public final static int[] getNodesExclusive(int nid){
    int[] ids = new int[allConfigurations.size()-1]; 
    int index = 0;
    for(Enumeration e = allConfigurations.elements(); e.hasMoreElements();){
      int tmp = (int) ((ConfigEntry)e.nextElement()).getNodeId().getIDint();
      if(tmp != nid){
        ids[index] = tmp;
        index ++;
      } 
    }
    assert index == allConfigurations.size() - 1;
    return ids;
  }

  public final static Enumeration getKnownNodeIds()
  {
    return allConfigurations.keys();
  }


  public final static Vector getSortedKnownNodeIds() {
    TreeSet sorted = new TreeSet() ;
    Vector sortedVec = new Vector() ;
    for(Enumeration e = getKnownNodeIds(); e.hasMoreElements();) {
      sorted.add(e.nextElement()) ;
    }
    for(Iterator it = sorted.iterator(); it.hasNext();) {
      sortedVec.add(it.next()) ;
    }
    return sortedVec ;
  }

  public final static int getNumNodes() {
    return allConfigurations.size() ;
  }

  public static void main(String[] argv){

    
    Config.readConfig("fj_config_10_X2");
    
    
    
    NodeId myid = new NodeId(1);
    Config.createEmptyConfig();
    Config.addOneNodeConfig(myid,
        "localhost.cs.utexas.edu",
        9988,
        9989,
        9991,
        9992,
        9990,
        "/tmp/ufs1",
        "/*",
        -1L,
        "localhost.cs.utexas.edu",
        9993,
        9994,
        -1,
        CACHE_SIZE_BYTES_DEFAULT,
        MAX_LOG_DISK_SIZE_BYTES,
        MAX_LOG_MEM_SIZE_BYTES);
    Config.addOneNodeConfig(new NodeId(0),
        "localhost.cs.utexas.edu",
        8888,
        8889,
        8891,
        8892,
        8890,
        "/tmp/ufs",
        "/*",
        -1L,
        "localhost.cs.utexas.edu",
        8893,
        8894,
        -1,
        CACHE_SIZE_BYTES_DEFAULT,
        MAX_LOG_DISK_SIZE_BYTES,
        MAX_LOG_MEM_SIZE_BYTES);
    Config.writeToFile("newConfigFile.config");    
    Config.readConfig("newConfigFile.config");
    Config.writeToFile("anotherConfigFile.config");
  }

}

//---------------------------------------------------------------------------
/* $Log: Config.java,v $
/* Revision 1.35  2007/05/31 06:02:01  zjiandan
/* add AllPreciseSetsUnit
/*
/* Revision 1.34  2006/08/31 17:32:18  dahlin
/* Synchronized StreamId::makeNewStreamId()
/*
/* Revision 1.33  2006/04/21 02:56:55  nalini
/* *** empty log message ***
/*
/* Revision 1.32  2006/04/04 15:59:59  nayate
/* Added the ability to (1) delay invalidates, and (2) support transactional updates.
/*
/* Revision 1.31  2005/10/13 23:03:29  nayate
/* Made disk and memory log restrictions infinite + removed one assertion
/*
/* Revision 1.30  2005/10/13 00:24:23  zjiandan
/* remove Config.getMy* fixed Garbage Collection and Checkpoint exchange code
/*
/* Revision 1.29  2005/07/18 05:10:22  zjiandan
/* Embargoed Writes etc. features implementation plus
/* log overhead measurement with disk size and in-memory size.
/*
/* Revision 1.28  2005/03/22 23:00:03  zjiandan
/* Changes for TactExpt.
/*
/* Revision 1.27  2005/03/16 01:59:41  nayate
/* Added a getPortNice() method
/*
/* Revision 1.26  2005/03/15 21:15:34  zjiandan
/* Automatic GC checked in.
/*
/* Revision 1.25  2005/03/14 22:44:15  lgao
/* *** empty log message ***
/*
/* Revision 1.24  2005/03/07 21:00:07  lgao
/* Planet lab exp check-in
/*
/* Revision 1.23  2005/03/04 22:07:29  nayate
/* Added a getPortCP() method
/*
/* Revision 1.22  2005/03/04 01:37:07  ypraveen
/* minor changes -- small bug fix
/*
/* Revision 1.21  2005/03/04 00:59:53  ypraveen
/* Added an OPTIONAL argument command port
/*
/* Revision 1.20  2005/03/01 04:35:32  nayate
/* Modified for new code
/*
/* Revision 1.19  2005/02/28 20:25:58  zjiandan
/* Added Garbage Collection code and part of Checkpoint exchange protocol code
/*
/* Revision 1.18  2005/01/10 03:47:47  zjiandan
/* Fixed some bugs. Successfully run SanityCheck and Partial Replication experiments.
/*
/* Revision 1.17  2004/11/02 22:24:32  zjiandan
/* add utility methods for core recovery self test.
/*
/* Revision 1.16  2004/10/22 20:46:54  dahlin
/* Replaced TentativeState with RandomAccessState in DataStore; got rid of 'chain' in BodyMsg; all self-tests pass EXCEPT (1) get compile-time error in rmic and (2) ./runSDIMSControllerTest fails [related to (1)?]
/*
/* Revision 1.15  2004/05/23 09:13:54  lgao
/* Add config entry for simulated network delays.
/*
/* Revision 1.14  2004/05/23 02:44:31  ypraveen
/* Added a function to return the number of nodes in the system
/*
/* Revision 1.13  2004/05/23 01:52:19  ypraveen
/* Added a function to extract sorted list of known node ids
/*
/* Revision 1.12  2004/05/21 04:35:17  ypraveen
/* tested
/*
/* Revision 1.11  2004/05/21 04:25:48  ypraveen
/* Added two new entries: SDIMS_NODENAME and SDIMS_PORT for sdims use
/*
/* Revision 1.10  2004/05/12 21:00:11  lgao
/* The FAKE node id for the coordinator is -1.  No other REAL URANode can have an id less than 0.
/*
/* Revision 1.9  2004/05/12 20:44:24  lgao
/* Add rmi interface for distributed stats collection at the coordinator.
/*
/* Revision 1.8  2004/05/10 20:48:19  dahlin
/* Clarified RMI exceptions; full version of (stub) DemandReadWorker
/*
/* Revision 1.7  2004/05/09 22:21:10  dahlin
/* Unit test and stub implementation for spanningTreeWorker
/*
/* Revision 1.6  2004/05/09 03:30:52  lgao
/* *** empty log message ***
/*
/* Revision 1.5  2004/04/27 07:59:05  lgao
/* Initial implementation for UpdatePriorityQueue
/*
/* Revision 1.4  2004/04/19 23:30:04  lgao
/* Initial implementation of the RMI package and modification to Makefile.
/*
/* Revision 1.3  2004/04/16 21:13:25  lgao
/* The initial implementation.
/*
/* Revision 1.2  2004/04/15 20:04:24  nayate
/* New Makefile; added provision to allow CVS to append file modification
/* logs to files.
/* */
//---------------------------------------------------------------------------
