package code;

import code.simulator.SyncRequest;

 /** 
 **/ 
public class ConfigEntry
{
  NodeId nodeId;
  String DNS;
  int portInval;
  int portBody;
  int portNice;
  int portCP;
  int portSync;
  long bandwidth;
  long delay;
  String rmiServiceName; // <nodeId>-URA
  String rmiUrl; // rmi://<DNS>/<rmiServiceName>
  String localStore;
  InterestRegion interestSet;
  long cacheSizeBytes;   // How much memory to give to RandomAccessState for cache
  long logDiskSizeBytes;
  long logMemSizeBytes;
  String sdimsNodeName ;
  int sdimsPort ;
  int commPort ;
  
  byte bodyconfig;

  ConfigEntry(NodeId nid, String dns, 
              int pi, int pb, int pn, int pc, int ps, 
              String ls, String is, long bw, 
              String sdimsNodeName_, int sdimsPort_, 
              int commPort_, long dl, long cs,
              long lds,
              long lms){
    nodeId = nid;
    DNS = dns;
    portInval = pi;
    portBody = pb;
    portNice = pn;
    portCP = pc;
    portSync = ps;
    localStore = ls;
    rmiServiceName = nid.toString() + "-URA";
    rmiUrl = "rmi://" + DNS + "/" + rmiServiceName;
    bandwidth = bw;
    delay = dl;
    String [] s = is.split(":");
    interestSet = new InterestRegion(s);

    sdimsNodeName = sdimsNodeName_ ;
    sdimsPort = sdimsPort_ ;
    commPort = commPort_ ;
    cacheSizeBytes = cs;
    logDiskSizeBytes = lds;
    logMemSizeBytes = lms;
    
    bodyconfig = SyncRequest.UncommittedLastBodies;
  }

 /** 
 **/ 
  public byte getBodyConfig(){
    return bodyconfig;
  }
  
  public void setBodyConfig(byte b){
    bodyconfig = b;
  }
  
  public NodeId getNodeId(){
    return nodeId;
  }
  public String getDNS(){
    return DNS;
  }
  public int getPortInval(){
    return portInval;
  }
  public int getPortBody(){
    return portBody;
  }
  public int getPortNice(){
    return portNice;
  }

  public int getPortCP(){
    return portCP;
  }
  public int getPortSync(){
    return portSync;
  }
  public String getRMIUrl(){
    return rmiUrl;
  }
  public String getRMIServiceName(){
    return rmiServiceName;
  }
  public String getLocalStore(){
    return localStore;
  }
  public long getBW(){
    return bandwidth;
  }
  public long getNWDelay(){
    return delay;
  }
  public InterestRegion getInterestSet(){
    return interestSet;
  }
  
  public void setInterestSet(String is){
    String [] s = is.split(":");
    interestSet = new InterestRegion(s);

  }
  public String getSdimsNodeName() {
    return sdimsNodeName ;
  }

  public int getSdimsPort() {
    return sdimsPort ;
  }

  public int getCommPort() {
    return commPort ;
  }

  public long getCacheSizeBytes(){
    return cacheSizeBytes;
  }
  
  public long getLogDiskSizeBytes(){
    return logDiskSizeBytes;
  }

  public long getLogMemSizeBytes(){
    return logMemSizeBytes;
  }

 /** 
 *  set PortInval -- for test 
 **/ 
  public void setPortInval(int port){
    this.portInval = port;
  }
  
 /** 
 *  set PortBody -- for test 
 **/ 
  public void setPortBody(int port){
    this.portBody = port;
  }

 /** 
 *  set PortNice -- for test 
 **/ 
  public void setPortNice(int port){
    this.portNice = port;
  }
  
 /** 
 *  set PortCP -- for test 
 **/ 
  public void setPortCP(int port){
    this.portCP = port;
  }
  
 /** 
 *  set PortSync -- for test 
 **/ 
  public void setPortSync(int port){
    this.portSync = port;
  }
}

//---------------------------------------------------------------------------
/* $Log: ConfigEntry.java,v $
/* Revision 1.15  2005/10/13 00:24:23  zjiandan
/* remove Config.getMy* fixed Garbage Collection and Checkpoint exchange code
/*
/* Revision 1.14  2005/07/18 05:10:22  zjiandan
/* Embargoed Writes etc. features implementation plus
/* log overhead measurement with disk size and in-memory size.
/*
/* Revision 1.13  2005/03/15 21:15:34  zjiandan
/* Automatic GC checked in.
/*
/* Revision 1.12  2005/03/04 00:59:53  ypraveen
/* Added an OPTIONAL argument command port
/*
/* Revision 1.11  2005/03/01 04:35:57  nayate
/* Modified for new code
/*
/* Revision 1.10  2005/02/28 20:25:58  zjiandan
/* Added Garbage Collection code and part of Checkpoint exchange protocol code
/*
/* Revision 1.9  2004/11/02 22:24:32  zjiandan
/* add utility methods for core recovery self test.
/*
/* Revision 1.8  2004/10/22 20:46:54  dahlin
/* Replaced TentativeState with RandomAccessState in DataStore; got rid of 'chain' in BodyMsg; all self-tests pass EXCEPT (1) get compile-time error in rmic and (2) ./runSDIMSControllerTest fails [related to (1)?]
/*
/* Revision 1.7  2004/05/23 09:13:54  lgao
/* Add config entry for simulated network delays.
/*
/* Revision 1.6  2004/05/21 04:25:48  ypraveen
/* Added two new entries: SDIMS_NODENAME and SDIMS_PORT for sdims use
/*
/* Revision 1.5  2004/05/09 03:30:52  lgao
/* *** empty log message ***
/*
/* Revision 1.4  2004/04/19 23:30:04  lgao
/* Initial implementation of the RMI package and modification to Makefile.
/*
/* Revision 1.3  2004/04/16 21:13:25  lgao
/* The initial implementation.
/*
/* Revision 1.2  2004/04/15 20:04:24  nayate
/* New Makefile; added provision to allow CVS to append file modification
/* logs to files.
/* */
//---------------------------------------------------------------------------
