package code;

import java.io.*;
import java.net.*;


public class ConstrainedOutputStream extends OutputStream{
    
    static long max_bw=Long.MIN_VALUE; // Bits per second
    private OutputStream os;
    private static double accumulatedTimeMillis;

    static double total_rate = 0.0;
    static long test_size = 0;
    static int test_num = 0;
    static int count = 0;
    private static final int FRAMESIZE = 4096; // each stream send upto 1k bytes at a time

  public ConstrainedOutputStream(OutputStream os, long bw) throws IOException{
      if(max_bw==Long.MIN_VALUE){
        max_bw = bw;
      }
      Env.printDebug("Bandwidth available: " + max_bw);
      this.os = os;
      this.accumulatedTimeMillis = 0.0;
    }

    public void write(int b)throws IOException{
	byte [] tmp = new byte[1];
	tmp[0] = (byte)b;
	constrainedWrite(tmp, 0, 1);
    }
    
    public void write(byte[] b)throws IOException{
	constrainedWrite(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len)throws IOException{
	constrainedWrite(b, off, len);
    }

    public void flush() throws IOException{
      os.flush();
    }

    public void close() throws IOException{
      os.close();
      os = null;
    } 

    public static synchronized void setTest(int t, int s){
	test_num = t;
	test_size = s;
    }

    public static synchronized void addAvg(double t){
	total_rate += t; // note, not accumulative, 
	count ++;
	if(count >= test_num){
	    Env.printDebug("Bandwidth achieved: " + total_rate*1000.0 + " bit/s");
	}
    }

  public static long getBW(){
    return getMaxBW();
  }

  public static void setBW(long newBW){
    setMaxBW(newBW);
  }

    private void constrainedWrite(byte[] b, int off, int len) throws IOException{
//      long tt = System.currentTimeMillis();
//      Env.sprintln("ConstrainedOutputStream::constrainedWrite() start with len=" + len
//                   + " at " + tt);
      if(getMaxBW() > -1){
        int totalLen = 0;
        int start = off;
        while(off + len > start){
          int frameSize = Math.min(off+len-start, FRAMESIZE);
          // everytime, the maximum amout of bytes sent can not exceed the maximal bandwidth.
          long st = System.currentTimeMillis();
          writeFrame(b, start, frameSize, this.os);
          long et = System.currentTimeMillis();
          //Env.sprintln("****writeFrame overhead: " + (et-st));
          start += frameSize;
          totalLen += frameSize;
        }
      } else {
        os.write(b, off, len);
      }
//      tt = System.currentTimeMillis() - tt;
//      Env.sprintln("ConstrainedOutputStream::constrainedWrite() end with len=" + len
//                   + " at " + System.currentTimeMillis() + " with trasmission rate @ " + (len*8/tt));
    }
  
  private static synchronized void setMaxBW(long newBW){
    max_bw = newBW;
//    System.out.println("BW is set to " + max_bw + "b/s");
  }

  private static synchronized long getMaxBW(){
    return max_bw;
  }

    private static synchronized void writeFrame(byte[] b, int off, int len, OutputStream os) throws IOException{
	long sendTime = 0;
	long currentTime = System.currentTimeMillis();
	double bw_millis = (double)max_bw/1000.0; // max_bw is bit/s, not bit/millis
	//Env.sprintln("about to writeFrame with len: " + len + " and bw_millis:" + bw_millis);
        // "len" is in bytes, we need to multiply it by 8 because "bw_millis" is in bit/s.
//	Env.printDebug(accumulatedTimeMillis + " " + len*8/bw_millis);
	accumulatedTimeMillis += len*8/bw_millis; 
	if(accumulatedTimeMillis > 1){
	    sendTime = (long)accumulatedTimeMillis;
	    // keep the number behind the decimal point and keep accumulating
	    accumulatedTimeMillis = accumulatedTimeMillis - sendTime; 
	}
//	Env.printDebug(sendTime);
        long expectedTime = (long) (currentTime + sendTime); 
	os.write(b, off, len);
	long diff = expectedTime - System.currentTimeMillis();
	
	    while(diff>0){
		try{
//System.err.println("T:" + diff);
		    Thread.sleep(diff);
		} catch (InterruptedException e){
		    Env.printDebug("Interrupted while waiting to send data. Will check for schedule again!");
		}
		diff = expectedTime - System.currentTimeMillis();
	    }

            assert (diff<=0); 
	    // The system is taking more time to send the data via the full bandwidth,
	    // we should composite it back with the time gained when system takes longer 
            // the send. Note: sleep might take huge overhead as large as 20ms therefore
            // need to amartize it across multi-frame
	    accumulatedTimeMillis += diff;  
    }
    
    public static void main(String [] argv){
	int num_th = 10;
	int port = 5566;
	Thread[] dth = new Thread[num_th];
	if(argv.length < 1){
	    Env.printDebug("Usage: [client][port][size] or [server]");
	}
	try{
	    if(argv[0].equals("client")){
		Config.readConfig("ufs.config");
		int size = (new Integer(argv[2])).intValue();
		setTest(num_th, size);
		    for(int i=0; i<num_th; i++){
		    dth[i] = new DummyThread(argv[1], port++, size);
		    dth[i].start();
		}
	    } else {
		Config.readConfig("ufs.config");
		int size = (new Integer(argv[1])).intValue();
		for(int i=0; i<num_th; i++){
		    dth[i] = new DummyServerThread(port++, size);
		    dth[i].start();
		    Env.printDebug("Started .. ");
		}
		
	    }
	} catch (Exception e){
	    e.printStackTrace();
	}
    }
}


class DummyObj implements Serializable{
    byte[] b;
    
    DummyObj(int size){
	b = new byte[size];
    }
	
    public int size(){
	return b.length;
    }
}

class DummyThread extends Thread{
    String h;
    int p;
    int s;
    public double r;
    
    DummyThread(String host, int port, int size){
	h = host;
	p = port;
	s = size;
    }

    public void run(){
	try{
	    Env.printDebug("Client strarts...");
	    OutputStream send = (new Socket(h, p)).getOutputStream();
	    ConstrainedOutputStream cos = new ConstrainedOutputStream(send, 10000);
	    ObjectOutputStream oos = new ObjectOutputStream(cos);
	    DummyObj b = new DummyObj(s);
	    double startT = (double)System.currentTimeMillis();
	    oos.writeObject(b);
	    double endT = (double)System.currentTimeMillis();
	    double interval = (double) (endT - startT);
	    r = s*8/interval;
	    ConstrainedOutputStream.addAvg(r);
//	    Env.printDebug(p + " has sent " + s + " bytes are received at " + r + " b/s");
//	    Env.printDebug("Total bandwidth is: " + ConstrainedOutputStream.max_bw);
	} catch (Exception e){
	    e.printStackTrace();
	}
    }
}

class DummyServerThread extends Thread{
    int p;
    int s;
    public double r;
    
    DummyServerThread(int port, int size){
	p = port;
	s = size;
    }

    public void run(){
	try{
	    ServerSocket ss = new ServerSocket(p);
	    Socket recv = (Socket) ss.accept();
	    ObjectInputStream ois = new ObjectInputStream(recv.getInputStream());
	    long startT = System.currentTimeMillis();
	    int rec_size = 0;
	    while(rec_size < s){
		DummyObj b = (DummyObj)ois.readObject();
		rec_size += b.size();
	    }
	    long endT = System.currentTimeMillis();
	    double interval = (double)((endT - startT) / 1000);
	    r = s*8/interval;
	    //Env.printDebug(p + " has sent " + s + " bytes are received at " + r + " b/s");
	} catch (Exception e){
	    
	}
    }
}
