package code;

 /** 
 **/ 
public interface Controller
{
  /*
    the controller decides who we should connect to and receive updates/
    invalidations/etc. from

    There will be different variations -- e.g., a hierarchical
    client-server controller; a Bayou controller, ...
  */

  public final static int NULL_CONTROLLER = 0;
  public final static int TRIVIAL_CONTROLLER = 1;
  public final static int SDIMS_CONTROLLER = 2;
  public final static int CODA_CONTROLLER = 3;
  public final static int BAYOU_CONTROLLER = 4;
  public final static int ORACLE_CONTROLLER = 4;

  //
  // Called when a stream is initiated (Maybe trigger timeout
  // and retry if an attempt to initiate fails. Maybe we didn't
  // initiate this stream, so this controller wants to know...)
  //
  public void informInvalStreamInitiated(NodeId senderNodeId, 
					 SubscriptionSet ss,
					 VV vvStart, 
					 boolean placeholderWriterSet);
  public void informCommitStreamInitiated(NodeId senderNodeId);
  public void informBodyStreamInitiated(NodeId senderNodeId);
  public void informUnbindStreamInitiated(NodeId senderNodeId);
  public void informSyncRplyStreamInitiated(NodeId senderNodeId);


  //
  // called when a stream is terminated (controller might
  // want to restart it).
  //
  
  public void informInvalStreamTerminated(NodeId senderNodeId, 
					  SubscriptionSet is,
					  VV vvStart, 
					  boolean placeholderWriterSet,
					  StreamId sId);
  public void informCommitStreamTerminated(NodeId senderNodeId);
  public void informBodyStreamTerminated(NodeId senderNodeId);
  public void informUnbindStreamTerminated(NodeId senderNodeId);
  public void informSyncRplyStreamTerminated(NodeId senderNodeId);

  //
  // Receive sync reply (once we get enough for a given
  // write, can unbind it)
  //
  public void recvSyncReply(AcceptStamp acceptStamp, NodeId sender);

  public void informReceivePushBody(BodyMsg msg); // We now have local copy of data
  public void informReceiveInval(GeneralInv inv, NodeId senderId); // We no longer have local copy of data
  public void informLocalWrite(ObjId objId, long offset, long length,
			       AcceptStamp as,
			       boolean isBound,
			       boolean isEmbargoed); // We now have local copy of data
  public void informLocalDelete(ObjId objId); // No one has this data anymore

  public void informLocalReadImprecise(ObjId objId, long offset, long length); // We tried to read imprecise data
  public void informLocalReadInvalid(ObjId objId, long offset, long length,
				     AcceptStamp inval); // we tried to read invalid data

  //
  // On a demand miss, the local store asks the controller to
  // get someone to send the data to me. Thought about including
  // an acceptStamp or VV indicating how new the data neeeds to be
  // to be useful, but (1) we don't always know [e.g., a miss for a new
  // object) and (2) it may change between request issue and reply recv
  // time (e.g., new invalidations arrive in the mean time). So, at best
  // it would be a hint -- but not a terribly useful one -- we probably
  // always want to go get the newest one we can lay our hands on anyhow.
  //
  public void informDemandReadMiss(ObjId objId, long offset, long length);

  //
  // Stop retrying; we now have local copy of data.
  // Note -- the copy that just arrived may turn out to be "too old"
  // to be useful. In that case the core should first call informReceiveDemandReply
  // so that we know to stop retrying that request and then call
  // informDemandReadMiss so we know to issue a new request.
  //
  public void informReceiveDemandReply(NodeId senderNodeId, BodyMsg msg); 

  //
  // To support controller cache replacement policy
  // [TBD: Add interface to core: "discardBody()" to discard
  // the body of an object from local storage and "removeIS()"
  // to discard an interest set (which allows us to discard
  // the per-object metadata like last known acceptStamp, etc.]
  //
  public void informDemandReadHit(ObjId objId, long offset, long length);

  //
  // We have received a demand read for an interest set that is
  // currently imprecise. The controller may need to identify 
  // an enclosing interest set to make precise (either an interest
  // set that the local core is already tracking or make a call
  // to the local core telling core to begin tracking a new
  // interest set [TBD: add this call to core].) Then, the controller
  // may need to contact remote nodes and tell them to set up
  // a subscription to this node. If objId belongs to an interest
  // set that the core is already tracking, enclosingIS identifies
  // it and lpVV indicates the last precise VV (from which the new
  // subscription must start.) On the other hand, if the
  // object does not belong to an interest set being tracked,
  // enclosingIS and lpVV will be null. In that case, the controller
  // has to tell the core to start tracking a new IS and when
  // the controller subscribes this node to a stream of invals,
  // this stream must start at time 0 OR we need to get a checkpoint
  // from another node [TBD: add checkpoint transfer interface
  // to node and core.]
  //
  // Note: informDemandImprecise brings the ISStatus up to date
  // and informDemandRead brings the object up to date; normally, 
  // if a core hits an imprecise interest set, it calls informDemandImprecise
  // first and then calls informDemandReadMiss immediately (so that
  // both requests can be doing their work in parallel)
  //
  public void informDemandImprecise(ObjId objId, 
				    PreciseSet enclosingIS, 
				    VV lpVV);

  public void informBecameImprecise(PreciseSet is); // This IS is currently "imprecise"
  public void informBecamePrecise(PreciseSet is);   // This IS is currently "precise"
  
 /** 
 **/ 
  //    inform methods for send-checkpoint protocol
 /** 
 **/ 

 /** 
 *  inform subscribe invalidate for a certain subscription set failed 
 **/ 
  public void
  informSubscribeInvalFailed(NodeId senderNodeId,
                             NodeId receiverNodeId,
                             SubscriptionSet ss,
                             VV vvStart);

 /** 
 *  inform subscribe invalidate for a certain subscription set failed 
 **/ 
  public void
  informSubscribeInvalSucceeded(NodeId senderNodeId,
                                NodeId receiverNodeId,
                                SubscriptionSet ss,
                                VV vvStart);
  
 /** 
 *  called in SubscribeInvalWorker when !(this.omitVV < startVV) i.e 
 *  gap exist between the sender's omitVV and the requested stream's  
 *  startVV. It implies that the ongoing subscribe inval stream is  
 *  failed. 
 *  
 *  What expected in the controller is to make the decision whether 
 *  to subscribe inval from other nodes for the receiver or invoke 
 *  a subscribeCheckpoint request to the same node optionally followed  
 *  by a subscribeInval request with a higher startVV 
 **/ 
  public void informGapExistForSubscribeInv(NodeId invReceiver,
                                            SubscriptionSet ss,
                                            VV startVV,
                                            VV omitVV);

 /** 
 *  inform Outgoing Checkpoint Stream initiated called in CPSendWorker 
 **/ 
  public void
  informOutgoingCheckpointStreamInitiated(NodeId targetNodeId, 
                                          String cpPath, 
                                          String[] exclChildNames,
                                          VV startVV,
                                          boolean placeholderWriterSet);

 /** 
 *  inform Outgoing Checkpoint Stream initiated called in CPSendWorker 
 **/ 
  public void
  informOutgoingCheckpointStreamTerminated(NodeId receiverNodeId, 
                                           String cpPath,
                                           String[] exclChildNames,
                                           VV startVV, 
                                           boolean placeholderWriterSet);

 /** 
 *  inform a Checkpoint Stream initiated called in CPRecvWorker 
 **/ 
  public void
  informCheckpointStreamInitiated(NodeId senderNodeId, 
                                  String cpPath,
                                  String[] exclChildNames,
                                  VV vvStart, 
                                  boolean placeholderWriterSet);

 /** 
 *  inform a Checkpoint Stream terminated called in CPRecvWorker 
 **/ 
  public void
  informCheckpointStreamTerminated(NodeId senderNodeId,
                                   String cpPath,
                                   String[] exclChildNames,
                                   VV vvStart, 
                                   boolean placeholderWriterSet);

 /** 
 *  inform a Checkpoint Stream apply status called in CPRecvWorker 
 **/ 
  public void
  informCheckpointStreamReceiveStatus(NodeId senderNodeId, 
                                      String cpPath,
                                      String[] exclChildNames,
                                      VV vvStart, 
                                      boolean applyStatus,
                                      boolean placeholderWriterSet);

   
 /** 
 *  inform successfully established a connection to the  
 *  targetNodeId. 
 **/ 
  public void 
  informOutgoingInvalStreamInitiated(NodeId targetNodeId, 
				     VV startVV,
				     boolean placeholderWriterSet);



 /** 
 *  inform outgoing stream terminated  
 **/ 
  public void 
  informOutgoingInvalStreamTerminated(NodeId receiverNodeId, 
				      SubscriptionSet is,
				      VV startVV, 
				      boolean placeholderWriterSet);

 /** 
 *  inform successfully adding subscriptionSet to OutgoingConnection's 
 *  invalidateIterator's interestset 
 **/ 
  public void 
  informOutgoingSubscribeInvalInitiated(NodeId receiverId, 
                                        SubscriptionSet subscriptionSet);

 /** 
 *  inform successfully removed subscriptionSet from 
 *  OutgoingConnection's invalIterator's interest set 
 **/ 
  public void
  informOutgoingSubscribeInvalTerminated(NodeId receiverId,
					 SubscriptionSet subscriptionSet);
  

 /** 
 *  inform subscription set added to a body stream connection 
 **/ 
  public void 
  informSubscribeBodySucceeded(NodeId senderNodeId,
                               SubscriptionSet ss);

 /** 
 *  inform subscription set removed from body stream connection 
 **/ 
  public void 
  informSubscribeBodyRemoved(NodeId senderNodeId,
                               SubscriptionSet ss);
 /** 
 *  inform established an outgoing body connection to targetNodeId 
 **/ 
  public void 
  informOutgoingBodyStreamInitiated(NodeId receiverNodeId, 
				    boolean placeholderWriterSet);
				
 /** 
 *   inform outgoing body connection terminated 
 **/ 
  public void 
  informOutgoingBodyStreamTerminated(NodeId receiverNodeId, 
				     SubscriptionSet subscriptionSet,
				     boolean placeholderWriteSet );

 /** 
 *   inform added SS to outgoing body connection's upq notifier 
 **/ 
  public void
  informOutgoingSubscribeBodyInitiated(NodeId receiverID, 
				       SubscriptionSet subscriptionSet);

 /** 
 *  inform removed SS from outgoing body connection's upq notifer 
 **/ 
  public void
  informOutgoingSubscribeBodyTerminated(NodeId receiverId,
					SubscriptionSet subscriptionSet);
  
  public void
  informCheckpointApplied(NodeId senderId, boolean status);

}


//---------------------------------------------------------------------------
/* $Log: Controller.java,v $
/* Revision 1.24  2006/12/08 21:36:26  nalini
/* reverting to the old read interface
/*
/* Revision 1.22  2006/10/31 21:43:32  nalini
/* added control msgs to body streams
/*
/* Revision 1.21  2006/08/15 21:46:23  dahlin
/* Added PicShare Reader and a simple unit test.
/*
/* Revision 1.20  2006/06/02 22:40:02  nalini
/* merged support for adding and removing ss for outgoing body streams
/*
/* Revision 1.19.2.1  2006/06/02 22:18:12  nalini
/* Supports addition and removeal of SS from Outgoing Body Streams
/*
/* Revision 1.19  2006/04/23 22:44:59  zjiandan
/* change informReceiveInval to have senderId info.
/*
/* Revision 1.18  2006/04/22 07:59:53  nalini
/* Working Version of P2 Runtime: Works with JD's interfaces
/*
/* Revision 1.17  2006/04/21 05:09:13  zjiandan
/* add inform methods.
/*
/* Revision 1.16  2006/04/20 03:52:52  zjiandan
/* Callbacks merged with runTime.
/*
/* Revision 1.15  2005/03/03 08:07:55  nayate
/* Added some checkpoint transfer code
/*
/* Revision 1.14  2005/03/01 10:40:35  nayate
/* First successful compilation
/*
/* Revision 1.13  2005/02/28 20:25:58  zjiandan
/* Added Garbage Collection code and part of Checkpoint exchange protocol code
/*
/* Revision 1.12  2004/05/27 01:59:00  arun
/* *** empty log message ***
/*
/* Revision 1.11  2004/05/25 01:51:41  ypraveen
/* changed SDIMS_SPANTREE_CONTROLLER name to SDIMS_CONTROLLER
/*
/* Revision 1.10  2004/05/23 01:53:10  ypraveen
/* Added a new static int SDIMS_SPANTREE_CONTROLLER
/*
/* Revision 1.9  2004/05/19 02:14:44  dahlin
/* Making progress on SDIMSController spanning test
/*
/* Revision 1.8  2004/05/14 21:19:59  dahlin
/* Retry logic for upward path on body push spanning tree
/*
/* Revision 1.7  2004/05/14 19:23:21  dahlin
/* Cleanup spanning tree logic; add update bodies
/*
/* Revision 1.6  2004/05/13 21:58:14  dahlin
/* simple unbind implemented
/*
/* Revision 1.5  2004/04/29 21:44:41  lgao
/* For compilation purposes...
/*
/* Revision 1.4  2004/04/27 18:39:35  dahlin
/* Added interfaces to increase knowledge of local events
/*
/* Revision 1.3  2004/04/26 20:01:57  nayate
/* Fixed method declarations + changed Timestamp to AcceptStamp
/*
/* Revision 1.2  2004/04/15 20:04:24  nayate
/* New Makefile; added provision to allow CVS to append file modification
/* logs to files.
/* */
//---------------------------------------------------------------------------
