package code;
 /** 
 *  Represents a communication packet sent to the coordinator 
 **/ 
import java.io.OutputStream;
import java.io.ObjectOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.io.BufferedInputStream;

public class CoordCommPacket implements Serializable
{
    public static final int AWAKE_SIGNAL = 1;
    public static final int ACCEPT_STAMP = 2;
    public static final int SYNC_DONE = 3;
    public static final int READ_DONE = 4;
    public static final int CURRENT_VV = 5;
    public static final int SYNC_BODY_DONE = 6;
    public static final int SYNC_BODY_RETRY = 7;

    private int signalType;
    private Object data;

 /** 
 *  Constructor 
 **/ 
    public CoordCommPacket(int signalType_, Object data_)
    {
	this.signalType = signalType_;
	this.data = data_;
    }

  private static boolean debug = false;

    public static void setD(boolean d){
	debug = true;
    }
    
 /** 
 *  Make a new CoordCommPacket object from the stream 
 **/ 
    public static CoordCommPacket makePacket(InputStream is)
	throws IOException, ClassNotFoundException
    {

	if(debug){ // look at the input stream content.
	    byte[] b = new byte[80];
	    is.read(b);
            for(int i = 0; i < 80; i++){
              System.err.println((char)b[i]);
            }
	}

	ObjectInputStream ois = null;
	CoordCommPacket ccp = null;


	//ois = new ObjectInputStream(is);
        // TEMPORARY!
        BufferedInputStream bis = null;
        try{
          bis = new BufferedInputStream(is);
          bis.mark(100000);
          ois = new ObjectInputStream(bis);
          ccp = (CoordCommPacket)ois.readObject();
          assert((ccp.signalType >= AWAKE_SIGNAL) &&
                 (ccp.signalType <= SYNC_BODY_RETRY));
          assert((ccp.signalType != AWAKE_SIGNAL) || (ccp.data == null));
          assert((ccp.signalType != SYNC_DONE) || (ccp.data == null));
          assert((ccp.signalType != READ_DONE) ||
                 (ccp.data instanceof AcceptStamp));
          assert((ccp.signalType != ACCEPT_STAMP) ||
                 (ccp.data instanceof AcceptStamp));
          assert((ccp.signalType != CURRENT_VV) ||
                 (ccp.data instanceof VV));
          assert((ccp.signalType != SYNC_BODY_DONE) || (ccp.data != null));
          assert((ccp.signalType != SYNC_BODY_RETRY) || (ccp.data == null));
        }catch(StreamCorruptedException e){
          bis.reset();
          byte[] b = new byte[80];
          bis.read(b);
          for(int i = 0; i < 80; i++){
            System.err.println((char)b[i]);
          }
          //is.reset();
        }
	return(ccp);
    }

 /** 
 *  Send this packet on the given channel 
 **/ 
    public void sendSelf(OutputStream os) throws IOException
    {
	ObjectOutputStream tos = null;

	tos = new ObjectOutputStream(os);
	tos.writeObject(this); // Automatically does a flush()
    }

 /** 
 *  Return a hash code (NOTE: Currently unimplemented) 
 **/ 
    public int hashCode()
    {
	assert(false);
	return(0);
    }

 /** 
 *  Return the type of this packet 
 **/ 
    public int getSignalType()
    {
	return(this.signalType);
    }

 /** 
 *  Return the data in this packet 
 **/ 
    public Object getData()
    {
	return(this.data);
    }

 /** 
 *  Convert to a string representation 
 **/ 
    public String toString()
    {
	String str = null;

	switch(this.signalType){
	case AWAKE_SIGNAL:
	    str = "AWAKE";
	    break;
	case ACCEPT_STAMP:
	    str = "" + this.data;
	    break;
	case SYNC_DONE:
	    str = "SYNC_DONE";
	    break;
	case READ_DONE:
	    str = "READ_DONE";
	    break;
	case CURRENT_VV:
	    str = "CURRENT_VV";
	    break;
	case SYNC_BODY_DONE:
	    str = "SYNC_BODY_DONE";
	    break;
	case SYNC_BODY_RETRY:
	    str = "SYNC_BODY_RETRY";
	    break;
	default:
	    assert(false);
	}
	return(str);
    }

 /** 
 *  Return true if o is equal to this object 
 **/ 
    public boolean equals(Object o)
    {
	boolean result = false;
	CoordCommPacket ccp = null;

	if(o instanceof CoordCommPacket){
	    ccp = (CoordCommPacket)o;
	    result = (this.signalType == ccp.signalType) &&
		(this.data.equals(ccp.data));
	}else{
	    result = false;
	}
	return(result);
    }

 /** 
 *  Used for testing 
 **/ 
    public static void main(String[] argv)
    {
	ByteArrayOutputStream baos = null;
	CoordCommPacket ccp1 = null;
	CoordCommPacket ccp2 = null;
	byte[] b = null;
	ByteArrayInputStream bais = null;
	ObjectInputStream ois = null;

	try{
	    baos = new ByteArrayOutputStream();
	    ccp1 = new CoordCommPacket(AWAKE_SIGNAL, null);
	    ccp1.sendSelf(baos);
	    b = baos.toByteArray();
	    bais = new ByteArrayInputStream(b);
	    ccp2 = CoordCommPacket.makePacket(bais);
	    assert(ccp1.equals(ccp2));
	}catch(IOException e){
	    System.err.println("" + e);
	    assert(false);
	}catch(ClassNotFoundException e){
	    System.err.println("" + e);
	    assert(false);
	}    
    }
}

 /** 
 *  $Log: CoordCommPacket.java,v $ 
 *  Revision 1.13  2005/03/22 23:00:03  zjiandan 
 *  Changes for TactExpt. 
 *  
 *  Revision 1.12  2005/01/10 03:47:47  zjiandan 
 *  Fixed some bugs. Successfully run SanityCheck and Partial Replication experiments. 
 *  
 *  Revision 1.11  2004/05/25 07:31:54  zjiandan 
 *  Change TaggedOutputStream to ObjectOutputSteam so that stats won't count 
 *  bytes communicated between Coord and RMIs. 
 *  
 *  Revision 1.10  2004/05/25 01:20:32  lgao 
 *  Add utitlity to check std.out 
 *  
 *  Revision 1.9  2004/05/24 03:08:58  lgao 
 *  Add syncBodyCheck... 
 *  
 *  Revision 1.8  2004/05/23 23:45:05  zjiandan 
 *  Add SyncBody 
 *  
 *  Revision 1.7  2004/05/21 13:37:20  nayate 
 *  Minor changes (removed some debugging information) 
 *  
 *  Revision 1.6  2004/05/21 13:11:38  nayate 
 *  Fixed applyWrite bug 
 *  
 *  Revision 1.5  2004/05/21 11:08:54  nayate 
 *  Minor change 
 *  
 *  Revision 1.4  2004/05/21 11:03:03  lgao 
 *  Add a method to return current VV 
 *  
 *  Revision 1.3  2004/05/21 08:31:31  nayate 
 *  Added a new READ_DONE signal 
 *  
 *  Revision 1.2  2004/05/19 22:08:18  nayate 
 *  Added a new SYNC_DONE signal type 
 *  
 *  Revision 1.1  2004/05/19 20:31:13  nayate 
 *  Changed code to use stdin and stdout to communicate with the Coordinator 
 *  
 **/ 
