package code;

//package utils.junit;

import junit.textui.TestRunner;
import junit.framework.*;
import java.util.*;
import java.io.ObjectOutputStream;
import java.io.ObjectInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
/**
 * TBD: Update class name
 */
public class DebargoMsgUnit extends TestCase {
  public static final String TEST_ALL_TEST_TYPE = "UNIT";
  
  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public DebargoMsgUnit (final String s) {
    super (s);
  }

  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
    /* 
     * TBD: Insert other fixture code here
     * e.g., this.objectUnderTest = new ClassToBeTested(...);
     */
  }

  protected void tearDown() throws Exception{
    /* 
     * TBD: Insert other fixture cleanup code here
     */
    super.tearDown();
  }

 /** 
 *  test basic functions
 
 **/ 
  public void testBasicFunction(){
    
      // Simple testing for this class
      DebargoMsg um = new DebargoMsg(new ObjInvalTarget(new ObjId("obj1"), 0, 0), 
                                   new AcceptStamp(100, new NodeId(190)));

      assert((um.getNodeId().equals(new NodeId(190)))
             && ( um.getTime() == 100)
             && ( um.getInvalTarget().getObjId().equals(new ObjId("obj1"))));
		
      assert((((DebargoMsg)(um.clone())).getNodeId().equals(new NodeId(190)))
             && ( ((DebargoMsg)(um.clone())).getTime() == 100)
             && ( ((DebargoMsg)(um.clone())).getInvalTarget().getObjId().equals(new ObjId("obj1"))));
		
      return;
  }
  
 /** 
 *  test the custom serialization methods
 
 **/ 
  public void testSerialization(){
    ObjInvalTarget hit1 = null;
    
    DebargoMsg ii1 = null;
    DebargoMsg ii2 = null;
    AcceptStamp as1 = null;
    
    ByteArrayOutputStream baos = null;
    ByteArrayInputStream bais = null;
    ObjectOutputStream oos = null;
    ObjectInputStream ois = null;

    // Test 1
    // Try a simple invalidate
    try{
      baos = new ByteArrayOutputStream();
      oos = new ObjectOutputStream(baos);
      
      ii1 = new DebargoMsg(new ObjInvalTarget(new ObjId("/b"),
                                              0,
                                              2),
                           new AcceptStamp(1, new NodeId(10)));
                           
                           

      //System.out.println("test " + ii1);
      oos.writeObject(ii1);
      oos.flush();
      oos.close();
      baos.flush();
      baos.close();

      bais = new ByteArrayInputStream(baos.toByteArray());
      ois = new ObjectInputStream(bais);
      try{
        ii2 = (DebargoMsg)(ois.readObject());
      }catch(ClassNotFoundException ce){
        ce.printStackTrace();
        assert false;
      }
      //System.out.println("get " + ii2);
      assert(ii1 != ii2);
      assert(ii2.equals(ii1));
      assert(ii1.equals(ii2));
    }catch(IOException e){
      e.printStackTrace();
      System.out.println("" + e);
      assert(false);
    }
  }
  
  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(DebargoMsgUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "DebargoMsgUnit";
    System.err.print(name + " self test begins...");
    TestRunner tr = new TestRunner();
    tr.doRun(suite());
    System.err.println(name + " self test succeeds");
  }

}
