package code;

 /** 
 *  Immutable data structure that stores fields of a Delete invalidate message 
 *  just inheritates all the methods from PreciseInv right now. 
 **/ 
public class DeleteInv implements GeneralInv, SingleWriterInval, Immutable{

  private final ObjId obj;
  private final AcceptStamp acceptStamp;
  private final AcceptStamp rtAcceptStamp;
  private boolean embargoed;
 /** 
 *  Constructor 
 **/ 
  public 
  DeleteInv(final ObjId obj_,
            final AcceptStamp acceptStamp_){
    assert(obj_ instanceof Immutable);
    this.obj = obj_;  // obj is immutable
    assert(acceptStamp_ instanceof Immutable);
    this.acceptStamp = acceptStamp_; // acceptStamp is immutable

    if(!warnedInht){
      Env.tbd("DeleteInv is logically a precise inval but is not a subclass of"
              + " PreciseInv. The reason for this is that delete stores objId"
              + " rather than ObjInvalTarget. The problem with this is that "
              + " we could have bugs where we check 'gi instanceof PreciseInv'"
              + " when we should have checked 'gi.isPrecise()'. Fix might be"
              + " to make an empty class PreciseInv and make the current "
              + " PreciseInv into a subclass of that.");
      warnedInht = true;
    }
    this.rtAcceptStamp = acceptStamp_;
    
    this.embargoed = false;
  }

 /** 
 *  Constructor 
 **/ 
  public 
  DeleteInv(final ObjId obj_,
            final AcceptStamp acceptStamp_,
            final AcceptStamp rtAcceptStamp_,
            boolean embargoed_){
    assert(obj_ instanceof Immutable);
    this.obj = obj_;  // obj is immutable
    assert(acceptStamp_ instanceof Immutable);
    this.acceptStamp = acceptStamp_; // acceptStamp is immutable

    if(!warnedInht){
      Env.tbd("DeleteInv is logically a precise inval but is not a subclass of"
              + " PreciseInv. The reason for this is that delete stores objId"
              + " rather than ObjInvalTarget. The problem with this is that "
              + " we could have bugs where we check 'gi instanceof PreciseInv'"
              + " when we should have checked 'gi.isPrecise()'. Fix might be"
              + " to make an empty class PreciseInv and make the current "
              + " PreciseInv into a subclass of that.");
      warnedInht = true;
    }
    this.rtAcceptStamp = rtAcceptStamp_;
    assert rtAcceptStamp_.getNodeId().equals(acceptStamp_.getNodeId());
    this.embargoed = embargoed_;
  }
  private static boolean warnedInht = false;

  public boolean isEmbargoed(){
    return embargoed;
  }
  public final AcceptStamp getRTAcceptStamp()
    {
      assert this.rtAcceptStamp != null;
      assert(this.rtAcceptStamp instanceof Immutable);
      return(this.rtAcceptStamp);
    }
 /** 
 *  Generate and return an acceptVV wrapper around acceptStamp 
 **/ 
  public final AcceptVV getRTVV()
    {
      AcceptVV vv = null;
      AcceptStamp[] uniStamp = null;

      uniStamp = new AcceptStamp[1];
      uniStamp[0] = this.rtAcceptStamp;
      vv = new AcceptVV(uniStamp);
      return(vv);
    }
 

 /** 
 *  Return the accept stamp 
 **/ 
  public final AcceptStamp 
  getAcceptStamp(){
    return(this.acceptStamp);
  }

 /** 
 *  Return the objid 
 **/ 
  public final ObjId
  getObjId(){
    assert(this.obj instanceof Immutable);
    return(this.obj);
  }

 /** 
 *  isDelete() 
 **/ 
  public final boolean
  isDelete(){
    return true;
  }

 /** 
 *  METHODS INHERITED FROM GENERALINV: 
 **/ 

 /** 
 *  Return the InvalTarget for this invalidate 
 **/ 
  public final InvalTarget 
  getInvalTarget(){
    return(new ObjInvalTarget(obj, 0, Long.MAX_VALUE));
  }

 /** 
 *  Generate and return an acceptVV wrapper around acceptStamp 
 **/ 
  public final AcceptVV 
  getStartVV(){
    AcceptVV vv = null;
    AcceptStamp[] uniStamp = null;
  
    uniStamp = new AcceptStamp[1];
    uniStamp[0] = this.acceptStamp;
    vv = new AcceptVV(uniStamp);
    return(vv);
  }

 /** 
 *  Generate and return an acceptVV wrapper around acceptStamp 
 **/ 
  public final AcceptVV 
  getEndVV(){
    return(this.getStartVV()); // For a precise inv, startVV == endVV
  }

//
// Note: No call for getVV() for a general
// inval -- need to say whether you mean the start or end
//

 /** 
 *  Clone this object 
 *  
 *  If we *know* that this object and all objects we reference 
 *  are immutable, then just return this; otherwise perform 
 *      newOne = super.clone();  
 *      now replace any fields in newOne that point to mutable  
 *          objects with a clone of that field 
 *      return newOne 
 *  
 **/ 
  public Object clone(){
    assert(this instanceof Immutable);
    return this;
  }

 /** 
 *  Return a new invalidate with mutiple operations performed 
 **/ 
  public GeneralInv 
  cloneIntersectInvaltargetChopStartEnd(GeneralInv inv){
    InvalTarget invTarget = null;
    GeneralInv intersectInv = null;
  
    invTarget = this.getInvalTarget().getIntersection(inv.getInvalTarget());
    assert(invTarget != null);
    if(inv.equals(this)){
      intersectInv = this;
    }else if(invTarget instanceof ObjInvalTarget){
      assert(((ObjInvalTarget)invTarget).getObjId().equals(this.obj));
      intersectInv = new DeleteInv(this.obj,
                                   this.acceptStamp);
    }else if(invTarget instanceof HierInvalTarget){//dummy
      //actually it's abnormal if the program goes here.
      //how could a node receives a preciseInv/deleteInv first
      //then receives something imprecise that doesn't intersect with
      //the preciseinv.
      intersectInv = new SingleWriterImpreciseInv((HierInvalTarget)invTarget,
                                                  this.acceptStamp,
                                                  this.acceptStamp,
                                                  this.rtAcceptStamp);
    }else if(invTarget instanceof MultiObjInvalTarget){
      System.err.println("Should not have received a MultiObjInvalTarget " +
                         "as the result of an intersection");
      assert(false);
    }else{
      System.err.println("Invalid inval target type");
      assert(false);
    }
    return(intersectInv);
  }

 /** 
 *  Return the portion of an invalidate for one writer whose 
 *  starting stamp is potentially chopped. 
 **/ 
  public GeneralInv 
  getOneWriterSubsetFrom(NodeId node,
                         long startStampInclusive){
    /*
      return an invalidation (possibly this) with 
      interestSet = this.interestSet
      nodeId = node // assert node was in this.VV
      startVV{node} == startStampInclusive
      // assert this.startStamp{node} >= startSTampInclusive
      endVV{node} == this.endVV{node}
      (Note: OK to just return this if we meet all of the other criteria)
    */
    GeneralInv subsetInv = null;
  
    assert(node.equals(this.acceptStamp.getNodeId()));
    if(this.acceptStamp.getLocalClock() == startStampInclusive){
      subsetInv = this;
    }
    return(subsetInv);
  }

 /** 
 *  Return true if the entire invalidation is already accounted 
 *  for by the specified vv 
 **/ 
  public boolean isIncludedBy(VV vv){
    //if we are precise, return vv.includes(this.timestamp)
    //if we are imprecise, return vv.includes(this.*endVV*)
    return(vv.includes(this.acceptStamp));
  }

 /** 
 *  Return true if any component of this invalidation is already 
 *  accounted for by the specified vv 
 **/ 
  public boolean anyComponentIncludedBy(VV vv) {
    //if we are precise, return vv.includes(this.timestamp)
    //if we are imprecise, true if for any entry e in *startVV*,
    //  vv.includes(e.timestamp)
    return(vv.includes(this.acceptStamp));
  }

 /** 
 *  Return true if this invalidation is committed 
 **/ 
  public boolean isCommitted() {
    return false;
  }

 /** 
 *  Return true if this invalidate is precise (which it is!) 
 **/ 
  public boolean isPrecise(){
    return(true);
  }

 /** 
 *  Return true if this invalidate is bound (which it isn't!) 
 **/ 
  public boolean isBound(){
    return(false);
  }

 /** 
 *  Create a new generalInv that is the union of this and i 
 **/ 
  public GeneralInv newUnion(GeneralInv i, SubscriptionSet ss){
    /*
      each element of startVV is min of corresponding
      end        max
      interest set is union of corresponding
      assert(either both are uncommitted or both are committed)
      if both committed 
      assert no gap between csnEnd of one and csnStart of
      next (OK to overlap)
      csnstart = min of both csnStart
      csnEnd = max of both csnMax
    */
    assert (!this.embargoed);
    assert (!i.isEmbargoed());

    InvalTarget it = null;
    ImpreciseInv impreciseInv = null;
    GeneralInv gi = null;
    AcceptVV newStartVV = null;
    AcceptVV newEndVV = null;
    AcceptVV newRTVV = null;
  
  
    it = (i.getInvalTarget()).getUnion(this.getInvalTarget(), ss);

    if((it instanceof ObjInvalTarget) && (!i.equals(this))){
      it = HierInvalTarget.makeHierInvalTarget(this.getObjId().getPath());
    }else if(it instanceof MultiObjInvalTarget){
      // Convert the returned object into a HierInvalTarget because we need
      // to build an Imprecise Invalidate out of the union
      it = ((MultiObjInvalTarget)it).makeHierInvalTarget();
    }
    assert(it instanceof HierInvalTarget);

    // Make an imprecise inval out of this
    newStartVV = this.getStartVV().cloneMinVV(i.getStartVV());
    newEndVV = this.getEndVV().cloneMaxVV(i.getEndVV());
    newRTVV = this.getRTVV().cloneMaxVV(i.getRTVV());
    impreciseInv = new ImpreciseInv((HierInvalTarget)it,
                                    newStartVV,
                                    newEndVV,
                                    newRTVV);
    return(impreciseInv);
  }

 /** 
 *  Return -1, 0, or 1 if this is smaller, equal, or larger than 
 *  gi2, respectively, based on mechanism to provide total orders. 
 **/ 
  public int 
  totalOrderCompare(GeneralInv gi2){
    /*
      return -1 if this < gi2 in the total order of the log
      return +1 if this > gi2 in the total order of the log
      return 0 if this and gi2 are equivalent and can be ordered either
      way (both start at the same time and end at the same time)

      we sort by CSN then by min acceptStamp then by serverId

      (1) CSN

      If this.CSN < gi2.CSN, then return -1
           
      Note that an unassigned CSN has an infinite value)

      For a bulk invalidation, consider the *minimum* CSN included
      in the invalidation.

      If this.CSN == gi2.CSN != CSN_UNASSIGNED, either order 
      is legal. If either is a bulk invalidation, the one with 
      the lower maxCSN goes first. If both have the same maxCSN
      then return 0

      (2) startTime acceptStamp
      assert this.CSN == gi2.CSN == CSN_UNASSIGNED

      if the invalidation is precise, consider its acceptStamp
      if the invalidation is imprecise, consider the startVV and
      look at the minimum entry across all nodeId's in startVV

      if they differ, return -1 or 1

      (3) nodeId
      if both minimum accept stamps in step (2) are equal, 
      then compare the node Ids

      if they differ, return -1 or 1

      (4) endtime acceptStamp

      assert csn, startTime, and nodeId are all the same

      send the "more precise" one first --> look at the endTime
      and the one with the smaller max endtime comes first

      if they differ, return -1 or 1
      if they are the same, return 0 (note that if the invals are
      imprecise, they may still differ in elements other than
      their max or min...but that's ok)
    */
    int result = 0;
    long stamp = Long.MAX_VALUE;
    long minStamp = Long.MAX_VALUE;
    Object gi2StampToken = null;
    Object minStampToken = null;
    AcceptVV gi2AcceptVV = null;
    NodeId nodeId = null;
    VVIterator i = null;

    gi2AcceptVV = gi2.getStartVV();
    for(i = gi2AcceptVV.getIterator(); i.hasMoreElements();){
      gi2StampToken = i.getNext();
      stamp = gi2AcceptVV.getStampByIteratorToken(gi2StampToken);
      if(stamp < minStamp){
        minStamp = stamp;
        minStampToken = gi2StampToken;
      }
    }
  
    assert(minStampToken != null);
    if(this.acceptStamp.getLocalClock() < minStamp){
      result = -1;
    }else if(minStamp < this.acceptStamp.getLocalClock()){
      result = 1;
    }else{
      nodeId = gi2AcceptVV.getServerByIteratorToken(minStampToken);
      // NOTE: NodeId.compareTo must return {-1,0,1}
      result = this.acceptStamp.getNodeId().compareTo(nodeId);
      if(result == 0){
        // NodeId's are the same; try end stamps
        assert(this.acceptStamp.getNodeId().equals(nodeId));
        if(this.acceptStamp.getLocalClock() <
           gi2.getEndVV().getMaxTimeStamp()){
          result = -1;
        }else if(gi2.getEndVV().getMaxTimeStamp() <
                 this.acceptStamp.getLocalClock()){
          result = 1;
        }else{
          result = 0;
        }
      }
    }
    return(result);
  }

 /** 
 *  METHODS INHERITED FROM SINGLEWRITERINVAL 
 **/ 

 /** 
 *  Return the start vv entry for this writer (start == end for precise) 
 **/ 
  public long getStart()
    {
      return(this.acceptStamp.getLocalClock());
    }

 /** 
 *  Return the end vv entry for this writer (start == end for precise) 
 **/ 
  public long getEnd()
    {
      return(this.acceptStamp.getLocalClock());
    }

 /** 
 *  Return the ID of the node that did this write 
 **/ 
  public NodeId getNodeId()
    {
      return(this.acceptStamp.getNodeId());
    }

 /** 
 *  Clone this object while chopping off a prefix of the startTime 
 **/ 
  public SingleWriterInval cloneChopStartTime(long startTimeOfNew)
    {
      assert(this.acceptStamp.getLocalClock() == startTimeOfNew);
      return((SingleWriterInval)this.clone());
    }

 /** 
 *  Clone this object while chopping off a suffix of the startTime 
 **/ 
  public SingleWriterInval cloneChopEndTime(long endTimeOfNew)
    {
      assert(this.acceptStamp.getLocalClock() == endTimeOfNew);
      return((SingleWriterInval)this.clone());
    }

 /** 
 *  Return true if the passed-in object is "equal" to this PreciseInv 
 **/ 
  public boolean
  equals(Object obj){
    boolean result = false;
    DeleteInv pi = null;

    if(obj instanceof DeleteInv){
      pi = (DeleteInv)obj;
      result = (this.obj.equals(pi.obj) &&
                this.acceptStamp.equals(pi.acceptStamp) &&
                this.rtAcceptStamp.equals(pi.rtAcceptStamp) &&
                (this.embargoed == pi.embargoed));
    }
    return(result);
  }


 /** 
 *  Convert to a string 
 **/ 
  public final String toString()
    {
      String str = null;

      str = "DeleteInv: <" + this.obj + ", " + this.acceptStamp 
        + ", " + this.rtAcceptStamp + ">";
      return(str);
    }

 /** 
 *  memSize() -- 
 *    Estimate the memory footprint of this object in a cheap while not 
 *    very accurate way. 
 *  
 *  Use SizeOf and TestClass to get the number of overheads: 
 *  if delete or add new members, recalculate the number of bytes 
 *  refering to ./test/FootPrintSizeOfStandardObject.txt 
 **/ 
  public long memSize(){
    return 144;
  }

 /** 
 *  Used for testing 
 **/ 
  public static void main(String[] argv)
    {
      DeleteInv di =
        new DeleteInv(new ObjId("/obj1"),
                      new AcceptStamp(1, new NodeId(200)));

      SingleWriterImpreciseInv ii =
        new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget("/obj1"),
                                     new AcceptStamp(0, new NodeId(200)),
                                     new AcceptStamp(2, new NodeId(200)));
      //
      // test 1: DeleteInv intersect with a general singlewriterimprecise inval
      // return a DeleteInv
      //
      System.err.println(di.cloneIntersectInvaltargetChopStartEnd(ii));

      //
      // test 2: a singlewriterimprecise inval intersect with DeleteInv
      // return a DeleteInv
      //
      System.err.println(ii.cloneIntersectInvaltargetChopStartEnd(di));
    }
      
}

//---------------------------------------------------------------------------
/* $Log: DeleteInv.java,v $
/* Revision 1.17  2006/04/20 03:52:53  zjiandan
/* Callbacks merged with runTime.
/*
/* Revision 1.16  2006/04/04 15:59:59  nayate
/* Added the ability to (1) delay invalidates, and (2) support transactional updates.
/*
/* Revision 1.15  2005/10/13 00:24:23  zjiandan
/* remove Config.getMy* fixed Garbage Collection and Checkpoint exchange code
/*
/* Revision 1.14  2005/07/18 05:10:22  zjiandan
/* Embargoed Writes etc. features implementation plus
/* log overhead measurement with disk size and in-memory size.
/*
/* Revision 1.13  2005/02/28 23:19:38  nayate
/* Modified for new code
/*
/* Revision 1.12  2005/02/28 22:57:58  nayate
/* Modified for new code
/*
/* Revision 1.11  2004/11/02 22:24:33  zjiandan
/* add utility methods for core recovery self test.
/*
/* Revision 1.10  2004/10/22 20:46:54  dahlin
/* Replaced TentativeState with RandomAccessState in DataStore; got rid of 'chain' in BodyMsg; all self-tests pass EXCEPT (1) get compile-time error in rmic and (2) ./runSDIMSControllerTest fails [related to (1)?]
/*
/* Revision 1.9  2004/10/22 18:13:38  zjiandan
/* cleaned csn from UpdateLog, modified DeleteInv.
/* TBD:
/*    1. clean csn from all subclasses of GeneralInv
/*    2. fix *Inv::cloneIntersectInvaltargetChopStartEnd
/* */
//---------------------------------------------------------------------------
