package code;

 /** 
 **/ 

import java.io.*;

public class DemandReadWorker extends Thread
{


private SDIMSController controller;
private WorkQueue work;
private RMIClient rmiClient;
private TimeoutQueue timeouts;
private ReadDirectory dir;
  private NodeId myNodeId;

public
DemandReadWorker(SDIMSController controller_, 
		 WorkQueue work_,
		 TimeoutQueue timeouts_,
		 RMIClient rmiClient_,
		 ReadDirectory dir_, 
                 NodeId myNodeId_)
{   
    this.controller = controller_;
    this.work = work_;
    this.timeouts = timeouts_;
    this.rmiClient = rmiClient_;
    this.dir = dir_;
    this.myNodeId = myNodeId_;
}


public void 
run()
{
    PendingDemandRequest pdr;
    NodeId target;
    long expectBytes;
    long timeoutMS;

    while(true){
	try{
	    pdr = (PendingDemandRequest)work.getNext();
		Env.sprintln(" -- pulled out request for " + pdr.getObjId() + " from work queue");
	    timeoutMS = pdr.getTimeout();

		//do {
	    target = dir.getTarget(pdr);
		if (!target.isValid() || target.equals(this.myNodeId)) {
		//
		// SDIMS couldn't tell us who to connect to
		// Retry after a timeout.
		//
		System.err.println(" -- SDIMS couldn't yet tell us where to fetch " + pdr.getObjId() + " from");
		timeouts.insert(timeoutMS, pdr);
		continue;
	    }
	    expectBytes = issueRMI(pdr, target);
	    if(expectBytes <= 0){
		//
		// either we already paid a timeout on an RMI error
		// or the node we went to didn't have the data.
		// Re-issue the request w/o any additional timeout
		// (note that we will re-aggregate so may go to a different
		// node on retry.)
		//
		timeouts.insert(0, pdr);
		continue;
	    }
	    //
	    // We succeeded in issuing the request. Set a timeout in
	    // case data doesn't show up.
	    //
	    timeouts.insert(timeoutMS, pdr);
	    continue;
	}
	catch(RuntimeException e){
	    Env.warn("DemandReadWorker had exception: "
		     + e.toString() + "...Skipping request and continuing.");
	    e.printStackTrace();
	}
    }
}

/*
 *------------------------------------------------------------------
 *
 * issueRMI --
 *
 *         Issue an RMI for the requested data. 
 *
 * Arguments:
 *      type1 arg1 -- description.
 *
 * Results:
 *      Return expected number of bytes this node can supply;
 *      >0 -- hit
 *       0 -- node replies "miss"
 *      <0 -- other error -- caller should retry
 *
 * Side effects:
 *      None.
 *
 *------------------------------------------------------------------
 */
private static boolean warned = false;
private static boolean warned2 = false;
private long
issueRMI(PendingDemandRequest pdr, NodeId node)
{

    try{
	long expect = rmiClient.issueDemandRead(pdr.getObjId(),
						pdr.getOffset(),
						pdr.getLength(),
						pdr.getRequestId(),
						node,
						this.myNodeId,
						Config.getDNS(this.myNodeId),
						Config.getPortBody(this.myNodeId),
						pdr.getAcceptStamp());
	return expect;
    }
    //
    // For exceptions that reflect communications errors, treat
    // them as timeouts. Retry.
    //
    catch(ObjNotFoundException d){
	if(!warned2){
	    Env.warn("DemandReadWorker::issueRMI() -- what happens if we try to read a non-existant file (or a file that is being deleted from the directory just as we issue the read? Does read ever terminate?");
	    warned2 = true;
	}
        //
        // Need to fix code so that in this case we (a) delete the pendingReadReq
        // from SDIMSController and (b) unblock the waiting local read.
        // Probably the waiting local read should retry -- see if the local state
        // still thinks the object exits (--> retry remote read) or if the
        // local state has now seen a later delete (--> it will say "obj not exist")
        //
        assert(false); 
	return 0;
    }
    catch(ReadOfInvalidRangeException e){
      //
      // The node we went to doesn't have the data we want. Retry.
      //
      return -1; // Will trigger retry by caller
    }
    catch(RMINetworkException e){
	return -1;
    }
    catch(RMIApplicationException f){
	//Env.remoteAssert(f);
	f.printStackTrace();
	return -1;
    }
    catch(IOException e) {
      Env.warn("IO Exception occurred during remote read " + e);
      return -1;
    }
    catch(ReadOfHoleException rhe){
      
      Env.warn(rhe.toString());
      assert false: rhe.toString();//tbd what to do if the demand read targeting a hole
      return -2;
    }
    
}






public static void 
main(String s[])
{
    System.err.print("DemandReadWorker self test...");
    System.err.println("DemandReadWorker self test SUCCEEDS");
}



}
//---------------------------------------------------------------------------
/* $Log: DemandReadWorker.java,v $
/* Revision 1.16  2007/02/27 04:44:41  zjiandan
/* change readOfHole interface such that read of hole will throw an
/* ReadOfHoleException with the position of the next written byte.
/*
/* Revision 1.15  2007/02/01 06:12:08  zjiandan
/* Add acceptStamp to demandRead so that the sender only sends the data
/* that's at least as new as the acceptStamp.
/*
/* Revision 1.14  2006/08/16 21:26:18  dahlin
/* PicShareUnit test works on linux, too!
/*
/* Revision 1.13  2005/10/13 00:24:23  zjiandan
/* remove Config.getMy* fixed Garbage Collection and Checkpoint exchange code
/*
/* Revision 1.12  2004/10/22 20:46:54  dahlin
/* Replaced TentativeState with RandomAccessState in DataStore; got rid of 'chain' in BodyMsg; all self-tests pass EXCEPT (1) get compile-time error in rmic and (2) ./runSDIMSControllerTest fails [related to (1)?]
/*
/* Revision 1.11  2004/05/26 09:45:55  arun
/* *** empty log message ***
/*
/* Revision 1.10  2004/05/26 04:42:22  arun
/* *** empty log message ***
/*
/* Revision 1.9  2004/05/20 01:06:11  arun
/* added some code for recovery support in store. Added maxVV definition in COunterVV etc.
/*
/* Revision 1.8  2004/05/20 00:47:34  dahlin
/* Fixed several bugs to make inval log exchange work (biggest one: ISIterator handling case when an single-writer log exists but has no records in it; also added some debugging tools
/*
/* Revision 1.7  2004/05/10 23:55:42  dahlin
/* Moved SDIMS read requests into ReadDirectory class for modularity and extensibility
/*
/* Revision 1.6  2004/05/10 22:45:47  dahlin
/* All unit: target tests succeed
/*
/* Revision 1.5  2004/05/10 21:14:15  dahlin
/* Getting close to something that compiles w/o errors...
/*
/* Revision 1.4  2004/05/10 21:00:22  lgao
/* Just to make things compile.
/*
/* Revision 1.3  2004/05/10 20:48:19  dahlin
/* Clarified RMI exceptions; full version of (stub) DemandReadWorker
/*
/* Revision 1.2  2004/05/10 18:57:22  dahlin
/* Fixed ^M formatting
/*
/* Revision 1.1  2004/05/08 22:20:17  dahlin
/* Partially complete version of SDIMSController (it should compile w/o error, though)
/*
 */
//---------------------------------------------------------------------------
