package code;

 /** 
 *  DirectoryUpdate contains information needed to update the distributed 
 *  directory of what data is stored on what nodes. 
 **/ 
public class DirectoryUpdate
{
    private ObjId objId;
    private long offset;
    private long length;
    private int action;
    
    public final static int INSERT = 3199;
    public final static int INVAL = 3200;

    public DirectoryUpdate(int action_, BodyMsg bodyMsg)
    {
	assert(action_ >= INSERT && action_ <= INVAL);
	this.action = action_;
	ObjInvalTarget oit = bodyMsg.getObjInvalTarget();
	this.objId = oit.getObjId();
	this.offset = oit.getOffset();
	this.length = oit.getLength();
    }

    public DirectoryUpdate(int action_, GeneralInv gi)
	throws IsImpreciseException
    {
	assert(action_ >= INSERT && action_ <= INVAL);
	this.action = action_;
	if(!gi.isPrecise()){
	    throw new IsImpreciseException("Don't know how to update dir"
					 + " for imprecise inval.");
	}
	ObjInvalTarget oit = (ObjInvalTarget)gi.getInvalTarget();
	this.objId = oit.getObjId();
	this.offset = oit.getOffset();
	this.length = oit.getLength();
    }

    public DirectoryUpdate(int action_, ObjId oid, long offset_, long length_)
    {
	assert(action_ >= INSERT && action_ <= INVAL);
	this.action = action_;
	this.objId = oid;
	this.offset = offset_;
	this.length = length_;
    }


    public final int getAction()
    {
	assert(action >= INSERT && action <= INVAL);
	return action;
    }

    public final long getOffset()
    {
	return offset;
    }

    public final long getLength()
    {
	return length;
    }

    public final ObjId getObjId()
    {
	return objId;
    }

    public String toString() {
	return "DirectoryUpdate("+objId+","+offset+","+length+","+
	    (action == INSERT? "INSERT":"INVAL")+")" ;
    }


 /** 
 *  Defensive programming. No hashcode() or equals() unless we've 
 *  thought about them first... 
 **/ 
    public int hashCode()
    {
	assert(false);
	return super.hashCode();
    }
 /** 
 *  Defensive programming. No hashcode() or equals() unless we've 
 *  thought about them first... 
 **/ 
    public boolean equals(Object o)
    {
	assert(false);
	return super.equals(o);
    }
}



//---------------------------------------------------------------------------
/* $Log: DirectoryUpdate.java,v $
/* Revision 1.3  2004/05/23 23:53:17  ypraveen
/* Added a toString() routine
/*
/* Revision 1.2  2004/05/22 06:46:19  arun
/* minor corrections
/*
/* Revision 1.1  2004/05/11 00:46:56  dahlin
/* Added read-miss-directory updates to SDIMSController
/*
 */
//---------------------------------------------------------------------------
