package code;

 /** 
 *  Apply directory updates to directory. This is a thread so that 
 *  we can tolerate latencies in the case of distributed directories. 
 **/ 
public class DirectoryUpdateWorker extends Thread
{
ReadDirectory dir;
WorkQueue work;

public DirectoryUpdateWorker(WorkQueue work_, ReadDirectory dir_)
{
    this.work = work_;
    this.dir = dir_;
}

public void run()
{
    while(true){
	try{
	    DirectoryUpdate du = (DirectoryUpdate)work.getNext();
	    switch(du.getAction()){
	    case DirectoryUpdate.INSERT:
		doInsert(du);
		break;
	    case DirectoryUpdate.INVAL:
		doInval(du);
		break;
	    default:
		assert(false);
	    }
	}
	catch(Exception e){
	    Env.warn("DirectoryUpdateWorker had exception: "
		     + "e.toString" + "...Goodbye cruel world.");
	    e.printStackTrace();
	    assert(false);
	}
    }
}


private void 
doInsert(DirectoryUpdate du)
{
    dir.insert(du);
}

private void 
doInval(DirectoryUpdate du)
{
    dir.inval(du);
}



}

//---------------------------------------------------------------------------
/* $Log: DirectoryUpdateWorker.java,v $
/* Revision 1.2  2004/05/22 10:10:12  arun
/* minor changes to notifyUpq logic. Correction of store behaviour while handling bound invals.
/*
/* Revision 1.1  2004/05/11 00:46:56  dahlin
/* Added read-miss-directory updates to SDIMSController
/*
 */
//---------------------------------------------------------------------------
