package code;

import java.io.*;
//
// Used in some unit tests that fork off worker process.
// Consume stdin and stderr or subprocesses so they
// don't block when the buffer is full
//
public class DvNull extends Thread
{
  private InputStream is;
  private String who;
  private boolean vverbose;
  private boolean verbose;

  public DvNull(InputStream is, String who, boolean verbose, boolean vverbose){
    this.is = is;
    this.who = who;
    this.verbose = verbose;
    this.vverbose = vverbose;
  }
  
  public void run(){
    try{
      InputStreamReader isr = new InputStreamReader(is);
      BufferedReader br = new BufferedReader(isr);
      String line = null;
      while((line = br.readLine()) != null){
        System.out.println(who + ": " + line);
      }
    }
    catch(IOException e){
      if( verbose ){
	Env.dprintln(verbose, who 
                  + ": " + e.toString() 
                  + " [closed]");
      }
      if(vverbose){
        e.printStackTrace();
      }
      try{
        is.close();
      }
      catch(Exception z){
        // Ignore error on close from exception...
      }
    }
  }
}
