package code;

 /** 
 **/ 
import java.io.BufferedWriter;
import java.io.FileWriter;

public class Env
{

  //
  // Thou Shalt Not turn off WARN, PERFORMANCEWARN, and TBD.
  // These provide important reminders for us (and may
  // help debug experiments.
  //
  // Callers should ensure that these messages print
  // rarely enough not to hurt performance or innundate
  // the person running the program with 
  // gunk.
  //
  // E.g.,
  // static warn = false;
  // ...
  // if(!warn){
  //   Env.warn(...);
  //   warn = true;
  // }
  //
  public static boolean WARN =true; 
  public static boolean PERFORMANCEWARN = false; 
  public static boolean TBD = false; 

  public static boolean DEBUG = false;
  public static boolean DEBUGSTREAM = false;
  public static boolean SDIMSBUG = false;

  public static boolean DO_EXPENSIVE_SANITY_CHECKS = false;

  //
  // for TactExpt: log invalidate/validate time to calculate read avail score 
  //
  public static final boolean EXPT_LOG = true;  
  private static BufferedWriter validLog = null;
  private static BufferedWriter writeLog = null;
  
    public static void 
    warn(String s)
    {
	if(WARN){
	    System.out.println("WARNING: " + s + "\n");
	}
    }

    public static void 
    tbd(String s)
    {
	if(TBD){
	    System.out.println("TBD: " + s + "\n");
	}
    }

 /** 
 *  convernience version of tbd to help print each warning once. Use it 
 *  as follows 
 *      printedAlreadyFlag = tbd(printedAlreadyFlag, message) 
 *  to ensure message only printed once. 
 **/ 
    public static boolean
    tbd(boolean done, String s)
    {
	if(!done && TBD){
	    System.out.println("TBD: " + s + "\n");
	}
        return true;
    }

    public static void verifyAssertEnabled()
    {
	boolean assertsEnabled = false;

	assert assertsEnabled = true; // Intentional side effect!!!
	if (!assertsEnabled){
	    System.err.println("Asserts must be enabled when testing!!!");
	    System.exit(-1);
	}
    }

    public static void remoteAssert(boolean cond)
    {
   	/*
	  we have detected an event that indicates a programming error on a
	  remote node. For debugging, we can treat this as an assert --
	  print a message and exit.  But in production mode, we must handle
	  bad or unexpected messages from remote node (e.g., by ignoring
	  the message and/or tearing down the connection to the bad node
	  and/or logging a warning to investigate the problem.)
	*/
	assert(cond);
    }

    public static void remoteAssert(boolean cond, String s)
    {
   	/*
	  we have detected an event that indicates a programming error on a
	  remote node. For debugging, we can treat this as an assert --
	  print a message and exit.  But in production mode, we must handle
	  bad or unexpected messages from remote node (e.g., by ignoring
	  the message and/or tearing down the connection to the bad node
	  and/or logging a warning to investigate the problem.)
	*/
	if(!cond){
	    System.err.println(s);
	}
	assert(cond);
    }


    public static void remoteAssert(boolean cond, Exception x)
    {
   	/*
	  we have detected an event that indicates a programming error on a
	  remote node. For debugging, we can treat this as an assert --
	  print a message and exit.  But in production mode, we must handle
	  bad or unexpected messages from remote node (e.g., by ignoring
	  the message and/or tearing down the connection to the bad node
	  and/or logging a warning to investigate the problem.)
	*/
	if(!cond){
          x.printStackTrace();
	}
	assert(cond);
    
    }

    public static void remoteAssert(Exception e)
    {
   	/*
	  we have detected an event that indicates a programming error on a
	  remote node. For debugging, we can treat this as an assert --
	  print a message and exit.  But in production mode, we must handle
	  bad or unexpected messages from remote node (e.g., by ignoring
	  the message and/or tearing down the connection to the bad node
	  and/or logging a warning to investigate the problem.)
	*/
	System.err.println("Remote bug treated as fatal: " + e.toString());
	e.printStackTrace();
	assert(false);
    }

  public static void printStackTrace(Exception e){
    e.printStackTrace();
  }

  public static void
    performanceWarning(String s)
  {
	/*
	  we have detected an event that indicates an inefficiency (e.g.,
	  where we deliberately chose to keep the code simple even though
	  rarely (we hope) it might be a bit inefficient. Log
	  this event so that we can notice if our assumptions that such
	  events are rare holds and to aid in performance debugging.
	*/
	if(PERFORMANCEWARN){
	    System.out.println("PERFORMANCE WARNING: " + s + "\n");
	}
    }

  public static boolean getDoExpensiveSanityChecks(){
    return DO_EXPENSIVE_SANITY_CHECKS;
  }

    public static void event(String str)
    {
	Env.printDebug("" + str);
    }

    public static void inform(String str)
    {
	Env.printDebug("" + str);
    }

    public static void printDebug(String str)
    {
	if(Env.DEBUG){
	    System.err.println(str);
	}
    }

	public static void sprint(String s) {
		System.err.print(s);
	}

	public static void sprintln(String s) {
		System.err.println(s);
	}
	public static void sprinterrln(String s) {
		System.err.println(s);
	}

	public static void dprint(boolean dbg, String s) {
	    if(dbg){
		System.err.print(s);
	    }
	}

	public static void dprintln(boolean dbg, String s) {
	    if(dbg){
		System.err.println(s);
	    }
	}
	public static void dprinterrln(boolean dbg, String s) {
	    if(dbg){
		System.err.println(s);
	    }
	}

  public static void logValid(String s) {
    if(EXPT_LOG){
      if(validLog == null){
        try{
          validLog = new BufferedWriter(new FileWriter("valid.log", true));
          assert validLog!=null;
          validLog.write(s, 0, s.length());
          validLog.flush();
      
        } catch (Exception e){
        
          e.printStackTrace();
          assert(false);
        }
      }else{
        try{
          validLog.write(s, 0, s.length());
          validLog.flush();
        } catch (Exception e){
          
          e.printStackTrace();
          assert(false);
        }
      }
    }
  }

  public static void logWrite(String str) {
    String s = System.currentTimeMillis() + " " + str + " [OUR_LOG]\n";
    if(EXPT_LOG){
      if(writeLog == null){
        try{
          String filename = "write.log";
          writeLog = new BufferedWriter(new FileWriter(filename, true));
          assert writeLog!=null;
          writeLog.write(s, 0, s.length());
          writeLog.flush();
      
        } catch (Exception e){
        
          e.printStackTrace();
          assert(false);
        }
      }else{
        try{
          writeLog.write(s, 0, s.length());
          writeLog.flush();
        } catch (Exception e){
          
          e.printStackTrace();
          assert(false);
        }
      }
    }
  }
  
  public static void logEvent(String str) {
    String s = str + "\n";
    if(EXPT_LOG){
      if(writeLog == null){
        try{
          String filename = "write.log";
          writeLog = new BufferedWriter(new FileWriter(filename, true));
          assert writeLog!=null;
          writeLog.write(s, 0, s.length());
          writeLog.flush();
      
        } catch (Exception e){
        
          e.printStackTrace();
          assert(false);
        }
      }else{
        try{
          writeLog.write(s, 0, s.length());
          writeLog.flush();
        } catch (Exception e){
          
          e.printStackTrace();
          assert(false);
        }
      }
    }
    
    
  }
}

//---------------------------------------------------------------------------
/* $Log: Env.java,v $
/* Revision 1.46  2007/07/12 17:02:32  zjiandan
/* *** empty log message ***
/*
/* Revision 1.45  2006/11/18 05:23:16  nalini
/* new read interface implemented
/*
/* Revision 1.44  2006/11/16 21:22:56  zjiandan
/* *** empty log message ***
/*
/* Revision 1.43  2006/08/31 17:32:18  dahlin
/* Synchronized StreamId::makeNewStreamId()
/*
/* Revision 1.42  2006/08/31 14:54:13  dahlin
/* DataStore restore from checkpoint seems to work now (including ISStatus and cVV)
/*
/* Revision 1.41  2006/08/15 21:46:23  dahlin
/* Added PicShare Reader and a simple unit test.
/*
/* Revision 1.40  2006/04/22 22:31:15  zjiandan
/* Completely merged with Runtime.
/*
/* Revision 1.39  2006/04/20 03:52:53  zjiandan
/* Callbacks merged with runTime.
/*
/* Revision 1.38  2005/10/14 22:05:01  zjiandan
/* Turn off printout.
/*
/* Revision 1.37  2005/10/13 00:24:23  zjiandan
/* remove Config.getMy* fixed Garbage Collection and Checkpoint exchange code
/*
/* Revision 1.36  2005/10/10 00:26:38  nayate
/* Removed some debugging output
/*
/* Revision 1.35  2005/06/01 22:41:46  dahlin
/* Added really basic self test for Nice
/*
/* Revision 1.34  2005/03/22 23:00:03  zjiandan
/* Changes for TactExpt.
/*
/* Revision 1.33  2005/03/07 06:54:14  nayate
/* Changed System.out to System.err
/*
/* Revision 1.32  2005/03/05 04:50:13  nayate
/* Added some testing code
/*
/* Revision 1.31  2005/03/02 21:43:20  zjiandan
/* Removed some bugs
/*
/* Revision 1.30  2005/01/10 03:47:47  zjiandan
/* Fixed some bugs. Successfully run SanityCheck and Partial Replication experiments.
/*
/* Revision 1.29  2004/11/02 22:24:33  zjiandan
/* add utility methods for core recovery self test.
/*
/* Revision 1.28  2004/10/22 20:46:54  dahlin
/* Replaced TentativeState with RandomAccessState in DataStore; got rid of 'chain' in BodyMsg; all self-tests pass EXCEPT (1) get compile-time error in rmic and (2) ./runSDIMSControllerTest fails [related to (1)?]
/*
/* Revision 1.27  2004/10/13 15:19:24  dahlin
/* Added remoteAssert(bool, Exception)
/*
/* Revision 1.26  2004/09/08 22:43:20  dahlin
/* Updated RandomAccessState to be more comprehensible; but at present it fails test 2 (endless loop)
/*
/* Revision 1.25  2004/08/18 22:44:43  dahlin
/* Made BoundInval subclass of PreciseInval; RandomAccessState passes 2 self tests
/*
/* Revision 1.24  2004/07/26 20:03:39  dahlin
/* Fixed typos from windows checkin so it will compile under Linux
/*
/* Revision 1.23  2004/05/26 16:19:28  nayate
/* *** empty log message ***
/*
/* Revision 1.22  2004/05/26 09:45:55  arun
/* *** empty log message ***
/*
/* Revision 1.21  2004/05/20 22:52:05  nayate
/* Minor changes
/*
/* Revision 1.20  2004/05/20 20:06:21  arun
/* *** empty log message ***
/*
/* Revision 1.19  2004/05/20 05:29:46  arun
/* minor changes + preciseinv typecast in DataStore
/*
/* Revision 1.18  2004/05/20 04:48:41  dahlin
/* Finished SDIMS controller self test for spanning tree; also basic spanning watchdog works
/*
/* Revision 1.17  2004/05/20 04:10:57  dahlin
/* Passes SDIMSController spanning tree self test
/*
/* Revision 1.16  2004/05/20 01:49:28  nayate
/* Changed some print statements to use Env.printDebug
/*
/* Revision 1.15  2004/05/20 01:44:07  dahlin
/* Looks like spanning trees are getting set up with TrivialSpanningTreeDirectory (though more testing remains)
/*
/* Revision 1.14  2004/05/20 01:06:11  arun
/* added some code for recovery support in store. Added maxVV definition in COunterVV etc.
/*
/* Revision 1.13  2004/05/19 02:25:44  dahlin
/* Testing fix
/*
/* Revision 1.12  2004/05/18 08:52:12  nayate
/* Changed "System.out.println" to "Env.debugPrintln" and turned off the debug
/* flag
/*
/* Revision 1.11  2004/05/13 18:49:17  dahlin
/* Clean SDIMSController by moving SpanningTree directory out as separate class (rather than using raw SDIMSInterface)
/*
/* Revision 1.10  2004/05/11 21:46:38  lgao
/* Implementation of TaggedOutputStream which counts bytes sent over the wire.
/*
/* Revision 1.9  2004/05/11 03:49:45  zjiandan
/* Made some changes to get the first version to work.
/*
/* Revision 1.8  2004/05/10 20:48:19  dahlin
/* Clarified RMI exceptions; full version of (stub) DemandReadWorker
/*
/* Revision 1.7  2004/05/09 18:52:50  nayate
/* Added a method "verifyAssertEnabled()" that exits if asserts are not turned
/* on.
/*
/* Revision 1.6  2004/05/07 00:41:08  dahlin
/* Updated Env.java
/*
/* Revision 1.5  2004/04/30 19:07:32  nayate
/* Added a "printDebug" method
/*
/* Revision 1.4  2004/04/26 20:05:35  nayate
/* Added a method to log events
/*
/* Revision 1.3  2004/04/16 18:53:22  nayate
/* Stub implementations that compile + minor fixes
/*
/* Revision 1.2  2004/04/15 20:04:24  nayate
/* New Makefile; added provision to allow CVS to append file modification
/* logs to files.
/* */
//---------------------------------------------------------------------------
