package code;

 /** 
 *  FileNameTokenizer: Convert a file name into tokens 
 **/ 
public class FileNameTokenizer{

 /** 
 *  Data members 
 **/ 
  private String fileName;
  private int index;

 /** 
 *  Constructor 
 **/ 
  public
  FileNameTokenizer(String myFileName){
    assert((myFileName.startsWith("/")) || (myFileName.equals(""))): "myFileName=" + myFileName;
    this.fileName = myFileName;
    this.index = -1;
  }

 /** 
 *  Return the next token 
 **/ 
  public String
  getNextToken(){
    String token = null;
    int slashLocation = 0;

    if(this.index >= -1){
      slashLocation = this.fileName.indexOf("/", this.index + 1);
      if(slashLocation < 0){
        token = this.fileName.substring(this.index + 1);
        this.index = -100;
      }else{
        token = this.fileName.substring(this.index + 1, slashLocation);
        this.index = slashLocation;
      }
    }else{
      token = null;
    }
    return(token);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    FileNameTokenizer fnt = null;
    String token = null;
    int i = 0;

    Env.verifyAssertEnabled();
    System.out.println("Testing FileNameTokenizer");

    // Test 1
    fnt = new FileNameTokenizer("/a/b");
    token = fnt.getNextToken();
    i = 0;
    while(token != null){
      assert(((i == 0) && (token.equals(""))) ||
             ((i == 1) && (token.equals("a"))) ||
             ((i == 2) && (token.equals("b"))));
      i++;
      token = fnt.getNextToken();
    }

    // Test 2
    fnt = new FileNameTokenizer("/");
    token = fnt.getNextToken();
    assert(token.equals(""));
    token = fnt.getNextToken();
    assert(token.equals(""));
    token = fnt.getNextToken();
    assert(token == null);

    // Test 3
    fnt = new FileNameTokenizer("/*");
    token = fnt.getNextToken();
    assert(token.equals(""));
    token = fnt.getNextToken();
    assert(token.equals("*"));
    token = fnt.getNextToken();
    assert(token == null);

    // Test 4
    fnt = new FileNameTokenizer("/c/d/*");
    token = fnt.getNextToken();
    assert(token.equals(""));
    token = fnt.getNextToken();
    assert(token.equals("c"));
    token = fnt.getNextToken();
    assert(token.equals("d"));
    token = fnt.getNextToken();
    assert(token.equals("*"));
    token = fnt.getNextToken();
    assert(token == null);

    System.out.println("Test passed");
  }
}