package code;

 /** 
 *  GeneralInv: Interface shared by data structures representing inv messages 
 **/ 
import java.io.Serializable;

public interface GeneralInv extends Serializable, Cloneable
{
    public abstract InvalTarget
	getInvalTarget();

 /** 
 *  estimate memory size 
 **/ 
  public abstract long 
  memSize();
  
  public abstract AcceptVV
	getStartVV();
    // return the immutable AcceptVV, or if we are precise
    // generate an acceptVV wrapper around timestamp

    public abstract AcceptVV
	getEndVV();

    public abstract AcceptVV
      getRTVV();
    
    //
    // Note: No call for getCSN() or getVV() for a general
    // inval -- need to say whether you mean the start or end
    //

    public abstract Object
	clone();

    /*
      If we *know* that this object and all objects we reference
      are immutable, then just return this; otherwise perform
         newOne = super.clone(); // shallow copy
         now replace any fields in newOne that point to mutable 
             objects with a clone of that field
         return newOne
    */


    public abstract GeneralInv
	cloneIntersectInvaltargetChopStartEnd(GeneralInv inv);

    public abstract GeneralInv
	getOneWriterSubsetFrom(NodeId node, long startStampInclusive);
    /*
      return an invalidation (possibly this) with 
      interestSet = this.interestSet
      nodeId = node // assert node was in this.VV
      startVV{node} == startStampInclusive // assert this.startStamp{node} >= startSTampInclusive
      endVV{node} == this.endVV{node}
      (Note: OK to just return this if we meet all of the other criteria)
    */
    
    public abstract boolean
	isIncludedBy(VV vv);
    // return true if the entire invalidation is already accounted
    // for by the specified vv
    //if we are precise, return vv.includes(this.timestamp)
    //if we are imprecise, return vv.includes(this.*endVV*)

    public abstract boolean
	anyComponentIncludedBy(VV vv);
    // return true if any component of this invalidation is already
    // accounted for by the specified vv
    //if we are precise, return vv.includes(this.timestamp)
    //if we are imprecise, true if for any entry e in *startVV*, vv.includes(e.timestamp)

    public abstract boolean 
    isEmbargoed();
    public abstract boolean
	isCommitted();
    //return true if this invalidation is committed

    public abstract boolean
	isPrecise();

    public abstract boolean
	isBound();

    public abstract boolean
      isDelete();

    public GeneralInv newUnion(GeneralInv i, SubscriptionSet ss);
    /*
      create a new generalInv that is the union of this and i
      each element of startVV is min of corresponding
                      end        max
      interest set is union of corresponding
      assert(either both are uncommitted or both are committed)
      if both committed 
         assert no gap between csnEnd of one and csnStart of next (OK to overlap)
         csnstart = min of both csnStart
         csnEnd = max of both csnMax
    */

    public abstract int
	totalOrderCompare(GeneralInv gi2);

  public boolean
  equals(Object obj);
    /*
      return -1 if this < gi2 in the total order of the log
      return +1 if this > gi2 in the total order of the log
      return 0 if this and gi2 are equivalent and can be ordered either
        way (both start at the same time and end at the same time)

       we sort by CSN then by min acceptStamp then by serverId

      (1) CSN

          If this.CSN < gi2.CSN, then return -1
           
          Note that an unassigned CSN has an infinite value)

          For a bulk invalidation, consider the *minimum* CSN included
          in the invalidation.

          If this.CSN == gi2.CSN != CSN_UNASSIGNED, either order 
          is legal. If either is a bulk invalidation, the one with 
          the lower maxCSN goes first. If both have the same maxCSN
          then return 0

      (2) startTime acceptStamp
      
          assert this.CSN == gi2.CSN == CSN_UNASSIGNED

          if the invalidation is precise, consider its acceptStamp
          if the invalidation is imprecise, consider the startVV and
          look at the minimum entry across all nodeId's in startVV

          if they differ, return -1 or 1

      (3) nodeId
         if both minimum accept stamps in step (2) are equal, 
         then compare the node Ids

         if they differ, return -1 or 1

       (4) endtime acceptStamp

          assert csn, startTime, and nodeId are all the same

          send the "more precise" one first --> look at the endTime
          and the one with the smaller max endtime comes first

          if they differ, return -1 or 1
          if they are the same, return 0 (note that if the invals are
          imprecise, they may still differ in elements other than
          their max or min...but that's ok)
    */
}

//---------------------------------------------------------------------------
/* $Log: GeneralInv.java,v $
/* Revision 1.13  2006/04/20 03:52:53  zjiandan
/* Callbacks merged with runTime.
/*
/* Revision 1.12  2005/07/18 05:10:22  zjiandan
/* Embargoed Writes etc. features implementation plus
/* log overhead measurement with disk size and in-memory size.
/*
/* Revision 1.11  2005/02/28 22:59:12  nayate
/* Modified for new code
/*
/* Revision 1.10  2005/01/10 03:47:47  zjiandan
/* Fixed some bugs. Successfully run SanityCheck and Partial Replication experiments.
/*
/* Revision 1.9  2004/10/22 20:46:54  dahlin
/* Replaced TentativeState with RandomAccessState in DataStore; got rid of 'chain' in BodyMsg; all self-tests pass EXCEPT (1) get compile-time error in rmic and (2) ./runSDIMSControllerTest fails [related to (1)?]
/*
/* Revision 1.8  2004/08/18 22:44:43  dahlin
/* Made BoundInval subclass of PreciseInval; RandomAccessState passes 2 self tests
/*
/* Revision 1.7  2004/05/11 00:46:56  dahlin
/* Added read-miss-directory updates to SDIMSController
/*
/* Revision 1.6  2004/05/03 19:35:54  nayate
/* Started making changes to allow passing an interest set to all union
/* operations.
/*
/* Revision 1.5  2004/04/18 17:38:29  nayate
/* Added new method
/*
/* Revision 1.4  2004/04/18 04:31:27  nayate
/* Added new method cloneIntersectInvaltargetChopStartEndCSN
/*
/* Revision 1.3  2004/04/16 16:05:16  nayate
/* Subset of PreciseInv implemented + removed some compiler errors.
/*
/* Revision 1.2  2004/04/15 20:04:24  nayate
/* New Makefile; added provision to allow CVS to append file modification
/* logs to files.
/* */
//---------------------------------------------------------------------------
