package code;

import java.io.*;

public class HeartbeatInputStream extends InputStream{

    private static final int WAIT_FRAME_NUM = 100;
    
    private long lastReadTime;
    private int start;
    private InputStream _is;
    private long _elapse;
    private byte [] msg;
    private boolean isSenderDead;
    private ReadDaemon readDaemon;
    private boolean isActive;
    private IOException pendingException;

    public HeartbeatInputStream(InputStream is) throws IOException
    {
	_is = is;
	isSenderDead = false;
	isActive = false;
	lastReadTime = System.currentTimeMillis();
	pendingException = null;
	(new ReadDaemon(_is)).start();
    }

    public int available()throws IOException{
	Env.printDebug("available()");
	return _is.available();
    }

    public void close()throws IOException{
	_is.close();
	Env.printDebug("close()");
    }

    public void mark(int limit){
	_is.mark(limit);
	Env.printDebug("mark()");
    }
    
    public boolean markSupported(){
	Env.printDebug("markSuported()");
	return _is.markSupported();
    }

    public void reset()throws IOException{
	_is.reset();
	Env.printDebug("reset()");
    }

    public long skip(long i)throws IOException{
	assert(false); // MDD -- this code appears to be incorrect --
                       // if msg != null, skip should start there
	Env.printDebug("skip()");
	return _is.skip(i);
    }

    public int read()throws IOException{
//	Env.printDebug("read()");
	byte[] b = new byte[1];
	hbRead(b, 0, 1);
	return b[0];
    }
    
    public int read(byte[] b)throws IOException{
	Env.printDebug("read(byte[])");
	return hbRead(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException{
//	Env.printDebug("read(byte[], int, int"+off+ "  " + len);
	return hbRead(b, off, len);
    }

    private synchronized int hbRead(byte [] b, int off, int len) throws IOException{
	int length = -1;
	try{
	    while((pendingException == null) && (msg == null) && (System.currentTimeMillis() - lastReadTime < HeartbeatSocket.HB_INTERVAL_MS*WAIT_FRAME_NUM)){
		wait(HeartbeatSocket.HB_INTERVAL_MS*3);
	    }
	    if(pendingException != null){
		//
		// Code should maintain order of underlying
		// stream. Do this by having producer block
		// until both pendingException and msg are null
		//
		assert(msg == null); 
		IOException e = pendingException;
		pendingException = null;
		notifyAll();
		// System.err.println(" -- Rethrowing exception " + e);
		throw e;
	    }
	    else if(msg == null){ // no msg read after the expected elapse of time
		isSenderDead = true;
		notifyAll();
		_is.close();
		// System.err.println(" -- Rethrowing exception " + pendingException);
		throw new IOException("The sender is unreachable !");
	    } else {
		assert(msg != null && pendingException == null);
		length = Math.min(len, msg.length-start);
		for(int i=0; i<length; i++){
		    b[off+i] = msg[start+i];
		}
		start += length;
		if(start >= msg.length){
		    msg = null;
		    notifyAll();
		}
	    }
	    assert(msg == null || start <= msg.length);
//	    throw new InterruptedException();
	}catch (InterruptedException e){
	    e.printStackTrace();
	    System.exit(-1);
	}
	return length;
    }

    private synchronized void gotHB(){
	lastReadTime = System.currentTimeMillis();
    }

    private synchronized void gotMsgOrException(HBFrame f, IOException e) 
	throws HISException, InterruptedException
    {
	//
	// Maintain order between exceptions and reads
	// by only allowing one of them to be non-null
	//
	assert(f == null || e == null);

	lastReadTime = System.currentTimeMillis();
	while(((pendingException != null) || (msg!=null))
	      &&(!isSenderDead)){
	    wait();
	}
	if(isSenderDead){
	    try{
		_is.close();
	    }
	    catch(IOException zz){
		// ignore error on close
	    }
	    throw new HISException("The sender is unreachable !");
	}
	if(f != null){
	    msg = f.getData();
	    start = 0;
	}
	else{
	    assert(e != null);
	    pendingException = e;
	}
	notifyAll();
    }

    class ReadDaemon extends Thread{
	private ObjectInputStream ois;
	
	public ReadDaemon(InputStream is) throws IOException{
	    ois = new ObjectInputStream(is);
	}
	
	public void run(){
	    try{
		while(true){
		    try{
			Object o = ois.readObject();		    
			if (o instanceof HBFrame){
			    gotMsgOrException((HBFrame)o, null);
			} else if (o instanceof HBObj){
			    gotHB();
			} else {
			    Env.printDebug("Wrong object type!");
			    Env.remoteAssert(false);
			}
		    } catch (IOException e){
			//
			// IO Exceptions are a normal part of underlying
			// stream and should be relayed up
			//
			gotMsgOrException(null, e);
		    } catch (InterruptedException ie){
			// Ignore and retry
		    }
		}
	    } catch (ClassNotFoundException cnfe){
		//
		// Other exceptions are fatal to this stream.
		// Stop processing and it will time out...
		//
		Env.remoteAssert(false);
		cnfe.printStackTrace();
	    }catch (HISException h){
		// Heartbeat timeout. Stop work and return.
	    }catch (Exception e){
		Env.remoteAssert(false);
		e.printStackTrace();
	    }
	}
    }
}


class HISException extends Exception
{
public HISException(String msg){
    super(msg);
}
public HISException(){
    super();
}
}


/*$Log: HeartbeatInputStream.java,v $
/*Revision 1.10  2006/08/15 21:46:23  dahlin
/*Added PicShare Reader and a simple unit test.
/*
/*Revision 1.9  2004/05/26 19:16:09  lgao
/**** empty log message ***
/*
/*Revision 1.8  2004/05/26 18:32:38  lgao
/*Increase waiting time to 10.
/*
/*Revision 1.7  2004/05/26 09:45:55  arun
/**** empty log message ***
/*
/*Revision 1.6  2004/05/26 04:42:22  arun
/**** empty log message ***
/*
/*Revision 1.5  2004/05/20 04:10:57  dahlin
/*Passes SDIMSController spanning tree self test
/*
/*Revision 1.4  2004/05/20 01:49:55  nayate
/*Changed "System.out.println" to "Env.printDebug"
/*
/*Revision 1.3  2004/05/11 23:45:44  nayate
/*Made the interface to HeartbeatSocket match that of Socket, and changed
/*classes to use HeartbeatSockets.
/*
/*Revision 1.2  2004/05/11 23:20:04  lgao
/**** empty log message ***
/*
/*Revision 1.1  2004/05/09 03:37:12  lgao
/*Initial version.
/**/
