package code;

import java.io.*;

public class HeartbeatOutputStream extends OutputStream{

    private ObjectOutputStream oos;

    public HeartbeatOutputStream(OutputStream os) throws IOException
    {
	oos = new ObjectOutputStream(os);
	(new HBDaemon(oos, HeartbeatSocket.HB_INTERVAL_MS)).start();
    }

    public void write(int b)throws IOException{
	byte [] tmp = new byte[1];
	tmp[0] = (byte)b;
	hbWrite(tmp, 0, 1);
    }
    
    public void write(byte[] b)throws IOException{
	hbWrite(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len)throws IOException{
	hbWrite(b, off, len);
    }

    private synchronized int hbWrite(byte [] b, int off, int len) throws IOException{
	int totalLen = 0;
	int start = off;
	while(off + len - start > 0){
	    int length = Math.min(off+len-start,
				  HeartbeatSocket.HB_FRAME_BYTES);
	    Object msg = new HBFrame(b, start, length);
	    writeHBMsg(msg);
	    start = start + length;
	    totalLen += length;
	}
	return totalLen;
    }
    
    private synchronized void writeHBMsg(Object o) throws IOException{
	oos.writeObject(o);
    }
    
    private void validateData(byte[] b){
	if(b[0] == (short)113 && b[1] == (short)0 && b[2] == (short)126 && b[3] == (short)0 && b[4] == (short)2){
	    Env.performanceWarning("ObjectOutputStream may have disregard changes to array elements !");
	}
    }

    class HBDaemon extends Thread{
	private ObjectOutputStream oos;
	private long _timeout;
	public HBDaemon(ObjectOutputStream outs, long timeout){
	    oos = outs;
	    _timeout = timeout;
	}

	public void run(){
	    while(true){
		try{
		    writeHBMsg(new HBObj());
		    sleep(_timeout);
		} catch (InterruptedException ie){
		    Env.printDebug("Unexpected interruption occurs!  An hearbeat is sent eariler than scheduled.");
		    continue;
		} catch (Exception e){
		    break;
		}
	    }
	}
    }
}

/*$Log: HeartbeatOutputStream.java,v $
/*Revision 1.8  2004/05/19 21:38:48  lgao
/**** empty log message ***
/*
/*Revision 1.7  2004/05/19 20:58:10  lgao
/*Add a debug option to hearbeat thread to print debugging info.
/*
/*Revision 1.6  2004/05/18 06:25:27  lgao
/*Initial implementation of the ConstrainedOutputStream.
/*Note: the bandwidth parameter, BW, in ufs.config limits the network output rate of the file system if ConstrainedOutputStream is used for sending data.
/*
/*Revision 1.5  2004/05/11 23:45:44  nayate
/*Made the interface to HeartbeatSocket match that of Socket, and changed
/*classes to use HeartbeatSockets.
/*
/*Revision 1.4  2004/05/11 23:20:04  lgao
/**** empty log message ***
/*
/*Revision 1.3  2004/05/11 21:46:38  lgao
/*Implementation of TaggedOutputStream which counts bytes sent over the wire.
/*
/*Revision 1.2  2004/05/09 04:26:44  lgao
/**** empty log message ***
/*
/*Revision 1.1  2004/05/09 03:37:12  lgao
/*Initial version.
/**/
