package code;

import java.net.*;
import java.io.*;
import java.util.*;


public class HeartbeatServerSocket extends ServerSocket{

    public static final int HeartbeatInterval = 5000; // 20 seconds

    public HeartbeatServerSocket(int port) throws IOException{
	super(port);
    }

    public Socket accept () throws IOException{
	HeartbeatSocket hbSocket = new HeartbeatSocket();
	implAccept(hbSocket);
	return hbSocket;
    }

    public static void main(String [] argv){
	
	if(argv.length < 1){
	    Env.printDebug("Usage: [client][port] or [server]");
	}
	Random r = new Random();
	int count = 0;
	try{
	    if(argv[0].equals("client")){
		HeartbeatSocket send = new HeartbeatSocket(argv[1], 5566);
		OutputStream hbos = send.getOutputStream();
		TaggedOutputStream tos = new TaggedOutputStream(hbos);
		IntArray ia = new IntArray();
		while(true){
/*		    int len = Math.abs(r.nextInt()) % 20;
		    byte [] b = new byte[len];
		    Env.printDebug("Written " + len + " bytes.");
		    
		    int value = Math.abs(r.nextInt()) % 26;
		    byte count = 'a';
		    count += value;
		    fillData(b, count);
		    Env.printDebug("Write value: " + new String(b));
*/
		    Hashtable h = new Hashtable();
		    Object o = fillData(h, r);
		    h.put(o, o);
		    //int j = Math.abs(r.nextInt()%3);
		    ((IntArray)ia).i[0] = Math.abs(r.nextInt()%10);
		    tos.writeObject(o);
		    Env.printDebug("" + Stats.createRecord());
		    Env.printDebug("Values to be written: " + o);
		    int wait = Math.abs(r.nextInt()) % (HeartbeatInterval*5);
		    if(wait <= (int)HeartbeatInterval*3){
			wait = 0;
		    }
		    Env.printDebug("Wait for " + wait + " for next send");
		    Thread.sleep(wait);
		    count ++;
		    if(count == 10000){
			System.exit(-1);
		    }
		}
		
	    } else {
		HeartbeatServerSocket ss = new HeartbeatServerSocket(5566);
		HeartbeatSocket recv = (HeartbeatSocket) ss.accept();
		InputStream hbis = recv.getInputStream();
		ObjectInputStream ois = new ObjectInputStream(hbis);
		int read_size = -1;
		while(true){
//		    Hashtable s = (Hashtable)ois.readObject();
		    Object s = ois.readObject();
		    Env.printDebug("" + s);
		}
	    }
	} catch (Exception e){
	    e.printStackTrace();
	}
    }
    
    public static Object fillData(Hashtable h, Random r){
	String s = "XXXXXXXXXXXXXXXXXXXXXXXXX"; // 26 chars
	Object o = null;
	int n = Math.abs(r.nextInt()) % 20;
	for(int i=0; i<1;/*n*/ i++){
	    int l = (Math.abs(r.nextInt()) % 6);
	    Env.printDebug("" + l);
	    switch(l){
	    case 0:
		o = new Date();
		break;
	    case 1:
		int index = Math.abs(r.nextInt()) % 25;
		o = s.substring(index);
		break;
	    case 3:
		o = new Integer(r.nextInt());
		break;
	    case 2:
		o = new Double(r.nextDouble());
		break;
	    case 4:
		o = new CharArray();
		int k = Math.abs(r.nextInt()%3);
		((CharArray)o).c[k] = 'x';
		break;
	    case 5:
		o = new IntArray();
		int j = Math.abs(r.nextInt()%3);
		((IntArray)o).i[j] = 9;
		break;
	    }
	    h.put(o,o);
	}
	
//	Env.printDebug("Data to be written: ");
//	Env.printDebug(h);
	
	return o;
    }
    
}


class CharArray implements Serializable{
    public char[] c = {'a', 'b', 'c'};
    public String toString(){
	return new String(c);
    }
}

class IntArray implements Serializable{
    public int[] i = {1, 2, 2};
    public String toString(){
	String s = Integer.toString(i[0]);
	s = s.concat(Integer.toString(i[1]));
	s = s.concat(Integer.toString(i[2]));
	return s;
    }
}



/*$Log: HeartbeatServerSocket.java,v $
/*Revision 1.9  2004/05/20 01:50:25  nayate
/*Replaced "System.out.println" with "Env.printDebug"
/*
/*Revision 1.8  2004/05/19 20:43:11  lgao
/*Add StatsRecord class to maintain stats
/*
/*Revision 1.7  2004/05/11 23:45:44  nayate
/*Made the interface to HeartbeatSocket match that of Socket, and changed
/*classes to use HeartbeatSockets.
/*
/*Revision 1.6  2004/05/11 23:20:04  lgao
/**** empty log message ***
/*
/*Revision 1.5  2004/05/11 22:19:14  lgao
/*Override the getInputStream and getOutputStream of the socket class.
/*
/*Revision 1.4  2004/05/11 21:46:38  lgao
/*Implementation of TaggedOutputStream which counts bytes sent over the wire.
/*
/*Revision 1.3  2004/05/10 21:17:38  lgao
/*Initial implementation
/*
/*Revision 1.2  2004/05/10 21:00:22  lgao
/*Just to make things compile.
/*
/*Revision 1.1  2004/05/09 03:37:12  lgao
/*Initial version.
/**/
