package code;

import java.net.*;
import java.io.*;

public class HeartbeatSocket extends Socket{

    public static long HB_INTERVAL_MS = 20000;  // 20 seconds
    public static int HB_FRAME_BYTES = 100000; // ~100 KB

    public HeartbeatSocket(String host, int port) 
	throws UnknownHostException, IOException{
	super(host, port);
    }

    public HeartbeatSocket()
	throws UnknownHostException, IOException{
	super();
    }
    
    public InputStream getInputStream() throws IOException{
	return new HeartbeatInputStream(super.getInputStream());
    }

    public OutputStream getOutputStream()throws IOException{
	return new HeartbeatOutputStream(super.getOutputStream());
    }

}

/*$Log: HeartbeatSocket.java,v $
/*Revision 1.3  2004/05/11 23:45:44  nayate
/*Made the interface to HeartbeatSocket match that of Socket, and changed
/*classes to use HeartbeatSockets.
/*
/*Revision 1.2  2004/05/11 22:19:14  lgao
/*Override the getInputStream and getOutputStream of the socket class.
/*
/*Revision 1.1  2004/05/09 03:37:12  lgao
/*Initial version.
/**/
