package code;

 /** 
 *  Maintains information - lpvv, cvv etc. - for interest sets. 
 *  
 *  (C) Copyright -- See the file COPYRIGHT for additional details 
 **/ 

import java.util.*;
import java.io.IOException;
import java.io.Serializable;

public class ISStatus implements Serializable{
    
 /** 
 *  Data members 
 **/ 
  private AllPreciseSets allPS;
  private InterestRegion interestRegion;


 /** 
 *  Constructor 
 **/ 
  public
  ISStatus(AllPreciseSets newAllPS,
           InterestRegion newInterestRegion){
    this.allPS = newAllPS;
    this.interestRegion = newInterestRegion;
  }

 /** 
 *      add connection pointer to the corresponding place in ISStatus tree 
 **/ 
  public void addConnection(SubscriptionSet ss,
                            ConnectionState ic){
    this.allPS.addConnection(ss, ic);
  }

 /** 
 *   remove connection pointer from the corresponding place in ISStatus tree 
 **/ 
  public void removeConnection(SubscriptionSet ss,
                               ConnectionState ic,
                               VV newLpvv){
    this.allPS.removeConnection(ss, ic, newLpvv);
  }

 /** 
 *  update all corresponding PTreeNode's lpvv <pathName, lpvv>* 
 **/ 
  public void updateLpVV(Vector lpvvRecs){
    this.allPS.updateLpVV(lpvvRecs);
  }

 /** 
 *  return pairs of (pathName, matching lpvv)  
 **/ 
  public Vector getMatchingLpvvs(SubscriptionSet ss, AcceptVV startVV){
    return this.allPS.getMatchingLpvvs(ss, startVV);
  }

 /** 
 *  Get the component-wise minimum LpVV of the LpVVs of all 
 *  PreciseSets that overlap this SubscriptionSet 
 *  NOTE: Mostly copied from getMinLpVV(String, String[]); 
 **/ 
  public AcceptVV
  getMinLpVV(SubscriptionSet ss){
    return allPS.getMinLpVV(ss);
  }
  
 /** 
 *  Get the minimum LpVV from the PreciseSets in which we are 
 *  interested. 
 **/ 
  public AcceptVV
  getInterestedMinLpVV(){

    return this.getMinLpVV(this.interestRegion.makeSubscriptionSet());
  }
 
 /** 
 *  Get the lpvv for an object 
 *  i.e. the component-wise max of (lpvv, con.prevv) 
 **/ 
  public AcceptVV
  getLpVV(String psPath){
    return allPS.getLpVV(psPath);
  }

 /** 
 *  Return true if the object with this object ID lies anywhere 
 *  under ss 
 **/ 
  static public boolean
  liesAnywhereUnder(SubscriptionSet ss, ObjId oid){
    SubscriptionSet inter = null;
    inter = ss.getIntersection(SubscriptionSet.makeSubscriptionSet(oid.getPath()));
    return !(inter.isEmpty());
  }

 /** 
 *  Return true if the object with this object ID lies anywhere 
 *  under ss 
 **/ 
  static public boolean
  liesAnywhereUnder(String ssPath, ObjId oid){
    SubscriptionSet ss = SubscriptionSet.makeSubscriptionSet(ssPath);
    
    return ISStatus.liesAnywhereUnder(ss, oid);
  }

  public String
  toString(){
    return allPS.toString();
  }

 /** 
 *  Split off a PreciseSet from a given pathName matching Node 
 **/ 
  public void
  split(String pathName, String newName)
  throws NoMatchPreciseSetException{
    allPS.split(pathName, newName);
  }

 /** 
 *  join all this.children, remove this.children, update this.other.lpvv 
 **/ 
  public boolean
  join(String pathName){
    return allPS.join(pathName);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    //moved to ISStatusUnit.java
  }
}

//---------------------------------------------------------------------------
/* $Log: ISStatus.java,v $
/* Revision 1.45  2007/07/11 19:08:07  zjiandan
/* clean IncommingConnection
/*
/* Revision 1.44  2007/06/29 01:01:41  zjiandan
/* *** empty log message ***
/*
/* Revision 1.43  2007/06/04 16:47:50  zjiandan
/* Clean and move ISStatus unit tests to ISStatusUnit
/*
/* Revision 1.42  2007/05/31 06:02:01  zjiandan
/* add AllPreciseSetsUnit
/*
/* Revision 1.41  2006/08/25 20:31:45  dahlin
/* Added serialization to PreciseSets (plan is to use serialization rather than 
/* sync() for persistence). Moved PreciseSet unit tests to junit (PreciseSetUnit)
/*
/* Revision 1.40  2006/08/22 16:13:14  dahlin
/* Who commented out ISStatus tests?
/*
/* Revision 1.39  2006/04/20 03:52:53  zjiandan
/* Callbacks merged with runTime.
/**/
//---------------------------------------------------------------------------
