package code;
 /** 
 *  Unit test for ISStatusUnit
 
 **/ 

import junit.textui.TestRunner;
import junit.framework.*;
import java.util.*;
import java.io.*;

/**
 * TBD: Update class name
 */
public class ISStatusUnit extends TestCase {
  public static final String TEST_ALL_TEST_TYPE = "UNIT";
  protected static boolean verbose = false; // Start/end of test
  protected static boolean vverbose = false; // Test internals
  // private Process rmiregistry;
  
  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public ISStatusUnit (final String s) {
    super (s);
  }


  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
    /*
    //
    // Start the registry
    //
    rmiregistry = Runtime.getRuntime().exec("rmiregistry");
    Env.dprintln(verbose, "rmiregistry started");
    Thread.sleep(2000);
    */
  }

  protected void tearDown() throws Exception{
    /*
    rmiregistry.destroy();
    */
    super.tearDown();
    
  }



 /** 
 *  Test basic functions
 
 **/ 
  public void testSimple(){
    Env.verifyAssertEnabled();
    if(verbose){
      System.out.println("Testing ISStatus...");
    }
    
    makePractiConfig();
    SubscriptionSet ss1 = SubscriptionSet.makeSubscriptionSet("/*");
    assert (ISStatus.liesAnywhereUnder(ss1, new ObjId("/a/a/a/a/a/a")));
    ss1 = SubscriptionSet.makeSubscriptionSet("/a/b/c/d:/b/e/*");
    assert (!ISStatus.liesAnywhereUnder(ss1, new ObjId("/a/a/a/a/a/a")));
    assert (ISStatus.liesAnywhereUnder(ss1, new ObjId("/a/b/c/d")));
    assert (ISStatus.liesAnywhereUnder(ss1, new ObjId("/b/e/c/d")));
    
    PreciseSet ps1 = null;
    AllPreciseSets aps1 = null;
    ISStatus iss1 = null;
    AcceptStamp[] as1 = null;
    CounterVV cVV1 = null;
    String[] exclChildNames1 = null;
    String[] exclChildNames2 = null;
    CounterVV dummyVV = CounterVV.makeVVAllNegatives();
    // Test ISStatus.liesAnywhereUnder()
    ps1 = new PreciseSet("", "", dummyVV, dummyVV);
    as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(10, new NodeId(100));
    as1[1] = new AcceptStamp(20, new NodeId(2000));

    aps1 = new AllPreciseSets(ps1);
    iss1 = new ISStatus(aps1,
                        new InterestRegion());
                            
    assert(iss1.liesAnywhereUnder("/apple", new ObjId("/apple")));
    assert(iss1.liesAnywhereUnder("/a/b/c/*", new ObjId("/a/b/c/d")));
    assert(!iss1.liesAnywhereUnder("/a/b", new ObjId("/a")));
    assert(!iss1.liesAnywhereUnder("/a/b", new ObjId("/a/c")));
    
    assert(!iss1.liesAnywhereUnder("/a",
                                   new ObjId("/a/b")));
    assert(!iss1.liesAnywhereUnder("/a",
                                   new ObjId("/a/a/c")));
    assert(iss1.liesAnywhereUnder("/a/m/*",
                                  new ObjId("/a/m/c")));
    assert(iss1.liesAnywhereUnder("/a/m/*",
                                  new ObjId("/a/m/d")));
    assert(!iss1.liesAnywhereUnder("/a/m/",
                                   new ObjId("/a/m/a")));
  }

  public void testGetInterestedMinLpVV(){
    InterestRegion ir1 = null;
    ISStatus iss1 = null;
    PreciseSet ps1 = null;
    PreciseSet ps2 = null;
    PreciseSet ps3 = null;
    PreciseSet ps4 = null;
    PreciseSet ps5 = null;
    AllPreciseSets aps1 = null;
    CounterVV lpVV1 = null;
    CounterVV dummyVV = null;
    AcceptStamp[] as1 = null;
    AcceptStamp[] as2 = null;
    AcceptStamp[] as3 = null;
    AcceptStamp[] as4 = null;
    AcceptStamp[] as5 = null;

    // Test 1
    // (1) Make aps1 and ir1 have the same structure
    // (2) Make sure that we get the lpVV "/a/b" from the call
    dummyVV = CounterVV.makeVVAllNegatives();
    as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(50, new NodeId(200));
    as1[1] = new AcceptStamp(150, new NodeId(400));
    lpVV1 = new CounterVV(as1);

    ir1 = new InterestRegion("/a/b/*");
    ps1 = new PreciseSet("", "", dummyVV, dummyVV);
    ir1.makeMirrorPS(ps1);
    aps1 = new AllPreciseSets(ps1);
    iss1 = new ISStatus(aps1,
                        ir1);
    ps2 = ps1.getChild("a");
    assert(ps2 != null);
    ps3 = ps2.getChild("b");
    assert(ps3 != null);
    
    iss1.removeConnection(SubscriptionSet.makeSubscriptionSet("/a/b/*"), null, lpVV1);
    assert(iss1.getInterestedMinLpVV().equalsIgnoreNegatives(lpVV1))
      : "expected: " + lpVV1 + " got:" + iss1.getInterestedMinLpVV();
    
    // Test 2
    // (1) Make aps1 have the structure "/a/b/c:/a/b/d"
    // (2) Make ir1 have the structure "/a/b/*"
    // (3) Set the lpVV for "/a" to [(10, "100"), (10, "200"), (10, "300")]
    //     Set the lpVV for "/a".other to the same as well
    //     (we need set the "other" lpvv because the original design
    //      is exlusive. The tree only have a, b, c, d nodes.
    //      /a/b/* will only check /a/b:/a/b/c:/a/b/d.
    //     
    //      the new design every node has "other" lpvv
    //      /a/b/* will include those lpvv as well.
    // (4) Set the lpVV for "/a/b" to [(20, "100"), (30, "200"), (40, "300")]
    // (5) Set the lpVV for "/a/b/c" to [(40, "100"), (20, "200"), (30, "300")]
    // (6) Set the lpVV for "/a/b/d" to [(30, "100"), (40, "200"), (20, "300")]
    // (7) Make sure that we get [(20, "100"), (20, "200"), (20, "300")] as
    //     the lpVV - i.e., the lpVV should be the min of the lpVVs of "/a/b",
    //     "/a/b/c", and "/a/b/d", and should not include "/a"
    ir1 = new InterestRegion("/a/b/*");
    ps1 = new PreciseSet("", "", dummyVV, dummyVV);
    ps2 = ps1.split("a"); // "/a"
    ps3 = ps2.split("b"); // "/a/b"
    ps4 = ps3.split("c"); // "/a/b/c"
    ps5 = ps3.split("d"); // "/a/b/d"
    aps1 = new AllPreciseSets(ps1);
    iss1 = new ISStatus(aps1,
                        ir1);
                        
    as1 = new AcceptStamp[3];
    as1[0] = new AcceptStamp(10, new NodeId(100));
    as1[1] = new AcceptStamp(10, new NodeId(200));
    as1[2] = new AcceptStamp(10, new NodeId(300));
    
    //ps2.getISR().setLastPreciseVV(new CounterVV(as1));
    iss1.removeConnection(SubscriptionSet.makeSubscriptionSet("/a"),
			  null,
			  new CounterVV(as1));
    ps2.updateOtherChildrenLpVV(new CounterVV(as1));

    as2 = new AcceptStamp[3];
    as2[0] = new AcceptStamp(20, new NodeId(100));
    as2[1] = new AcceptStamp(30, new NodeId(200));
    as2[2] = new AcceptStamp(40, new NodeId(300));
    //ps3.getISR().setLastPreciseVV(new CounterVV(as2));
    iss1.removeConnection(SubscriptionSet.makeSubscriptionSet("/a/b"),
			  null,
			  new CounterVV(as2));
    ps3.updateOtherChildrenLpVV(new CounterVV(as2));

    as3 = new AcceptStamp[3];
    as3[0] = new AcceptStamp(40, new NodeId(100));
    as3[1] = new AcceptStamp(20, new NodeId(200));
    as3[2] = new AcceptStamp(30, new NodeId(300));
    //ps4.getISR().setLastPreciseVV(new CounterVV(as3));
    iss1.removeConnection(SubscriptionSet.makeSubscriptionSet("/a/b/c"),
			  null,
			  new CounterVV(as3));
    ps4.updateOtherChildrenLpVV(new CounterVV(as3));

    as4 = new AcceptStamp[3];
    as4[0] = new AcceptStamp(30, new NodeId(100));
    as4[1] = new AcceptStamp(40, new NodeId(200));
    as4[2] = new AcceptStamp(20, new NodeId(300));
    //ps5.getISR().setLastPreciseVV(new CounterVV(as4));
    iss1.removeConnection(SubscriptionSet.makeSubscriptionSet("/a/b/d"),
			  null,
			  new CounterVV(as4));
    ps5.updateOtherChildrenLpVV(new CounterVV(as4));

    as5 = new AcceptStamp[3];
    as5[0] = new AcceptStamp(20, new NodeId(100));
    as5[1] = new AcceptStamp(20, new NodeId(200));
    as5[2] = new AcceptStamp(20, new NodeId(300));
    lpVV1 = new CounterVV(as5);
    assert(iss1.getInterestedMinLpVV().equalsIgnoreNegatives(lpVV1));

    // Test 3
    // (1) Make aps1 have the structure "/a/b:/a/d"
    // (2) Make ir1 have the structure "/a/b/c*"
    // (3) Set the lpVV for "/a" to [(10, "100"), (10, "200"), (10, "300")]
    // (4) Set the lpVV for "/a/b" to [(20, "100"), (30, "200"), (40, "300")]
    // (5) Set the lpVV for "/a/d" to [(30, "100"), (40, "200"), (20, "300")]
    // (6) Make sure that we get [(20, "100"), (30, "200"), (40, "300")] as
    //     the lpVV - i.e., the lpVV should be the lpVV of "/a/b" and should
    //     not include "/a"
    ir1 = new InterestRegion("/a/b/c/*");
    ps1 = new PreciseSet("", "", dummyVV, dummyVV);
    ps2 = ps1.split("a");
    ps3 = ps2.split("b");
    ps4 = ps2.split("d");
    aps1 = new AllPreciseSets(ps1);
    iss1 = new ISStatus(aps1,
                        ir1);
    as1 = new AcceptStamp[3];
    as1[0] = new AcceptStamp(10, new NodeId(100));
    as1[1] = new AcceptStamp(10, new NodeId(200));
    as1[2] = new AcceptStamp(10, new NodeId(300));
    //ps2.getISR().setLastPreciseVV(new CounterVV(as1));
    iss1.removeConnection(SubscriptionSet.makeSubscriptionSet("/a"),
			  null,
			  new CounterVV(as1));
    ps2.updateOtherChildrenLpVV(new CounterVV(as1));

    as2 = new AcceptStamp[3];
    as2[0] = new AcceptStamp(20, new NodeId(100));
    as2[1] = new AcceptStamp(30, new NodeId(200));
    as2[2] = new AcceptStamp(40, new NodeId(300));
    //ps3.getISR().setLastPreciseVV(new CounterVV(as2));
    iss1.removeConnection(SubscriptionSet.makeSubscriptionSet("/a/b"),
			  null,
			  new CounterVV(as2));
    ps3.updateOtherChildrenLpVV(new CounterVV(as2));

    as3 = new AcceptStamp[3];
    as3[0] = new AcceptStamp(30, new NodeId(100));
    as3[1] = new AcceptStamp(40, new NodeId(200));
    as3[2] = new AcceptStamp(20, new NodeId(300));
    //ps4.getISR().setLastPreciseVV(new CounterVV(as3));
    iss1.removeConnection(SubscriptionSet.makeSubscriptionSet("/a/d"),
			  null,
			  new CounterVV(as3));
    ps4.updateOtherChildrenLpVV(new CounterVV(as3));

    as5 = new AcceptStamp[3];
    as5[0] = new AcceptStamp(20, new NodeId(100));
    as5[1] = new AcceptStamp(30, new NodeId(200));
    as5[2] = new AcceptStamp(40, new NodeId(300));
    lpVV1 = new CounterVV(as5);
    assert(iss1.getInterestedMinLpVV().equalsIgnoreNegatives(lpVV1));

    // Test 4
    // (1) Make aps1 have the structure "/a/b:/a/d"
    // (2) Make ir1 have the structure "/a/c*"
    // (3) Set the lpVV for "/a" to [(20, "100"), (30, "200"), (40, "300")]
    // (4) Set the lpVV for "/a/b" to [(40, "100"), (20, "200"), (30, "300")]
    // (5) Set the lpVV for "/a/d" to [(30, "100"), (40, "200"), (20, "300")]
    // (6) Make sure that we get [(20, "100"), (30, "200"), (40, "300")] as
    //     the lpVV - i.e., the lpVV should be the lpVV of "/a"
    ir1 = new InterestRegion("/a/c/*");
    ps1 = new PreciseSet("", "", dummyVV, dummyVV);
    ps2 = ps1.split("a");
    ps3 = ps2.split("b");
    ps4 = ps2.split("d");
    aps1 = new AllPreciseSets(ps1);
    iss1 = new ISStatus(aps1,
                        ir1);

    as1 = new AcceptStamp[3];
    as1[0] = new AcceptStamp(20, new NodeId(100));
    as1[1] = new AcceptStamp(30, new NodeId(200));
    as1[2] = new AcceptStamp(40, new NodeId(300));
    //ps2.getISR().setLastPreciseVV(new CounterVV(as1));
    iss1.removeConnection(SubscriptionSet.makeSubscriptionSet("/a"),
			  null,
			  new CounterVV(as1));
    ps2.updateOtherChildrenLpVV(new CounterVV(as1));
    
    as2 = new AcceptStamp[3];
    as2[0] = new AcceptStamp(40, new NodeId(100));
    as2[1] = new AcceptStamp(20, new NodeId(200));
    as2[2] = new AcceptStamp(30, new NodeId(300));
    //ps3.getISR().setLastPreciseVV(new CounterVV(as2));
    iss1.removeConnection(SubscriptionSet.makeSubscriptionSet("/a/b"),
			  null,
			  new CounterVV(as2));
    ps3.updateOtherChildrenLpVV(new CounterVV(as2));

    as3 = new AcceptStamp[3];
    as3[0] = new AcceptStamp(30, new NodeId(100));
    as3[1] = new AcceptStamp(40, new NodeId(200));
    as3[2] = new AcceptStamp(20, new NodeId(300));
    //ps4.getISR().setLastPreciseVV(new CounterVV(as3));
    iss1.removeConnection(SubscriptionSet.makeSubscriptionSet("/a/d"),
			  null,
			  new CounterVV(as3));
    ps4.updateOtherChildrenLpVV(new CounterVV(as3));

    as5 = new AcceptStamp[3];
    as5[0] = new AcceptStamp(20, new NodeId(100));
    as5[1] = new AcceptStamp(30, new NodeId(200));
    as5[2] = new AcceptStamp(40, new NodeId(300));
    lpVV1 = new CounterVV(as5);
    assert(iss1.getInterestedMinLpVV().equalsIgnoreNegatives(lpVV1));

    // Test 5
    // (1) Make aps1 have the structure "/a/b:/a/b/c"
    // (2) Make ir1 have the structure "/a/b"
    // (3) Set the lpVV for "/a" to [(10, "100"), (10, "200"), (10, "300")]
    // (4) Set the lpVV for "/a/b" to [(40, "100"), (20, "200"), (30, "300")]
    // (5) Set the lpVV for "/a/b/c" to [(10, "100"), (10, "200"), (10, "300")]
    // (6) Make sure that we get [(40, "100"), (20, "200"), (30, "300")] as
    //     the lpVV - i.e., the lpVV should be the lpVV of "/a/b"
    ir1 = new InterestRegion("/a/b");
    ps1 = new PreciseSet("", "", dummyVV, dummyVV);
    ps2 = ps1.split("a");
    ps3 = ps2.split("b");
    ps4 = ps3.split("c");
    aps1 = new AllPreciseSets(ps1);
    iss1 = new ISStatus(aps1,
                        ir1);
    as1 = new AcceptStamp[3];
    as1[0] = new AcceptStamp(10, new NodeId(100));
    as1[1] = new AcceptStamp(10, new NodeId(200));
    as1[2] = new AcceptStamp(10, new NodeId(300));
    //ps2.getISR().setLastPreciseVV(new CounterVV(as1));
    iss1.removeConnection(SubscriptionSet.makeSubscriptionSet("/a"),
			  null,
			  new CounterVV(as1));
    
    as2 = new AcceptStamp[3];
    as2[0] = new AcceptStamp(40, new NodeId(100));
    as2[1] = new AcceptStamp(20, new NodeId(200));
    as2[2] = new AcceptStamp(30, new NodeId(300));
    //ps3.getISR().setLastPreciseVV(new CounterVV(as2));
    iss1.removeConnection(SubscriptionSet.makeSubscriptionSet("/a/b"),
			  null,
			  new CounterVV(as2));

    as3 = new AcceptStamp[3];
    as3[0] = new AcceptStamp(10, new NodeId(100));
    as3[1] = new AcceptStamp(10, new NodeId(200));
    as3[2] = new AcceptStamp(10, new NodeId(300));
    //ps4.getISR().setLastPreciseVV(new CounterVV(as3));
    iss1.removeConnection(SubscriptionSet.makeSubscriptionSet("/a/b/c"),
			  null,
			  new CounterVV(as3));

    as5 = new AcceptStamp[3];
    as5[0] = new AcceptStamp(40, new NodeId(100));
    as5[1] = new AcceptStamp(20, new NodeId(200));
    as5[2] = new AcceptStamp(30, new NodeId(300));
    lpVV1 = new CounterVV(as5);
    assert(iss1.getInterestedMinLpVV().equalsIgnoreNegatives(lpVV1));    
  }

  /*
    zjd -- the following tests are commented 
    either because they are already tested in AllPreciseSetUnit/PreciseSetUnit
    or method not supported any more in the new design.

  //----------------------------------------------------------------------
  // Test the getMinLpVV() method
  //----------------------------------------------------------------------
  private static
  void testGetMinLpVV(){
    
    CounterVV dummyVV = CounterVV.makeVVAllNegatives();
    InterestRegion ir1 = null;
    ISStatus iss1 = null;
    PreciseSet ps1 = null;
    PreciseSet ps2 = null;
    PreciseSet ps3 = null;
    PreciseSet ps4 = null;
    PreciseSet ps5 = null;
    AllPreciseSets aps1 = null;
    CounterVV lpVV1 = null;
    CounterVV lpVV2 = null;
    CounterVV lpVV3 = null;
    AcceptStamp[] as1 = null;
    AcceptStamp[] as2 = null;
    AcceptStamp[] as3 = null;
    AcceptStamp[] as4 = null;
    AcceptStamp[] as5 = null;
    AcceptStamp[] as6 = null;
    AcceptStamp[] as7 = null;

    // Test 1
    // (1) Make aps1 with structure "/a"
    // (2) Get the minLpVV for "/a" without exclusions
    // (3) Make sure they match
    // (4) Get the minLpVV for "/a" but exclude "/a/b"
    //     (which doesn't exist)
    // (5) Make sure they still match
    ir1 = new InterestRegion();
    ps1 = new PreciseSet("", "", dummyVV, dummyVV);
    ps2 = ps1.split("a");
    aps1 = new AllPreciseSets(ps1);
    iss1 = new ISStatus(aps1,
                        ir1);

    as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(10, new NodeId(100));
    as1[1] = new AcceptStamp(10, new NodeId(200));
    //ps2.getISR().setLastPreciseVV(new CounterVV(as1));
    iss1.removeConnection(SubscriptionSet.makeSubscriptionSet("/a"),
		    null,
		    new CounterVV(as1));

    as2 = new AcceptStamp[2];
    as2[0] = new AcceptStamp(10, new NodeId(100));
    as2[1] = new AcceptStamp(10, new NodeId(200));
    lpVV1 = new CounterVV(as2);
    
    assert(iss1.getMinLpVV(SubscriptionSet.makeSubscriptionSet("/a")).equalsIgnoreNegatives(lpVV1));
    

    assert(iss1.getMinLpVV("/a", new String[0]).equals(lpVV1));
    exclChildNames1 = new String[1];
    exclChildNames1[0] = "b";
    assert(iss1.getMinLpVV("/a", exclChildNames1).equals(lpVV1));
    
    // Test 2
    // (1) Make aps1 with structure "/a/b:/a/b/c"
    // (2) Set the LpVV for "/a" to [(10, "100"), (10, "200")]
    // (3) Set the LpVV for "/a/b" to [(30, "100"), (20, "200")]
    // (4) Set the LpVV for "/a/b/c" to [(20, "100"), (30, "200")]
    // (5) Get the minLpVV for "/a/b" without exclusions
    // (6) Make sure that we get [(20, "100"), (20, "200")]
    // (7) Get the minLpVV for "/a/b" excluding "/a/b/c"
    // (8) Make sure that we get [(30, "100"), (20, "200")]
    ir1 = new InterestRegion();
    ps1 = new PreciseSet("", "", dummyVV, dummyVV);
    ps2 = ps1.split("a");
    ps3 = ps2.split("b");
    ps4 = ps3.split("c");
    aps1 = new AllPreciseSets(ps1);
    iss1 = new ISStatus(aps1,
                        ir1);
    as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(10, new NodeId(100));
    as1[1] = new AcceptStamp(10, new NodeId(200));
    ps2.getISR().setLastPreciseVV(new CounterVV(as1));
    as2 = new AcceptStamp[2];
    as2[0] = new AcceptStamp(30, new NodeId(100));
    as2[1] = new AcceptStamp(20, new NodeId(200));
    ps3.getISR().setLastPreciseVV(new CounterVV(as2));
    as3 = new AcceptStamp[2];
    as3[0] = new AcceptStamp(20, new NodeId(100));
    as3[1] = new AcceptStamp(30, new NodeId(200));
    ps4.getISR().setLastPreciseVV(new CounterVV(as3));
    as5 = new AcceptStamp[2];
    as5[0] = new AcceptStamp(20, new NodeId(100));
    as5[1] = new AcceptStamp(20, new NodeId(200));
    lpVV1 = new CounterVV(as5);
    assert(iss1.getMinLpVV("/a/b", new String[0]).equals(lpVV1));
    as6 = new AcceptStamp[2];
    as6[0] = new AcceptStamp(30, new NodeId(100));
    as6[1] = new AcceptStamp(20, new NodeId(200));
    lpVV2 = new CounterVV(as6);
    exclChildNames1 = new String[1];
    exclChildNames1[0] = "c";
    assert(iss1.getMinLpVV("/a/b", exclChildNames1).equals(lpVV2));

    // Test 3
    // (1) Make aps1 with structure "/a/b/c:/a/b/d"
    // (2) Set the LpVV for "/a" to [(20, "100"), (20, "200")]
    // (3) Set the LpVV for "/a/b" to [(10, "100"), (10, "200")]
    // (4) Set the LpVV for "/a/b/c" to [(10, "100"), (10, "200")]
    // (5) Set the LpVV for "/a/b/d" to [(10, "100"), (10, "200")]
    // (6) Get the minLpVV for "/a/e" without exclusions
    // (7) Make sure that we get [(20, "100"), (20, "200")] directly
    //     from /a
    // (8) Get the minLpVV for "/a" without exclusions
    // (9) Make sure that we get [(10, "100"), (10, "200")]
    // (10) Get the minLpVV for "/a", excluding "b"
    // (11) Make sure that we get [(20, "100"), (20, "200")]
    ir1 = new InterestRegion();
    ps1 = new PreciseSet("", "", dummyVV, dummyVV);
    ps2 = ps1.split("a");
    ps3 = ps2.split("b");
    ps4 = ps3.split("c");
    ps5 = ps3.split("d");
    aps1 = new AllPreciseSets(ps1);
    iss1 = new ISStatus(aps1,
                        new CounterVV(CounterVV.makeVVAllNegatives()),
                        ir1,
                        new StaticPSController());
    as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(20, new NodeId(100));
    as1[1] = new AcceptStamp(20, new NodeId(200));
    ps2.getISR().setLastPreciseVV(new CounterVV(as1));
    as2 = new AcceptStamp[2];
    as2[0] = new AcceptStamp(10, new NodeId(100));
    as2[1] = new AcceptStamp(10, new NodeId(200));
    ps3.getISR().setLastPreciseVV(new CounterVV(as2));
    as3 = new AcceptStamp[2];
    as3[0] = new AcceptStamp(10, new NodeId(100));
    as3[1] = new AcceptStamp(10, new NodeId(200));
    ps4.getISR().setLastPreciseVV(new CounterVV(as3));
    as4 = new AcceptStamp[2];
    as4[0] = new AcceptStamp(10, new NodeId(100));
    as4[1] = new AcceptStamp(10, new NodeId(200));
    ps5.getISR().setLastPreciseVV(new CounterVV(as4));
    as5 = new AcceptStamp[2];
    as5[0] = new AcceptStamp(20, new NodeId(100));
    as5[1] = new AcceptStamp(20, new NodeId(200));
    lpVV1 = new CounterVV(as5);
    assert(iss1.getMinLpVV("/a/e", new String[0]).equals(lpVV1));
    as6 = new AcceptStamp[2];
    as6[0] = new AcceptStamp(10, new NodeId(100));
    as6[1] = new AcceptStamp(10, new NodeId(200));
    lpVV2 = new CounterVV(as6);
    assert(iss1.getMinLpVV("/a", new String[0]).equals(lpVV2));
    as7 = new AcceptStamp[2];
    as7[0] = new AcceptStamp(20, new NodeId(100));
    as7[1] = new AcceptStamp(20, new NodeId(200));
    lpVV3 = new CounterVV(as7);
    exclChildNames1 = new String[1];
    exclChildNames1[0] = "b";
    assert(iss1.getMinLpVV("/a", exclChildNames1).equals(lpVV3));

    // Test 4
    // (1) Make aps1 with structure "/a/b/c:/a/b/d"
    // (2) Set the LpVV for "/a" to [(20, "100"), (20, "200")]
    // (3) Set the LpVV for "/a/b" to [(30, "100"), (30, "200")]
    // (4) Set the LpVV for "/a/b/c" to [(10, "100"), (10, "200")]
    // (5) Set the LpVV for "/a/b/d" to [(10, "100"), (10, "200")]
    // (6) Get the minLpVV for "/a/b" excluding "c"
    // (7) Make sure that we get [(10, "100"), (10, "200")]
    // (8) Get the minLpVV for "/a/b" excluding "c" and "d"
    // (9) Make sure that we get [(30, "100"), (30, "200")]
    ir1 = new InterestRegion();
    ps1 = new PreciseSet("", "", dummyVV, dummyVV);
    ps2 = ps1.split("a");
    ps3 = ps2.split("b");
    ps4 = ps3.split("c");
    ps5 = ps3.split("d");
    aps1 = new AllPreciseSets(ps1);
    iss1 = new ISStatus(aps1,
                        new CounterVV(CounterVV.makeVVAllNegatives()),
                        ir1,
                        new StaticPSController());
    as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(20, new NodeId(100));
    as1[1] = new AcceptStamp(20, new NodeId(200));
    ps2.getISR().setLastPreciseVV(new CounterVV(as1));
    as2 = new AcceptStamp[2];
    as2[0] = new AcceptStamp(30, new NodeId(100));
    as2[1] = new AcceptStamp(30, new NodeId(200));
    ps3.getISR().setLastPreciseVV(new CounterVV(as2));
    as3 = new AcceptStamp[2];
    as3[0] = new AcceptStamp(10, new NodeId(100));
    as3[1] = new AcceptStamp(10, new NodeId(200));
    ps4.getISR().setLastPreciseVV(new CounterVV(as3));
    as4 = new AcceptStamp[2];
    as4[0] = new AcceptStamp(10, new NodeId(100));
    as4[1] = new AcceptStamp(10, new NodeId(200));
    ps5.getISR().setLastPreciseVV(new CounterVV(as4));
    as5 = new AcceptStamp[2];
    as5[0] = new AcceptStamp(10, new NodeId(100));
    as5[1] = new AcceptStamp(10, new NodeId(200));
    lpVV1 = new CounterVV(as5);
    exclChildNames1 = new String[1];
    exclChildNames1[0] = "c";
    assert(iss1.getMinLpVV("/a/b", exclChildNames1).equals(lpVV1));
    as6 = new AcceptStamp[2];
    as6[0] = new AcceptStamp(30, new NodeId(100));
    as6[1] = new AcceptStamp(30, new NodeId(200));
    lpVV2 = new CounterVV(as6);
    exclChildNames2 = new String[2];
    exclChildNames2[0] = "c";
    exclChildNames2[1] = "d";
    assert(iss1.getMinLpVV("/a/b", exclChildNames2).equals(lpVV2));

  }

  //----------------------------------------------------------------------
  // Test the checkMinLpVV() method
  //----------------------------------------------------------------------
  private static
  void testCheckMinLpVV(){


    InterestRegion ir1 = null;
    ISStatus iss1 = null;
    PreciseSet ps1 = null;
    PreciseSet ps2 = null;
    PreciseSet ps3 = null;
    PreciseSet ps4 = null;
    PreciseSet ps5 = null;
    AllPreciseSets aps1 = null;
    CounterVV lpVV1 = null;
    CounterVV lpVV2 = null;
    CounterVV lpVV3 = null;
    CounterVV lpVV4 = null;
    CounterVV lpVV5 = null;
    CounterVV lpVV6 = null;
    CounterVV lpVV7 = null;
    AcceptStamp[] as1 = null;
    AcceptStamp[] as2 = null;
    AcceptStamp[] as3 = null;
    AcceptStamp[] as4 = null;
    AcceptStamp[] as5 = null;
    AcceptStamp[] as6 = null;
    AcceptStamp[] as7 = null;
    AcceptStamp[] as8 = null;
    AcceptStamp[] as9 = null;
    AcceptStamp[] as10 = null;
    AcceptStamp[] as11 = null;
    String[] exclChildNames1 = null;
    String[] exclChildNames2 = null;

    // Test 1
    // (1) Make aps1 with structure "/a"
    // (2) Set the LpVV for "/a" to [(10, "100"), (10, "200")]
    // (3) Make sure "/a" is beyond [(10, "100"), (9, "200")]
    // (4) Make sure "/a" is beyond [(10, "100"), (10, "200")]
    // (5) Make sure "/a" is not beyond [(11, "100"), (10, "200")]
    // (6) Make sure these are true independent of exclusions
    ir1 = new InterestRegion();
    ps1 = new PreciseSet("", "", dummyVV, dummyVV);
    ps2 = ps1.split("a");
    aps1 = new AllPreciseSets(ps1);
    iss1 = new ISStatus(aps1,
                        new CounterVV(CounterVV.makeVVAllNegatives()),
                        ir1,
                        new StaticPSController());
    as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(10, new NodeId(100));
    as1[1] = new AcceptStamp(10, new NodeId(200));
    ps2.getISR().setLastPreciseVV(new CounterVV(as1));
    as2 = new AcceptStamp[2];
    as2[0] = new AcceptStamp(10, new NodeId(100));
    as2[1] = new AcceptStamp(9, new NodeId(200));
    lpVV1 = new CounterVV(as2);
    exclChildNames1 = new String[1];
    exclChildNames1[0] = "b";
    assert(iss1.checkMinLpVV("/a", new String[0], lpVV1));
    assert(iss1.checkMinLpVV("/a", exclChildNames1, lpVV1));
    as3 = new AcceptStamp[2];
    as3[0] = new AcceptStamp(10, new NodeId(100));
    as3[1] = new AcceptStamp(10, new NodeId(200));
    lpVV2 = new CounterVV(as3);
    assert(iss1.checkMinLpVV("/a", new String[0], lpVV2));
    assert(iss1.checkMinLpVV("/a", exclChildNames1, lpVV2));
    as4 = new AcceptStamp[2];
    as4[0] = new AcceptStamp(11, new NodeId(100));
    as4[1] = new AcceptStamp(10, new NodeId(200));
    lpVV3 = new CounterVV(as4);
    assert(!iss1.checkMinLpVV("/a", new String[0], lpVV3));
    assert(!iss1.checkMinLpVV("/a", exclChildNames1, lpVV3));

    // Test 2
    // (1) Make aps1 with structure "/a/b:/a/b/c"
    // (2) Set the LpVV for "/a" to [(10, "100"), (10, "200")]
    // (3) Set the LpVV for "/a/b" to [(20, "100"), (30, "200")]
    // (4) Set the LpVV for "/a/b/c" to [(30, "100"), (20, "200")]
    // (5) Make sure "/a/b" is at or beyond [(20, "100"), (20, "200")]
    // (6) Make sure "/a/b" is not beyond [(20, "100"), (25, "200")]
    // (7) Make sure "/a/b" is not beyond [(25, "100"), (20, "200")]
    // (8) Make sure "/a/b/c" is at or beyond [(25, "100"), (20, "200")]
    // (9) Make sure "/a/d" is at or beyond [(10, "100"), (10, "200")]
    // (10) Make sure "/a/d" is not beyond [(15, "100"), (10, "200")]
    // (11) Make sure "/a/b" excluding "c" includes [(20, "100"), (30, "200")]
    // (12) Make sure "/a/d" excluding "b" does not include
    //      [(15, "100"), (10, "200")]
    ir1 = new InterestRegion();
    ps1 = new PreciseSet("", "", dummyVV, dummyVV);
    ps2 = ps1.split("a");
    ps3 = ps2.split("b");
    ps4 = ps3.split("c");
    aps1 = new AllPreciseSets(ps1);
    iss1 = new ISStatus(aps1,
                        new CounterVV(CounterVV.makeVVAllNegatives()),
                        ir1,
                        new StaticPSController());
    as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(10, new NodeId(100));
    as1[1] = new AcceptStamp(10, new NodeId(200));
    ps2.getISR().setLastPreciseVV(new CounterVV(as1));
    as2 = new AcceptStamp[2];
    as2[0] = new AcceptStamp(20, new NodeId(100));
    as2[1] = new AcceptStamp(30, new NodeId(200));
    ps3.getISR().setLastPreciseVV(new CounterVV(as2));
    as3 = new AcceptStamp[2];
    as3[0] = new AcceptStamp(30, new NodeId(100));
    as3[1] = new AcceptStamp(20, new NodeId(200));
    ps4.getISR().setLastPreciseVV(new CounterVV(as3));
    as4 = new AcceptStamp[2];
    as4[0] = new AcceptStamp(20, new NodeId(100));
    as4[1] = new AcceptStamp(20, new NodeId(200));
    lpVV1 = new CounterVV(as4);
    assert(iss1.checkMinLpVV("/a/b", new String[0], lpVV1));
    as5 = new AcceptStamp[2];
    as5[0] = new AcceptStamp(20, new NodeId(100));
    as5[1] = new AcceptStamp(25, new NodeId(200));
    lpVV2 = new CounterVV(as5);
    assert(!iss1.checkMinLpVV("/a/b", new String[0], lpVV2));
    as6 = new AcceptStamp[2];
    as6[0] = new AcceptStamp(25, new NodeId(100));
    as6[1] = new AcceptStamp(20, new NodeId(200));
    lpVV3 = new CounterVV(as6);
    assert(!iss1.checkMinLpVV("/a/b", new String[0], lpVV3));
    as7 = new AcceptStamp[2];
    as7[0] = new AcceptStamp(25, new NodeId(100));
    as7[1] = new AcceptStamp(20, new NodeId(200));
    lpVV3 = new CounterVV(as7);
    assert(iss1.checkMinLpVV("/a/b/c", new String[0], lpVV3));
    as8 = new AcceptStamp[2];
    as8[0] = new AcceptStamp(10, new NodeId(100));
    as8[1] = new AcceptStamp(10, new NodeId(200));
    lpVV4 = new CounterVV(as8);
    assert(iss1.checkMinLpVV("/a/d", new String[0], lpVV4));
    as9 = new AcceptStamp[2];
    as9[0] = new AcceptStamp(15, new NodeId(100));
    as9[1] = new AcceptStamp(10, new NodeId(200));
    lpVV5 = new CounterVV(as9);
    assert(!iss1.checkMinLpVV("/a/d", new String[0], lpVV5));
    as10 = new AcceptStamp[2];
    as10[0] = new AcceptStamp(20, new NodeId(100));
    as10[1] = new AcceptStamp(30, new NodeId(200));
    lpVV6 = new CounterVV(as10);
    exclChildNames1 = new String[1];
    exclChildNames1[0] = "c";
    assert(iss1.checkMinLpVV("/a/b", exclChildNames1, lpVV6));
    as11 = new AcceptStamp[2];
    as11[0] = new AcceptStamp(15, new NodeId(100));
    as11[1] = new AcceptStamp(10, new NodeId(200));
    lpVV7 = new CounterVV(as11);
    exclChildNames2 = new String[1];
    exclChildNames2[0] = "b";
    assert(!iss1.checkMinLpVV("/a/d", exclChildNames2, lpVV7));
  }

  //----------------------------------------------------------------------
  // Test the updateAllLpVVs() method
  //----------------------------------------------------------------------
  private static void
  testUpdateAllLpVVs(){
    

    InterestRegion ir1 = null;
    ISStatus iss1 = null;
    PreciseSet ps1 = null;
    PreciseSet ps2 = null;
    PreciseSet ps3 = null;
    PreciseSet ps4 = null;
    AllPreciseSets aps1 = null;
    CounterVV lpVV1 = null;
    CounterVV lpVV2 = null;
    AcceptStamp[] as1 = null;
    AcceptStamp[] as2 = null;
    AcceptStamp[] as3 = null;
    AcceptStamp[] as4 = null;
    AcceptStamp[] as5 = null;
    String[] exclChildNames1 = null;

    // Test 1
    // (1) Make aps1 with structure "/a/b:/a/b/c"
    // (2) Set the lpVV of "/a" to [(10, "100")]
    // (3) Set the lpVV of "/a/b" to [(20, "100")]
    // (4) Set the lpVV of "/a/b/c" to [(30, "100")]
    // (5) Update the lpVV of "/a/b" to [(40, "100")] without exclusions
    // (6) Make sure that the lpVV of "/a/b" is updated
    // (7) Make sure that the lpVV of "/a/b/c" is updated as well
    // (8) Make sure that the lpVV of "/a" is not updated
    // (9) Update the lpVV of "/a/b" to [(50, "100")] excluding "c"
    // (10) Make sure that the lpVV of "/a/b" is updated
    // (11) Make sure that the lpVV of "/a/b/c" is not updated
    ir1 = new InterestRegion();
    ps1 = new PreciseSet("", "", dummyVV, dummyVV);
    ps2 = ps1.split("a");
    ps3 = ps2.split("b");
    ps4 = ps3.split("c");
    aps1 = new AllPreciseSets(ps1);
    iss1 = new ISStatus(aps1,
                        new CounterVV(CounterVV.makeVVAllNegatives()),
                        ir1,
                        new StaticPSController());
    as1 = new AcceptStamp[1];
    as1[0] = new AcceptStamp(10, new NodeId(100));
    ps2.getISR().setLastPreciseVV(new CounterVV(as1));
    as2 = new AcceptStamp[1];
    as2[0] = new AcceptStamp(20, new NodeId(100));
    ps3.getISR().setLastPreciseVV(new CounterVV(as2));
    as3 = new AcceptStamp[1];
    as3[0] = new AcceptStamp(30, new NodeId(100));
    ps4.getISR().setLastPreciseVV(new CounterVV(as3));
    as4 = new AcceptStamp[1];
    as4[0] = new AcceptStamp(40, new NodeId(100));
    lpVV1 = new CounterVV(as4);
    iss1.updateAllLpVVs("/a/b", new String[0], lpVV1);
    assert(lpVV1.equals(ps3.getISR().getLastPreciseVV()));
    assert(lpVV1.equals(ps4.getISR().getLastPreciseVV()));
    assert(!lpVV1.equals(ps2.getISR().getLastPreciseVV()));
    as5 = new AcceptStamp[1];
    as5[0] = new AcceptStamp(50, new NodeId(100));
    lpVV2 = new CounterVV(as5);
    exclChildNames1 = new String[1];
    exclChildNames1[0] = "c";
    iss1.updateAllLpVVs("/a/b", exclChildNames1, lpVV2);
    assert(lpVV2.equals(ps3.getISR().getLastPreciseVV()));
    assert(!lpVV2.equals(ps4.getISR().getLastPreciseVV()));

    // Test 2
    // (1) Make aps1 with structure "/a/b:/a/b/c"
    // (2) Set the lpVV of "/a" to [(10, "100")]
    // (3) Set the lpVV of "/a/b" to [(20, "100")]
    // (4) Set the lpVV of "/a/b/c" to [(30, "100")]
    // (5) Update the lpVV of "/a/d" to [(40, "100")] without exclusions
    // (6) Make sure that the lpVV of "/a" is updated
    // (7) Make sure that the lpVV of "/a/b" is not updated
    // (8) Make sure that the lpVV of "/a/b/c" is not updated either
    // (9) Update the lpVV of "/a/d" to [(50, "100")] excluding "b"
    // (10) Make sure that the lpVV of "/a" is updated
    // (11) Make sure that the lpVV of "/a/b" is not updated
    // (12) Make sure that the lpVV of "/a/b/c" is not updated either
    ir1 = new InterestRegion();
    ps1 = new PreciseSet("", "", dummyVV, dummyVV);
    ps2 = ps1.split("a");
    ps3 = ps2.split("b");
    ps4 = ps3.split("c");
    aps1 = new AllPreciseSets(ps1);
    iss1 = new ISStatus(aps1,
                        new CounterVV(CounterVV.makeVVAllNegatives()),
                        ir1,
                        new StaticPSController());
    as1 = new AcceptStamp[1];
    as1[0] = new AcceptStamp(10, new NodeId(100));
    ps2.getISR().setLastPreciseVV(new CounterVV(as1));
    as2 = new AcceptStamp[1];
    as2[0] = new AcceptStamp(20, new NodeId(100));
    ps3.getISR().setLastPreciseVV(new CounterVV(as2));
    as3 = new AcceptStamp[1];
    as3[0] = new AcceptStamp(30, new NodeId(100));
    ps4.getISR().setLastPreciseVV(new CounterVV(as3));
    as4 = new AcceptStamp[1];
    as4[0] = new AcceptStamp(40, new NodeId(100));
    lpVV1 = new CounterVV(as4);
    iss1.updateAllLpVVs("/a/d", new String[0], lpVV1);
    assert(lpVV1.equals(ps2.getISR().getLastPreciseVV()));
    assert(!lpVV1.equals(ps3.getISR().getLastPreciseVV()));
    assert(!lpVV1.equals(ps4.getISR().getLastPreciseVV()));
    // (9) Update the lpVV of "/a/d" to [(50, "100")] excluding "b" and "c"
    // (10) Make sure that the lpVV of "/a" is updated
    // (11) Make sure that the lpVV of "/a/b" is not updated
    // (12) Make sure that the lpVV of "/a/b/c" is not updated either
    as5 = new AcceptStamp[1];
    as5[0] = new AcceptStamp(50, new NodeId(100));
    lpVV2 = new CounterVV(as5);
    exclChildNames1 = new String[2];
    exclChildNames1[0] = "b";
    exclChildNames1[1] = "c";
    iss1.updateAllLpVVs("/a/d", exclChildNames1, lpVV2);
    assert(lpVV2.equals(ps2.getISR().getLastPreciseVV()));
    assert(!lpVV2.equals(ps3.getISR().getLastPreciseVV()));
    assert(!lpVV2.equals(ps4.getISR().getLastPreciseVV()));

  }

  //----------------------------------------------------------------------
  // Test the version of getMinLpVV() that accepts a SubscriptionSet
  //----------------------------------------------------------------------
  private static void
  testGetMinLpVV2(){


    SubscriptionSet ss1 = null;
    SubscriptionSet ss2 = null;
    SubscriptionSet ss3 = null;
    SubscriptionSet ss4 = null;
    SubscriptionSet ss5 = null;
    ISStatus iss1 = null;
    InterestRegion ir1 = null;
    PreciseSet ps1 = null;
    PreciseSet ps2 = null;
    PreciseSet ps3 = null;
    PreciseSet ps4 = null;
    PreciseSet ps5 = null;
    AllPreciseSets aps1 = null;
    AcceptStamp[] as1 = null;
    AcceptStamp[] as2 = null;
    AcceptStamp[] as3 = null;
    AcceptStamp[] as4 = null;
    AcceptStamp[] as5 = null;
    AcceptStamp[] as6 = null;
    AcceptStamp[] as7 = null;
    AcceptStamp[] as8 = null;
    AcceptStamp[] as9 = null;
    CounterVV lpVV1 = null;
    CounterVV lpVV2 = null;
    CounterVV lpVV3 = null;
    CounterVV lpVV4 = null;
    CounterVV lpVV5 = null;

    // NOTE: We rely on having tested the other version of getMinLpVV()
    // so we do not do as much testing here

    // Test 1
    // (1) Make aps1 with structure "/a"
    // (2) Get the minLpVV for "/a"
    // (3) Make sure they match
    ir1 = new InterestRegion();
    ps1 = new PreciseSet("", "", dummyVV, dummyVV);
    ps2 = ps1.split("a");
    aps1 = new AllPreciseSets(ps1);
    iss1 = new ISStatus(aps1,
                        new CounterVV(CounterVV.makeVVAllNegatives()),
                        ir1,
                        new StaticPSController());
    as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(10, new NodeId(100));
    as1[1] = new AcceptStamp(10, new NodeId(200));
    ps2.getISR().setLastPreciseVV(new CounterVV(as1));
    as2 = new AcceptStamp[2];
    as2[0] = new AcceptStamp(10, new NodeId(100));
    as2[1] = new AcceptStamp(10, new NodeId(200));
    lpVV1 = new CounterVV(as2);
    ss1 = SubscriptionSet.makeSubscriptionSet("/a");
    assert(iss1.getMinLpVV(ss1).equals(lpVV1));

    // Test 2
    // (1) Make aps1 with structure "/a/b/c:/a/b/d"
    // (2) Set the LpVV for "/a" to [(20, "100"), (20, "200")]
    // (3) Set the LpVV for "/a/b" to [(15, "100"), (10, "200")]
    // (4) Set the LpVV for "/a/b/c" to [(10, "100"), (15, "200")]
    // (5) Set the LpVV for "/a/b/d" to [(10, "100"), (10, "200")]
    // (6) Get the minLpVV for "/a/e"
    // (7) Make sure that we get [(20, "100"), (20, "200")] from "/a"
    // (8) Get the minLpVV for "/a"
    // (9) Make sure that we get [(20, "100"), (20, "200")]
    // (10) Get the minLpVV for "/a:/a/b"
    // (11) Make sure that we get [(15, "100"), (10, "200")]

    // (12) Get the minLpVV for "/a/*"
    // (13) Make sure that we get [(10, "100"), (10, "100")]
    // (14) Get the minLpVV for "/a/b/*"
    // (15) Make sure that we get [(10, "100"), (10, "100")]
    ir1 = new InterestRegion();
    ps1 = new PreciseSet("", "", dummyVV, dummyVV);
    ps2 = ps1.split("a");
    ps3 = ps2.split("b");
    ps4 = ps3.split("c");
    ps5 = ps3.split("d");
    aps1 = new AllPreciseSets(ps1);
    iss1 = new ISStatus(aps1,
                        new CounterVV(CounterVV.makeVVAllNegatives()),
                        ir1,
                        new StaticPSController());
    as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(20, new NodeId(100));
    as1[1] = new AcceptStamp(20, new NodeId(200));
    ps2.getISR().setLastPreciseVV(new CounterVV(as1));
    as2 = new AcceptStamp[2];
    as2[0] = new AcceptStamp(15, new NodeId(100));
    as2[1] = new AcceptStamp(10, new NodeId(200));
    ps3.getISR().setLastPreciseVV(new CounterVV(as2));
    as3 = new AcceptStamp[2];
    as3[0] = new AcceptStamp(10, new NodeId(100));
    as3[1] = new AcceptStamp(15, new NodeId(200));
    ps4.getISR().setLastPreciseVV(new CounterVV(as3));
    as4 = new AcceptStamp[2];
    as4[0] = new AcceptStamp(10, new NodeId(100));
    as4[1] = new AcceptStamp(10, new NodeId(200));
    ps5.getISR().setLastPreciseVV(new CounterVV(as4));
    as5 = new AcceptStamp[2];
    as5[0] = new AcceptStamp(20, new NodeId(100));
    as5[1] = new AcceptStamp(20, new NodeId(200));
    lpVV1 = new CounterVV(as5);
    ss1 = SubscriptionSet.makeSubscriptionSet("/a/e");
    assert(iss1.getMinLpVV(ss1).equals(lpVV1));
    as6 = new AcceptStamp[2];
    as6[0] = new AcceptStamp(20, new NodeId(100));
    as6[1] = new AcceptStamp(20, new NodeId(200));
    lpVV2 = new CounterVV(as6);
    ss2 = SubscriptionSet.makeSubscriptionSet("/a");
    assert(iss1.getMinLpVV(ss2).equals(lpVV2));
    as7 = new AcceptStamp[2];
    as7[0] = new AcceptStamp(15, new NodeId(100));
    as7[1] = new AcceptStamp(10, new NodeId(200));
    lpVV3 = new CounterVV(as7);
    ss3 = SubscriptionSet.makeSubscriptionSet("/a:/a/b");
    assert(iss1.getMinLpVV(ss3).equals(lpVV3));
    as8 = new AcceptStamp[2];
    as8[0] = new AcceptStamp(10, new NodeId(100));
    as8[1] = new AcceptStamp(10, new NodeId(200));
    lpVV4 = new CounterVV(as8);
    ss4 = SubscriptionSet.makeSubscriptionSet("/a/*");
    assert(iss1.getMinLpVV(ss4).equals(lpVV4));
    as9 = new AcceptStamp[2];
    as9[0] = new AcceptStamp(10, new NodeId(100));
    as9[1] = new AcceptStamp(10, new NodeId(200));
    lpVV5 = new CounterVV(as9);
    ss5 = SubscriptionSet.makeSubscriptionSet("/a/b/*");
    assert(iss1.getMinLpVV(ss5).equals(lpVV5));

  }
  */
  private static void makePractiConfig(){
    Config.createEmptyConfig();
    long NODE_0_ID = 0;
    long NODE_1_ID = 1;
    long NODE_2_ID = 2;
    long NODE_3_ID = 3;
    long NODE_4_ID = 4;
    String NODE_0_IP = "localhost";
    String NODE_1_IP = "localhost";
    String NODE_2_IP = "localhost";
    String NODE_3_IP = "localhost";
    String NODE_4_IP = "localhost";
    Config.addOneNodeConfig(new NodeId(NODE_0_ID),
                            NODE_0_IP,
                            9988,
                            9989,
                            9991,
                            9992,
                            9990,
                            "test" + File.separatorChar + "local-" + 
			    NODE_0_ID + ".db",
                            "/*",
                            -1L,
                            NODE_0_IP,
                            9993,
                            9994,
                            -1,
  			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);
 
   Config.addOneNodeConfig(new NodeId(NODE_1_ID),
			   NODE_1_IP,
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "local-" + 
			   NODE_1_ID+".db",
			   "/*",
			   -1L,
			   NODE_1_IP,
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);
   Config.addOneNodeConfig(new NodeId(NODE_2_ID),
			   NODE_2_IP,
			   9788,
			   9789,
			   9791,
			   9792,
			   9790,
                           "test" + File.separatorChar + "local-" + 
			   NODE_2_ID+".db",
			   "/*",
			   -1L,
			   NODE_2_IP,
			   9793,
			   9794,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);

   Config.addOneNodeConfig(new NodeId(NODE_3_ID),
			   NODE_3_IP,
			   9688,
			   9689,
			   9691,
			   9692,
                           9690,
                           "test" + File.separatorChar + "local-" + 
			   NODE_3_ID+".db",
			   "/*",
			   -1L,
			   NODE_3_IP,
			   9693,
			   9694,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);
    
   
   
   
   Config.addOneNodeConfig(new NodeId(NODE_4_ID),
			   NODE_4_IP,
			   9588,
			   9589,
			   9591,
			   9592,
			   9590,
                           "test" + File.separatorChar + "local-" + 
			   NODE_4_ID+".db",
			   "/*",
			   -1L,
			   NODE_4_IP,
			   9593,
			   9594,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);
   //Config.writeToFile(configPath);
  }

  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(ISStatusUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * usage: java <classname> [-verbose] [-vverbose] [testName]*
   * 
   *   If verbose or vverbose are included, print info to screen
   *
   *   If [testName]* are included, then run test called "test[testName]"
   *   for each such [testName]. E.g., "java ISStatusUnit foo" runs
   *   ISStatusUnit.testfoo() as a TestCase.
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "ISStatusUnit";
    System.err.print(name + " self test begins...");
    //
    // Default: run all tests
    //
    TestSuite ste = new TestSuite();
    Test test;
    boolean doAllTests = true;

    if(s.length > 0){
      int ii;
      for(ii = 0; ii < s.length; ii++){
        if(s[ii].equals("-verbose")){
          verbose = true;
        }
        else if(s[ii].equals("-vverbose")){
          verbose = true;
        }
        else{
          doAllTests = false;
          ste.addTest(new ISStatusUnit("test" + s[ii]));
        }
        
      }
    }
    if(doAllTests){
      test = suite();
    }
    else{
      test = ste;
    }
    TestRunner tr = new TestRunner();
    tr.doRun(test);
    System.err.println(name + " self test succeeds");
    System.exit(0); 
  }

}
