package code;

 /** 
 *  IllegalRemoveSubscriptionSet.java: Called when the user attempts to 
 *  remove a SubscriptionSet that is not a substree of the source 
 *  SubscriptionSet. 
 **/ 
public class IllegalRemoveSubscriptionSetException extends Exception{

 /** 
 *  Data members 
 **/ 
  private String errStr;

 /** 
 *  Constructor 
 **/ 
  public
  IllegalRemoveSubscriptionSetException(String errorString){
    this.errStr = errorString;
  }

 /** 
 *  Constructor 
 **/ 
  public
  IllegalRemoveSubscriptionSetException(){
    this.errStr = "";
  }

 /** 
 *  Convert this exception to a string 
 **/ 
  public String
  toString(){
    return(this.errStr);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    IllegalRemoveSubscriptionSetException irsse = null;

    Env.verifyAssertEnabled();
    System.out.println("Testing IllegalRemoveSubscriptionSet.java...");
    try{
      throw new IllegalRemoveSubscriptionSetException("a");
    }catch(IllegalRemoveSubscriptionSetException e){
      assert((new String("a")).equals("" + e));
    }

    System.out.println("...Finished");
  }
}

//---------------------------------------------------------------------------
/* $LOG$ */
//---------------------------------------------------------------------------
