package code;

 /** Immutable.java
 * 
 * Classes that implement this interface are *by convention* immutable.
 * Note that we cannot enforce this, so programmers must be careful.
 * But, saying that a class "implements Immutable" at least documents
 * this assumption; also, when you use a class that you are assuming
 * to be immutable, you can assert that the class is an instanceof 
 * immutable to document your assumption.
 *
 * We use immutable objects when we want to share a read-only
 * object across threads.
 *
 * (C) Copyright 2004 -- See the file COPYRIGHT for additional details
 */


public interface Immutable{
    //*Notes on IMMUTABLE*
    // A bunch of primitive objects  are 
    // *immutable* classes.  We do this because references to them
    // get passed around throughout the system and they are basically
    // all just container classes.
    //
    // Immutable class as per
    // http://www-106.ibm.com/developerworks/java/library/j-jtp02183.html
    // This means we must do the following:
    //
    //  * All of its fields are final
    //  * The class is declared final
    //  * The this reference is not allowed to escape during construction
    //  * Any fields that contain references to mutable objects, such as arrays, collections, or mutable classes like Date:
    //        o Are private
    //        o Are never returned or otherwise exposed to callers
    //        o Are the only reference to the objects that they reference
    //        o Do not change the state of the referenced objects after construction

}

//---------------------------------------------------------------------------
/* $Log: Immutable.java,v $
/* Revision 1.1  2004/07/28 14:27:35  dahlin
/* Added sanity checks for immutable objects
/*
 */
//---------------------------------------------------------------------------
