package code;
//package utils.junit;

import junit.textui.TestRunner;
import junit.framework.*;
import java.io.ObjectOutputStream;
import java.io.ObjectInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
/**
 * TBD: Update class name
 */
public class ImpreciseInvUnit extends TestCase {
  public static final String TEST_ALL_TEST_TYPE = "UNIT";
  
  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public ImpreciseInvUnit (final String s) {
    super (s);
  }

  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
    /* 
     * TBD: Insert other fixture code here
     * e.g., this.objectUnderTest = new ClassToBeTested(...);
     */
  }

  protected void tearDown() throws Exception{
    /* 
     * TBD: Insert other fixture cleanup code here
     */
    super.tearDown();
  }

 /** 
 *  test basic functions
 
 **/ 
  public void testBasicFunction(){
    ImpreciseInv ii1 = null;
    ImpreciseInv ii2 = null;
    AcceptStamp[] as1 = null;
    AcceptStamp[] as2 = null;
    AcceptStamp[] as3 = null;
    InvalTarget it1 = null;
    InvalTarget it2 = null;
    PreciseInv pi1 = null;
    PreciseInv pi2 = null;
    NodeId nodeId1 = null;
    AcceptVV vv1 = null;

    as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(190, new NodeId(200));
    as1[1] = new AcceptStamp(180, new NodeId(300));
    as2 = new AcceptStamp[2];
    as2[0] = new AcceptStamp(200, new NodeId(200));
    as2[1] = new AcceptStamp(190, new NodeId(300));
    ii1 = new ImpreciseInv(new ISet(),
                           new AcceptVV(as1),
                           new AcceptVV(as2));

    // Test toString + simple get methods
    System.out.println("ii1 = " + ii1);
    System.out.println("ii1.getInvalTarget() = " + ii1.getInvalTarget());
    System.out.println("ii1.getStartVV() = " + ii1.getStartVV());
    System.out.println("ii1.getEndVV() = " + ii1.getEndVV());
    System.out.println("ii1.isCommitted() = " + ii1.isCommitted());
    System.out.println("ii1.isPrecise() = " + ii1.isPrecise());
    System.out.println();

    // Test some clone/chop methods
    System.out.println("ii1.clone() = " + ii1.clone());
    System.out.println();

    // Test clone + intersection routines
    // NOTE: Because we don't have an implementation of InterestSet,
    // we are limited in what we can test
    it1 = ii1.getInvalTarget();
/*      System.out.println("ii1.cloneIntersectInvalTarget(" +
                       "ii1.getInvalTarget()) = " +
                       ii1.cloneIntersectInvalTarget(it1));*/
    it2 = new ObjInvalTarget(new ObjId("obj1"), 10, 20);
    pi1 = new PreciseInv((ObjInvalTarget)it2,
                         new AcceptStamp(190, new NodeId(200)));
    System.out.println("ii1.cloneIntersectInvaltargetChopStartEnd(" +
                       pi1 + ") = " +
                       ii1.cloneIntersectInvaltargetChopStartEnd(pi1));
    ii2 = new ImpreciseInv(new ISet(),
                           new AcceptVV(as1),
                           new AcceptVV(as2));
    System.out.println("ii2 = " + ii2);
    pi2 = new PreciseInv((ObjInvalTarget)it2,
                         new AcceptStamp(190, new NodeId(200)));
    System.out.println("ii2.cloneIntersectInvaltargetChopStartEnd(" +
                       pi2 + ") = " +
                       ii2.cloneIntersectInvaltargetChopStartEnd(pi2));
    System.out.println();
    // NOTE: Did not do heavy testing of clone methods because they
    // are based on the same heavily-tested methods in PreciseInv

    // Test getOneWriterSubset
    System.out.println("ii1 = " + ii1);
    nodeId1 = new NodeId(300);
    System.out.println("ii1.getOneWriterSubsetFrom(" + nodeId1 + ", 180)" +
                       " = " + ii1.getOneWriterSubsetFrom(nodeId1, 180));
    /*
      // Both the following methods correctly throw assert failures
      System.out.println("ii1.getOneWriterSubsetFrom(" +
      nodeId1 + ", 200)" +
      " = " + ii1.getOneWriterSubsetFrom(nodeId1, 200));
      System.out.println("ii1.getOneWriterSubsetFrom(" +
      nodeId1 + ", 170)" +
      " = " + ii1.getOneWriterSubsetFrom(nodeId1, 170));
    */

    // No need to test isIncludedBy(); tested as part of PreciseInv
    // Test anyComponentIncludedBy()
    as3 = new AcceptStamp[2];
    as3[0] = new AcceptStamp(300, new NodeId(300));
    as3[1] = new AcceptStamp(140, new NodeId(200));
    vv1 = new AcceptVV(as3);
    System.out.println("ii1.anyComponentIncludedBy(" + vv1 + ") = " +
                       ii1.anyComponentIncludedBy(vv1));
    as3[0] = new AcceptStamp(150, new NodeId(300));
    as3[1] = new AcceptStamp(140, new NodeId(200));
    vv1 = new AcceptVV(as3);
    System.out.println("ii1.anyComponentIncludedBy(" + vv1 + ") = " +
                       ii1.anyComponentIncludedBy(vv1));
    as3[0] = new AcceptStamp(250, new NodeId(300));
    as3[1] = new AcceptStamp(250, new NodeId(200));
    vv1 = new AcceptVV(as3);
    System.out.println("ii1.anyComponentIncludedBy(" + vv1 + ") = " +
                       ii1.anyComponentIncludedBy(vv1));
    as3[0] = new AcceptStamp(150, new NodeId(300));
    as3[1] = new AcceptStamp(250, new NodeId(400));
    vv1 = new AcceptVV(as3);
    System.out.println("ii1.anyComponentIncludedBy(" + vv1 + ") = " +
                       ii1.anyComponentIncludedBy(vv1));
    System.out.println();

    // Test newUnion
    System.out.println("ii1.newUnion(" + ii1 + ") = " + 
                       ii1.newUnion(ii1, null));
    as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(160, new NodeId(300));
    as1[1] = new AcceptStamp(190, new NodeId(200));
    as2 = new AcceptStamp[2];
    as2[0] = new AcceptStamp(190, new NodeId(300));
    as2[1] = new AcceptStamp(210, new NodeId(200));
    ii2 = new ImpreciseInv(new ISet(),
                           new AcceptVV(as1),
                           new AcceptVV(as2));
    System.out.println("ii2 = " + ii2);
    System.out.println("ii1.newUnion(ii2) = " + ii1.newUnion(ii2, null));
    System.out.println();

    // Test totalOrderCompare()
    // Case 1a:
    as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(160, new NodeId(300));
    as1[1] = new AcceptStamp(190, new NodeId(200));
    as2 = new AcceptStamp[2];
    as2[0] = new AcceptStamp(190, new NodeId(300));
    as2[1] = new AcceptStamp(210, new NodeId(200));
    ii1 = new ImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
                           new AcceptVV(as1),
                           new AcceptVV(as2));
    ii2 = new ImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
                           new AcceptVV(as1),
                           new AcceptVV(as2));
    System.out.println("ii1 = " + ii1);
    System.out.println("ii2 = " + ii2);
    assert ii1.equals(ii2);

    // Case 1b:
    ii1 = new ImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
                           new AcceptVV(as1),
                           new AcceptVV(as2));
    ii2 = new ImpreciseInv(HierInvalTarget.makeHierInvalTarget("/*"),
                           new AcceptVV(as1),
                           new AcceptVV(as2));
    System.out.println("ii1 = " + ii1);
    System.out.println("ii2 = " + ii2);
    assert ii1.equals(ii2);

    // Case 2a:
    pi1 = new PreciseInv((ObjInvalTarget)it2,
                         new AcceptStamp(190, new NodeId(200)));
    ii2 = new ImpreciseInv(new ISet(),
                           new AcceptVV(as1),
                           new AcceptVV(as2));
    System.out.println("pi1 = " + pi1);
    System.out.println("ii2 = " + ii2);
    checkComparisons(pi1, ii2);

    // Case 2b:
    as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(150, new NodeId(300));
    as1[1] = new AcceptStamp(180, new NodeId(200));
    as2 = new AcceptStamp[2];
    as2[0] = new AcceptStamp(190, new NodeId(300));
    as2[1] = new AcceptStamp(210, new NodeId(200));
    ii1 = new ImpreciseInv(new ISet(),
                           new AcceptVV(as1),
                           new AcceptVV(as2));
    System.out.println("ii1 = " + ii1);
    System.out.println("ii2 = " + ii2);
    checkComparisons(ii2, ii1);

    // Case 3:
    as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(160, new NodeId(299));
    as1[1] = new AcceptStamp(190, new NodeId(200));
    as2 = new AcceptStamp[2];
    as2[0] = new AcceptStamp(190, new NodeId(300));
    as2[1] = new AcceptStamp(210, new NodeId(200));
    ii1 = new ImpreciseInv(new ISet(),
                           new AcceptVV(as1),
                           new AcceptVV(as2));
    System.out.println("ii1 = " + ii1);
    System.out.println("ii2 = " + ii2);
    checkComparisons(ii2, ii1);

    // Case 4:
    as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(160, new NodeId(300));
    as1[1] = new AcceptStamp(190, new NodeId(200));
    as2 = new AcceptStamp[2];
    as2[0] = new AcceptStamp(190, new NodeId(300));
    as2[1] = new AcceptStamp(209, new NodeId(200));
    ii1 = new ImpreciseInv(new ISet(),
                           new AcceptVV(as1),
                           new AcceptVV(as2));
    System.out.println("ii1 = " + ii1);
    System.out.println("ii2 = " + ii2);
    checkComparisons(ii2, ii1);
}


//-----------------------------------------------------------------------
// i1 < i2
//-----------------------------------------------------------------------
private static final void
checkComparisons(GeneralInv i1, GeneralInv i2){
  boolean dbg = false;
  if(dbg){
  System.out.println("i1.totalOrderCompare(i1) = " +
                     i1.totalOrderCompare(i1));
  System.out.println("i2.totalOrderCompare(i2) = " +
                     i2.totalOrderCompare(i2));
  System.out.println("i1.totalOrderCompare(i2) = " +
                     i1.totalOrderCompare(i2));
  System.out.println("i2.totalOrderCompare(i1) = " +
                     i2.totalOrderCompare(i1));
  }
  assert i1.totalOrderCompare(i1) == 0;
  assert i2.totalOrderCompare(i2) == 0;
  assert i1.totalOrderCompare(i2) == 1;
  assert i2.totalOrderCompare(i1) == -1;
} 
  
  
//-----------------------------------------------------------------------
  // Test chopImpreciseInv
  //-----------------------------------------------------------------------
  public static void testChopImpreciseInv(){
    ImpreciseInv ii1 = null;
    ImpreciseInv ii2 = null;
    ImpreciseInv ii3 = null;
    
    AcceptStamp[] as1 = null;
    AcceptStamp[] as2 = null;
    AcceptStamp[] as3 = null;
    AcceptStamp[] as4 = null;
    AcceptStamp[] as5 = null;
    AcceptVV vv1 = null;
    AcceptVV vv2 = null;
    AcceptVV vv3 = null;
    AcceptVV vv4 = null;
    AcceptVV vv5 = null;

    as1 = new AcceptStamp[4];
    as1[0] = new AcceptStamp(1, new NodeId(200));
    as1[1] = new AcceptStamp(1, new NodeId(300));
    as1[2] = new AcceptStamp(1, new NodeId(400));
    as1[3] = new AcceptStamp(1, new NodeId(500));

    as2 = new AcceptStamp[4];
    as2[0] = new AcceptStamp(2, new NodeId(200));
    as2[1] = new AcceptStamp(2, new NodeId(300));
    as2[2] = new AcceptStamp(2, new NodeId(400));
    as2[3] = new AcceptStamp(2, new NodeId(500));

    as3 = new AcceptStamp[4];
    as3[0] = new AcceptStamp(3, new NodeId(200));
    as3[1] = new AcceptStamp(3, new NodeId(300));
    as3[2] = new AcceptStamp(3, new NodeId(400));
    as3[3] = new AcceptStamp(0, new NodeId(500));

    as4 = new AcceptStamp[4];
    as4[0] = new AcceptStamp(1, new NodeId(200));
    as4[1] = new AcceptStamp(2, new NodeId(300));
    as4[2] = new AcceptStamp(3, new NodeId(400));
    as4[3] = new AcceptStamp(4, new NodeId(500));

    as5 = new AcceptStamp[4];
    as5[0] = new AcceptStamp(5, new NodeId(200));
    as5[1] = new AcceptStamp(5, new NodeId(300));
    as5[2] = new AcceptStamp(5, new NodeId(400));
    as5[3] = new AcceptStamp(5, new NodeId(500));

    vv1 = new AcceptVV(as1);
    vv2 = new AcceptVV(as2);
    vv3 = new AcceptVV(as3);
    vv4 = new AcceptVV(as4);
    vv5 = new AcceptVV(as5);

    AcceptStamp[] as6 = null;
    AcceptVV vv6 = null;
    as6 = new AcceptStamp[3];
    
    as6[0] = new AcceptStamp(1, new NodeId(200));
    as6[1] = new AcceptStamp(1, new NodeId(300));
    as6[2] = new AcceptStamp(1, new NodeId(400));
    vv6 = new AcceptVV(as6);

    AcceptStamp[] as7 = null;
    AcceptVV vv7 = null;
    as7 = new AcceptStamp[3];
    as7[0] = new AcceptStamp(1, new NodeId(200));
    as7[1] = new AcceptStamp(2, new NodeId(300));
    as7[2] = new AcceptStamp(3, new NodeId(400));
    vv7 = new AcceptVV(as7);

    HierInvalTarget hit = HierInvalTarget.makeHierInvalTarget("/*");
    ii1 = new ImpreciseInv(hit, vv1, vv4);
    ii2 = ImpreciseInv.chopImpreciseInv(ii1, vv4);
    assert ii2.equals(ii1);
    ii2 = ImpreciseInv.chopImpreciseInv(ii1, vv3);

    assert ii2.getStartVV().equals(vv6);
    assert ii2.getEndVV().equals(vv7);
    ii2 = ImpreciseInv.chopImpreciseInv(ii1, vv1);
    assert ii2.getStartVV().equals(vv1);
    assert ii2.getEndVV().equals(vv1);
    ii2 = ImpreciseInv.chopImpreciseInv(ii1, vv5);
    assert ii2.equals(ii1);
    ii2 = ImpreciseInv.chopImpreciseInv(ii1, vv7);
    assert ii2.getStartVV().equals(vv6);

    assert ii2.getEndVV().equals(vv7);
  }
  
  public void testBasics(){
  HierInvalTarget hit1 = null;
  HierInvalTarget hit2 = null;
  ImpreciseInv ii1 = null;
  ImpreciseInv ii2 = null;
  AcceptStamp[] as1 = null;
  AcceptStamp[] as2 = null;
  AcceptStamp[] as3 = null;
      

  ByteArrayOutputStream baos = null;
  ByteArrayInputStream bais = null;
  ObjectOutputStream oos = null;
  ObjectInputStream ois = null;

  // Test 1
  // Try a simple invalidate
  try{
    baos = new ByteArrayOutputStream();
    oos = new ObjectOutputStream(baos);
    hit1 = HierInvalTarget.makeHierInvalTarget("/a/b:/a/b/*");
    as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(190, new NodeId(200));
    as1[1] = new AcceptStamp(180, new NodeId(300));
    as2 = new AcceptStamp[2];
    as2[0] = new AcceptStamp(200, new NodeId(200));
    as2[1] = new AcceptStamp(190, new NodeId(300));
    as3 = new AcceptStamp[2];
    as3[0] = new AcceptStamp(100, new NodeId(200));
    as3[1] = new AcceptStamp(190, new NodeId(300));

    ii1 = new ImpreciseInv(hit1,
                           new AcceptVV(as1),
                           new AcceptVV(as2),
                           new AcceptVV(as3));
    //System.out.println("test " + ii1);
    oos.writeObject(ii1);
    oos.flush();
    oos.close();
    baos.flush();
    baos.close();

    bais = new ByteArrayInputStream(baos.toByteArray());
    ois = new ObjectInputStream(bais);
    try{
      ii2 = (ImpreciseInv)(ois.readObject());
    }catch(ClassNotFoundException ce){
      ce.printStackTrace();
      assert false;
    }
    assert(ii1 != ii2);
    assert(ii2.equals(ii1));
    assert(ii1.equals(ii2));
  }catch(IOException e){
    e.printStackTrace();
    System.out.println("" + e);
    assert(false);
  }

  // Test 2
  // Try an empty invalidate
  try{
    baos = new ByteArrayOutputStream();
    oos = new ObjectOutputStream(baos);
    
    hit1 = HierInvalTarget.makeHierInvalTarget("");
    as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(190, new NodeId(200));
    as1[1] = new AcceptStamp(180, new NodeId(300));
    as2 = new AcceptStamp[2];
    as2[0] = new AcceptStamp(200, new NodeId(200));
    as2[1] = new AcceptStamp(190, new NodeId(300));
    as3 = new AcceptStamp[2];
    as3[0] = new AcceptStamp(100, new NodeId(200));
    as3[1] = new AcceptStamp(190, new NodeId(300));

    ii1 = new ImpreciseInv(hit1,
                           new AcceptVV(as1),
                           new AcceptVV(as2),
                           new AcceptVV(as3));
    //System.out.println("test " + ii1);

    oos.writeObject(ii1);
    oos.flush();
    oos.close();
    baos.flush();
    baos.close();

    bais = new ByteArrayInputStream(baos.toByteArray());
    ois = new ObjectInputStream(bais);
    try{
      ii2 = (ImpreciseInv)(ois.readObject());
    }catch(ClassNotFoundException ce){
      ce.printStackTrace();
      assert false;
    }
    assert(ii1 != ii2);
    assert(ii2.equals(ii1));
    assert(ii1.equals(ii2));
  }catch(IOException e){
    e.printStackTrace();
    System.out.println("" + e);
    assert(false);
  }

  // Test 3
  // Try a slightly more complicated invalidate
  try{
    baos = new ByteArrayOutputStream();
    oos = new ObjectOutputStream(baos);
    hit1 = HierInvalTarget.makeHierInvalTarget("/:/*");
    as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(-1, new NodeId(200));
    as1[1] = new AcceptStamp(-1, new NodeId(300));
    as2 = new AcceptStamp[2];
    as2[0] = new AcceptStamp(-1, new NodeId(200));
    as2[1] = new AcceptStamp(-1, new NodeId(300));
    as3 = new AcceptStamp[2];
    as3[0] = new AcceptStamp(-1, new NodeId(200));
    as3[1] = new AcceptStamp(-1, new NodeId(300));

    ii1 = new ImpreciseInv(hit1,
                           new AcceptVV(as1),
                           new AcceptVV(as2),
                           new AcceptVV(as3));
    //System.out.println("test " + ii1);
    oos.writeObject(ii1);
    oos.flush();
    oos.close();
    baos.flush();
    baos.close();

    bais = new ByteArrayInputStream(baos.toByteArray());
    ois = new ObjectInputStream(bais);
    try{
      ii2 = (ImpreciseInv)(ois.readObject());
    }catch(ClassNotFoundException ce){
      ce.printStackTrace();
      assert false;
    }
    assert(ii1 != ii2);
    assert(ii2.equals(ii1));
    assert(ii1.equals(ii2));
  }catch(IOException e){
    e.printStackTrace();
    System.out.println("" + e);
    assert(false);
  }
}
  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(ImpreciseInvUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "ImpreciseInvUnit";
    System.err.print(name + " self test begins...");
    TestRunner tr = new TestRunner();
    tr.doRun(suite());
    System.err.println(name + " self test succeeds");
  }

}

 /** 
 * Temporary implementation of an Interest Set (for testing only)
 
 **/ 
class ISet implements InvalTarget
{

 /** 
 *  Constructor
 
 **/ 
 public ISet()
 {
     // TBD;
 }

 /** 
 *  Temporary
 
 **/ 
 public final Object clone()
 {
     return(new ISet());
 }

 /** 
 *  Temporary
 
 **/ 
 public final InvalTarget getIntersection(InvalTarget t)
 {
     InvalTarget it = null;

     if(t instanceof HierInvalTarget){
         it = new ISet();
     }else if(t instanceof ObjInvalTarget){
         it = t;
     }else{
         assert(false);
     }
     return(it);
 }

 /** 
 *  Temporary
 
 **/ 
 public final InvalTarget getUnion(InvalTarget t, SubscriptionSet ss)
 {
     return(new HierInvalTarget());
 }

 /** 
 *  Temporary
 
 **/ 
 public final boolean intersects(SubscriptionSet ss)
 {
     return(true);
 }

 /** 
 *  Temporary
 
 **/ 
 public final boolean isEmpty()
 {
     return(true);
 }

 /** 
 *  Convery to a string representation
 
 **/ 
 public final String toString()
 {
     return("ISet");
 }

 /** 
 *  Return true if this interest set contains exactly one subdirectory
 
 *  (plus the path from that subdirectory to /).
 
 **/ 
 public boolean containsExactlyOneSubdirectory()
 {
     assert(false); // Not implemented
     return false;
 }

 public int onDiskSize(){
   return 1;
 }

}

//---------------------------------------------------------------------------
/* $Log$*/
//---------------------------------------------------------------------------
