package code;

 /** 
 *  Template for writing JUnit tests. To write the test for class 
 *  Foo, copy this file to FooUnit.java and update as described 
 *  below. 
 **/ 

import junit.textui.TestRunner;
import junit.framework.*;
import java.util.*;
import java.io.*;

import java.io.ObjectInputStream;
import java.io.IOException;
import java.io.EOFException;
import java.io.File;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Vector;
import java.util.Enumeration;

/**
 * TBD: Update class name
 */
public class IncommingConnectionUnit extends TestCase {
  public static final String TEST_ALL_TEST_TYPE = "UNIT";
  protected static boolean verbose = false; // Start/end of test
  protected static boolean vverbose = false; // Test internals
  // private Process rmiregistry;
  
  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public IncommingConnectionUnit (final String s) {
    super (s);
  }


  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
    /*
    //
    // Start the registry
    //
    rmiregistry = Runtime.getRuntime().exec("rmiregistry");
    Env.dprintln(verbose, "rmiregistry started");
    Thread.sleep(2000);
      */
  }

  protected void tearDown() throws Exception{
    /*
    rmiregistry.destroy();
    */
    super.tearDown();
    
  }

  private static void makePractiConfig(long first, int total){
    Config.createEmptyConfig();

    long NODE_1_ID = first;
    int port = 9941;
    String NODE_1_IP = "localhost";
    
    for(int i = 0; i < total; i++){
      
      Config.addOneNodeConfig(new NodeId(NODE_1_ID++),
			      NODE_1_IP,
			    port++,
			    port++,
			    port++,
			    port++,
			    port++,
			    "test" + File.separatorChar + "local-" + 
			    NODE_1_ID + ".db",
			    "/*",
			    -1L,
			    NODE_1_IP,
			    port++,
			    port++,
			    -1,
			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);
    }
        
  }

  //-----------------------------------------------------------------------
  // Test basic functions
  //-----------------------------------------------------------------------
  public void testBasics(){
    Env.verifyAssertEnabled();
    AcceptStamp[] as1 = null;
    AcceptStamp[] as2 = null;
    AcceptStamp[] as3 = null;
    AcceptStamp[] as4 = null;

    AcceptVV vv1 = null;
    AcceptVV vv2 = null;
    AcceptVV vv3 = null;
    AcceptVV vv4 = null;

    PreciseSet ps = null;
    PreciseSet newPS = null;
    PreciseSet newPS2 = null;
    PreciseSet newChildPS = null;
    PreciseSet newChildPS2 = null;

    as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(1, new NodeId(200));
    as1[1] = new AcceptStamp(1, new NodeId(300));

    as2 = new AcceptStamp[2];
    as2[0] = new AcceptStamp(2, new NodeId(200));
    as2[1] = new AcceptStamp(2, new NodeId(300));

    as3 = new AcceptStamp[2];
    as3[0] = new AcceptStamp(3, new NodeId(200));
    as3[1] = new AcceptStamp(3, new NodeId(300));

    vv1 = new AcceptVV(as1);
    vv2 = new AcceptVV(as2);
    vv3 = new AcceptVV(as3);

    ps = new PreciseSet("", "", vv1, vv2);
    newPS = new PreciseSet("apple", "/apple", vv1, vv1);
    newPS2 = new PreciseSet("cherry", "/cherry", vv2, vv2);
    newChildPS = new PreciseSet("banana", "/apple/banana", vv2, vv1);
    
    ps.children.put("apple", newPS);
    ps.children.put("cherry", newPS2);
    newPS.children.put("banana", newChildPS);
      
    assert(ps.getChild("apple") == newPS);
    assert(ps.getChild("cherry") == newPS2);
    assert(ps.getChild("apple").getChild("banana") == newChildPS);

    AllPreciseSets aps = new AllPreciseSets(ps);
    ISStatus isStatus = new ISStatus(aps, null);
    RMIClient rmiClient = new RMIClient();

    NodeId myId = new NodeId(1);
    //String configFile = "test" + File.separatorChar + "IncommingConnectionUnit.config";
    //Config.readConfig(configFile);
    makePractiConfig(0, 2);
    Core fakeCore = new Core(rmiClient, false, true, myId, isStatus, false);
    fakeCore.testSkipRecoverLocalState();
       
    FileInputStream fis = null;
    TaggedInputStream tis = null;
    Object nextInFile = null;
    String fileName = "fakeIncommingStream.tmp";
    
    //prepare CP outputfile for /cherry checkpoint
    int index = 0;
    Vector vec1 = null;

    AcceptStamp[] as0 = new AcceptStamp[3];
    as0[0] = new AcceptStamp(130, new NodeId(100));
    as0[1] = new AcceptStamp(100, new NodeId(200));
    as0[2] = new AcceptStamp(100, new NodeId(300));
    AcceptVV vv0 = new AcceptVV(as0);
    
    index = 0;
    vec1 = new Vector();
    
    vec1.add(index, new PerRangeStateForSend(new ObjId("/cherry"),
                                             0,
                                             5,
                                             new AcceptStamp(128, new NodeId(100))));
    index++;
    vec1.add(index, new Long(RandomAccessState.RAS_SHIP_DONE));
    prepareCPFile(fileName, vec1);

    try{
      new File(fileName).createNewFile();
      fis = new FileInputStream(fileName);
      tis = new TaggedInputStream(fis);
    }catch(Exception e){
      e.printStackTrace();
      assert false;
    }

    IncommingConnection ic = new IncommingConnection(tis, 
                                                     fakeCore, 
                                                     new LocalController(fakeCore),
                                                     null,
                                                     StreamId.makeNewStreamId());

    doApplyImprecise("/water", 200, 0, 100, ic);    
    
    //test addSubscriptionSet
    assert !ISStatus.liesAnywhereUnder(ic.getSubscriptionSet(), new ObjId("/apple"));
    assert !ISStatus.liesAnywhereUnder(ic.getSubscriptionSet(), new ObjId("/apple/dog"));
    ic.advancePrevVV(vv3);
    ic.addSubscriptionSet(SubscriptionSet.makeSubscriptionSet("/apple:/apple/dog"));
    assert newPS.getLiveCons().size() == 1;
    assert newPS.getOtherChildrenLiveCons().size() == 0;
    assert newPS.getMyLpVV().equals(vv1);
    assert newPS.getOtherChildrenLpVV().equals(vv1);
    
    assert newPS.getMyMaxLpVV().equalsIgnoreNegatives(vv3);
    assert newPS.getOtherChildrenMaxLpVV().equals(vv1);

    newChildPS2 = newPS.getChild("dog");
    assert newChildPS2 != null;
    assert newChildPS2.getMyLpVV().equals(vv1);
    assert newChildPS2.getOtherChildrenLpVV().equals(vv1);
    assert newChildPS2.getLiveCons().size() == 1;
    assert newChildPS2.getMyMaxLpVV().equalsIgnoreNegatives(vv3);
    assert newChildPS2.getOtherChildrenMaxLpVV().equalsIgnoreNegatives(vv1);
    assert newChildPS2.getOtherChildrenLiveCons().size() == 0;
    assert ISStatus.liesAnywhereUnder(ic.getSubscriptionSet(), new ObjId("/apple"));
    assert ISStatus.liesAnywhereUnder(ic.getSubscriptionSet(), new ObjId("/apple/dog"));

    as4 = new AcceptStamp[2];
    as4[0] = new AcceptStamp(2, new NodeId(200));
    as4[1] = new AcceptStamp(4, new NodeId(300));
 
    vv4 = new AcceptVV(as4);

    AcceptStamp[] as5 = null;
    AcceptVV vv5 = null;
    
    as5 = new AcceptStamp[2];
    as5[0] = new AcceptStamp(3, new NodeId(200));
    as5[1] = new AcceptStamp(4, new NodeId(300));
 
    vv5 = new AcceptVV(as5);

    //test removeSubscriptionSet
    ic.removeSubscriptionSet(SubscriptionSet.makeSubscriptionSet("/apple:/cherry"), 
                             vv4);

    ///cherry lpvv updated
    assert newPS2.getMyLpVV().equals(vv4);
    assert newPS2.getOtherChildrenLpVV().equals(vv2);
    assert newPS2.getLiveCons().size() == 0;
    assert newPS2.getMyMaxLpVV().equalsIgnoreNegatives(vv4);
    assert newPS2.getOtherChildrenMaxLpVV().equalsIgnoreNegatives(vv2);
    assert newPS2.getOtherChildrenLiveCons().size() == 0;
    assert !ISStatus.liesAnywhereUnder(ic.getSubscriptionSet(), new ObjId("/apple"));
    assert !ISStatus.liesAnywhereUnder(ic.getSubscriptionSet(), new ObjId("/cherry"));
    assert ISStatus.liesAnywhereUnder(ic.getSubscriptionSet(), new ObjId("/apple/dog"));
    
    ///apple/dog the same as before
    assert newChildPS2.getMyLpVV().equals(vv1);
    assert newChildPS2.getOtherChildrenLpVV().equals(vv1);
    assert newChildPS2.getLiveCons().size() == 1;
    assert newChildPS2.getMyMaxLpVV().equalsIgnoreNegatives(vv3);
    assert newChildPS2.getOtherChildrenMaxLpVV().equalsIgnoreNegatives(vv1);
    assert newChildPS2.getOtherChildrenLiveCons().size() == 0;

    // /apple updated
    assert newPS.getLiveCons().size() == 0;
    assert newPS.getOtherChildrenLiveCons().size() == 0;
    
    assert newPS.getMyLpVV().equalsIgnoreNegatives(vv4);
    assert newPS.getOtherChildrenLpVV().equals(vv1);

    //test applyCatchupStreamStartMsg
    ic.removeSubscriptionSet(SubscriptionSet.makeSubscriptionSet("/apple:/cherry"), 
                             vv4);

    ic.resetSubscriptionSet(SubscriptionSet.makeSubscriptionSet("/cherry"));
    assert ic.getPendingSet() == null;
    assert ic.getPendingStartVV() == null;
    SubscriptionSet ss1 = null;
    SubscriptionSet ss2 = null;
    CatchupStreamStartMsg cssm = null;
    ss1 = SubscriptionSet.makeSubscriptionSet("/cherry");
    cssm = new CatchupStreamStartMsg(ss1,
                                     vv1);
                                     
    ic.applyCatchupStreamStartMsg(cssm);//already in the connection
    assert ic.getPendingSet() == null;
    assert ic.getPendingStartVV() == null;
    assert ic.getSubscriptionSet().equals(ss1);
    
    //partially overlapped
    
    assert ic.getPendingSet() == null;
    assert ic.getPendingStartVV() == null;
    ss1 = SubscriptionSet.makeSubscriptionSet("/cherry:/apple");
    
    cssm = new CatchupStreamStartMsg(ss1,
                                     vv1);
    //prevVV is equal or less than lpvv, directly add it.
    ic.resetPrevVV(vv2);
    ic.removeSubscriptionSet(SubscriptionSet.makeSubscriptionSet("/apple:/cherry"), 
                             vv4);
    ic.applyCatchupStreamStartMsg(cssm);
    assert ic.getPendingSet() == null;
    assert ic.getPendingStartVV() == null;
    assert ic.getSubscriptionSet().equals(ss1);
    
    //startVV >= lpvv
    
    ss1 = SubscriptionSet.makeSubscriptionSet("/cherry");
    ss2 = SubscriptionSet.makeSubscriptionSet("/cherry:/apple");
    ic.resetSubscriptionSet(ss1);
    //System.out.println("newPS: " + newPS.getLiveCons().size());
    //System.out.println("newPS2: " + newPS2.getLiveCons().size());
    //System.out.println("--------LpVV:" + fakeCore.getLpVV(ss2));
    ic.advancePrevVV(vv5);
    //System.out.println("=======LpVV:" + fakeCore.getLpVV(ss2));
    ic.removeSubscriptionSet(SubscriptionSet.makeSubscriptionSet("/apple:/cherry"), 
                             vv4);
    cssm = new CatchupStreamStartMsg(ss2,
                                     vv4);

    ic.resetSubscriptionSet(ss1);
    ic.applyCatchupStreamStartMsg(cssm);
    //add part of subset
    //System.out.println("prevVV:" + ic.prevVV);
    //System.out.println("startVV:" + vv4);
    //System.out.println("LpVV:" + fakeCore.getLpVV(ss2));
    //System.out.println("ic.ss:" + ic.getSubscriptionSet());
    assert ic.getPendingSet().equals(ss2);
    assert ic.getSubscriptionSet().equals(ss1);
    assert ic.getPendingStartVV().equals(vv4);
    
    //startvv < lpvv
   
    cssm = new CatchupStreamStartMsg(ss2,
                                     vv3);
    ic.removeSubscriptionSet(SubscriptionSet.makeSubscriptionSet("/apple:/cherry"), 
                             vv4);

    ic.resetPendingSet();
    ic.resetSubscriptionSet(ss1);
    ic.applyCatchupStreamStartMsg(cssm);
    //can't add part of subset
    assert ic.getPendingSet() == null;
    assert ic.getSubscriptionSet().equals(ss1);
    assert ic.getPendingStartVV() == null;
    
    
    // prepare new lpvv
    as4 = new AcceptStamp[2];
    as4[0] = new AcceptStamp(2, new NodeId(100));
    as4[1] = new AcceptStamp(4, new NodeId(300));
 
    vv4 = new AcceptVV(as4);

    as5 = new AcceptStamp[2];
    as5[0] = new AcceptStamp(3, new NodeId(200));
    as5[1] = new AcceptStamp(6, new NodeId(300));
 
    vv5 = new AcceptVV(as5);
    
    as3 = new AcceptStamp[3];
    as3[0] = new AcceptStamp(2, new NodeId(200));
    as3[1] = new AcceptStamp(5, new NodeId(300));
    as3[2] = new AcceptStamp(2, new NodeId(100));
    vv3 = new AcceptVV(as3);
    assert ic.prepareNewLpvv(vv4, vv5).equals(vv3);

    // prepare gapinv
    as1 = new AcceptStamp[3];
    as1[0] = new AcceptStamp(-1, new NodeId(200));
    as1[1] = new AcceptStamp(-1, new NodeId(300));
    as1[2] = new AcceptStamp(-1, new NodeId(100));
    vv1 = new AcceptVV(as1);
    as2 = new AcceptStamp[3];
    as2[0] = new AcceptStamp(2, new NodeId(200));
    as2[1] = new AcceptStamp(5, new NodeId(300));
    as2[2] = new AcceptStamp(2, new NodeId(100));
    vv2 = new AcceptVV(as2);
    as3 = new AcceptStamp[3];
    as3[0] = new AcceptStamp(2, new NodeId(400));
    as3[1] = new AcceptStamp(6, new NodeId(300));
    as3[2] = new AcceptStamp(2, new NodeId(100));
    vv3 = new AcceptVV(as3);

    as4 = new AcceptStamp[2];
    as4[0] = new AcceptStamp(2, new NodeId(400));
    as4[1] = new AcceptStamp(6, new NodeId(300));
    
    vv4 = new AcceptVV(as4);

    as5 = new AcceptStamp[2];
    as5[0] = new AcceptStamp(0, new NodeId(400));
    as5[1] = new AcceptStamp(6, new NodeId(300));
    
    vv5 = new AcceptVV(as5);

    HierInvalTarget hit = HierInvalTarget.makeHierInvalTarget("/*");
    ImpreciseInv ii1 = null;
    ImpreciseInv ii2 = null;
    ii1 = new ImpreciseInv(hit,
                           vv1,
                           vv2);//cvv

    fakeCore.applyInval(ii1, ic.getStreamId());//advance cvv
    ii2 = ic.prepareGapInv(vv2);
    assert ii2 == null;

    ii2 = ic.prepareGapInv(vv3);
    
    assert ii2.getStartVV().equals(vv5);
    assert ii2.getEndVV().equals(vv4);
    
    //applyGI
    //test scenarios:
    // 1. normal precise inv -- prevvv increased, cvv increased
    // 2. normal imprecise inv -- knocked off invaltarget from ss with lpvv increase to max(startvv-1 , prevvv)
    //                         increase prevVV
    // 3. catch up invals to fix imprecise inv of a subset invaltarget -- ss add the subset again
    // 4. catch up cp to fix imprecise inv of another subset invaltarget --  ss add the other subset 
    // 5. catch up invals of a new subset with an imprecise inv in it --> at the end add those all precise
    //                                                             --> check those knock off with imprecise.startvv-1
    
    as1 = new AcceptStamp[3];
    as1[0] = new AcceptStamp(100, new NodeId(100));
    as1[1] = new AcceptStamp(100, new NodeId(200));
    as1[2] = new AcceptStamp(100, new NodeId(300));

    as2 = new AcceptStamp[3];
    as2[0] = new AcceptStamp(200, new NodeId(100));
    as2[1] = new AcceptStamp(200, new NodeId(200));
    as2[2] = new AcceptStamp(200, new NodeId(300));

    as3 = new AcceptStamp[3];
    as3[0] = new AcceptStamp(300, new NodeId(100));
    as3[1] = new AcceptStamp(300, new NodeId(200));
    as3[2] = new AcceptStamp(300, new NodeId(300));

    vv1 = new AcceptVV(as1);
    vv2 = new AcceptVV(as2);
    vv3 = new AcceptVV(as3);
    
    hit = HierInvalTarget.makeHierInvalTarget(":/*");
    ii1 = new ImpreciseInv(hit,
                           vv1,
                           vv1);//cvv

    fakeCore.applyInval(ii1, ic.getStreamId());//advance cvv to 100
    ic.resetPrevVV(fakeCore.getCurrentVV());
    //System.out.println("vv1:" + vv1);
    //System.out.println("ic.getPrevVV():"+ ic.getPrevVV());
    assert ic.getPrevVV().equalsIgnoreNegatives(vv1);
    SubscriptionSet allSet = SubscriptionSet.makeSubscriptionSet(":/apple:/apple/banana:/apple/dog:/cherry");
    ic.addSubscriptionSet(allSet);//add this connection to all ISStatus nodes
    
    assert ic.getPendingSet() == null;
    assert ic.getPendingStartVV() == null;
    assert ic.getSubscriptionSet().equals(allSet);
    
    assert ps.getLiveCons().size() == 1;
    assert newPS.getLiveCons().size() == 1;
    assert newPS2.getLiveCons().size() == 1;
    assert newChildPS.getLiveCons().size() == 1;
    assert newChildPS2.getLiveCons().size() == 1;
    /*
    assert ps.getOtherChildrenLiveCons().size() == 1;
    assert newPS.getOtherChildrenLiveCons().size() == 1;
    assert newPS2.getOtherChildrenLiveCons().size() == 1;
    assert newChildPS.getOtherChildrenLiveCons().size() == 1;
    assert newChildPS2.getOtherChildrenLiveCons().size() == 1;
    */
    assert ps.getMyMaxLpVV().equalsIgnoreNegatives(vv1);
    assert newPS.getMyMaxLpVV().equalsIgnoreNegatives(vv1);
    assert newPS2.getMyMaxLpVV().equalsIgnoreNegatives(vv1);
    assert newChildPS.getMyMaxLpVV().equalsIgnoreNegatives(vv1);
    assert newChildPS2.getMyMaxLpVV().equalsIgnoreNegatives(vv1);
    /*
    assert ps.getOtherChildrenMaxLpVV().equalsIgnoreNegatives(vv1);
    assert newPS.getOtherChildrenMaxLpVV().equalsIgnoreNegatives(vv1);
    assert newPS2.getOtherChildrenMaxLpVV().equalsIgnoreNegatives(vv1);
    assert newChildPS.getOtherChildrenMaxLpVV().equalsIgnoreNegatives(vv1);
    assert newChildPS2.getOtherChildrenMaxLpVV().equalsIgnoreNegatives(vv1);
    */
    //populate every object
    doApplyBound("/", 100, 101, 0, 5, (byte)35, ic);
    doApplyBound("/apple", 100, 102, 0, 5, (byte)36, ic);
    doApplyBound("/cherry", 100, 103, 0, 5, (byte)37, ic);
    doApplyBound("/apple/banana", 100, 104, 0, 5, (byte)38, ic);
    doApplyBound("/apple/dog", 100, 105, 0, 5, (byte)39, ic);
    
    as1 = new AcceptStamp[3];
    as1[0] = new AcceptStamp(105, new NodeId(100));
    as1[1] = new AcceptStamp(100, new NodeId(200));
    as1[2] = new AcceptStamp(100, new NodeId(300));
    vv1 = new AcceptVV(as1);
    
    assert ic.getPrevVV().equalsIgnoreNegatives(vv1);
    assert fakeCore.liesInPreciseIS(new ObjId("/apple"));
    assert fakeCore.liesInPreciseIS(new ObjId("/"));

    doReadBody("/", 0, 5, (byte)35, fakeCore);
    doReadBody("/apple", 0, 5, (byte)36, fakeCore);
    doReadBody("/cherry", 0, 5, (byte)37, fakeCore);
    doReadBody("/apple/banana", 0, 5, (byte)38, fakeCore);
    doReadBody("/apple/dog", 0, 5, (byte)39, fakeCore);
    
    assert ic.getPrevVV().equalsIgnoreNegatives(fakeCore.getCurrentVV());

    //invalid every object with precise invalidate
    doApplyPrecise("/", 100, 106, 0, 5, ic);
    doApplyPrecise("/apple", 100, 107, 0, 5, ic);
    doApplyPrecise("/cherry", 100, 108, 0, 5, ic);
    doApplyPrecise("/apple/banana", 100, 109, 0, 5, ic);
    doApplyPrecise("/apple/dog", 100, 110, 0, 5, ic);
    
    as1 = new AcceptStamp[3];
    as1[0] = new AcceptStamp(110, new NodeId(100));
    as1[1] = new AcceptStamp(100, new NodeId(200));
    as1[2] = new AcceptStamp(100, new NodeId(300));
    vv1 = new AcceptVV(as1);
    
    assert ic.getPrevVV().equalsIgnoreNegatives(vv1);
    //System.out.println("lpVV:" + fakeCore.getLpVV(SubscriptionSet.makeSubscriptionSet("/apple")));
    //System.out.println("cvv: " + fakeCore.getCurrentVV());
    assert fakeCore.liesInPreciseIS(new ObjId("/apple"));
    assert fakeCore.liesInPreciseIS(new ObjId("/"));

    doReadInvalidRange("/", 0, fakeCore);
    doReadInvalidRange("/apple", 0, fakeCore);
    doReadInvalidRange("/cherry", 0, fakeCore);
    doReadInvalidRange("/apple/banana", 0, fakeCore);
    doReadInvalidRange("/apple/dog", 0, fakeCore);
    
    assert ic.getPrevVV().equalsIgnoreNegatives(fakeCore.getCurrentVV());
    
    //apply impreicse inv to knock off :/apple/banana: /cherry
    // -- ic.getSubscriptionSet() remove invaltarget, pendingset = null; prevVV advanced
    //    invalTarget in ISStatus removed the connection, lpvv -> inv.startVV -1
    doApplyImprecise("/apple/banana:/cherry", 100, 120, 130, ic);
    assert fakeCore.liesInPreciseIS(new ObjId("/apple"));
    assert fakeCore.liesInPreciseIS(new ObjId("/apple/dog"));
    assert fakeCore.liesInPreciseIS(new ObjId("/"));
    assert !fakeCore.liesInPreciseIS(new ObjId("/nobody"));
    assert !fakeCore.liesInPreciseIS(new ObjId("/apple/banana"));
    assert !fakeCore.liesInPreciseIS(new ObjId("/cherry"));
    assert ic.getSubscriptionSet().equals(SubscriptionSet.makeSubscriptionSet(":/apple:/apple/dog"));
    assert ic.getPendingSet() == null;
    assert ic.getPendingStartVV() == null;

    as1 = new AcceptStamp[3];
    as1[0] = new AcceptStamp(130, new NodeId(100));
    as1[1] = new AcceptStamp(100, new NodeId(200));
    as1[2] = new AcceptStamp(100, new NodeId(300));
    vv1 = new AcceptVV(as1);

    as2 = new AcceptStamp[3];
    as2[0] = new AcceptStamp(119, new NodeId(100));
    as2[1] = new AcceptStamp(100, new NodeId(200));
    as2[2] = new AcceptStamp(100, new NodeId(300));
    vv2 = new AcceptVV(as2);
    
    assert ic.getPrevVV().equalsIgnoreNegatives(vv1);
    assert fakeCore.getCurrentVV().equalsIgnoreNegatives(vv1);
    assert fakeCore.getLpVV(SubscriptionSet.makeSubscriptionSet("/apple/banana")).equalsIgnoreNegatives(vv2);
    assert fakeCore.getLpVV(SubscriptionSet.makeSubscriptionSet("/cherry")).equalsIgnoreNegatives(vv2);
    assert newPS2.getLiveCons().size()==0;
    assert newChildPS.getLiveCons().size() ==0;
    assert ps.getLiveCons().size() == 1;
    assert newPS.getLiveCons().size() == 1;
    assert newChildPS2.getLiveCons().size() == 1;

    //catch up /apple/banana by log
    SubscriptionSet appleSS = SubscriptionSet.makeSubscriptionSet("/apple");
    SubscriptionSet bananaSS = SubscriptionSet.makeSubscriptionSet("/apple/banana");
    SubscriptionSet cherrySS = SubscriptionSet.makeSubscriptionSet("/cherry");
    cssm = new CatchupStreamStartMsg(bananaSS, vv2);
    ic.applyCatchupStreamStartMsg(cssm);
    assert ic.getPendingSet() == bananaSS;
    assert ic.getPendingStartVV().equalsIgnoreNegatives(vv2);
    doApplyPrecise("/apple/banana", 100, 124, 0, 5, ic);
    doApplyImprecise("/cherry", 100, 125, 129, ic);
    doApplyPrecise("/apple/banana", 100, 130, 0, 5, ic);
    assert ic.getPendingSet() ==bananaSS;
    assert ic.getPendingStartVV().equalsIgnoreNegatives(vv1);
    CatchupStreamEndMsg csem = new CatchupStreamEndMsg();
    ic.applyCatchupStreamEndMsg(cssm);
    
    //apple/banana catched up
    assert ic.getSubscriptionSet().equals(
      SubscriptionSet.makeSubscriptionSet(":/apple:/apple/banana:/apple/dog"));
    
    assert ic.getPrevVV().equalsIgnoreNegatives(vv1);
    assert fakeCore.getCurrentVV().equalsIgnoreNegatives(vv1);
    assert fakeCore.getLpVV(SubscriptionSet.makeSubscriptionSet("/apple/banana")).equalsIgnoreNegatives(vv1);
    assert fakeCore.getLpVV(SubscriptionSet.makeSubscriptionSet("/cherry")).equalsIgnoreNegatives(vv2);
    assert newPS2.getLiveCons().size()==0;
    assert newChildPS.getLiveCons().size() ==1;
    assert ps.getLiveCons().size() == 1;
    assert newPS.getLiveCons().size() == 1;
    assert newChildPS2.getLiveCons().size() == 1;
    assert ic.getPendingSet() == null;
    assert ic.getPendingStartVV() == null;


    
    

    AcceptStamp[] cvvAS = new AcceptStamp[3];
    cvvAS[0] = new AcceptStamp(130, new NodeId(100));
    cvvAS[1] = new AcceptStamp(100, new NodeId(200));
    cvvAS[2] = new AcceptStamp(100, new NodeId(300));
    AcceptVV cvvToSend = new AcceptVV(cvvAS);
    
    
    Vector vecLpVV = new Vector();
    vecLpVV.add(new LPVVRecord("/cherry", cvvToSend, cvvToSend));
    
    //catch up /cherry by cp
    CPStartMsg cpsm = new CPStartMsg(SubscriptionSet.makeSubscriptionSet("/cherry"),
                                     vv2,
				     cvvToSend,
				     vecLpVV);
    try{
      ic.applyCP(tis, cpsm);
    }catch (Exception ie){
      ie.printStackTrace();
      assert false;
    }
    //cherry catched up
    assert ic.getSubscriptionSet().equals(
      SubscriptionSet.makeSubscriptionSet(":/apple:/apple/banana:/apple/dog:/cherry"));
    
    assert ic.getPrevVV().equalsIgnoreNegatives(vv1);
    assert fakeCore.getCurrentVV().equalsIgnoreNegatives(vv1);
    assert fakeCore.getLpVV(SubscriptionSet.makeSubscriptionSet("/apple/banana")).equalsIgnoreNegatives(vv1);
    assert fakeCore.getLpVV(SubscriptionSet.makeSubscriptionSet("/cherry")).equalsIgnoreNegatives(vv1);
    assert newPS2.getLiveCons().size()==1;
    assert newChildPS.getLiveCons().size() ==1;
    assert ps.getLiveCons().size() == 1;
    assert newPS.getLiveCons().size() == 1;
    assert newChildPS2.getLiveCons().size() == 1;
    assert ic.getPendingSet() == null;
    assert ic.getPendingStartVV() == null;


    //make sure normal stream continues
    //invalid every object with precise invalidate
    doApplyPrecise("/", 100, 131, 0, 5, ic);
    doApplyPrecise("/apple", 100, 132, 0, 5, ic);
    doApplyPrecise("/cherry", 100, 133, 0, 5, ic);
    doApplyPrecise("/apple/banana", 100, 134, 0, 5, ic);
    doApplyPrecise("/apple/dog", 100, 135, 0, 5, ic);
    
    as1 = new AcceptStamp[3];
    as1[0] = new AcceptStamp(135, new NodeId(100));
    as1[1] = new AcceptStamp(100, new NodeId(200));
    as1[2] = new AcceptStamp(100, new NodeId(300));
    vv1 = new AcceptVV(as1);
    
    assert ic.getPrevVV().equalsIgnoreNegatives(vv1);
    assert ic.getPrevVV().equalsIgnoreNegatives(fakeCore.getCurrentVV());
    assert fakeCore.liesInPreciseIS(new ObjId("/apple"));
    assert fakeCore.liesInPreciseIS(new ObjId("/"));

    doReadInvalidRange("/", 0, fakeCore);
    doReadInvalidRange("/apple", 0, fakeCore);
    doReadInvalidRange("/cherry", 0, fakeCore);
    doReadInvalidRange("/apple/banana", 0, fakeCore);
    doReadInvalidRange("/apple/dog", 0, fakeCore);

    // catch up invals of a new subset with an imprecise inv in it 
    //      --> at the end add those all precise
    //      --> check those knock off with imprecise.startvv-1
    as1 = new AcceptStamp[3];
    as1[0] = new AcceptStamp(-1, new NodeId(100));
    as1[1] = new AcceptStamp(-1, new NodeId(200));
    as1[2] = new AcceptStamp(-1, new NodeId(300));
    vv1 = new AcceptVV(as1);
    cssm = new CatchupStreamStartMsg(SubscriptionSet.makeSubscriptionSet("/water:/nothing"),
                                     vv1);
    ic.applyCatchupStreamStartMsg(cssm);
    assert ic.getPendingStartVV()!= null;
    assert ic.getPendingSet().equals(SubscriptionSet.makeSubscriptionSet("/water:/nothing"));
    doApplyImprecise("/:/apple/banana:/apple/dog:/apple:/cherry", 100, -1, 135, ic);
    doApplyImprecise("/apple/banana:/apple/dog:/apple:/cherry", 300, -1, 100, ic);
    doApplyPrecise("/water", 200, 80, 0, 5, ic);
    doApplyImprecise("/water", 200, 90, 100, ic);
    csem = new CatchupStreamEndMsg();
    ic.applyCatchupStreamEndMsg(cssm);

    as1 = new AcceptStamp[3];
    as1[0] = new AcceptStamp(135, new NodeId(100));
    as1[1] = new AcceptStamp(100, new NodeId(200));
    as1[2] = new AcceptStamp(100, new NodeId(300));
    vv1 = new AcceptVV(as1);

    as2 = new AcceptStamp[3];
    as2[0] = new AcceptStamp(135, new NodeId(100));
    as2[1] = new AcceptStamp(89, new NodeId(200));
    as2[2] = new AcceptStamp(100, new NodeId(300));
    vv2 = new AcceptVV(as2);
    assert ic.getPrevVV().equalsIgnoreNegatives(vv1);
    assert fakeCore.getCurrentVV().equalsIgnoreNegatives(vv1);
    assert fakeCore.getLpVV(SubscriptionSet.makeSubscriptionSet("/water")).equalsIgnoreNegatives(vv2);
    assert fakeCore.getLpVV(SubscriptionSet.makeSubscriptionSet("/nothing")).equalsIgnoreNegatives(vv1);
    assert ps.getChild("water").getLiveCons().size()==0;
    assert ps.getChild("nothing").getLiveCons().size() ==1;
    assert ps.getLiveCons().size() == 1;
    assert newPS.getLiveCons().size() == 1;
    assert newChildPS2.getLiveCons().size() == 1;
    doReadInvalidRange("/water", 0, fakeCore);

    try{
      
      tis.close();
      fis.close();
    }catch(Exception e){
      assert false;
    }
  }

 /** 
 **/ 
  // unit test helper functions
 /** 
 **/ 

 /** 
 *  doSetBytes 
 **/ 
  private void
  doSetBytes(byte b[], int len, byte value){
    int ii;
    for(ii = 0; ii < len; ii++){
      b[ii] = value;
    }
  }

 /** 
 *  doWriteBound 
 **/ 
  private void 
  doApplyBound(String path, long node, long localStamp, long offset, int len, byte val,
    IncommingConnection ic){
    ObjId id = new ObjId(path);
    ObjInvalTarget oit = new ObjInvalTarget(id, offset, len);
    NodeId nodeId = new NodeId(node);
    AcceptStamp stamp = new AcceptStamp(localStamp, nodeId);
    int ii;
    byte b[] = new byte[len];
    doSetBytes(b, len, val);
    ImmutableBytes ib = new ImmutableBytes(b);
    BoundInval bi = new BoundInval(oit, stamp, ib);
    VVMap startVVs;

    ic.applyGI(bi);
  }

 /** 
 *  doWritePI 
 **/ 
  private void 
  doApplyPrecise(String path, long node, long localStamp, long offset, long len,
    IncommingConnection ic){
    ObjId id = new ObjId(path);
    ObjInvalTarget oit = new ObjInvalTarget(id, offset, len);
    NodeId nodeId = new NodeId(node);
    AcceptStamp stamp = new AcceptStamp(localStamp, nodeId);
    PreciseInv pi = new PreciseInv(oit, stamp);
    VVMap startVVs;
    ic.applyGI(pi);
  }

 /** 
 *  doWriteImprecise 
 **/ 
  private void 
  doApplyImprecise(String path, long node, long localStart, long localEnd,
    IncommingConnection ic){

    HierInvalTarget hit = HierInvalTarget.makeHierInvalTarget(path);
    PreciseSet ps = null;
    boolean isPrecise = true;
    NodeId nodeId = new NodeId(node);
    AcceptStamp start = new AcceptStamp(localStart, nodeId);
    AcceptStamp end = new AcceptStamp(localEnd, nodeId);
    AcceptStamp startStamps[] = new AcceptStamp[1];
    startStamps[0] = start;
    AcceptStamp endStamps[] = new AcceptStamp[1];
    endStamps[0] = end;
    
    AcceptVV startVV = new AcceptVV(startStamps);
    AcceptVV endVV = new AcceptVV(endStamps);
    VVMap startVVs;

    ImpreciseInv ii = new ImpreciseInv(hit,
                                       startVV,
                                       endVV);
    ic.applyGI(ii);
  }
  
 /** 
 *  doReadBody 
 **/ 
  private void 
  doReadBody(String path, long offset, long len, byte val,
    Core core){
    ObjId id = new ObjId(path);
    BodyMsg bm;
    byte b[];
    int ii;
    try{
      bm = core.read(id, offset, len, true, true, true, -1);
      b = bm.getBody().dangerousGetReferenceToInternalByteArray();
      for(ii = 0; ii < len; ii++){
        assert(b[ii] == val);
      }
    }
    catch(Exception e){
      e.printStackTrace();
      assert(false);
    }
  }

 /** 
 *  doReadInvalidRange 
 **/ 
  private void 
  doReadInvalidRange(String path, long offset,
    Core core){
    ObjId id = new ObjId(path);
    try{
      core.read(id, offset, 1, false, false, true, -1);
      assert(false);
    }
    catch(ReadOfInvalidRangeException e){
      // Expected this
      return;
    }
    catch(Exception e){
      e.printStackTrace();
      assert(false);
    }
  }


  public static void
  prepareCPFile(String outputFileName, Vector vec){
    FileOutputStream fos = null;
    TaggedOutputStream tos = null;
    try{
      fos = new FileOutputStream(outputFileName);
      tos = new TaggedOutputStream(fos);
    }catch(Exception e){
      System.err.println("outputstream  error: "
                         + e.toString());
      e.printStackTrace();
      return;
    }
    
    try{
      for(Enumeration e = vec.elements(); e.hasMoreElements();){
        tos.writeObject(e.nextElement());
      }
      tos.close();
      fos.close();
    }catch(Exception eee){
      eee.printStackTrace();
      assert false;
    }
  }


  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(IncommingConnectionUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * usage: java <classname> [-verbose] [-vverbose] [testName]*
   * 
   *   If verbose or vverbose are included, print info to screen
   *
   *   If [testName]* are included, then run test called "test[testName]"
   *   for each such [testName]. E.g., "java IncommingConnectionUnit foo" runs
   *   IncommingConnectionUnit.testfoo() as a TestCase.
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "IncommingConnectionUnit";
    System.err.print(name + " self test begins...");
    //
    // Default: run all tests
    //
    TestSuite ste = new TestSuite();
    Test test;
    boolean doAllTests = true;

    if(s.length > 0){
      int ii;
      for(ii = 0; ii < s.length; ii++){
        if(s[ii].equals("-verbose")){
          verbose = true;
        }
        else if(s[ii].equals("-vverbose")){
          verbose = true;
        }
        else{
          doAllTests = false;
          ste.addTest(new IncommingConnectionUnit("test" + s[ii]));
        }
        
      }
    }
    if(doAllTests){
      test = suite();
    }
    else{
      test = ste;
    }
    TestRunner tr = new TestRunner();
    tr.doRun(test);
    System.err.println(name + " self test succeeds");
    System.exit(0); 
  }

}

//---------------------------------------------------------------------------
/* $Log: IncommingConnectionUnit.java,v $
/* Revision 1.14  2007/11/28 08:11:34  nalini
/* safety policy module and example checked in
/*
/* Revision 1.13  2007/08/05 21:43:14  zjiandan
/* *** empty log message ***
/*
/* Revision 1.12  2007/07/12 17:02:32  zjiandan
/* *** empty log message ***
/*
/* Revision 1.11  2007/06/25 05:21:28  zjiandan
/* Cleanup OutgoingConnection and add unit tests
/* */
//---------------------------------------------------------------------------
