package code;

 /** 
 *  Represent what directories a user is interested in receiving 
 *  precise invalidates for. 
 **/ 
import java.util.Iterator;
import java.util.Collection;
import java.util.Vector;
import java.io.Serializable;

public class InterestRegion implements Immutable, Serializable{

 /** 
 *  Private data 
 **/ 
  private SubscriptionSet rootSS;

 /** 
 *  Constructor 
 **/ 
  public
  InterestRegion(){
    this.rootSS = SubscriptionSet.makeSubscriptionSet("");
  }

 /** 
 *  Constructor 
 **/ 
  public
  InterestRegion(SubscriptionSet newRootSS){
    this.rootSS = newRootSS;
  }

 /** 
 *  Constructor 
 **/ 
  public
  InterestRegion(String irString){
    this.rootSS = SubscriptionSet.makeSubscriptionSet(irString);
  }

 /** 
 *  Constructor 
 **/ 
  public
  InterestRegion(String[] irPaths){
    String completeName = null;

    assert(irPaths.length > 0);
    completeName = irPaths[0];
    for(int i = 1; i < irPaths.length; i++){
      completeName = completeName + ":" + irPaths[i];
    }
    this.rootSS = SubscriptionSet.makeSubscriptionSet(completeName);
  }

 /** 
 *  Clone this object 
 **/ 
  public Object
  clone(){
    // Immutable
    return(this);
  }

 /** 
 *  Return a SubscriptionSet view of this InterestRegion 
 **/ 
  public SubscriptionSet
  makeSubscriptionSet(){
	return(this.rootSS);
  }

 /** 
 *  Return true if according to this InterestRegion object we are 
 *  interested in any subset of "ps". 
 **/ 
  public boolean
  containsAnyOfPS(PreciseSet ps){
    String fullName = null;
    FileNameTokenizer fnt = null;
    String token = null;
    boolean done = false;
    boolean decided = false;
    boolean contained = false;
    SubscriptionSet ss = null;
    SubscriptionSet ssChild = null;
    Collection childValues = null;

    fullName = ps.getFullName();
    fnt = new FileNameTokenizer(fullName);
    token = fnt.getNextToken();
    assert((token != null) && (this.rootSS.getName().equals(token)));
    ss = this.rootSS;
    done = false;
    decided = false;
    while(!done){
      token = fnt.getNextToken();
      if(token != null){
        ss = ss.getChild(token);
        if(ss == null){
          contained = false;
          decided = true;
          done = true;
        }else if(ss.containsChildren()){
          contained = true;
          decided = true;
          done = true;
        }
      }else{
        contained = false;
        decided = false;
        done = true;
      }
    }
    if(!decided){
      assert(ss != null);
      assert(ss.getName().equals(ps.getName()));
      assert(!ss.containsChildren());
      if(ss.containsSelf()){
        contained = true;
      }else{
        // If this tree has children that ps does not,
        // since ps is a tree of excluded children,
        // the region of directory space represented by
        // this InterestRegion overlaps that of ps.
        childValues = ss.getChildValues();

        contained = false;
        for(Iterator i = childValues.iterator(); !contained && i.hasNext();){
          ssChild = (SubscriptionSet)i.next();
          if(ps.getChild(ssChild.getName()) == null){
            contained = true;
          }
        }
      }
    }
    return(contained);
  }

 /** 
 *  Add a new directory to this InterestRegion object 
 **/ 
  public void
  addRegion(String dirName){
    SubscriptionSet ss = null;
    ss = SubscriptionSet.makeSubscriptionSet(dirName);
    this.rootSS = this.rootSS.getCompleteUnion(ss);
  }

 /** 
 *  Make a PreciseSet tree that mirrors the InterestRegion tree 
 **/ 
  public void
  makeMirrorPS(PreciseSet rootPS){
    assert(this.rootSS.getName().equals(""));
    assert(rootPS.getName().equals(""));
    InterestRegion.makeMirrorPS(this.rootSS, rootPS);
  }

 /** 
 *  Recursive helper function to makeMirrorPS(PreciseSet rootPS) 
 **/ 
  private static void
  makeMirrorPS(SubscriptionSet ss, PreciseSet ps){
    Collection childValues = null;
    SubscriptionSet ssChild = null;
    PreciseSet psChild = null;

    assert(ss.getName().equals(ps.getName()));
    childValues = ss.getChildValues();
    for(Iterator i = childValues.iterator(); i.hasNext();){
      ssChild = (SubscriptionSet)i.next();
      psChild = ps.getChild(ssChild.getName());
      if(psChild == null){
        psChild = ps.split(ssChild.getName());
      }
      InterestRegion.makeMirrorPS(ssChild, psChild);
    }
  }

 /** 
 *  Used for debugging 
 **/ 
  public String
  toString(){
    return(this.rootSS.toString());
  }

  
 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    //unit test moved to InterestRegionUnit.java
  }

 /** 
 *  Used for testing 
 **/ 
  public SubscriptionSet getRoot(){
    return this.rootSS;
  }
  
}
//---------------------------------------------------------------------------
/* $Log: InterestRegion.java,v $
/* Revision 1.10  2007/06/25 05:21:28  zjiandan
/* Cleanup OutgoingConnection and add unit tests
/* */
//---------------------------------------------------------------------------