package code;

 /** 
 *  Unit test for InterestRegionUnit
 
 **/ 

import junit.textui.TestRunner;
import junit.framework.*;
import java.util.*;
import java.io.*;

/**
 * TBD: Update class name
 */
public class InterestRegionUnit extends TestCase {
  public static final String TEST_ALL_TEST_TYPE = "UNIT";
  protected static boolean verbose = false; // Start/end of test
  protected static boolean vverbose = false; // Test internals
  // private Process rmiregistry;
  
  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public InterestRegionUnit (final String s) {
    super (s);
  }


  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
    /*
    //
    // Start the registry
    //
    rmiregistry = Runtime.getRuntime().exec("rmiregistry");
    Env.dprintln(verbose, "rmiregistry started");
    Thread.sleep(2000);
    */
  }

  protected void tearDown() throws Exception{
    /*
    rmiregistry.destroy();
    */
    super.tearDown();
    
  }



 /** 
 *  Test basic functions
 
 **/ 
  public void testBasics(){
    Env.verifyAssertEnabled();
    if(verbose){
      System.out.println("Testing InterestRegion.java...");
    }

    makePractiConfig();
    InterestRegion ir = null;
    PreciseSet ps = null;
    PreciseSet ps1 = null;
    PreciseSet ps2 = null;
    PreciseSet ps3 = null;
    PreciseSet ps4 = null;
    Vector vec = null;

    
    
    // Test addRegion
    ir = new InterestRegion();
    assert((ir.getRoot() != null) && (ir.getRoot().getName().equals("")));
    assert((ir.getRoot().containsSelf()) && (!ir.getRoot().containsChildren()));
    ir.addRegion("/a/b/*");
    assert(ir.getRoot().getChild("a") != null);
    assert((ir.getRoot().getChild("a")).getChild("b") != null);
    assert(((ir.getRoot().getChild("a")).getChild("b")).containsChildren());
    assert(!((ir.getRoot().getChild("a")).getChild("b")).containsSelf());

    // Test containsAnyOfPS()
    ps = new PreciseSet("a", "/a/a");
    assert(!ir.containsAnyOfPS(ps));
    ps = new PreciseSet("a", "/a");
    assert(ir.containsAnyOfPS(ps));
    ps = new PreciseSet("b", "/a/b");
    assert(ir.containsAnyOfPS(ps));
    ps = new PreciseSet("d", "/a/b/c/d");
    assert(ir.containsAnyOfPS(ps));

    // Test makeMirrorPS
    // Make sure that an InterestRegion with "/a/b" is correctly mirrored.
    ir = new InterestRegion();
    ir.addRegion("/a/b");
    ps = new PreciseSet("", "");
    ir.makeMirrorPS(ps);
    vec = ps.getChildrenVector();
    assert(vec.size() == 1);
    ps1 = (PreciseSet)vec.get(0);
    assert(ps1.getFullName().equals("/a"));
    vec = ps1.getChildrenVector();
    assert(vec.size() == 1);
    ps2 = (PreciseSet)vec.get(0);
    assert(ps2.getFullName().equals("/a/b"));
    vec = ps2.getChildrenVector();
    assert(vec.isEmpty());

    // Make sure that an InterestRegion with "/a/b/*" is correctly mirrored.
    ir.addRegion("/a/b/*");
    ps = new PreciseSet("", "");
    ir.makeMirrorPS(ps);
    vec = ps.getChildrenVector();
    assert(vec.size() == 1);
    ps1 = (PreciseSet)vec.get(0);
    assert(ps1.getFullName().equals("/a"));
    vec = ps1.getChildrenVector();
    assert(vec.size() == 1);
    ps2 = (PreciseSet)vec.get(0);
    assert(ps2.getFullName().equals("/a/b"));
    vec = ps2.getChildrenVector();
    assert(vec.isEmpty());

    // Make sure that an InterestRegion with "/a/b/*:/c/d/e/f/*:/g/h" is
    // correctly mirrored.
    ir.addRegion("/a/b/*");
    ir.addRegion("/c/d/e/f/*");
    ir.addRegion("/g/h");
    ps = new PreciseSet("", "");
    ir.makeMirrorPS(ps);
    // Check the first level
    vec = ps.getChildrenVector();
    assert(vec.size() == 3);
    ps1 = (PreciseSet)vec.get(0);
    ps2 = (PreciseSet)vec.get(1);
    ps3 = (PreciseSet)vec.get(2);
    assert((ps1.getFullName().equals("/a") ||
            ps1.getFullName().equals("/c") ||
            ps1.getFullName().equals("/g")) &&
           (ps2.getFullName().equals("/a") ||
            ps2.getFullName().equals("/c") ||
            ps2.getFullName().equals("/g")) &&
           (ps3.getFullName().equals("/a") ||
            ps3.getFullName().equals("/c") ||
            ps3.getFullName().equals("/g")) &&
           (!ps1.getFullName().equals(ps2.getFullName())) &&
           (!ps1.getFullName().equals(ps3.getFullName())) &&
           (!ps2.getFullName().equals(ps3.getFullName())));
    // Check the first branch
    ps1 = ps.getChild("a");
    assert(ps1 != null);
    ps2 = ps1.getChild("b");
    assert(ps2 != null);
    assert((ps1.getChildrenVector()).size() == 1);
    assert((ps1.getChildrenVector()).get(0) == ps2);
    assert((ps2.getChildrenVector()).isEmpty());
    // Check the second branch
    ps1 = ps.getChild("c");
    assert(ps1 != null);
    ps2 = ps1.getChild("d");
    assert(ps2 != null);
    ps3 = ps2.getChild("e");
    assert(ps3 != null);
    ps4 = ps3.getChild("f");
    assert(ps4 != null);
    assert((ps1.getChildrenVector()).size() == 1);
    assert((ps1.getChildrenVector()).get(0) == ps2);
    assert((ps2.getChildrenVector()).size() == 1);
    assert((ps2.getChildrenVector()).get(0) == ps3);
    assert((ps3.getChildrenVector()).size() == 1);
    assert((ps3.getChildrenVector()).get(0) == ps4);
    assert((ps4.getChildrenVector()).isEmpty());
    // Check the third branch
    ps1 = ps.getChild("g");
    assert(ps1 != null);
    ps2 = ps1.getChild("h");
    assert(ps2 != null);
    assert((ps1.getChildrenVector()).size() == 1);
    assert((ps1.getChildrenVector()).get(0) == ps2);
    assert((ps2.getChildrenVector()).isEmpty());

    if(verbose){
      System.out.println("...Finished");
    }
  }

  private static void makePractiConfig(){
    Config.createEmptyConfig();
    long NODE_0_ID = 0;
    long NODE_1_ID = 1;
    long NODE_2_ID = 2;
    long NODE_3_ID = 3;
    long NODE_4_ID = 4;
    String NODE_0_IP = "localhost";
    String NODE_1_IP = "localhost";
    String NODE_2_IP = "localhost";
    String NODE_3_IP = "localhost";
    String NODE_4_IP = "localhost";
    Config.addOneNodeConfig(new NodeId(NODE_0_ID),
                            NODE_0_IP,
                            9988,
                            9989,
                            9991,
                            9992,
                            9990,
                            "test" + File.separatorChar + "local-" + 
			    NODE_0_ID + ".db",
                            "/*",
                            -1L,
                            NODE_0_IP,
                            9993,
                            9994,
                            -1,
  			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);
 
   Config.addOneNodeConfig(new NodeId(NODE_1_ID),
			   NODE_1_IP,
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "local-" + 
			   NODE_1_ID+".db",
			   "/*",
			   -1L,
			   NODE_1_IP,
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);
   Config.addOneNodeConfig(new NodeId(NODE_2_ID),
			   NODE_2_IP,
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "local-" + 
			   NODE_2_ID+".db",
			   "/*",
			   -1L,
			   NODE_2_IP,
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);

   Config.addOneNodeConfig(new NodeId(NODE_3_ID),
			   NODE_3_IP,
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "local-" + 
			   NODE_3_ID+".db",
			   "/*",
			   -1L,
			   NODE_3_IP,
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);
    
   
   
   
   Config.addOneNodeConfig(new NodeId(NODE_4_ID),
			   NODE_4_IP,
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "local-" + 
			   NODE_4_ID+".db",
			   "/*",
			   -1L,
			   NODE_4_IP,
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);
   //Config.writeToFile(configPath);
  }

  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(InterestRegionUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * usage: java <classname> [-verbose] [-vverbose] [testName]*
   * 
   *   If verbose or vverbose are included, print info to screen
   *
   *   If [testName]* are included, then run test called "test[testName]"
   *   for each such [testName]. E.g., "java InterestRegionUnit foo" runs
   *   InterestRegionUnit.testfoo() as a TestCase.
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "InterestRegionUnit";
    System.err.print(name + " self test begins...");
    //
    // Default: run all tests
    //
    TestSuite ste = new TestSuite();
    Test test;
    boolean doAllTests = true;

    if(s.length > 0){
      int ii;
      for(ii = 0; ii < s.length; ii++){
        if(s[ii].equals("-verbose")){
          verbose = true;
        }
        else if(s[ii].equals("-vverbose")){
          verbose = true;
        }
        else{
          doAllTests = false;
          ste.addTest(new InterestRegionUnit("test" + s[ii]));
        }
        
      }
    }
    if(doAllTests){
      test = suite();
    }
    else{
      test = ste;
    }
    TestRunner tr = new TestRunner();
    tr.doRun(test);
    System.err.println(name + " self test succeeds");
    System.exit(0); 
  }

}

//---------------------------------------------------------------------------
/* $Log: InterestRegionUnit.java,v $
/* Revision 1.1  2007/06/25 05:25:04  zjiandan
/* *** empty log message ***
/* */
//---------------------------------------------------------------------------