package code;

 /** 
 *  Represents an "Interest Set"; i.e. regions of interest for which a 
 *  node requires invalidate messages 
 **/ 
public interface InterestSet extends Immutable
{
    /*
      note: we use interest sets as hash keys, so make sure comparison and
      hash do what are expected!
    */

    public Object clone();

 /** 
 *  Return true if this interest set contains exactly one subdirectory 
 *  (plus the path from that subdirectory to /). 
 **/ 
    public boolean containsExactlyOneSubdirectory();
    public String toString();
}

/* $Log: InterestSet.java,v $
/* Revision 1.9  2005/10/13 00:24:23  zjiandan
/* remove Config.getMy* fixed Garbage Collection and Checkpoint exchange code
/*
/* Revision 1.8  2004/07/28 14:27:35  dahlin
/* Added sanity checks for immutable objects
/*
/* Revision 1.7  2004/05/13 18:49:17  dahlin
/* Clean SDIMSController by moving SpanningTree directory out as separate class (rather than using raw SDIMSInterface)
/*
/* Revision 1.6  2004/05/09 20:09:14  dahlin
/* Updated unit tests for WorkQueue, TimeoutQueue, TimeoutQueueWorker, DirectoryInterestSet, SubscribeInvalRequest, InvalSpanningList, AcceptStamp, NodeId, and AcceptVV
/*
/* Revision 1.5  2004/05/04 06:26:05  nayate
/* Minor modification (indentation)
/*
/* Revision 1.4  2004/04/21 17:37:41  zjiandan
/* Miner Change to make UpdateLog.java compile successfully.
/*
/* Revision 1.3  2004/04/16 18:53:22  nayate
/* Stub implementations that compile + minor fixes
/*
/* Revision 1.2  2004/04/15 20:04:25  nayate
/* New Makefile; added provision to allow CVS to append file modification
/* logs to files.
/* */
