package code;

 /** 
 *  Used to iterate through invalidate messages in a list 
 **/ 
import javax.naming.TimeLimitExceededException;
import java.io.IOException;
import java.util.Iterator;

public class InvalIterator
{
  
  public static final boolean useNewIterator = Core.useNewIterator;
  
  private Iterator<SingleWriterInval> iter = null;
  private Object pendingNextEventO = null;
  /*
   * An invalIterator is guaranteed to return a sequence
   * of invalidation messages that ensure a causally
   * consistent view of data for the receiver. In particular,
   * we send every invalidation in the log whose timestamp
   * exceeds the startVV of the iterator.
   */
  private UpdateLog causalLog;
  private CounterVV currentVV;   // We have sent a causal stream
  // up to currentVV

  private long unbindCounter; // Hint of which unbind messages
  private long debargoCounter;//Hint of which debargo messages
  // are in the "past"
  private SubscriptionSet ss; //set of objects what to be precise

  private long maxAccumulateForceMS; // Want to force propagation
  //i.e. the maximum time to accumulate nonoverlapping invalidates into 
  // one imprecise invalidate

  private GeneralInv accumulatedImprecise;//current accumulated impreciseInval
  // for non-overlapping invalidates

  public static final boolean dbg = false;
  //constance for handlenextEvent cases
  //private static final int 
    
  public static final boolean dbgSubscribeBWUnit = false;
  public InvalIterator(){
  }

 /** 
 *  Constructor 
 **/ 
  public InvalIterator(VV startVV_,
                       SubscriptionSet ss_,
                       long unbindCounter_,
                       long debargoCounter_,
                       long maxAccumulateForceMS_,
                       long maxSendDelayMS_,
                       UpdateLog log_)
    
    {
      this.currentVV = new CounterVV(startVV_);
      this.unbindCounter = unbindCounter_;
      this.debargoCounter = debargoCounter_;
      this.ss = (SubscriptionSet) ss_.clone();
      assert maxSendDelayMS_ <=0;//not support accumulate across overlapping inv.
      assert (maxSendDelayMS_<=0)||(maxAccumulateForceMS_ <= maxSendDelayMS_);
      this.maxAccumulateForceMS = maxAccumulateForceMS_;
      this.causalLog = log_;

      //assert !causalLog.getInMemOmitVV().includesAnyPartOf(currentVV);
      //
      //getNext() will check this and throw OmittedVVException if this statement is false
      //if(causalLog.getInMemOmitVV().includesAnyPartOf(currentVV)){
      //  throw new OmittedVVException();
      //}
      
      this.accumulatedImprecise = null;
      
      if(useNewIterator){
        iter = this.causalLog.makeInMemLogIterator((AcceptVV)startVV_);
      }
    }
    
 /** 
 *  Constructor -- temp  removed later 
 **/ 
  public InvalIterator(VV startVV_,
                       SubscriptionSet ss_,
                       long unbindCounter_,
                       long maxAccumulateForceMS_,
                       long maxSendDelayMS_,
                       UpdateLog log_) 
    {
      this.currentVV = new CounterVV(startVV_);
      this.unbindCounter = unbindCounter_;
      this.debargoCounter = Long.MAX_VALUE;
      this.ss = (SubscriptionSet) ss_.clone();
      assert maxSendDelayMS_ <=0;//not support accumulate across overlapping inv.
      assert (maxSendDelayMS_<=0)||(maxAccumulateForceMS_ <= maxSendDelayMS_);
      this.maxAccumulateForceMS = maxAccumulateForceMS_;
      this.causalLog = log_;

      
      assert !causalLog.getInMemOmitVV().includesAnyPartOf(currentVV);
      this.accumulatedImprecise = null;
      if(useNewIterator){
        iter = this.causalLog.makeInMemLogIterator(this.currentVV.cloneAcceptVV());
      }
    }
    
  static boolean printone = true;
 /** 
 *  Advance CurrentVV to reduce redundant invals. 
 **/ 
  public synchronized void advanceCVV(VV newVV){
    if(printone){
      Env.tbd("need new mechanisms other than the InvalIteratorFilter "
              + "to avoid the redundant invalidations when there's a ring "
              + "in the inval subscription topology."
              + " because advanceCVV will falsely advance incommingConnection.prevVV"
              + " while the incommingConnection.subscriptionSet misses "
              + "some preciseInv in between");
      printone = false;
    }
    
    this.currentVV.advanceTimestamps(newVV);
  }

 /** 
 *  Handle nextEvent to decide next step. 
 *  
 *  if nextevent = unbindMsg|debargoMsg|overlapping Inv 
 *        if (accumulatedImpreciseInv != null) return accumulatedImpreciseInv 
 *        else return nextevent 
 *   
 *  if nextevent = nonoverlapping Inv 
 *     start accumulate and return null 
 *  
 **/ 
  private synchronized Object 
    handleNextEvent(Object nextEventO){
      //handle next event
      Object ret = null;
      if( nextEventO instanceof UnbindMsg){  
	if(accumulatedImprecise != null){
	  // Return what has come before; And clear the accumulatedImprecise
	  // next call will see same unbindMsg
	  ret = accumulatedImprecise;
	  accumulatedImprecise = null;
	  pendingNextEventO = nextEventO;
	  return ret;
	}
	unbindCounter++; // Consume the message
	
	ret = nextEventO;
	return ret;

      }else if( nextEventO instanceof DebargoMsg){
	if(accumulatedImprecise != null){
	  // Return what has come before; And clear the accumulatedImprecise
	  // next call will see same unbindMsg
	  ret = accumulatedImprecise;
	  accumulatedImprecise = null;
	  pendingNextEventO = nextEventO;
	  return ret;
	}
	
	debargoCounter++; // Consume the message
	
	ret = nextEventO;
	return ret;
	
    }else if (((GeneralInv)nextEventO).isEmbargoed()){
      //
      // embargoed write shouldn't be accumulated in an impreciseInv.
      // therefore we send the accumulatedimpreciseInv first if any
      // the next call of InvalIterator.getNext() will return 
      // this embargoed invalidate
      //
      assert nextEventO instanceof PreciseInv;
      PreciseInv pi = (PreciseInv)nextEventO;

      if(accumulatedImprecise != null){
	// Return what has come before; And clear the accumulatedImprecise
	// next call will see same unbindMsg
	ret = accumulatedImprecise;
	accumulatedImprecise = null;
	pendingNextEventO = nextEventO;
	return ret;
      }
		
      currentVV.advanceTimestamps(pi.getEndVV());
      
      //original statement
      //return bi;
      ret = pi;
      return ret;

    }else if (nextEventO instanceof GeneralInv){
      GeneralInv nextEvent = (GeneralInv)nextEventO;
      
      if(nextEvent.getInvalTarget().intersects(ss)){
	if(accumulatedImprecise != null){
	  // Return what has come before; And clear the accumulatedImprecise
	  // next call will see same unbindMsg
	  ret = accumulatedImprecise;
	  accumulatedImprecise = null;
	  pendingNextEventO = nextEventO;
	  return ret;
	}
        
        currentVV.advanceTimestamps(nextEvent.getEndVV());	
        ret = nextEvent;
        return ret;
	
      }else{ // No intersection

        if ( accumulatedImprecise == null ){
          accumulatedImprecise = (GeneralInv)nextEvent.clone();
          
        }else{
	  if (dbg){
	    Env.dprintln(dbg, "InvalIterator::handleNextEvent() accumu:" + accumulatedImprecise);
	    Env.dprintln(dbg,"    nextEvent:" + nextEvent);
	    Env.dprintln(dbg,"    ss:" + this.ss);
	  }  
          accumulatedImprecise =(ImpreciseInv)accumulatedImprecise.newUnion(nextEvent, 
									    this.ss);
        }
       
        currentVV.advanceTimestamps(nextEvent.getEndVV());
        ret = null;
        return ret;
      }

    }else{
      assert(false):"InvalIterator.handleNextEvent(): Unknown event";
      return null;
    }
    
  }
    

 /** 
 *  Get the next invalidate such that it exceeds current StartVV 
 *   
 *  Simple policy here: 
 *  Send invalidations from IS immediately 
 *  Accumulate invalidations from outside interest 
 *  set into imprecise invals (but make sure to send 
 *  them in causal order before any later invalidations 
 *  from IS!) 
 *   
 *  return next causal invalidate. 
 *  return null on either of the follwing two scenarios:  
 *       (1) no more invalidate 
 *       (2) the omitVV advanced cvv, i.e. next causal invalidate  
 *           might be garbage collected, therefore no more available. 
 *           this stream can not progress as it can no long garantee 
 *           causal order. Therefore has to stop. 
 *  
 **/ 
  public Object getNext(long timeoutForNextEvent)
    throws OmittedVVException, IOException{
    long lastGetNextTime = System.currentTimeMillis(); 
    long timeToStopAccumulate = lastGetNextTime + this.maxAccumulateForceMS;
    if(timeToStopAccumulate <0){
      timeToStopAccumulate = Long.MAX_VALUE;
    }
    Object nextEventO = null;
    accumulatedImprecise = null;

    while(timeToStopAccumulate > lastGetNextTime){ // Keep going until something to send
      
      //get next event
      try{
        if(!useNewIterator){
          nextEventO = causalLog.getNext(unbindCounter, 
                                         debargoCounter,
                                         currentVV.cloneAcceptVV(), 
                                         timeoutForNextEvent);
          //System.out.println("****\n"+ ((SingleWriterInval)(nextEventO)).toString() + "\n");
          lastGetNextTime = System.currentTimeMillis();
        }else{
          if(pendingNextEventO != null){
            nextEventO = pendingNextEventO;
            pendingNextEventO = null;
          }else{//we need use the pendingNextEventO
            //because the new InMemLogIterator.getNext() is stateful, it can
            //only get one item once. While in the InvalIterator, it keeps cvv
            //which will allow the log.getNext(cvv) to get the same item again.
            nextEventO = iter.next();
          }
          if(nextEventO==null){
            try{
              Thread.sleep(timeoutForNextEvent);//simulate the original timeout
            }catch(InterruptedException e){
              e.printStackTrace();
            }
            nextEventO = iter.next();
            if(nextEventO == null){
              if(dbg){
                System.out.println("--- no new inval. log: " + causalLog.toString());
                System.out.println("iter: " + iter.toString());
              }
              throw new TimeLimitExceededException("End of log");
            }
          }
          //System.out.println("****\n"+ ((SingleWriterInval)(nextEventO)).toString() + "\n");
          lastGetNextTime = System.currentTimeMillis();
        }
      }catch(TimeLimitExceededException t){		
	if(accumulatedImprecise != null){
	  
	  if(dbgSubscribeBWUnit){
	    if(accumulatedImprecise.isPrecise()){
	      Env.dprintln(dbgSubscribeBWUnit, "InvalIterator(" + this.ss +")" 
			   + ":getNext(" + timeoutForNextEvent
			   + ") return nonOverlapping preciseInv 1 :" 
			   + accumulatedImprecise);
	    }
	  }
	  return accumulatedImprecise;
	}else{
	  //throw new TimeLimitExceededException("No more invalidate.");
	  return null;
	}
	
      }catch(OmittedVVException oe){
	// return the accumulated ImpreciseInv if exists
	// the immidiate next call will catch the same oe and
	// with nep.accumulatedImprecise == null;
	// therefore forword the oe to the caller.
	if(accumulatedImprecise != null){
	  //reset timeout for next imprecise
          
	  if(dbgSubscribeBWUnit){
	    if(accumulatedImprecise.isPrecise()){
	      Env.dprintln(dbgSubscribeBWUnit, "InvalIterator(" + this.ss + ")" 
			   + ":getNext(" + timeoutForNextEvent
			   + ") return nonOverlapping preciseInv 2:" 
			   + accumulatedImprecise);
	    }
	  }
	  return accumulatedImprecise;
	}else{
	  throw oe;
	}
	
      }
      
      Object ret = handleNextEvent(nextEventO);
     
      if (ret != null) {
	if(dbgSubscribeBWUnit){
	  // print the preciseInv about to send which does not intersect the ss
	  if(ret instanceof PreciseInv){
	    PreciseInv pi = (PreciseInv)(ret);
	    if (!pi.getInvalTarget().intersects(ss)){
	      Env.dprintln(dbgSubscribeBWUnit, "InvalIterator(" + this.ss + ")" 
			   + ":getNext(" + timeoutForNextEvent 
			   + ") return nonOverlapping preciseInv 3:" 
			   + ret);
	    }
	  }
	}
	return ret;
	
      } else {
	continue;
      }
      
    }//while
    
    //accumulation time out
    //send any accumulated imprecise invalidate if any
    if (accumulatedImprecise != null) {
      if(dbgSubscribeBWUnit){
	// print the preciseInv about to send which does not intersect the ss
	if(accumulatedImprecise instanceof PreciseInv){
	  PreciseInv pi = (PreciseInv)(accumulatedImprecise);
	  if (!pi.getInvalTarget().intersects(ss)){
	    Env.dprintln(dbgSubscribeBWUnit, "InvalIterator(" + this.ss + ")" 
			 + ":getNext(" + timeoutForNextEvent 
			 + ") return nonOverlapping preciseInv 4 :accumulation timeout" 
			 + accumulatedImprecise);
	  }
	}
      }
      return accumulatedImprecise;
    }else{
      if(dbgSubscribeBWUnit){
	Env.dprintln(dbgSubscribeBWUnit, "InvalIterator(" + this.ss + ", " 
		     + this.maxAccumulateForceMS + ")" 
		     + ":getNext(" + this.currentVV 
		     + ") accumulation timeout" );
      }
      return null;
    }
    
  }//method
  
 /** 
 *  Return currentVV 
 **/ 
  public AcceptVV getCurrentVV(){    
    return currentVV.cloneAcceptVV();
  }

 /** 
 *  Return subscriptionset 
 **/ 
  public SubscriptionSet getSubscriptionSet(){    
    return ss;
  }

 /** 
 *  ****** callback ********* start	 
 **/ 
  
 /** 
 *  Add new subscription set to this subscription set 
 **/ 
  public synchronized void addSubscriptionSet(SubscriptionSet newSS){    
    this.ss = this.ss.getCompleteUnion(newSS);
  }

 /** 
 *  Remove a sub-subscription set from this subscription set 
  // Note: "/a/*" remove "/a/b" will actually result in an empty SubscriptionSet
  **/
  public synchronized void removeSubscriptionSet(SubscriptionSet newSS){
    try{
      this.ss = this.ss.remove(newSS, true);
    }catch(IllegalRemoveSubscriptionSetException e){
      assert false : ("" + e);
    }
  }
  
  //-------------------------------------------------------------------------
  // ****** callback ********* end	
  //-------------------------------------------------------------------------  

  public String getLogStr(){
    Env.performanceWarning("Printing log is expensivve."
        + "It should not be called unless debuging.");
    return causalLog.toString();
  }
  
  /**
   * Return a string representation -- for testing
   **/
  public String toString(){
    String str = null;
    str = "InvalIterator: cvv = " + this.currentVV.toString() 
      + " is = " + this.ss.toString();  
    return str;
  }
  

}//class


//---------------------------------------------------------------------------
/* $Log: InvalIterator.java,v $
/* Revision 1.44  2007/08/05 04:43:54  zjiandan
/* SocketServer shutdown quietly
/*
/* Revision 1.43  2007/06/25 05:21:28  zjiandan
/* Cleanup OutgoingConnection and add unit tests
/*
/* Revision 1.42  2007/04/12 17:09:32  zjiandan
/* fix across unit test mem leak.
/*
/* Revision 1.41  2007/04/11 07:18:33  zjiandan
/* Fix SubscribeBWUnit test.
/*
/* Revision 1.40  2007/04/02 21:11:38  zjiandan
/* snapshort for sosp2007.
/*
/* Revision 1.39  2007/03/16 07:10:18  zjiandan
/* fixed OutgoingConnection unittest.
/*
/* Revision 1.38  2007/03/15 21:58:31  dahlin
/* Added experimetn to test BW for subscribe for SOSP paper
/**/
//---------------------------------------------------------------------------
