package code;

import java.util.*;

 /** 
 *  To enable InvalIterator to filter redundant invalidates 
 **/ 
public class InvalIteratorFilter
{
  HashMap invalIters;
  final boolean on;
    
 /** 
 *  Constructor 
 **/ 
  public InvalIteratorFilter(boolean on){
    this.invalIters = new HashMap();
    this.on = on; 
  }

 /** 
 *  put an InvalIterator into invalIters with key of nodeId 
 **/ 
  public synchronized void add(NodeId nodeId, InvalIterator ii){
    if (!on) return;
    //invoked when creating a new invaliterator
    Vector iters = null;
    if (invalIters.containsKey(nodeId)){
      iters = (Vector)(invalIters.get(nodeId));
      //          System.err.println("Multiple connection created for: " + nodeId);
    }else {
      assert iters == null;
      iters = new Vector();
      //            System.err.println("First connection created for: " + nodeId);
    }
    iters.add(ii);
    invalIters.put(nodeId, 
		   iters);
  }
    
 /** 
 *  put an InvalIterator into invalIters with key of nodeId 
 **/ 
  public synchronized void add(NodeId nodeId, CatchupInvalIterator ii){
    if (!on) return;
    //invoked when creating a new invaliterator
    Vector iters = null;
    if (invalIters.containsKey(nodeId)){
      iters = (Vector)(invalIters.get(nodeId));
      //          System.err.println("Multiple connection created for: " + nodeId);
    }else {
      assert iters == null;
      iters = new Vector();
      //            System.err.println("First connection created for: " + nodeId);
    }
    iters.add(ii);
    invalIters.put(nodeId, 
		   iters);
  }
    
 /** 
 *  remove an InvalIterator out of invalIters 
 **/ 
  public synchronized void remove(NodeId nodeId, InvalIterator ii){
    if (!on) return;
    //invoked when destroying a new invaliterator
    Vector iters = (Vector)invalIters.get(nodeId);
    if (iters != null){
      iters.removeElement(ii);
      //            System.err.println("One connection removed for: " + nodeId);
      if (iters == null){
	invalIters.remove(nodeId);
	//              System.err.println("All connection removed for: " + nodeId);
      }
    } else invalIters.remove(nodeId);
  } 
    
 /** 
 *  remove an InvalIterator out of invalIters 
 **/ 
  public synchronized void remove(NodeId nodeId, CatchupInvalIterator ii){
    if (!on) return;
    //invoked when destroying a new invaliterator
    Vector iters = (Vector)invalIters.get(nodeId);
    if (iters != null){
      iters.removeElement(ii);
      //            System.err.println("One connection removed for: " + nodeId);
      if (iters == null){
	invalIters.remove(nodeId);
	//              System.err.println("All connection removed for: " + nodeId);
      }
    } else invalIters.remove(nodeId);
  } 

 /** 
 *  advance invaliterator startvv 
 **/ 
  public synchronized void advanceVV(NodeId nodeId, VV vv){
    if (!on) return;
    Vector iters = (Vector)invalIters.get(nodeId);
    if (iters != null){
      //          System.err.println("Advancing VV " + vv + " for: " + nodeId);
      Enumeration e = iters.elements();
      while(e.hasMoreElements()){
	//InvalIterator ii = (InvalIterator)e.nextElement();
	Object ii = e.nextElement();
	    
            
	if(ii instanceof InvalIterator){
	  ((InvalIterator)ii).advanceCVV(vv);
	}else {
	  assert ii instanceof CatchupInvalIterator;
	  ((CatchupInvalIterator)ii).advanceCVV(vv);
	}
      }
    }
  }

  

 /** 
 *  Test 
 **/ 
  public static void main(String[] args){
	
    InvalIterator i1 = new InvalIterator(new CounterVV(),
					     
					 SubscriptionSet.makeSubscriptionSet("/1"),
					 -1,
					 20,
					 0,
					 null);
    InvalIterator i2 = new InvalIterator(new CounterVV(),
					     
					 SubscriptionSet.makeSubscriptionSet("/2"),
					 -1,
					 20,
					 0,
					 null);
    InvalIterator i3 = new InvalIterator(new CounterVV(),
					     
					 SubscriptionSet.makeSubscriptionSet("/3"),
					 -1,
					 20,
					 0,
					 null);
    InvalIteratorFilter iif = new InvalIteratorFilter(true);
    iif.add(new NodeId(1), i1);
    iif.add(new NodeId(2), i2);
    iif.add(new NodeId(1), i3);
	
    AcceptStamp[] as1 = new AcceptStamp[3];
    as1[0] = new AcceptStamp(11, new NodeId(1));
    as1[1] = new AcceptStamp(22, new NodeId(2));
    as1[2] = new AcceptStamp(44, new NodeId(4));

    AcceptStamp[] as2 = new AcceptStamp[1];
    as2[0] = new AcceptStamp(33, new NodeId(3));
	
    AcceptStamp[] as3 = new AcceptStamp[1];
    as3[0] = new AcceptStamp(55, new NodeId(3));

    AcceptVV vv1 = new AcceptVV(as1);
    AcceptVV vv2 = new AcceptVV(as2);
    AcceptVV vv3 = new AcceptVV(as3);
	
    iif.advanceVV(new NodeId(1), vv1);
    iif.advanceVV(new NodeId(2), vv2);
	
    System.out.println(i1);
    System.out.println(i2);
    System.out.println(i3);

    iif.remove(new NodeId(1), i1);
    iif.advanceVV(new NodeId(1), vv2);
    System.out.println("after remove");
    System.out.println(i1);
    System.out.println(i3);

    iif.remove(new NodeId(2), i2);
    iif.remove(new NodeId(1), i3);
    iif.advanceVV(new NodeId(1), vv3);
    System.out.println(i3);
	
    iif.add(new NodeId(1), i2);
    iif.advanceVV(new NodeId(1), vv3);
    System.out.println(i2);
  }
}

/* $Log: InvalIteratorFilter.java,v $
/* Revision 1.8  2007/08/05 04:43:54  zjiandan
/* SocketServer shutdown quietly
/*
/* Revision 1.7  2007/03/07 20:39:07  zjiandan
/* add InvalIterator Filter.
/*
   /* Revision 1.6  2005/03/10 19:38:55  lgao
   /* *** empty log message ***
   /*
   /* Revision 1.5  2005/03/10 18:49:00  lgao
   /* *** empty log message ***
   /*
   /* Revision 1.4  2005/03/01 10:40:35  nayate
   /* First successful compilation
   /*
   /* Revision 1.3  2005/01/13 20:55:40  zjiandan
   /* Reorganized sosp experiments files into sosp subdirectory under experiments.
   /*
   /* Revision 1.2  2004/05/25 07:36:39  zjiandan
   /* Minor changes.
   /*
   /* Revision 1.1  2004/05/24 05:43:15  zjiandan
   /* Filter InvalIterator
   /* */













