package code;

import code.security.ChainingHash;

 /** 
 *  Represent one entry in an inval list 
 **/ 
public class InvalListItem
{
  private InvalListItem older;
  private InvalListItem newer;
  private SingleWriterInval inv;
  
  private ChainingHash chainedHash;

 /** 
 *  Constructor 
 **/ 
  public
  InvalListItem(SingleWriterInval inv_){
    this.inv = inv_;
    this.older = null;
    this.newer = null;
  }

  public boolean
  isDummy(){
    return inv.getInvalTarget().isEmpty();
  }
 /** 
 *  Note -- caller must hold lock for any public 
 *  method 
 **/ 

 /** 
 *  Replace a bound invalidate with an unbound one 
 **/ 
  void
  replaceBoundWithUnbound(UnbindMsg unbind){
    BoundInval bInv = null;
    InvalTarget invTarget = null;
    MultiObjPreciseInv mopi = null;
    MultiObjPreciseInv replaceMOPI = null;

    assert((this.inv instanceof BoundInval) ||
           (this.inv instanceof MultiObjPreciseInv));
    if(this.inv instanceof BoundInval){
      bInv = (BoundInval)this.inv;
      invTarget = bInv.getInvalTarget();
      assert(invTarget.equals(unbind.getInvalTarget()));
      assert(invTarget instanceof ObjInvalTarget);
      this.inv = new PreciseInv((ObjInvalTarget)invTarget,
                                bInv.getAcceptStamp(),
                                bInv.getRTAcceptStamp(),
                                false);
    }else{
      mopi = (MultiObjPreciseInv)this.inv;
      replaceMOPI = mopi.cloneRemoveBoundEntry(unbind.getInvalTarget());
      this.inv = replaceMOPI;
    }
  }
  
 /** 
 *  debargo an embargoed invalidate 
 **/ 
  void
  debargo(){
    PreciseInv bInv = null;
    InvalTarget invTarget = null;

    assert(inv instanceof PreciseInv);
    bInv = (PreciseInv)inv;
    invTarget = bInv.getInvalTarget();
    assert(invTarget instanceof ObjInvalTarget);
    assert(bInv.isEmbargoed());
    this.inv = new PreciseInv((ObjInvalTarget)invTarget,
                              bInv.getAcceptStamp(),
                              bInv.getRTAcceptStamp(),
                              false);
  }

 /** 
 *  Set the "older" reference 
 **/ 
  public final void
  setOlder(InvalListItem o){
    this.older = o;
  }

 /** 
 *  Set the "newer" reference 
 **/ 
  public final void
  setNewer(InvalListItem n){
    this.newer = n;
  }

 /** 
 *  Set the "inv" referece 
 **/ 
  public final void
  setInv(SingleWriterInval inv){
    assert this.inv.getStart() == inv.getStart();
    this.inv = null;
    
    this.inv = inv;
  }

 /** 
 *  Return the "newer" reference 
 **/ 
  public final InvalListItem
  getNewer(){
    return(this.newer);
  }

 /** 
 *  Return the "older" reference 
 **/ 
  public final InvalListItem
  getOlder(){
    return(this.older);
  }

 /** 
 *  Return the stored invalidate message 
 **/ 
  public final SingleWriterInval
  getInv(){
    return(this.inv);
  }

 /** 
 *  Show the whole list 
 **/ 
  public final void
  showList(){
    InvalListItem cur = this;

    assert(cur != null);
    //get the first item
    while(cur.getOlder() != null){
      cur = cur.getOlder();
    }

    Env.printDebug("Current List is:");
    //print one by one
    while(cur !=null){
      Env.printDebug("" + cur.getInv());
      cur = cur.getNewer();
    }
    return;
  }

 /** 
 *  Return a string representation 
 **/ 
  public final String
  toString(){
    String str = null;
    InvalListItem cur = this;

    assert(cur != null);
    str = ">> ";
    //get the first item
    while(cur.getOlder() != null){
      cur = cur.getOlder();
    }

    //print one by one
    while(cur != null){
      str += cur.getInv() +"\n";
      cur = cur.getNewer();
    }
    str += "<<";
    return str;
  }
  
  public ChainingHash getChainHash(){
	return this.chainedHash;
  }
  
  public void putChainHash(ChainingHash h){
	  this.chainedHash = h;
  }
    
 /** 
 *  estimate this item's memory size: 4(reference)*3 + inv.memSize 
 *                                   +8(object overhead) + 4 (align to 8*) 
 *                                   = 24 
 **/ 
  public long
  memSize(){
    return 24 + this.inv.memSize();
  }

 /** 
 *  Used for Unit testing 
 **/ 
  public static void
  main(String[]args){
    //test1 basic funtionalities
    Env.printDebug(" InvalListItem self test...");
    Env.printDebug("Pass All InvalListItem Unit Test!:)");
    System.exit(0);
  }
}

//---------------------------------------------------------------------------
/* $Log: InvalListItem.java,v $
/* Revision 1.18  2006/04/08 06:10:06  nayate
/* Formatting changes
/*
/* Revision 1.17  2006/04/04 15:59:59  nayate
/* Added the ability to (1) delay invalidates, and (2) support transactional updates.
/*
/* Revision 1.16  2005/07/18 05:10:22  zjiandan
/* Embargoed Writes etc. features implementation plus
/* log overhead measurement with disk size and in-memory size.
/*
/* Revision 1.15  2005/06/08 20:09:03  dahlin
/* *** empty log message ***
/*
/* Revision 1.14  2005/02/28 23:03:34  nayate
/* Modified for new code
/*
/* Revision 1.13  2005/02/28 23:00:28  nayate
/* Modified for new code
/*
/* Revision 1.12  2004/07/28 20:18:25  dahlin
/* encapsulated byte[] bodies in ImmutableBytes for safety
/*
/* Revision 1.11  2004/05/20 01:51:28  nayate
/* Replaced "System.out.println" with "Env.printDebug"
/*
/* Revision 1.10  2004/05/12 19:08:41  zjiandan
/* Add UpdateLog self test.
/*
/* Revision 1.9  2004/04/29 02:01:46  zjiandan
/* Fix small bugs for wrong assertion. Add new test interface for updatelog.
/*
/* Revision 1.8  2004/04/26 20:59:51  zjiandan
/* Finished UpdateLog and partially tested(InterestSet intersect not complete yet
/* waiting for the local interface to finish design of InterstSet).
/* TodoList: Test Parallel InvalIterators and Inserters.
/*
/* Revision 1.7  2004/04/22 20:41:39  zjiandan
/* Min change to make the test automatically
/*
/* Revision 1.6  2004/04/22 19:01:07  zjiandan
/* Fully Tested
/*
/* Revision 1.5  2004/04/21 17:37:41  zjiandan
/* Miner Change to make UpdateLog.java compile successfully.
/*
/* Revision 1.4  2004/04/16 18:53:22  nayate
/* Stub implementations that compile + minor fixes
/*
/* Revision 1.3  2004/04/16 18:02:59  zjiandan
/* Add Timestamp.java VVIterator.java VVIteratorToken.java
/* Modified BodyMsg BoundInval InvalListItem so that get InvalListItem compiled
/*
/* Revision 1.2  2004/04/15 20:04:25  nayate
/* New Makefile; added provision to allow CVS to append file modification
/* logs to files.
/* */
//---------------------------------------------------------------------------
