package code;

//package utils.junit;

import junit.textui.TestRunner;
import junit.framework.*;
import java.util.*;

/**
 * TBD: Update class name
 */
public class InvalListItemUnit extends TestCase {
  public static final String TEST_ALL_TEST_TYPE = "UNIT";
  
  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public InvalListItemUnit (final String s) {
    super (s);
  }


  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
    /* 
     * TBD: Insert other fixture code here
     * e.g., this.objectUnderTest = new ClassToBeTested(...);
     */
  }

  protected void tearDown() throws Exception{
    /* 
     * TBD: Insert other fixture cleanup code here
     */
    super.tearDown();
  }

  public void testMain(){
	final boolean debugging = false;
	   
       	byte[] bdy1 = null;
	BoundInval bi1 = null;
	BoundInval bi2 = null;

	bdy1 = new byte[5];
	bdy1[0] = 10;
	bdy1[1] = 9;
	bdy1[2] = 8;
	bdy1[3] = 7;
	bdy1[4] = 6;
        ImmutableBytes body1 = new ImmutableBytes(bdy1);
		
	bi1 = new BoundInval(new ObjId("obj1"),
			     10,
			     body1.getLength(),
			     new AcceptStamp(190, new NodeId(200)),
			     body1);
   
	bi2 = new BoundInval(new ObjId("obj1"),
			     10,
			     body1.getLength(),
			     new AcceptStamp(193, new NodeId(200)),
			     body1);
   
	PreciseInv pi1 = new PreciseInv(new ObjInvalTarget(new ObjId("obj1"), 10, 20),
					new AcceptStamp(191, new NodeId(200)));

	PreciseInv pi2 = new PreciseInv(new ObjInvalTarget(new ObjId("obj1"), 10, 20),
					new AcceptStamp(192, new NodeId(200)));

	PreciseInv pi3 = new PreciseInv(new ObjInvalTarget(new ObjId("obj1"), 10, 20),
					new AcceptStamp(192, new NodeId(200)));

	InvalListItem li1 = new InvalListItem(bi1);//500
	InvalListItem li2 = new InvalListItem(pi1);//501
	InvalListItem li3 = new InvalListItem(pi2);//UNCOMMITTED
	InvalListItem li4 = new InvalListItem(bi2);//503
   
	if (debugging){
	    li1.showList();
	    li2.showList();
	    li3.showList();
	    li4.showList();
	}
   
	//test Set*
	li1.setNewer(li2);
	li2.setOlder(li1);
	li2.setNewer(li3);
	li3.setOlder(li2);
	li3.setNewer(li4);
	li4.setOlder(li3);
   
	if (debugging) li1.showList();
	assert( (li1.getOlder() == null)
		&& (li1.getNewer().getNewer().getNewer().getNewer() ==null));
			
	assert( (li4.getNewer() == null)
		&& (li4.getOlder().getOlder().getOlder().getOlder() ==null));
			
//	Env.printDebug("Pass Test 0");
	//---------------------------------------------------------------------------------
   
	li3.setInv(pi3);

	if (debugging) li4.showList();
	assert( (li1.getOlder() == null)
		&& (li1.getNewer().getNewer().getNewer().getNewer() == null));
			
	assert( (li4.getNewer() == null)
		&& (li4.getOlder().getOlder().getOlder().getOlder() ==null));
   
//	Env.printDebug("Pass Test 1");
   
	//---------------------------------------------------------------------------------
   
	//test replaceBoundWithUnbound
	if (debugging) Env.printDebug("test replaceBoundWithUnbound");
	li1.replaceBoundWithUnbound(new UnbindMsg(bi1.getObjInvalTarget(),
                                                  bi1.getAcceptStamp()));
	li4.replaceBoundWithUnbound(new UnbindMsg(bi2.getObjInvalTarget(),
                                                  bi2.getAcceptStamp()));
   
	if (debugging) li1.showList();
	assert(!(li1.getInv() instanceof BoundInval));
	assert(!(li4.getInv() instanceof BoundInval));
   
	//li2.replaceBoundWithUnbound();//assert should fail
	//li3.replaceBoundWithUnbound();//assert should fail
   
//	Env.printDebug("Pass Test 2");
	//--------------------------------------------------------------------------------
   
	//Stress test
	li1.setNewer(li4.getOlder().getNewer());
	li4.setOlder(li1);
	if (debugging) li1.showList();
	assert((li1.getOlder() == null)
		&& (li1.getNewer().getNewer() == null));
	assert( (li4.getNewer() == null)
		&& (li4.getOlder().getOlder() == null));

  }
  
  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(InvalListItemUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "InvalListItemUnit";
    System.err.print(name + " self test begins...");
    TestRunner tr = new TestRunner();
    tr.doRun(suite());
    System.err.println(name + " self test succeeds");
  }

}
