package code;

/* InvalStreamReceiver
 *
 *   Listen to the InvalStream port, create worker threads to 
 *   process incomming invalidation subscriptions streams.
 *   
 *
 * (C) Copyright -- See the file COPYRIGHT for additional details
 */
 

import code.security.*;
import code.signedVV.RIncomingInvalConnection;

import java.net.Socket;
import java.net.ServerSocket;
import java.net.SocketException;
import java.io.ObjectInputStream;
import java.io.IOException;

public class InvalStreamReceiver extends Thread{
  public static final boolean useNewIterator = Core.useNewIterator;

  private static boolean dbg = false;
  private Core core;
  private Controller controller;
  private boolean shutdown;
  private ServerSocket ss = null;
  private Thread me = null;

 /** 
 *  Constructor 
 **/ 
  public InvalStreamReceiver(Core core, Controller controller){    
    this.core = core;
    this.controller = controller;
    this.shutdown = false;
  }

  public void shutdown(){
    shutdown = true;
    if (ss != null){
      try{
        ss.close();// this call will make any thread currently blocked in accept()
        // throw a SocketException
      }catch(IOException ioe){
        System.err.println(" InvalStreamReceiver shutting down ignore Exception: " 
            +ioe.toString());
      }
      ss = null;
    }
  }
  static boolean warnedHB = false;
 /** 
 *  Main thread method 
 **/ 
  public void run(){
    Socket connection = null;
    TaggedInputStream tis = null;
    IncommingConnection t = null;
    IncommingInvalConnection tt = null;
    StreamId newStreamId = null;

    if( dbg ){
      Env.dprintln(dbg, "InvalStreamReceiver::run on port " 
          + Config.getPortInval(core.getMyNodeId()));
    }

    try{
      try{
        if(OutgoingConnection.USE_HEARTBEATS){
          ss = new HeartbeatServerSocket(Config.getPortInval(core.getMyNodeId()));
        }else{
          if(dbg && !warnedHB){
            Env.warn("InvalReciver -- heartbeats turned off");
            warnedHB = true;
          }
          ss = new ServerSocket(Config.getPortInval(core.getMyNodeId()));
        }
      }
      catch(IOException f){
        Env.sprinterrln("InvalReceiver cannot open server socket on port " 
            + Config.getPortInval(core.getMyNodeId()) + ": " + f);
        assert(false);
        return;
      }
      int i =0;
      while(!shutdown){
        try{
          connection = ss.accept(); // Should get a HeartbeatSocket

          connection.setTcpNoDelay(true);
          tis = new TaggedInputStream(connection.getInputStream());
          newStreamId = StreamId.makeNewStreamId();

          if(useNewIterator){
            if(SangminConfig.securityLevel >=
              SangminConfig.SIGNATURE){
            	if(SecureRMIServerImpl.useNewConnectionClasses){
                    tt = new SecureNewIncomingInvalConnection(tis,
                            this.core,
                            this.controller,
                            connection,
                            newStreamId);
            		
            	}else{
                    tt = new SecureIncomingInvalConnection(tis,
                            this.core,
                            this.controller,
                            connection,
                            newStreamId);
            		
            	}
            }else if(SangminConfig.securityLevel == SangminConfig.SIGNEDVV){
              tt = new RIncomingInvalConnection(tis,
                  this.core,
                  this.controller,
                  connection,
                  newStreamId);
            }else{
              tt = new IncommingInvalConnection(tis,
                  this.core,
                  this.controller,
                  connection,
                  newStreamId);
            }

            if(dbg){
              Env.dprintln(dbg, "DBG node " + core.getMyNodeId() 
                  + " InvalStreamReceiver create IncommingConnection on port" 
                  + Config.getPortInval(core.getMyNodeId()) );
            }

            tt.startWorker();
          }else{
            if(SangminConfig.securityLevel > 
            SangminConfig.NONE){
              t = new SecureIncomingConnection(tis,
                  this.core,
                  this.controller,
                  connection,
                  newStreamId);
            }else{
              t = new IncommingConnection(tis,
                  this.core,
                  this.controller,
                  connection,
                  newStreamId);
            }
            if(dbg){
              Env.dprintln(dbg, "DBG node " + core.getMyNodeId() 
                  + " InvalStreamReceiver create IncommingConnection on port" 
                  + Config.getPortInval(core.getMyNodeId()) );
            }

            t.startWorker();
          }


        }catch(IOException e){ 
          if(!shutdown){
            Env.warn("InvalStreamReceiver thread exception" + e +
            " dropping this request and continuing");
          }
        }
      }
      if(dbg){
        System.out.println("================Inval Stream receiver stops =============");
      }
    }
    finally{
      if(ss != null){
        try{
          if( dbg ){
            Env.dprintln(dbg, "InvalStreamReceiver::close port " 
                + Config.getPortInval(core.getMyNodeId()));
          }

          ss.close();
        }
        catch(IOException sdf){
        }
        ss = null;
      }
//    if(t != null){
//    t.interruptWorker();
//    t = null;
//    }
    }
  }
}
//---------------------------------------------------------------------------
/* $Log: InvalStreamReceiver.java,v $
/* Revision 1.13  2007/08/05 04:43:54  zjiandan
/* SocketServer shutdown quietly
/*
/* Revision 1.12  2007/07/12 17:02:32  zjiandan
/* *** empty log message ***
/*
/* Revision 1.11  2007/07/11 22:06:45  zjiandan
/* *** empty log message ***
/*
/* Revision 1.10  2007/07/11 19:08:07  zjiandan
/* clean IncommingConnection
/*
/* Revision 1.9  2007/06/29 01:01:41  zjiandan
/* *** empty log message ***
/*
/* Revision 1.8  2007/04/02 21:11:38  zjiandan
/* snapshort for sosp2007.
/*
/* Revision 1.7  2007/03/06 18:25:51  zjiandan
/* Add optimization for CatchupInvalIterator, fixed SubscriptionSet, HierInvalTarget
/* and P2Runtime problems. Add aways split when receiving subtree ISStatus in Checkpoint.
/*
/* Revision 1.6  2006/09/12 22:18:05  dahlin
/* Working to get the unit tests to all run. Up to RandomAccessState now go through. Note that to encourage people to run RASUnit, I have changed the parameters to --quick-- versions that are less extensive tests.
/*
/* Revision 1.5  2006/09/01 15:59:01  dahlin
/* Added test of core recovery. It works -- including log replay.
/*
/* Revision 1.4  2006/08/31 17:32:18  dahlin
/* Synchronized StreamId::makeNewStreamId()
/*
/* Revision 1.3  2006/08/16 21:26:18  dahlin
/* PicShareUnit test works on linux, too!
/*
/* Revision 1.2  2006/04/21 03:21:42  zjiandan
/* Clean SubscribeInvalWorker.
/*
/* Revision 1.1  2006/04/20 03:52:53  zjiandan
/* Callbacks merged with runTime.
/* */
//---------------------------------------------------------------------------
