package code;

 /** 
 *  InvalTarget: Represents entities that can be invalidated 
 **/ 
import java.io.Serializable;

public interface InvalTarget extends Serializable, Cloneable, Immutable
{

 /** 
 *  Return true if this intersects ss 
 **/ 
  public boolean intersects(SubscriptionSet ss);

 /** 
 *  Return the intersected region 
 *  NOTE: We must adhere to the following rules: 
 *    (1) Intersection(ObjInvalTarget, HierInvalTarget) = ObjInvalTarget 
 *    (2) Intersection(ObjInvalTarget, ObjInvalTarget) is undefined 
 *           (unless they are equal) 
 *    (3) Intersection(HierInvalTarget, HierInvalTarget) = HierInvalTarget 
 *    (4) Empty inval targets must be stored in imprecise invalidates 
 **/ 
  public InvalTarget getIntersection(InvalTarget it);

 /** 
 *  Return the union of two regions. The union must obey the rule 
 *  that it will try to keep all invalidates in "ss" as precise as 
 *  possible. 
 *  NOTE: We try to stay as precise as possible, so when taking the 
 *  union of two ObjInvalTargets we try to return another ObjInvalTarget 
 **/ 
  public InvalTarget getUnion(InvalTarget it, SubscriptionSet ss);

 /** 
 *  Return true if this inval target is empty 
 **/ 
  public boolean isEmpty();
 /** 
 *  Return true if the passed-in object is equal to this 
 **/ 
  public boolean
  equals(Object obj);
  
  public int onDiskSize();
}
