package code;
 /** 
 *  LPVVRecord: <pathName, mylpvv, myChildLpVV) 
 **/ 
import java.io.Serializable;
public class LPVVRecord implements Serializable{

 /** 
 *  Data members 
 **/ 
  private final String name;
  private final AcceptVV lastPreciseVV;
  private final AcceptVV childrenLpVV;
  
 /** 
 *  Constructor 
 **/ 
  public
  LPVVRecord(String pathName, AcceptVV newLastPreciseVV, AcceptVV newCurrentVV){
    this.name = pathName;
    this.lastPreciseVV = newLastPreciseVV;
    this.childrenLpVV = newCurrentVV;
  }

 /** 
 *  Return the last precise VV 
 **/ 
  public AcceptVV
  getLpVV(){
    return this.lastPreciseVV;
  }

 /** 
 *  Return the childrenLpVV 
 **/ 
  public AcceptVV
  getChildrenLpVV(){
    return this.childrenLpVV;
  }

 /** 
 *  Return the current VV 
 **/ 
  public String
  getPathName(){
    return name;
  }
  
 /** 
 *  Clone this object 
 **/ 
  public Object
  clone(){
    return(new LPVVRecord(new String(name),
                          new AcceptVV(this.lastPreciseVV),
                          new AcceptVV(this.childrenLpVV)));
  }

 /** 
 *  Return true if this lpvvRecord is equal to the given lpvvRecord 
 **/ 
  public final boolean
  equals(Object o){
    boolean ret = false;
    if (o instanceof LPVVRecord){
      LPVVRecord lr = (LPVVRecord)o;
      ret = (this.name.equals(lr.name)&&
             
             ((this.lastPreciseVV == null) && (lr.getLpVV() == null)||
              ((this.lastPreciseVV != null) && (lr.getLpVV() != null) &&
               (this.lastPreciseVV.equalsIgnoreNegatives(lr.getLpVV())))) &&
             
              ((this.childrenLpVV == null) && (lr.getChildrenLpVV() == null)||
              ((this.childrenLpVV != null) && (lr.getChildrenLpVV() != null) &&
               (this.childrenLpVV.equalsIgnoreNegatives(lr.getChildrenLpVV()))))); 
             
    }else{
      ret = false;
    }
    return ret;
  }
  
 /** 
 *  Return a String representation of this object 
 **/ 
  public String
  toString(){
    return("LPVVRecord:(" + this.name + ", " + this.lastPreciseVV + ", " + this.childrenLpVV + ")");
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    LPVVRecord isr1 = null;
    LPVVRecord isr2 = null;
    AcceptVV vv1 = null;
    AcceptVV vv2 = null;
    AcceptStamp[] as1 = null;
    AcceptStamp[] as2 = null;

    Env.verifyAssertEnabled();
    System.out.println("Testing LPVVRecord...");
     // Set vv1 to [("1", 10), ("2", 20)]
    as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(10, new NodeId(1));
    as1[1] = new AcceptStamp(20, new NodeId(2));
    vv1 = new AcceptVV(as1);
    // Set vv2 to [("1", 15), ("2", 25)]
    as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(15, new NodeId(1));
    as1[1] = new AcceptStamp(25, new NodeId(2));
    vv2 = new AcceptVV(as1);
    
    LPVVRecord lr1 = new LPVVRecord("lr1", vv1, null);
    LPVVRecord lr2 = new LPVVRecord("lr1", vv2, vv1);
    LPVVRecord lr3 = new LPVVRecord("lr12", vv1, vv2);
    LPVVRecord lr4 = new LPVVRecord("lr1", vv1, null);
    assert !lr1.equals(lr2);
    assert !lr1.equals(lr3);
    assert lr1.equals(lr1);
    assert lr1.equals(lr4);
    System.out.println("...Finished");
  }

}

//---------------------------------------------------------------------------
/* $Log: LPVVRecord.java,v $
/* Revision 1.1  2006/04/20 03:52:53  zjiandan
/* Callbacks merged with runTime.
/* */
//---------------------------------------------------------------------------
