package code;
 /** 
 *  Make a local controller Object 
 **/ 
public class LocalController implements Controller
{
  private static final boolean dbg = true;

  Core _core;
  
 /** 
 *  Constructor 
 **/ 
    public LocalController()
    {
     this._core = null;
    }

    public LocalController(Core core) {
      this._core = core;
    }
 /** 
 *  Fake method 
 **/ 
    public void informInvalStreamInitiated(NodeId senderNodeId, 
					   SubscriptionSet is,
					   VV vvStart, 
					   boolean placeholderWriterSet)
    {
	Env.dprintln(dbg, "informInvalStreamInitiated");
    }

 /** 
 *  Fake method 
 **/ 
    public void informCommitStreamInitiated(NodeId senderNodeId)
    {
	Env.dprintln(dbg, "informCommitStreamInitiated");
    }

 /** 
 *  Fake method 
 **/ 
    public void informBodyStreamInitiated(NodeId senderNodeId)
    {
	Env.dprintln(dbg, "informBodyStreamInitiated");
    }

 /** 
 *  Fake method 
 **/ 
    public void informUnbindStreamInitiated(NodeId senderNodeId)
    {
	Env.dprintln(dbg, "informUnbindStreamInitiated");
    }

 /** 
 *  Fake method 
 **/ 
    public void informSyncRplyStreamInitiated(NodeId senderNodeId)
    {
	Env.dprintln(dbg, "informSyncRplyStreamInitiated");
    }

 /** 
 *  Fake method 
 **/ 
    public void informOutgoingInvalStreamInitiated(NodeId targetNodeId, 
						   VV startVV,
						   boolean placeholderWriterSet)
    {
	Env.dprintln(dbg, "informOutgoingInvalStreamInitiated");
    }

 /** 
 *  Fake method 
 **/ 
    public void informOutgoingBodyStreamInitiated(NodeId targetNodeId, 
						  boolean placeholderWriterSet)
    {
	Env.dprintln(dbg, "informOutgoingBodyStreamInitiated");
    }


 /** 
 *  Fake method 
 **/ 
    public void informInvalStreamTerminated(NodeId senderNodeId, 
					    SubscriptionSet is,
					    VV vvStart, 
					    boolean placeholderWriterSet,
					    StreamId sId)
    {
	Env.dprintln(dbg, "informInvalStreamTerminated");
    }

 /** 
 *  Fake method 
 **/ 
    public void informCommitStreamTerminated(NodeId senderNodeId)
    {
	Env.dprintln(dbg, "informCommitStreamTerminated");
    }

 /** 
 *  Fake method 
 **/ 
    public void informBodyStreamTerminated(NodeId senderNodeId)
    {
	Env.dprintln(dbg, "informBodyStreamTerminated");
    }

 /** 
 *  Fake method 
 **/ 
    public void informUnbindStreamTerminated(NodeId senderNodeId)
    {
	Env.dprintln(dbg, "informUnbindStreamTerminated");
    }

 /** 
 *  Fake method 
 **/ 
    public void informSyncRplyStreamTerminated(NodeId senderNodeId)
    {
	Env.dprintln(dbg, "informSyncRplyStreamTerminated");
    }

 /** 
 *  Fake method 
 **/ 
    public void informOutgoingInvalStreamTerminated(NodeId targetNodeId, 
						   SubscriptionSet is, 
						   VV startVV,
						   boolean placeholderWriterSet)
    {
	Env.dprintln(dbg, "informOutgoingInvalStreamTerminated");
    }

 /** 
 *  Fake method 
 **/ 
    public void informOutgoingBodyStreamTerminated(NodeId targetNodeId, 
						   SubscriptionSet is,
						   boolean placeholderWriterSet)
    {
	Env.dprintln(dbg, "informOutgoingBodyStreamTerminated");
    }

 /** 
 *  Fake method 
 **/ 
    public void recvSyncReply(AcceptStamp acceptStamp, NodeId sender)
    {
	Env.dprintln(dbg, "recvSyncReply");
        
        
    }

 /** 
 *  Fake method 
 **/ 
    public void informReceivePushBody(BodyMsg msg)
    {
	Env.dprintln(dbg, "informReceivePushBody " + msg);
    }
 /** 
 *  Fake method 
 **/ 
  public void informReceiveInval(GeneralInv inv , NodeId senderId)
    {
	Env.dprintln(dbg, "informReceiveInval" + inv + " from " + senderId);
    }

 /** 
 *  Fake method 
 **/ 
    public void informLocalWrite(ObjId objId, long offset, long length,
				 AcceptStamp as,
                                 boolean isBound,
                                 boolean isEmbargoed)
    {
	Env.dprintln(dbg, "informLocalWrite " + objId + " " + offset + " " + length + " " + as);
    }

 /** 
 *  Fake method 
 **/ 
    public void informLocalDelete(ObjId objId)
    {
	Env.dprintln(dbg, "informLocalDelete");
    }

 /** 
 *  Fake method 
 **/ 
    public void informDemandReadMiss(ObjId objId, long offset, long length)
    {
	Env.dprintln(dbg, "informDemandReadMiss");
    }

  public void informReceiveDemandReply(NodeId senderNodeId, BodyMsg msg){
    Env.dprintln(dbg, "informReceiveDemandReadReply");
  }

 /** 
 *  Fake method 
 **/ 
    public void informLocalReadImprecise(ObjId objId, long offset, long length)
    {
        Env.dprintln(dbg, "informLocalReadImprecise");
    }

 /** 
 *  Fake method 
 **/ 
    public void informLocalReadNoBody(ObjId objId, long offset, long length)
    {
        Env.dprintln(dbg, "informLocalReadNoBody");
    }


 /** 
 *  Fake method 
 **/ 
    public void informLocalReadInvalid(ObjId objId, long offset, long length,
				       AcceptStamp inval)
    {
        Env.dprintln(dbg, "informLocalReadInvalid:" + objId + " " + offset 
                       + " " + length + " " + inval);
    }


 /** 
 *  Fake method 
 **/ 
    public void informReceiveDemandReply(BodyMsg msg)
    {
	Env.dprintln(dbg, "informReceiveDemandReply");
    }

 /** 
 *  Fake method 
 **/ 
    public void informDemandReadHit(ObjId objId, long offset, long length)
    {
	Env.dprintln(dbg, "informDemandReadHit");
    }
 /** 
 *  Fake method 
 **/ 
    public void informDemandImprecise(ObjId objId, 
                                      PreciseSet enclosingIS, 
                                      VV lpVV)
    {
	Env.dprintln(dbg, "informDemandImprecise");
    }

 /** 
 *  Fake method 
 **/ 
    public void informBecameImprecise(PreciseSet is)
    {
	Env.dprintln(dbg, "informBecameImprecise");
    }

 /** 
 *  Fake method 
 **/ 
    public void informBecamePrecise(PreciseSet is)
    {
	Env.dprintln(dbg, "informBecamePrecise");
    }
 /** 
 **/ 
  //    inform methods for send-checkpoint protocol
 /** 
 **/ 
  
 /** 
 *  called in SubscribeInvalWorker when !(this.omitVV < startVV) i.e 
 *  gap exist between the sender's omitVV and the requested stream's  
 *  startVV. It implies that the ongoing subscribe inval stream is  
 *  failed. 
 *  
 *  What expected in the controller is to make the decision whether 
 *  to subscribe inval from other nodes for the receiver or invoke 
 *  a subscribeCheckpoint request to the same node optionally followed  
 *  by a subscribeInval request with a higher startVV 
 **/ 
  public void informGapExistForSubscribeInv(NodeId invReceiver,
                                            SubscriptionSet is,
                                            VV startVV,
                                            VV omitVV){
    Env.dprintln(dbg, "informGapExistForSubscribeInv");
  }

 /** 
 *  inform Outgoing Checkpoint Stream initiated called in CPSendWorker 
 **/ 
  public void
  informOutgoingCheckpointStreamInitiated(NodeId targetNodeId, 
                                          String cpPath, 
                                          String[] exclChildNames,
                                          VV startVV,
                                          boolean placeholderWriterSet){
    Env.dprintln(dbg, "informOutgoingCheckpointStreamInitiated");
  }
 /** 
 *  inform Outgoing Checkpoint Stream initiated called in CPSendWorker 
 **/ 
  public void
  informOutgoingCheckpointStreamTerminated(NodeId receiverNodeId,
                                           String cpPath,
                                           String[] exclChildNames,
                                           VV startVV, 
                                           boolean placeholderWriterSet){
    Env.dprintln(dbg, "informOutgoingCheckpointStreamTerminated");
  }
 /** 
 *  inform a Checkpoint Stream initiated called in CPRecvWorker 
 **/ 
  public void
  informCheckpointStreamInitiated(NodeId senderNodeId, 
                                  String cpPath,
                                  String[] exclChildNames,
                                  VV vvStart,
                                  boolean placeholderWriterSet){
    Env.dprintln(dbg, "informCheckpointStreamInitiated");
  }

 /** 
 *  inform a Checkpoint Stream terminated called in CPRecvWorker 
 **/ 
  public void
  informCheckpointStreamTerminated(NodeId senderNodeId, 
                                   String cpPath,
                                   String[] exclChildNames,
                                   VV vvStart, 
                                   boolean placeholderWriterSet){
    Env.dprintln(dbg, "informCheckpointStreamTerminated");
  }

 /** 
 *  inform a Checkpoint Stream apply status called in CPRecvWorker 
 **/ 
  public void
  informCheckpointStreamReceiveStatus(NodeId senderNodeId, 
                                      String cpPath,
                                      String[] exclChildNames,
                                      VV vvStart, 
                                      boolean applyStatus,
                                      boolean placeholderWriterSet){
    Env.dprintln(dbg, "informCheckpointStreamTerminated"); 
  }

  

 /** 
 *  inform subscribe invalidate for a certain subscription set failed 
 **/ 
  public void
  informSubscribeInvalFailed(NodeId senderNodeId,
                             NodeId receiverNodeId,
                             SubscriptionSet ss,
                             VV vvStart){
    Env.dprintln(dbg, "informSubscribeInvalFailed");
  }

 /** 
 *  inform subscribe invalidate for a certain subscription set failed 
 **/ 
  public void
  informSubscribeInvalSucceeded(NodeId senderNodeId,
                                NodeId receiverNodeId,
                                SubscriptionSet ss,
                                VV vvStart){
    Env.dprintln(dbg, "informSubscribeInvalSucceeded");
  }

 /** 
 *  inform SS was added to a incomming body stream 
 **/ 
  public void
  informSubscribeBodySucceeded(NodeId senderNodeId,
                               SubscriptionSet ss){
    Env.dprintln(dbg, "informSubscribeBodySucceeded");
  }

 /** 
 *  inform SS was removed from an incomming body stream 
 **/ 
  public void
  informSubscribeBodyRemoved(NodeId senderNodeId,
                             SubscriptionSet ss){
    Env.dprintln(dbg, "informSubscribeBodyRemoved");
  }

 /** 
 *  inform successfully adding subscriptionSet to OutgoingConnection's 
 *  invalidateIterator's interestset 
 **/ 
  public void 
  informOutgoingSubscribeInvalInitiated(NodeId receiverId, 
                                        SubscriptionSet subscriptionSet){
    Env.dprintln(dbg, "informOutgoingSubscribeInvalInitiated");
  }

 /** 
 *  inform successfully removed subscriptionSet from 
 *  OutgoingConnection's invalIterator's interest set 
 **/ 
  public void
  informOutgoingSubscribeInvalTerminated(NodeId receiverId,
					 SubscriptionSet subscriptionSet){
    Env.dprintln(dbg, "informOutgoingSubscribeInvalTerminated");
  }
 /** 
 *   inform added SS to outgoing body connection's upq notifier 
 **/ 
  public void
  informOutgoingSubscribeBodyInitiated(NodeId receiverID, 
				       SubscriptionSet subscriptionSet){
    Env.dprintln(dbg, "informOutgoingSubscribeBodyInitiated");
  }

 /** 
 *  inform removed SS from outgoing body connection's upq notifer 
 **/ 
  public void
  informOutgoingSubscribeBodyTerminated(NodeId receiverId,
					SubscriptionSet subscriptionSet){
    Env.dprintln(dbg, "informOutgoingSubscribeBodyTerminated");
  }
  
 /** 
 *  inform received DVV is not included by current VV 
 **/ 
  public void
  informInvalidSignature(){
          Env.dprintln(dbg, "informInvalidSignature");
  }
  
 /** 
 *  inform received DVV is not included by current VV 
 **/ 
  public void
  informReceivedDVVNotIncluded(){
	  Env.dprintln(dbg, "informReceivedDVVNotIncluded");
  }
 /** 
 *  inform received DVV is not included by current VV 
 **/ 
  public void
  informReceivedSHUnmatched(){
	  Env.dprintln(dbg, "informReceivedSHUnmatched");
  }  
 /** 
 *  inform received DVV is not included by current VV 
 **/ 
  public void
  informReceivedBodyUnmatched(){
	  Env.dprintln(dbg, "informReceivedBodyUnmatched");
  }

  public void
  informCheckpointApplied(NodeId senderId, boolean status){
	  Env.dprintln(dbg, "informCheckpointApplied");
  }

}
