package code;
/* 
 * LogIterator -- Iterator to scan Persistent Log
 *
 */

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.tuple.TupleBinding;
 
public class LogIterator{

  private Cursor cursor;
//  private SerialBinding logRecordBinding;  -- for LogRecord.java
  private TupleBinding logRecordBinding;
  public LogIterator(Cursor cursor, TupleBinding logRecordBinding){
    assert cursor != null;
    this.cursor = cursor;
    assert logRecordBinding instanceof LogRecordBinding;
    this.logRecordBinding = logRecordBinding;
  }

 /** 
 *  return the nextMsg in the current Cursor 
 *  the returned msg can be of type:  
 *  GeneralInv or UnbindMsg 
 *  return null if there's no more entry 
 **/ 
  public Object getNext()
    throws NullPointerException, 
    IllegalArgumentException, DatabaseException{
    DatabaseEntry theKey = new DatabaseEntry();
    DatabaseEntry theData = new DatabaseEntry();
    
    if (cursor.getNext(theKey, theData, null) == 
        OperationStatus.SUCCESS){
        
      return logRecordBinding.entryToObject(theData);
    } else {
      return null;
    }
  }
 
 /** 
 *  close cursor, Note it must be called when destruct 
 **/ 
  public void
  close()
  throws DatabaseException{
    if(cursor != null){
      cursor.close();
    }
  }

 /** 
 *  Self Test 
 **/ 
  public static void
    main(String[] argv){
  }
}

//---------------------------------------------------------------------------
/* $Log: LogIterator.java,v $
/* Revision 1.2  2005/01/10 03:47:47  zjiandan
/* Fixed some bugs. Successfully run SanityCheck and Partial Replication experiments.
/*
/* Revision 1.1  2004/10/13 17:41:36  zjiandan
/* Initial implementation of PersistentLog tested with DataStore stubs.
/*
/* TBD: test recovery with integrated DataStore and RandomAccessState.
/**/
//---------------------------------------------------------------------------

