package code;
/*
 * LogRecord -- Data for InvalDB
 *
 */
import java.io.Serializable;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseNotFoundException;
import java.io.UnsupportedEncodingException;

import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.bind.tuple.IntegerBinding;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;

import java.io.File;
import java.io.IOException;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class LogRecord implements Serializable{

  private Object record;
  
 /** 
 *  constructor  
 **/ 
  public 
  LogRecord(GeneralInv inv){

    this.record = inv;
  }

 /** 
 *  constructor  
 **/ 
  public
  LogRecord(UnbindMsg ubm){

    this.record = ubm;
  }
  
 /** 
 *  return the object 
 **/ 
  public Object
  getRecord(){
    return this.record;
  }

 /** 
 *  self test -- convert to DatabaseEntry 
 **/ 
  public static void
  main(String[] argv)
  throws Exception{
    //
    // init BerkeleyDB variables 
    Environment env;
    Database db;
    Database classDb;

    String classDbName = "StoredClassCatalog";
    StoredClassCatalog classCatalog;

    EnvironmentConfig envConfig = new EnvironmentConfig();
    envConfig.setTransactional(true);
    envConfig.setAllowCreate(true);
    
    DatabaseConfig dbConfig = new DatabaseConfig();
    dbConfig.setTransactional(true);
    dbConfig.setAllowCreate(true);
    
    File dbDir = new File("/u/zjiandan/space0/je-1.5.3/examples/" 
                          + "com/sleepycat/examples/je/dbenv");
    try{
      File[] dbFiles = dbDir.listFiles();
      
      if (dbFiles != null){
        for (int i = 0; i < dbFiles.length; i ++){
          dbFiles[i].delete();
        }
      }
      
    } catch (SecurityException se){
      assert false; //should never be here.
    }
    
    try{
      dbDir.mkdirs();
      env = new Environment(dbDir, 
                            envConfig);
      
      db = env.openDatabase(null, 
                            "TestDB",
                            dbConfig);
      
      //
      // open/create classDB
      //
      
      try{
        env.truncateDatabase(null, classDbName, false);
      }catch(DatabaseNotFoundException dnfe){
        //do nothing.
      }
      classDb = env.openDatabase(null, classDbName, dbConfig);
      classCatalog = new StoredClassCatalog(classDb);
      
    }catch(DatabaseException dbe){
      String msg = dbe.toString();
      
      throw new IOException("Exception opening berkeleyDB Environment: " 
                            + msg);
    }
    //initialize binding stuff
    SerialBinding logRecordBinding = new SerialBinding(classCatalog, 
                                                       LogRecord.class);
    DatabaseEntry key = new DatabaseEntry("LogRecordUMB".getBytes("UTF-8"));
    DatabaseEntry data = new DatabaseEntry();
   
    UnbindMsg um = new UnbindMsg(new ObjInvalTarget(new ObjId("obj1"), 0, 0), 
                                 new AcceptStamp(100, new NodeId(190)));
    LogRecord logRecord = new LogRecord(um);

    assert logRecord.getRecord() instanceof UnbindMsg;
    
    logRecordBinding.objectToEntry(logRecord, data);
    OperationStatus status = db.put(null, key, data);
    if (status != OperationStatus.SUCCESS){
      System.out.println("put LogRecordUMB fail!");
      return;
    }
    data = null;
    data = new DatabaseEntry();
    status = db.get(null, key, data, null);
    if (status == OperationStatus.SUCCESS){
      System.out.println("get UnbindMsg: " + 
                         (((LogRecord)(logRecordBinding.entryToObject(data))).getRecord() instanceof UnbindMsg));
    } else {
      System.out.println("get UnbindMsg fail!");
    }
    
   
    AcceptStamp[] as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(190, new NodeId(200));
    as1[1] = new AcceptStamp(180, new NodeId(300));
    
    AcceptStamp[] as2 = new AcceptStamp[2];
    as2[0] = new AcceptStamp(200, new NodeId(200));
    as2[1] = new AcceptStamp(210, new NodeId(300));
    
    String[] dir = new String[2];
    dir[0] = "/d1/*";
    dir[1] = "/d2/*";
    
    ImpreciseInv ii = new ImpreciseInv(HierInvalTarget.makeHierInvalTarget(dir),
                                       new AcceptVV(as1),
                                       new AcceptVV(as2));
    logRecord = null;
    logRecord = new LogRecord(ii);
    
    assert logRecord.getRecord() instanceof ImpreciseInv;

    key = null;
    data = null;
    key = new DatabaseEntry("LogRecordINV".getBytes("UTF-8"));
    data = new DatabaseEntry();
    
    logRecordBinding.objectToEntry(logRecord, data);
    status = db.put(null, key, data);
    if (status != OperationStatus.SUCCESS){
      System.out.println("put LogRecordINV fail!");
      return;
    }
    data = null;
    data = new DatabaseEntry();
    status = db.get(null, key, data, null);
    if (status == OperationStatus.SUCCESS){
      System.out.println("get ImpreciseInv: " + 
                         (((LogRecord)(logRecordBinding.entryToObject(data))).getRecord() instanceof ImpreciseInv));
    } else {
      System.out.println("get ImpreciseInv fail!");
    }
    
    BufferedReader din = null;
    try{
      
      din = new BufferedReader(new InputStreamReader(System.in));
      String input;
      System.out.println("input boundinv length:(0 to exit) ");
      for(input = din.readLine(); input!= null; input=din.readLine()) {
        
        StringTokenizer st = new StringTokenizer(input);
        
        ObjId id = new ObjId("/test/");
        long length = (new Long(st.nextToken())).longValue();
        if(length == 0L) break;
        ObjInvalTarget oit = new ObjInvalTarget(id, 1, length);
        AcceptStamp as = new AcceptStamp(1, new NodeId(10));
        byte b[] = new byte[(int)length];
        int i;
        byte value = 1;
        for(i = 0; i < length; i++){
          b[i] = (byte)(value + i);
        }
        
        ImmutableBytes im = new ImmutableBytes(b);
        b = null;
        BoundInval bi = new BoundInval(oit, as, im);
        logRecord = null;
        logRecord = new LogRecord(bi);
        
        key = null;
        data = null;
        key = new DatabaseEntry("LogRecordBI".getBytes("UTF-8"));
        data = new DatabaseEntry();
        
        long start, end;
        double avgMS;
        start = System.currentTimeMillis();
        logRecordBinding.objectToEntry(logRecord, data);
        end = System.currentTimeMillis();
        avgMS = ((double)((double)end - (double)start));
        System.out.print("convert to Entry of size " +length + " " 
                         +avgMS + "ms.");
        im = null;
        status = db.put(null, key, data);
        if (status != OperationStatus.SUCCESS){
          System.out.println("put LogRecordBI fail!");
          return;
        }
        data = null;
        data = new DatabaseEntry();
        status = db.get(null, key, data, null);
        if (status == OperationStatus.SUCCESS){
          System.out.println("get BoundInval: " + 
                             (((LogRecord)(logRecordBinding.entryToObject(data))).getRecord() instanceof BoundInval));
        } else {
          System.out.println("get BoundInval fail!");
        }
        System.out.println("input boundinv length:(0 to exit) ");
      }
    } catch (Exception e){
      e.printStackTrace();
    }

    db.close();
    classDb.close();
    env.sync();
    env.close();
  }
}
//---------------------------------------------------------------------------
/* $Log: LogRecord.java,v $
/* Revision 1.6  2005/07/18 05:10:23  zjiandan
/* Embargoed Writes etc. features implementation plus
/* log overhead measurement with disk size and in-memory size.
/*
/* Revision 1.5  2005/02/28 23:18:25  nayate
/* Modified for new code
/*
/* Revision 1.4  2005/02/28 23:10:39  nayate
/* Modified for new code
/*
/* Revision 1.3  2005/01/10 03:47:47  zjiandan
/* Fixed some bugs. Successfully run SanityCheck and Partial Replication experiments.
/*
/* Revision 1.2  2004/10/22 18:13:39  zjiandan
/* cleaned csn from UpdateLog, modified DeleteInv.
/* TBD:
/*    1. clean csn from all subclasses of GeneralInv
/*    2. fix *Inv::cloneIntersectInvaltargetChopStartEnd
/*
/* Revision 1.1  2004/10/13 17:41:36  zjiandan
/* Initial implementation of PersistentLog tested with DataStore stubs.
/*
/* TBD: test recovery with integrated DataStore and RandomAccessState.
/**/
//---------------------------------------------------------------------------
