package code;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;

import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.bind.tuple.IntegerBinding;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import java.io.UnsupportedEncodingException;

import java.io.File;
import java.io.IOException;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

import java.io.ObjectOutputStream;
import java.io.ByteArrayOutputStream;

public class LogRecordBinding extends TupleBinding{
  
  private static final short IMPRECISEINV = 0;
  private static final short DELETEINV = 1;
  private static final short PRECISEINV = 2;
  private static final short BOUNDINV = 3;
  private static final short SINGLEWRITERIMPRECISEINV = 4;
  private static final short MULTIOBJPRECISEINV = 5;
  private static final short UNBINDMSG = 6;
  private static final short DEBARGOMSG = 7;

  public void objectToEntry(Object object, TupleOutput to){
    if(object instanceof GeneralInv){
      if(object instanceof BoundInval){
        BoundInval bi = (BoundInval)object;
        to.writeShort(BOUNDINV);   //--type
        
	to.writeString(bi.getObjId().getPath());//--objid
	to.writeLong(bi.getOffset()); //--offset
	to.writeLong(bi.getLength()); //--length
	to.writeLong(bi.getStart());  //--AcceptStamp.localClock
	to.writeLong(bi.getNodeId().getIDint());//--AcceptStamp.nodeId
        
        //
        //new members added for tact/embargoed write
        //
        to.writeLong(bi.getRTAcceptStamp().getLocalClock());//real stamp
        to.writeDouble(bi.getPriority());  //priority
        to.writeBoolean(bi.isEmbargoed()); //embargoed
        
        byte[] body = bi.getBody().dangerousGetReferenceToInternalByteArray();
        to.writeInt(body.length); //--body.length
        
        to.writeFast(body);//--body
        
      }else if(object instanceof PreciseInv){
        PreciseInv pi = (PreciseInv)object;
        to.writeShort(PRECISEINV); // -- type
        to.writeString(pi.getObjId().getPath()); // -- objid
        to.writeLong(pi.getOffset()); // -- offset
        to.writeLong(pi.getLength());// -- length
        to.writeLong(pi.getStart()); //--AcceptStamp.localClock
        to.writeLong(pi.getNodeId().getIDint());//--AcceptStamp.nodeId
        
        //
        //new members added for tact/embargoed write
        //
        to.writeLong(pi.getRTAcceptStamp().getLocalClock());//real stamp
        to.writeBoolean(pi.isEmbargoed());
      }else if(object instanceof MultiObjPreciseInv){
        MultiObjPreciseInv mopi = (MultiObjPreciseInv)object;
        to.writeShort(MULTIOBJPRECISEINV); // -- type
        try{
          mopi.writeSelf(to);
        }catch(IOException e){
          assert false : ("" + e);
        }
      }else if(object instanceof ImpreciseInv){
        ImpreciseInv ii = (ImpreciseInv)object;
        to.writeShort(IMPRECISEINV); // -- type
        
        assert(ii.getInvalTarget() instanceof HierInvalTarget);
        to.writeString(ii.getInvalTarget().toString()); // -- interstSet
        
        AcceptVV avv = null;
        Object token = null;
        VVIterator vvIter = null;

        // -- start AcceptVV
        avv = ii.getStartVV();
        to.writeInt(avv.size()); // -- startVV size
        int i = 0;
        for (vvIter = avv.getIterator(); vvIter.hasMoreElements();){
          token = vvIter.getNext();
          to.writeLong(avv.getStampByIteratorToken(token));  // -- acceptStamp
          to.writeLong(avv.getServerByIteratorToken(token).getIDint()); //-- nodeId
          i++;
        }
        assert i == avv.size();
        
        // -- end AcceptVV
        avv = ii.getEndVV();
        to.writeInt(avv.size()); // -- EndVV size
        i = 0;
        for (vvIter = avv.getIterator(); vvIter.hasMoreElements();){
          token = vvIter.getNext();
          to.writeLong(avv.getStampByIteratorToken(token));  // -- acceptStamp
          to.writeLong(avv.getServerByIteratorToken(token).getIDint()); //-- nodeId
          i++;
        }
        assert i == avv.size();

        //new members for TACT staleness bound
        // -- realtime AcceptVV
        avv = ii.getRTVV();
        to.writeInt(avv.size()); // -- EndVV size
        i = 0;
        for (vvIter = avv.getIterator(); vvIter.hasMoreElements();){
          token = vvIter.getNext();
          to.writeLong(avv.getStampByIteratorToken(token));  // -- acceptStamp
          to.writeLong(avv.getServerByIteratorToken(token).getIDint()); //-- nodeId
          i++;
        }
        assert i == avv.size();
      }else if(object instanceof SingleWriterImpreciseInv){
        SingleWriterImpreciseInv swii = (SingleWriterImpreciseInv)object;
        to.writeShort(SINGLEWRITERIMPRECISEINV); // -- type
        
        //
        // note: if the interestset is not DirectoryInterestSet
        //       need to take care of the corresponding code in entryToObject()
        //       as well
        //
        assert(swii.getInvalTarget() instanceof HierInvalTarget);
        to.writeString(swii.getInvalTarget().toString()); // -- interestSet
        to.writeLong(swii.getStart()); // --start
        to.writeLong(swii.getEnd()); // -- end
        to.writeLong(swii.getReal());// -- realTime
        to.writeLong(swii.getNodeId().getIDint()); // -- nodeID

        
      }else if(object instanceof DeleteInv){
        DeleteInv di = (DeleteInv)object;
        to.writeShort(DELETEINV); // -- type
        to.writeString(di.getObjId().getPath()); // -- objid
        to.writeLong(di.getStart()); // -- start
        to.writeLong(di.getRTAcceptStamp().getLocalClock());  // -- realTime
        to.writeLong(di.getNodeId().getIDint()); // -- nodeID
        to.writeBoolean(di.isEmbargoed());

      }else{
        assert false;// unexpected object
        System.exit(-1);
      }
    }else if(object instanceof UnbindMsg){
      UnbindMsg ubm = (UnbindMsg)object;
      
      to.writeShort(UNBINDMSG);
      to.writeString(ubm.getObjId().getPath()); // -- objid
      to.writeLong(ubm.getOffset()); // -- offset
      to.writeLong(ubm.getLength());// -- length
      to.writeLong(ubm.getTime()); //--AcceptStamp.localClock
      to.writeLong(ubm.getNodeId().getIDint());//--AcceptStamp.nodeId
    }else if(object instanceof DebargoMsg){
      DebargoMsg ubm = (DebargoMsg)object;
      
      to.writeShort(DEBARGOMSG);
      to.writeString(ubm.getObjId().getPath()); // -- objid
      to.writeLong(ubm.getOffset()); // -- offset
      to.writeLong(ubm.getLength());// -- length
      to.writeLong(ubm.getTime()); //--AcceptStamp.localClock
      to.writeLong(ubm.getNodeId().getIDint());//--AcceptStamp.nodeId
      
    }else {//should never be here
      assert false;
      System.exit(-1);
    }
    
  }

  public Object entryToObject(TupleInput ti){
    int strLength;
    short type = ti.readShort(); //--type
    if (type == BOUNDINV){
      
      String objIdString = ti.readString();
      long offset = ti.readLong();
      long length = ti.readLong();
      long localClock = ti.readLong();
      long nodeIdInt = ti.readLong();
      
      long realTime = ti.readLong();
      double newPriority = ti.readDouble();
      boolean embargoed = ti.readBoolean();

      strLength = ti.readInt();
      byte [] b = new byte[strLength];
      int got = ti.readFast(b);
      assert got == strLength;
      return new BoundInval(new ObjId(objIdString),
                            offset,
                            length,
                            new AcceptStamp(localClock, new NodeId(nodeIdInt)),
                            new ImmutableBytes(b),
                            newPriority,
                            new AcceptStamp(realTime, new NodeId(nodeIdInt)),
                            embargoed);

    }else if (type == PRECISEINV){
      String objIdString = ti.readString();
      long offset = ti.readLong();
      long length = ti.readLong();
      long localClock = ti.readLong();
      long nodeIdInt = ti.readLong();
      
      long realTime = ti.readLong();
      boolean embargoed = ti.readBoolean();

      return new PreciseInv(new ObjInvalTarget(new ObjId(objIdString),
                                               offset,
                                               length),
                            new AcceptStamp(localClock, new NodeId(nodeIdInt)),
                            new AcceptStamp(realTime, new NodeId(nodeIdInt)),
                            embargoed);

    }else if (type == IMPRECISEINV){
      
      String interestSetString = ti.readString();

      int vvsize = ti.readInt();
      AcceptStamp[] vv1 = new AcceptStamp[vvsize];
      for (int i = 0; i < vvsize; i++){
        vv1[i] = new AcceptStamp(ti.readLong(), 
                                         new NodeId(ti.readLong()));
      }

      vvsize = ti.readInt();
      AcceptStamp[] vv2 = new AcceptStamp[vvsize];
      for (int i = 0; i < vvsize; i++){
        vv2[i] = new AcceptStamp(ti.readLong(), 
                                 new NodeId(ti.readLong()));
      }
      
      vvsize = ti.readInt();
      AcceptStamp[] vv3 = new AcceptStamp[vvsize];
      for (int i = 0; i < vvsize; i++){
        vv3[i] = new AcceptStamp(ti.readLong(), 
                                 new NodeId(ti.readLong()));
      }
      return new ImpreciseInv(HierInvalTarget.makeHierInvalTarget(interestSetString),
                              new AcceptVV(vv1),
                              new AcceptVV(vv2),
                              new AcceptVV(vv3));

    }else if (type == SINGLEWRITERIMPRECISEINV){
      String isString = ti.readString();
      long start = ti.readLong();
      long end = ti.readLong();
      long realTime = ti.readLong();
      long nodeIdInt = ti.readLong();
      return 
        new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget(isString),
                                     new AcceptStamp(start, 
                                                     new NodeId(nodeIdInt)),
                                     new AcceptStamp(end, 
                                                     new NodeId(nodeIdInt)),
                                     new AcceptStamp(realTime,
                                                     new NodeId(nodeIdInt)));
                                                        
    }else if (type == MULTIOBJPRECISEINV){
      MultiObjPreciseInv mopi = null;

      try{
        mopi = new MultiObjPreciseInv(ti);
      }catch(IOException e){
        assert false : ("" + e);
      }
      return(mopi);
    }else if (type == DELETEINV){
      String objIdString = ti.readString();
      long localClock = ti.readLong();
      long realTime = ti.readLong();
      long nodeIdInt = ti.readLong();
      boolean embargoed = ti.readBoolean();
      return new DeleteInv(new ObjId(objIdString),
                           new AcceptStamp(localClock, new NodeId(nodeIdInt)),
                           new AcceptStamp(realTime, new NodeId(nodeIdInt)),
                           embargoed);

    }else if (type == UNBINDMSG){
      String objIdString = ti.readString();
      long offset = ti.readLong();
      long length = ti.readLong();
      long time = ti.readLong();
      long nodeIdInt = ti.readLong();
      return new UnbindMsg(new ObjInvalTarget(new ObjId(objIdString),
                                              offset,
                                              length),
                           new AcceptStamp(time, new NodeId(nodeIdInt)));
    }else if (type == DEBARGOMSG){
      String objIdString = ti.readString();
      long offset = ti.readLong();
      long length = ti.readLong();
      long time = ti.readLong();
      long nodeIdInt = ti.readLong();
      return new DebargoMsg(new ObjInvalTarget(new ObjId(objIdString),
                                              offset,
                                              length),
                           new AcceptStamp(time, new NodeId(nodeIdInt)));
    } else {
      assert false; //-- corrupted object
      System.exit(-1);
      return null;
    }
  }

  //---------------------------------------------------------------------
  // performance test of BoundInv
  //---------------------------------------------------------------------
  private static void perfOfBound()
    throws Exception{
    //
    // init BerkeleyDB variables 
    Environment env;
    Database db;
    Database classDb;
    
    EnvironmentConfig envConfig = new EnvironmentConfig();
    envConfig.setTransactional(true);
    envConfig.setAllowCreate(true);
    envConfig.setCacheSize(30000000);
    DatabaseConfig dbConfig = new DatabaseConfig();
    dbConfig.setTransactional(true);
    dbConfig.setAllowCreate(true);
    
    File dbDir = new File("/tmp/ufs");
    try{
      File[] dbFiles = dbDir.listFiles();
      
      if (dbFiles != null){
        for (int i = 0; i < dbFiles.length; i ++){
          dbFiles[i].delete();
        }
      }
      
    } catch (SecurityException se){
      assert false; //should never be here.
    }
    
    try{
      dbDir.mkdirs();
      env = new Environment(dbDir, 
                            envConfig);
      
      db = env.openDatabase(null, 
                            "TestDB",
                            dbConfig);
      
    }catch(DatabaseException dbe){
      String msg = dbe.toString();
      
      throw new IOException("Exception opening berkeleyDB Environment: " 
                            + msg);
    }
    //initialize binding stuff
    TupleBinding logRecordBinding = new LogRecordBinding();
    DatabaseEntry key = new DatabaseEntry("LogRecordUMB".getBytes("UTF-8"));
    DatabaseEntry data = new DatabaseEntry();
    OperationStatus status;

    BufferedReader din = null;
    try{
      
      din = new BufferedReader(new InputStreamReader(System.in));
      String input;
      System.out.println("input boundinv length:(0 to exit) ");
      for(input = din.readLine(); input!= null; input=din.readLine()) {
        
        StringTokenizer st = new StringTokenizer(input);
        
        ObjId id = new ObjId("/test/");
        long length = (new Long(st.nextToken())).longValue();
        if(length == 0L) break;
        ObjInvalTarget oit = new ObjInvalTarget(id, 1, length);
        AcceptStamp as = new AcceptStamp(1, new NodeId(10));
        byte b[] = new byte[(int)length];
        int i;
        byte value = 122;
        for(i = 0; i < length; i++){
          b[i] = (byte)(value + i);
        }
        
        long start, end;
        double avgMS;

        
        start = System.currentTimeMillis();
        DatabaseEntry d = new DatabaseEntry(b);
        end = System.currentTimeMillis();

        avgMS = ((double)((double)end - (double)start));
        System.out.println("by mike's method of size:" +length + " ***" 
                         +avgMS + "ms.");
                        
        
        ImmutableBytes im = new ImmutableBytes(b);
        b = null;

        BoundInval bi = new BoundInval(oit, as, im);
        //logRecord = null;
        //logRecord = new LogRecord(bi);
        
        key = null;
        data = null;
        key = new DatabaseEntry("LogRecordBI".getBytes("UTF-8"));
        data = new DatabaseEntry();

/*        
        long start, end;
        double avgMS;
*/
        start = System.currentTimeMillis();
        logRecordBinding.objectToEntry(bi, data);
        end = System.currentTimeMillis();

        avgMS = ((double)((double)end - (double)start));
        System.out.println("convert to Entry of size " +length + " ****" 
                         +avgMS + "ms.");

        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        //ObjectOutputStream buffer = new ObjectOutputStream(baos);
        try{
          start = System.currentTimeMillis();
          
          //buffer.writeObject(bi);
          baos.write(Short.toString(BOUNDINV).getBytes());   //--type
        //to.writeInt(bi.getObjId().getPath().length()); //--objid string length
	baos.write(bi.getObjId().getPath().getBytes());//--objid
	baos.write(Long.toString(bi.getOffset()).getBytes()); //--offset
	baos.write(Long.toString(bi.getLength()).getBytes()); //--length
	baos.write(Long.toString(bi.getStart()).getBytes());  //--AcceptStamp.localClock
	baos.write(Long.toString(bi.getNodeId().getIDint()).getBytes());
        baos.write(bi.getBody().dangerousGetReferenceToInternalByteArray());
        byte[] newb = baos.toByteArray();  
        end = System.currentTimeMillis();

          avgMS = ((double)((double)end - (double)start));
          System.out.println("writeObject " +baos.size() + " ****" 
                         +avgMS + "ms.");

          
          start = System.currentTimeMillis();
          
          d = new DatabaseEntry(newb);
        
          end = System.currentTimeMillis();

          avgMS = ((double)((double)end - (double)start));
          System.out.println("convert to byteArr directly " +baos.size() + " ****" 
                         +avgMS + "ms.");
        
        }catch (Exception e){
          e.printStackTrace();
          assert false;
        }
        im = null;
        status = db.put(null, key, data);
        if (status != OperationStatus.SUCCESS){
          System.out.println("put LogRecordBI fail!");
          return;
        }
        data = null;
        data = new DatabaseEntry();
        status = db.get(null, key, data, null);
        if (status == OperationStatus.SUCCESS){
          System.out.println("get BoundInval: " + 
                             ((BoundInval)(logRecordBinding.entryToObject(data)))); //instanceof BoundInval));
        } else {
          System.out.println("get BoundInval fail!");
        }
        System.out.println("input boundinv length:(0 to exit) ");
      }
    } catch (Exception e){
      e.printStackTrace();
    }
    db.close();
    env.sync();
    env.close();
  }
  public static void main(String[] arg)
    throws Exception{
    //
    // init BerkeleyDB variables 
    Environment env;
    Database db;
    Database classDb;
    
    EnvironmentConfig envConfig = new EnvironmentConfig();
    envConfig.setTransactional(true);
    envConfig.setAllowCreate(true);
    envConfig.setCacheSize(30000000);
    DatabaseConfig dbConfig = new DatabaseConfig();
    dbConfig.setTransactional(true);
    dbConfig.setAllowCreate(true);
    
    File dbDir = new File("/tmp/ufs");
    try{
      File[] dbFiles = dbDir.listFiles();
      
      if (dbFiles != null){
        for (int i = 0; i < dbFiles.length; i ++){
          dbFiles[i].delete();
        }
      }
      
    } catch (SecurityException se){
      assert false; //should never be here.
    }
    
    try{
      dbDir.mkdirs();
      env = new Environment(dbDir, 
                            envConfig);
      
      db = env.openDatabase(null, 
                            "TestDB",
                            dbConfig);
      
    }catch(DatabaseException dbe){
      String msg = dbe.toString();
      
      throw new IOException("Exception opening berkeleyDB Environment: " 
                            + msg);
    }
    //initialize binding stuff
    TupleBinding logRecordBinding = new LogRecordBinding();
    DatabaseEntry key = new DatabaseEntry("LogRecordUMB".getBytes("UTF-8"));
    DatabaseEntry data = new DatabaseEntry();
    OperationStatus status;

    //---------------------------------------------------------------------
    // UnbindMsg
    //---------------------------------------------------------------------
    UnbindMsg um = new UnbindMsg(new ObjInvalTarget(new ObjId("/obj1"), 0, 0), 
                                 new AcceptStamp(100, new NodeId(190)));
    
    logRecordBinding.objectToEntry(um, data);
    status = db.put(null, key, data);
    if (status != OperationStatus.SUCCESS){
      System.out.println("put UMB fail!");
      return;
    }
    data = null;
    data = new DatabaseEntry();
    status = db.get(null, key, data, null);
    if (status == OperationStatus.SUCCESS){
      System.out.println("get UnbindMsg: " + 
                         logRecordBinding.entryToObject(data));
    } else {
      System.out.println("get UnbindMsg fail!");
    }
    
    //---------------------------------------------------------------------
    // DebargoMsg
    //---------------------------------------------------------------------
    DebargoMsg dm = new DebargoMsg(new ObjInvalTarget(new ObjId("/obj1"), 
                                                      0, 0), 
                                 new AcceptStamp(100, new NodeId(190)));
    
    logRecordBinding.objectToEntry(dm, data);
    status = db.put(null, key, data);
    if (status != OperationStatus.SUCCESS){
      System.out.println("put DMB fail!");
      return;
    }
    data = null;
    data = new DatabaseEntry();
    status = db.get(null, key, data, null);
    if (status == OperationStatus.SUCCESS){
      System.out.println("get DebargoMsg: " + 
                         logRecordBinding.entryToObject(data));
    } else {
      System.out.println("get DebargoMsg fail!");
    }

    //---------------------------------------------------------------------
    // ImpreciseInv
    //---------------------------------------------------------------------
    
    AcceptStamp[] as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(190, new NodeId(200));
    as1[1] = new AcceptStamp(180, new NodeId(300));
    
    AcceptStamp[] as2 = new AcceptStamp[2];
    as2[0] = new AcceptStamp(200, new NodeId(200));
    as2[1] = new AcceptStamp(210, new NodeId(300));
    
    AcceptStamp[] as3 = new AcceptStamp[2];
    as3[0] = new AcceptStamp(10000, new NodeId(200));
    as3[1] = new AcceptStamp(10000, new NodeId(300));
    
    String[] dir = new String[2];
    dir[0] = "/d1/*";
    dir[1] = "/d2/*";
    
    ImpreciseInv ii = new ImpreciseInv(HierInvalTarget.makeHierInvalTarget(dir),
                                       new AcceptVV(as1),
                                       new AcceptVV(as2),
                                       new AcceptVV(as3));
    key = null;
    data = null;
    key = new DatabaseEntry("IMPRECISEINV".getBytes("UTF-8"));
    data = new DatabaseEntry();
    
    logRecordBinding.objectToEntry(ii, data);
    status = db.put(null, key, data);
    if (status != OperationStatus.SUCCESS){
      System.out.println("put IMPRECISEINV fail!");
      return;
    }
    data = null;
    data = new DatabaseEntry();
    status = db.get(null, key, data, null);
    if (status == OperationStatus.SUCCESS){
      System.out.println("get ImpreciseInv: " + 
                         logRecordBinding.entryToObject(data));
    } else {
      System.out.println("get ImpreciseInv fail!");
    }

    
    //---------------------------------------------------------------------
    // PreciseInv
    //---------------------------------------------------------------------
    PreciseInv pi = new PreciseInv(new ObjInvalTarget(new ObjId("/obj1"), 
                                                      10, 20),
                                   new AcceptStamp(190, new NodeId(200)),
                                   new AcceptStamp(10000, new NodeId(200)),
                                   false);

    key = null;
    data = null;
    key = new DatabaseEntry("PRECISEINV".getBytes("UTF-8"));
    data = new DatabaseEntry();
    
    logRecordBinding.objectToEntry(pi, data);
    status = db.put(null, key, data);
    if (status != OperationStatus.SUCCESS){
      System.out.println("put PRECISEINV fail!");
      return;
    }
    data = null;
    data = new DatabaseEntry();
    status = db.get(null, key, data, null);
    if (status == OperationStatus.SUCCESS){
      System.out.println("get PreciseInv: " + 
                         logRecordBinding.entryToObject(data));
    } else {
      System.out.println("get PreciseInv fail!");
    }

    //---------------------------------------------------------------------
    // BoundInval
    //---------------------------------------------------------------------
    byte[] body = new byte[10];
    for(int i = 0; i<10; i++){
      body[i] = 1;
    }
    
    BoundInval bi = new BoundInval(new ObjInvalTarget(new ObjId("/obj1"), 
                                                      10, 10),
                                   new AcceptStamp(190, new NodeId(200)),
                                   new ImmutableBytes(body),
                                   0.2,
                                   new AcceptStamp(10000, new NodeId(200)),
                                   false);

    key = null;
    data = null;
    key = new DatabaseEntry("BOUNDINV".getBytes("UTF-8"));
    data = new DatabaseEntry();
    
    logRecordBinding.objectToEntry(bi, data);
    status = db.put(null, key, data);
    if (status != OperationStatus.SUCCESS){
      System.out.println("put BOUNDINV fail!");
      return;
    }
    data = null;
    data = new DatabaseEntry();
    status = db.get(null, key, data, null);
    if (status == OperationStatus.SUCCESS){
      System.out.println("get BoundInv: " + 
                         logRecordBinding.entryToObject(data));
    } else {
      System.out.println("get BoundInv fail!");
    }

    //---------------------------------------------------------------------
    // MultiObjPreciseInv
    //---------------------------------------------------------------------
    key = null;
    data = null;
    key = new DatabaseEntry("MULTIOBJPRECISEINV".getBytes("UTF-8"));
    data = new DatabaseEntry();

    MOITBoundEntry[] be1 = null;
    MultiObjInvalTarget moit1 = null;
    MultiObjPreciseInv mopi = null;
    ObjInvalTarget[] invs = null;
    ObjInvalTarget[] dels = null;

    invs = new ObjInvalTarget[1];
    invs[0] = new ObjInvalTarget(new ObjId("/a"), 10, 10);
    dels = new ObjInvalTarget[0];
    moit1 = new MultiObjInvalTarget(invs, dels);
    be1 = new MOITBoundEntry[1];
    be1[0] = new MOITBoundEntry(invs[0],
                                1.0,
                                new ImmutableBytes(new byte[10]));
    mopi = new MultiObjPreciseInv(moit1,
                                  new AcceptStamp(100, new NodeId(1)),
                                  new AcceptStamp(200, new NodeId(1)),
                                  false,
                                  be1);

    logRecordBinding.objectToEntry(mopi, data);
    status = db.put(null, key, data);
    if (status != OperationStatus.SUCCESS){
      System.out.println("put MULTIOBJPRECISEINV fail!");
      return;
    }
    data = null;
    data = new DatabaseEntry();
    status = db.get(null, key, data, null);
    if (status == OperationStatus.SUCCESS){
      System.out.println("get MultiObjPreciseInv: " + 
                         logRecordBinding.entryToObject(data));
    } else {
      System.out.println("get BoundInv fail!");
    }

    //---------------------------------------------------------------------
    // SingleWriterImpreciseInv
    //---------------------------------------------------------------------
    SingleWriterImpreciseInv si = 
      new SingleWriterImpreciseInv(HierInvalTarget.makeHierInvalTarget(dir),
                                   new AcceptStamp(190, new NodeId(200)),
                                   new AcceptStamp(200, new NodeId(200)),
                                   new AcceptStamp(100000, new NodeId(200)));

    key = null;
    data = null;
    key = new DatabaseEntry("SINGLEWRITERIMPRECISEINV".getBytes("UTF-8"));
    data = new DatabaseEntry();
    
    logRecordBinding.objectToEntry(si, data);
    status = db.put(null, key, data);
    if (status != OperationStatus.SUCCESS){
      System.out.println("put SINGLEWRITERIMPRECISEINV fail!");
      return;
    }
    data = null;
    data = new DatabaseEntry();
    status = db.get(null, key, data, null);
    if (status == OperationStatus.SUCCESS){
      System.out.println("get singleWriterImpreciseInv: " + 
                         logRecordBinding.entryToObject(data));
    } else {
      System.out.println("get singleWriterImpreciseInv fail!");
    }

    //---------------------------------------------------------------------
    // DeleteInv
    //---------------------------------------------------------------------
    DeleteInv di = new DeleteInv(new ObjId("/obj1"),
                                 new AcceptStamp(190, new NodeId(200)),
                                 new AcceptStamp(100000, new NodeId(200)),
                                 false);

    key = null;
    data = null;
    key = new DatabaseEntry("DELETEINV".getBytes("UTF-8"));
    data = new DatabaseEntry();
    
    logRecordBinding.objectToEntry(di, data);
    status = db.put(null, key, data);
    if (status != OperationStatus.SUCCESS){
      System.out.println("put DELETEINV fail!");
      return;
    }
    data = null;
    data = new DatabaseEntry();
    status = db.get(null, key, data, null);
    if (status == OperationStatus.SUCCESS){
      System.out.println("get DeleteInv: " + 
                         logRecordBinding.entryToObject(data));
    } else {
      System.out.println("get DeleteInv fail!");
    }
    
    db.close();
    env.sync();
    env.close();
    
  }
}
