package code;
 /** 
 *  NodeId: Used to store a Node ID 
 **/ 
import java.io.Serializable;

public class MOITIterator
{
 /** 
 *  Data members 
 **/ 
  private int nextIndex = 0;
  private final ObjInvalTarget[] objInvalTargets;
	
 /** 
 *  Constructor 
 **/ 
  public
  MOITIterator(final ObjInvalTarget[] newObjInvalTargets){
    this.objInvalTargets = newObjInvalTargets;
    this.nextIndex = 0;
  }

 /** 
 *  Return true if there exists a next entry 
 **/ 
  public final boolean
  hasNext(){
    return(this.nextIndex < this.objInvalTargets.length);
  }

 /** 
 *  Return the next entry and more the iterator forward 
 **/ 
  public ObjInvalTarget
  getNext(){
    ObjInvalTarget oit = null;

    assert(this.hasNext());
    oit = this.objInvalTargets[this.nextIndex];
    this.nextIndex++;
    return(oit);
  }

 /** 
 *  Return true if obj is "equal" to this (unimplemented) 
 **/ 
  public boolean
  equals(Object obj){
    System.out.println("MOITIterator.equals() unimplemented");
    assert(false);
    return(false);
  }

 /** 
 *  Return a hash code for this object (unimplemented) 
 **/ 
  public int
  hashCode(){
    System.out.println("MOITIterator.hashCode() unimplemented");
    assert(false);
    return(0);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.out.println("Testing MOITIterator.java");
    MOITIterator.test1();
    System.out.println("...Finished");
  }

 /** 
 *  Test the class 
 **/ 
  private static void
  test1(){
    MOITIterator moitIter1 = null;
    ObjInvalTarget[] objITs = null;

    // Test 1
    objITs = new ObjInvalTarget[2];
    objITs[0] = new ObjInvalTarget(new ObjId("/a"), 10, 10);
    objITs[1] = new ObjInvalTarget(new ObjId("/b"), 20, 20);
    moitIter1 = new MOITIterator(objITs);
    assert(moitIter1.hasNext());
    assert(moitIter1.getNext() == objITs[0]);
    assert(moitIter1.getNext() == objITs[1]);
    assert(!moitIter1.hasNext());

    // Test 2: Empty iterator
    objITs = new ObjInvalTarget[0];
    moitIter1 = new MOITIterator(objITs);
    assert(!moitIter1.hasNext());
  }
}

 /** 
 *  $Log: MOITIterator.java,v $ 
 *  Revision 1.1  2006/04/04 15:59:59  nayate 
 *  Added the ability to (1) delay invalidates, and (2) support transactional updates. 
 *  
 **/ 
