package code;
import java.util.LinkedList;
import java.util.ListIterator;


public class MailBoxList{
  private static final boolean dbg = true;
  private LinkedList<OutgoingConnectionMailBox> mailBoxList;
  private int size;
  private final int max;
  public MailBoxList(int max){
    mailBoxList = new LinkedList<OutgoingConnectionMailBox>();
    size = 0;
    this.max = max;
  }
  
  synchronized void add(OutgoingConnectionMailBox box){
    while(size >= max){
      if(dbg){
        System.out.println("MailBoxList is full, waiting for space.");
      }
      try{
      	wait();
      } catch (InterruptedException e){
	//ignore.
      }
    }
    assert size < max;
    mailBoxList.add(box);
    size ++;
  }
  
  synchronized void remove(OutgoingConnectionMailBox box){
    if(mailBoxList.remove(box)){
      size --;
      assert size >= 0;
      assert size < max;
      notifyAll();
    }
  }
  
  synchronized void receiveNewUpdates(){
    if(size<=0){
      return;
    }
    ListIterator<OutgoingConnectionMailBox> iter = mailBoxList.listIterator();
    while(iter.hasNext()){
      iter.next().newUpdate();
    }
    
  }
}
